/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconCodec;
import org.bouncycastle.pqc.crypto.falcon.FalconFFT;
import org.bouncycastle.pqc.crypto.falcon.FalconFPR;
import org.bouncycastle.pqc.crypto.falcon.FalconSmallPrime;
import org.bouncycastle.pqc.crypto.falcon.FalconSmallPrimeList;
import org.bouncycastle.pqc.crypto.falcon.FalconVrfy;
import org.bouncycastle.pqc.crypto.falcon.SHAKE256;

class FalconKeyGen {
    FPREngine fpr;
    FalconSmallPrimeList primes;
    FalconFFT fft;
    FalconCodec codec;
    FalconVrfy vrfy;
    private short[] REV10;
    final long[] gauss_1024_12289;
    final int[] MAX_BL_SMALL;
    final int[] MAX_BL_LARGE;
    final int[] bitlength_avg;
    final int[] bitlength_std;
    final int DEPTH_INT_FG = 4;

    FalconKeyGen() {
        short[] sArray = new short[1024];
        sArray[1] = 512;
        sArray[2] = 256;
        sArray[3] = 768;
        sArray[4] = 128;
        sArray[5] = 640;
        sArray[6] = 384;
        sArray[7] = 896;
        sArray[8] = 64;
        sArray[9] = 576;
        sArray[10] = 320;
        sArray[11] = 832;
        sArray[12] = 192;
        sArray[13] = 704;
        sArray[14] = 448;
        sArray[15] = 960;
        sArray[16] = 32;
        sArray[17] = 544;
        sArray[18] = 288;
        sArray[19] = 800;
        sArray[20] = 160;
        sArray[21] = 672;
        sArray[22] = 416;
        sArray[23] = 928;
        sArray[24] = 96;
        sArray[25] = 608;
        sArray[26] = 352;
        sArray[27] = 864;
        sArray[28] = 224;
        sArray[29] = 736;
        sArray[30] = 480;
        sArray[31] = 992;
        sArray[32] = 16;
        sArray[33] = 528;
        sArray[34] = 272;
        sArray[35] = 784;
        sArray[36] = 144;
        sArray[37] = 656;
        sArray[38] = 400;
        sArray[39] = 912;
        sArray[40] = 80;
        sArray[41] = 592;
        sArray[42] = 336;
        sArray[43] = 848;
        sArray[44] = 208;
        sArray[45] = 720;
        sArray[46] = 464;
        sArray[47] = 976;
        sArray[48] = 48;
        sArray[49] = 560;
        sArray[50] = 304;
        sArray[51] = 816;
        sArray[52] = 176;
        sArray[53] = 688;
        sArray[54] = 432;
        sArray[55] = 944;
        sArray[56] = 112;
        sArray[57] = 624;
        sArray[58] = 368;
        sArray[59] = 880;
        sArray[60] = 240;
        sArray[61] = 752;
        sArray[62] = 496;
        sArray[63] = 1008;
        sArray[64] = 8;
        sArray[65] = 520;
        sArray[66] = 264;
        sArray[67] = 776;
        sArray[68] = 136;
        sArray[69] = 648;
        sArray[70] = 392;
        sArray[71] = 904;
        sArray[72] = 72;
        sArray[73] = 584;
        sArray[74] = 328;
        sArray[75] = 840;
        sArray[76] = 200;
        sArray[77] = 712;
        sArray[78] = 456;
        sArray[79] = 968;
        sArray[80] = 40;
        sArray[81] = 552;
        sArray[82] = 296;
        sArray[83] = 808;
        sArray[84] = 168;
        sArray[85] = 680;
        sArray[86] = 424;
        sArray[87] = 936;
        sArray[88] = 104;
        sArray[89] = 616;
        sArray[90] = 360;
        sArray[91] = 872;
        sArray[92] = 232;
        sArray[93] = 744;
        sArray[94] = 488;
        sArray[95] = 1000;
        sArray[96] = 24;
        sArray[97] = 536;
        sArray[98] = 280;
        sArray[99] = 792;
        sArray[100] = 152;
        sArray[101] = 664;
        sArray[102] = 408;
        sArray[103] = 920;
        sArray[104] = 88;
        sArray[105] = 600;
        sArray[106] = 344;
        sArray[107] = 856;
        sArray[108] = 216;
        sArray[109] = 728;
        sArray[110] = 472;
        sArray[111] = 984;
        sArray[112] = 56;
        sArray[113] = 568;
        sArray[114] = 312;
        sArray[115] = 824;
        sArray[116] = 184;
        sArray[117] = 696;
        sArray[118] = 440;
        sArray[119] = 952;
        sArray[120] = 120;
        sArray[121] = 632;
        sArray[122] = 376;
        sArray[123] = 888;
        sArray[124] = 248;
        sArray[125] = 760;
        sArray[126] = 504;
        sArray[127] = 1016;
        sArray[128] = 4;
        sArray[129] = 516;
        sArray[130] = 260;
        sArray[131] = 772;
        sArray[132] = 132;
        sArray[133] = 644;
        sArray[134] = 388;
        sArray[135] = 900;
        sArray[136] = 68;
        sArray[137] = 580;
        sArray[138] = 324;
        sArray[139] = 836;
        sArray[140] = 196;
        sArray[141] = 708;
        sArray[142] = 452;
        sArray[143] = 964;
        sArray[144] = 36;
        sArray[145] = 548;
        sArray[146] = 292;
        sArray[147] = 804;
        sArray[148] = 164;
        sArray[149] = 676;
        sArray[150] = 420;
        sArray[151] = 932;
        sArray[152] = 100;
        sArray[153] = 612;
        sArray[154] = 356;
        sArray[155] = 868;
        sArray[156] = 228;
        sArray[157] = 740;
        sArray[158] = 484;
        sArray[159] = 996;
        sArray[160] = 20;
        sArray[161] = 532;
        sArray[162] = 276;
        sArray[163] = 788;
        sArray[164] = 148;
        sArray[165] = 660;
        sArray[166] = 404;
        sArray[167] = 916;
        sArray[168] = 84;
        sArray[169] = 596;
        sArray[170] = 340;
        sArray[171] = 852;
        sArray[172] = 212;
        sArray[173] = 724;
        sArray[174] = 468;
        sArray[175] = 980;
        sArray[176] = 52;
        sArray[177] = 564;
        sArray[178] = 308;
        sArray[179] = 820;
        sArray[180] = 180;
        sArray[181] = 692;
        sArray[182] = 436;
        sArray[183] = 948;
        sArray[184] = 116;
        sArray[185] = 628;
        sArray[186] = 372;
        sArray[187] = 884;
        sArray[188] = 244;
        sArray[189] = 756;
        sArray[190] = 500;
        sArray[191] = 1012;
        sArray[192] = 12;
        sArray[193] = 524;
        sArray[194] = 268;
        sArray[195] = 780;
        sArray[196] = 140;
        sArray[197] = 652;
        sArray[198] = 396;
        sArray[199] = 908;
        sArray[200] = 76;
        sArray[201] = 588;
        sArray[202] = 332;
        sArray[203] = 844;
        sArray[204] = 204;
        sArray[205] = 716;
        sArray[206] = 460;
        sArray[207] = 972;
        sArray[208] = 44;
        sArray[209] = 556;
        sArray[210] = 300;
        sArray[211] = 812;
        sArray[212] = 172;
        sArray[213] = 684;
        sArray[214] = 428;
        sArray[215] = 940;
        sArray[216] = 108;
        sArray[217] = 620;
        sArray[218] = 364;
        sArray[219] = 876;
        sArray[220] = 236;
        sArray[221] = 748;
        sArray[222] = 492;
        sArray[223] = 1004;
        sArray[224] = 28;
        sArray[225] = 540;
        sArray[226] = 284;
        sArray[227] = 796;
        sArray[228] = 156;
        sArray[229] = 668;
        sArray[230] = 412;
        sArray[231] = 924;
        sArray[232] = 92;
        sArray[233] = 604;
        sArray[234] = 348;
        sArray[235] = 860;
        sArray[236] = 220;
        sArray[237] = 732;
        sArray[238] = 476;
        sArray[239] = 988;
        sArray[240] = 60;
        sArray[241] = 572;
        sArray[242] = 316;
        sArray[243] = 828;
        sArray[244] = 188;
        sArray[245] = 700;
        sArray[246] = 444;
        sArray[247] = 956;
        sArray[248] = 124;
        sArray[249] = 636;
        sArray[250] = 380;
        sArray[251] = 892;
        sArray[252] = 252;
        sArray[253] = 764;
        sArray[254] = 508;
        sArray[255] = 1020;
        sArray[256] = 2;
        sArray[257] = 514;
        sArray[258] = 258;
        sArray[259] = 770;
        sArray[260] = 130;
        sArray[261] = 642;
        sArray[262] = 386;
        sArray[263] = 898;
        sArray[264] = 66;
        sArray[265] = 578;
        sArray[266] = 322;
        sArray[267] = 834;
        sArray[268] = 194;
        sArray[269] = 706;
        sArray[270] = 450;
        sArray[271] = 962;
        sArray[272] = 34;
        sArray[273] = 546;
        sArray[274] = 290;
        sArray[275] = 802;
        sArray[276] = 162;
        sArray[277] = 674;
        sArray[278] = 418;
        sArray[279] = 930;
        sArray[280] = 98;
        sArray[281] = 610;
        sArray[282] = 354;
        sArray[283] = 866;
        sArray[284] = 226;
        sArray[285] = 738;
        sArray[286] = 482;
        sArray[287] = 994;
        sArray[288] = 18;
        sArray[289] = 530;
        sArray[290] = 274;
        sArray[291] = 786;
        sArray[292] = 146;
        sArray[293] = 658;
        sArray[294] = 402;
        sArray[295] = 914;
        sArray[296] = 82;
        sArray[297] = 594;
        sArray[298] = 338;
        sArray[299] = 850;
        sArray[300] = 210;
        sArray[301] = 722;
        sArray[302] = 466;
        sArray[303] = 978;
        sArray[304] = 50;
        sArray[305] = 562;
        sArray[306] = 306;
        sArray[307] = 818;
        sArray[308] = 178;
        sArray[309] = 690;
        sArray[310] = 434;
        sArray[311] = 946;
        sArray[312] = 114;
        sArray[313] = 626;
        sArray[314] = 370;
        sArray[315] = 882;
        sArray[316] = 242;
        sArray[317] = 754;
        sArray[318] = 498;
        sArray[319] = 1010;
        sArray[320] = 10;
        sArray[321] = 522;
        sArray[322] = 266;
        sArray[323] = 778;
        sArray[324] = 138;
        sArray[325] = 650;
        sArray[326] = 394;
        sArray[327] = 906;
        sArray[328] = 74;
        sArray[329] = 586;
        sArray[330] = 330;
        sArray[331] = 842;
        sArray[332] = 202;
        sArray[333] = 714;
        sArray[334] = 458;
        sArray[335] = 970;
        sArray[336] = 42;
        sArray[337] = 554;
        sArray[338] = 298;
        sArray[339] = 810;
        sArray[340] = 170;
        sArray[341] = 682;
        sArray[342] = 426;
        sArray[343] = 938;
        sArray[344] = 106;
        sArray[345] = 618;
        sArray[346] = 362;
        sArray[347] = 874;
        sArray[348] = 234;
        sArray[349] = 746;
        sArray[350] = 490;
        sArray[351] = 1002;
        sArray[352] = 26;
        sArray[353] = 538;
        sArray[354] = 282;
        sArray[355] = 794;
        sArray[356] = 154;
        sArray[357] = 666;
        sArray[358] = 410;
        sArray[359] = 922;
        sArray[360] = 90;
        sArray[361] = 602;
        sArray[362] = 346;
        sArray[363] = 858;
        sArray[364] = 218;
        sArray[365] = 730;
        sArray[366] = 474;
        sArray[367] = 986;
        sArray[368] = 58;
        sArray[369] = 570;
        sArray[370] = 314;
        sArray[371] = 826;
        sArray[372] = 186;
        sArray[373] = 698;
        sArray[374] = 442;
        sArray[375] = 954;
        sArray[376] = 122;
        sArray[377] = 634;
        sArray[378] = 378;
        sArray[379] = 890;
        sArray[380] = 250;
        sArray[381] = 762;
        sArray[382] = 506;
        sArray[383] = 1018;
        sArray[384] = 6;
        sArray[385] = 518;
        sArray[386] = 262;
        sArray[387] = 774;
        sArray[388] = 134;
        sArray[389] = 646;
        sArray[390] = 390;
        sArray[391] = 902;
        sArray[392] = 70;
        sArray[393] = 582;
        sArray[394] = 326;
        sArray[395] = 838;
        sArray[396] = 198;
        sArray[397] = 710;
        sArray[398] = 454;
        sArray[399] = 966;
        sArray[400] = 38;
        sArray[401] = 550;
        sArray[402] = 294;
        sArray[403] = 806;
        sArray[404] = 166;
        sArray[405] = 678;
        sArray[406] = 422;
        sArray[407] = 934;
        sArray[408] = 102;
        sArray[409] = 614;
        sArray[410] = 358;
        sArray[411] = 870;
        sArray[412] = 230;
        sArray[413] = 742;
        sArray[414] = 486;
        sArray[415] = 998;
        sArray[416] = 22;
        sArray[417] = 534;
        sArray[418] = 278;
        sArray[419] = 790;
        sArray[420] = 150;
        sArray[421] = 662;
        sArray[422] = 406;
        sArray[423] = 918;
        sArray[424] = 86;
        sArray[425] = 598;
        sArray[426] = 342;
        sArray[427] = 854;
        sArray[428] = 214;
        sArray[429] = 726;
        sArray[430] = 470;
        sArray[431] = 982;
        sArray[432] = 54;
        sArray[433] = 566;
        sArray[434] = 310;
        sArray[435] = 822;
        sArray[436] = 182;
        sArray[437] = 694;
        sArray[438] = 438;
        sArray[439] = 950;
        sArray[440] = 118;
        sArray[441] = 630;
        sArray[442] = 374;
        sArray[443] = 886;
        sArray[444] = 246;
        sArray[445] = 758;
        sArray[446] = 502;
        sArray[447] = 1014;
        sArray[448] = 14;
        sArray[449] = 526;
        sArray[450] = 270;
        sArray[451] = 782;
        sArray[452] = 142;
        sArray[453] = 654;
        sArray[454] = 398;
        sArray[455] = 910;
        sArray[456] = 78;
        sArray[457] = 590;
        sArray[458] = 334;
        sArray[459] = 846;
        sArray[460] = 206;
        sArray[461] = 718;
        sArray[462] = 462;
        sArray[463] = 974;
        sArray[464] = 46;
        sArray[465] = 558;
        sArray[466] = 302;
        sArray[467] = 814;
        sArray[468] = 174;
        sArray[469] = 686;
        sArray[470] = 430;
        sArray[471] = 942;
        sArray[472] = 110;
        sArray[473] = 622;
        sArray[474] = 366;
        sArray[475] = 878;
        sArray[476] = 238;
        sArray[477] = 750;
        sArray[478] = 494;
        sArray[479] = 1006;
        sArray[480] = 30;
        sArray[481] = 542;
        sArray[482] = 286;
        sArray[483] = 798;
        sArray[484] = 158;
        sArray[485] = 670;
        sArray[486] = 414;
        sArray[487] = 926;
        sArray[488] = 94;
        sArray[489] = 606;
        sArray[490] = 350;
        sArray[491] = 862;
        sArray[492] = 222;
        sArray[493] = 734;
        sArray[494] = 478;
        sArray[495] = 990;
        sArray[496] = 62;
        sArray[497] = 574;
        sArray[498] = 318;
        sArray[499] = 830;
        sArray[500] = 190;
        sArray[501] = 702;
        sArray[502] = 446;
        sArray[503] = 958;
        sArray[504] = 126;
        sArray[505] = 638;
        sArray[506] = 382;
        sArray[507] = 894;
        sArray[508] = 254;
        sArray[509] = 766;
        sArray[510] = 510;
        sArray[511] = 1022;
        sArray[512] = 1;
        sArray[513] = 513;
        sArray[514] = 257;
        sArray[515] = 769;
        sArray[516] = 129;
        sArray[517] = 641;
        sArray[518] = 385;
        sArray[519] = 897;
        sArray[520] = 65;
        sArray[521] = 577;
        sArray[522] = 321;
        sArray[523] = 833;
        sArray[524] = 193;
        sArray[525] = 705;
        sArray[526] = 449;
        sArray[527] = 961;
        sArray[528] = 33;
        sArray[529] = 545;
        sArray[530] = 289;
        sArray[531] = 801;
        sArray[532] = 161;
        sArray[533] = 673;
        sArray[534] = 417;
        sArray[535] = 929;
        sArray[536] = 97;
        sArray[537] = 609;
        sArray[538] = 353;
        sArray[539] = 865;
        sArray[540] = 225;
        sArray[541] = 737;
        sArray[542] = 481;
        sArray[543] = 993;
        sArray[544] = 17;
        sArray[545] = 529;
        sArray[546] = 273;
        sArray[547] = 785;
        sArray[548] = 145;
        sArray[549] = 657;
        sArray[550] = 401;
        sArray[551] = 913;
        sArray[552] = 81;
        sArray[553] = 593;
        sArray[554] = 337;
        sArray[555] = 849;
        sArray[556] = 209;
        sArray[557] = 721;
        sArray[558] = 465;
        sArray[559] = 977;
        sArray[560] = 49;
        sArray[561] = 561;
        sArray[562] = 305;
        sArray[563] = 817;
        sArray[564] = 177;
        sArray[565] = 689;
        sArray[566] = 433;
        sArray[567] = 945;
        sArray[568] = 113;
        sArray[569] = 625;
        sArray[570] = 369;
        sArray[571] = 881;
        sArray[572] = 241;
        sArray[573] = 753;
        sArray[574] = 497;
        sArray[575] = 1009;
        sArray[576] = 9;
        sArray[577] = 521;
        sArray[578] = 265;
        sArray[579] = 777;
        sArray[580] = 137;
        sArray[581] = 649;
        sArray[582] = 393;
        sArray[583] = 905;
        sArray[584] = 73;
        sArray[585] = 585;
        sArray[586] = 329;
        sArray[587] = 841;
        sArray[588] = 201;
        sArray[589] = 713;
        sArray[590] = 457;
        sArray[591] = 969;
        sArray[592] = 41;
        sArray[593] = 553;
        sArray[594] = 297;
        sArray[595] = 809;
        sArray[596] = 169;
        sArray[597] = 681;
        sArray[598] = 425;
        sArray[599] = 937;
        sArray[600] = 105;
        sArray[601] = 617;
        sArray[602] = 361;
        sArray[603] = 873;
        sArray[604] = 233;
        sArray[605] = 745;
        sArray[606] = 489;
        sArray[607] = 1001;
        sArray[608] = 25;
        sArray[609] = 537;
        sArray[610] = 281;
        sArray[611] = 793;
        sArray[612] = 153;
        sArray[613] = 665;
        sArray[614] = 409;
        sArray[615] = 921;
        sArray[616] = 89;
        sArray[617] = 601;
        sArray[618] = 345;
        sArray[619] = 857;
        sArray[620] = 217;
        sArray[621] = 729;
        sArray[622] = 473;
        sArray[623] = 985;
        sArray[624] = 57;
        sArray[625] = 569;
        sArray[626] = 313;
        sArray[627] = 825;
        sArray[628] = 185;
        sArray[629] = 697;
        sArray[630] = 441;
        sArray[631] = 953;
        sArray[632] = 121;
        sArray[633] = 633;
        sArray[634] = 377;
        sArray[635] = 889;
        sArray[636] = 249;
        sArray[637] = 761;
        sArray[638] = 505;
        sArray[639] = 1017;
        sArray[640] = 5;
        sArray[641] = 517;
        sArray[642] = 261;
        sArray[643] = 773;
        sArray[644] = 133;
        sArray[645] = 645;
        sArray[646] = 389;
        sArray[647] = 901;
        sArray[648] = 69;
        sArray[649] = 581;
        sArray[650] = 325;
        sArray[651] = 837;
        sArray[652] = 197;
        sArray[653] = 709;
        sArray[654] = 453;
        sArray[655] = 965;
        sArray[656] = 37;
        sArray[657] = 549;
        sArray[658] = 293;
        sArray[659] = 805;
        sArray[660] = 165;
        sArray[661] = 677;
        sArray[662] = 421;
        sArray[663] = 933;
        sArray[664] = 101;
        sArray[665] = 613;
        sArray[666] = 357;
        sArray[667] = 869;
        sArray[668] = 229;
        sArray[669] = 741;
        sArray[670] = 485;
        sArray[671] = 997;
        sArray[672] = 21;
        sArray[673] = 533;
        sArray[674] = 277;
        sArray[675] = 789;
        sArray[676] = 149;
        sArray[677] = 661;
        sArray[678] = 405;
        sArray[679] = 917;
        sArray[680] = 85;
        sArray[681] = 597;
        sArray[682] = 341;
        sArray[683] = 853;
        sArray[684] = 213;
        sArray[685] = 725;
        sArray[686] = 469;
        sArray[687] = 981;
        sArray[688] = 53;
        sArray[689] = 565;
        sArray[690] = 309;
        sArray[691] = 821;
        sArray[692] = 181;
        sArray[693] = 693;
        sArray[694] = 437;
        sArray[695] = 949;
        sArray[696] = 117;
        sArray[697] = 629;
        sArray[698] = 373;
        sArray[699] = 885;
        sArray[700] = 245;
        sArray[701] = 757;
        sArray[702] = 501;
        sArray[703] = 1013;
        sArray[704] = 13;
        sArray[705] = 525;
        sArray[706] = 269;
        sArray[707] = 781;
        sArray[708] = 141;
        sArray[709] = 653;
        sArray[710] = 397;
        sArray[711] = 909;
        sArray[712] = 77;
        sArray[713] = 589;
        sArray[714] = 333;
        sArray[715] = 845;
        sArray[716] = 205;
        sArray[717] = 717;
        sArray[718] = 461;
        sArray[719] = 973;
        sArray[720] = 45;
        sArray[721] = 557;
        sArray[722] = 301;
        sArray[723] = 813;
        sArray[724] = 173;
        sArray[725] = 685;
        sArray[726] = 429;
        sArray[727] = 941;
        sArray[728] = 109;
        sArray[729] = 621;
        sArray[730] = 365;
        sArray[731] = 877;
        sArray[732] = 237;
        sArray[733] = 749;
        sArray[734] = 493;
        sArray[735] = 1005;
        sArray[736] = 29;
        sArray[737] = 541;
        sArray[738] = 285;
        sArray[739] = 797;
        sArray[740] = 157;
        sArray[741] = 669;
        sArray[742] = 413;
        sArray[743] = 925;
        sArray[744] = 93;
        sArray[745] = 605;
        sArray[746] = 349;
        sArray[747] = 861;
        sArray[748] = 221;
        sArray[749] = 733;
        sArray[750] = 477;
        sArray[751] = 989;
        sArray[752] = 61;
        sArray[753] = 573;
        sArray[754] = 317;
        sArray[755] = 829;
        sArray[756] = 189;
        sArray[757] = 701;
        sArray[758] = 445;
        sArray[759] = 957;
        sArray[760] = 125;
        sArray[761] = 637;
        sArray[762] = 381;
        sArray[763] = 893;
        sArray[764] = 253;
        sArray[765] = 765;
        sArray[766] = 509;
        sArray[767] = 1021;
        sArray[768] = 3;
        sArray[769] = 515;
        sArray[770] = 259;
        sArray[771] = 771;
        sArray[772] = 131;
        sArray[773] = 643;
        sArray[774] = 387;
        sArray[775] = 899;
        sArray[776] = 67;
        sArray[777] = 579;
        sArray[778] = 323;
        sArray[779] = 835;
        sArray[780] = 195;
        sArray[781] = 707;
        sArray[782] = 451;
        sArray[783] = 963;
        sArray[784] = 35;
        sArray[785] = 547;
        sArray[786] = 291;
        sArray[787] = 803;
        sArray[788] = 163;
        sArray[789] = 675;
        sArray[790] = 419;
        sArray[791] = 931;
        sArray[792] = 99;
        sArray[793] = 611;
        sArray[794] = 355;
        sArray[795] = 867;
        sArray[796] = 227;
        sArray[797] = 739;
        sArray[798] = 483;
        sArray[799] = 995;
        sArray[800] = 19;
        sArray[801] = 531;
        sArray[802] = 275;
        sArray[803] = 787;
        sArray[804] = 147;
        sArray[805] = 659;
        sArray[806] = 403;
        sArray[807] = 915;
        sArray[808] = 83;
        sArray[809] = 595;
        sArray[810] = 339;
        sArray[811] = 851;
        sArray[812] = 211;
        sArray[813] = 723;
        sArray[814] = 467;
        sArray[815] = 979;
        sArray[816] = 51;
        sArray[817] = 563;
        sArray[818] = 307;
        sArray[819] = 819;
        sArray[820] = 179;
        sArray[821] = 691;
        sArray[822] = 435;
        sArray[823] = 947;
        sArray[824] = 115;
        sArray[825] = 627;
        sArray[826] = 371;
        sArray[827] = 883;
        sArray[828] = 243;
        sArray[829] = 755;
        sArray[830] = 499;
        sArray[831] = 1011;
        sArray[832] = 11;
        sArray[833] = 523;
        sArray[834] = 267;
        sArray[835] = 779;
        sArray[836] = 139;
        sArray[837] = 651;
        sArray[838] = 395;
        sArray[839] = 907;
        sArray[840] = 75;
        sArray[841] = 587;
        sArray[842] = 331;
        sArray[843] = 843;
        sArray[844] = 203;
        sArray[845] = 715;
        sArray[846] = 459;
        sArray[847] = 971;
        sArray[848] = 43;
        sArray[849] = 555;
        sArray[850] = 299;
        sArray[851] = 811;
        sArray[852] = 171;
        sArray[853] = 683;
        sArray[854] = 427;
        sArray[855] = 939;
        sArray[856] = 107;
        sArray[857] = 619;
        sArray[858] = 363;
        sArray[859] = 875;
        sArray[860] = 235;
        sArray[861] = 747;
        sArray[862] = 491;
        sArray[863] = 1003;
        sArray[864] = 27;
        sArray[865] = 539;
        sArray[866] = 283;
        sArray[867] = 795;
        sArray[868] = 155;
        sArray[869] = 667;
        sArray[870] = 411;
        sArray[871] = 923;
        sArray[872] = 91;
        sArray[873] = 603;
        sArray[874] = 347;
        sArray[875] = 859;
        sArray[876] = 219;
        sArray[877] = 731;
        sArray[878] = 475;
        sArray[879] = 987;
        sArray[880] = 59;
        sArray[881] = 571;
        sArray[882] = 315;
        sArray[883] = 827;
        sArray[884] = 187;
        sArray[885] = 699;
        sArray[886] = 443;
        sArray[887] = 955;
        sArray[888] = 123;
        sArray[889] = 635;
        sArray[890] = 379;
        sArray[891] = 891;
        sArray[892] = 251;
        sArray[893] = 763;
        sArray[894] = 507;
        sArray[895] = 1019;
        sArray[896] = 7;
        sArray[897] = 519;
        sArray[898] = 263;
        sArray[899] = 775;
        sArray[900] = 135;
        sArray[901] = 647;
        sArray[902] = 391;
        sArray[903] = 903;
        sArray[904] = 71;
        sArray[905] = 583;
        sArray[906] = 327;
        sArray[907] = 839;
        sArray[908] = 199;
        sArray[909] = 711;
        sArray[910] = 455;
        sArray[911] = 967;
        sArray[912] = 39;
        sArray[913] = 551;
        sArray[914] = 295;
        sArray[915] = 807;
        sArray[916] = 167;
        sArray[917] = 679;
        sArray[918] = 423;
        sArray[919] = 935;
        sArray[920] = 103;
        sArray[921] = 615;
        sArray[922] = 359;
        sArray[923] = 871;
        sArray[924] = 231;
        sArray[925] = 743;
        sArray[926] = 487;
        sArray[927] = 999;
        sArray[928] = 23;
        sArray[929] = 535;
        sArray[930] = 279;
        sArray[931] = 791;
        sArray[932] = 151;
        sArray[933] = 663;
        sArray[934] = 407;
        sArray[935] = 919;
        sArray[936] = 87;
        sArray[937] = 599;
        sArray[938] = 343;
        sArray[939] = 855;
        sArray[940] = 215;
        sArray[941] = 727;
        sArray[942] = 471;
        sArray[943] = 983;
        sArray[944] = 55;
        sArray[945] = 567;
        sArray[946] = 311;
        sArray[947] = 823;
        sArray[948] = 183;
        sArray[949] = 695;
        sArray[950] = 439;
        sArray[951] = 951;
        sArray[952] = 119;
        sArray[953] = 631;
        sArray[954] = 375;
        sArray[955] = 887;
        sArray[956] = 247;
        sArray[957] = 759;
        sArray[958] = 503;
        sArray[959] = 1015;
        sArray[960] = 15;
        sArray[961] = 527;
        sArray[962] = 271;
        sArray[963] = 783;
        sArray[964] = 143;
        sArray[965] = 655;
        sArray[966] = 399;
        sArray[967] = 911;
        sArray[968] = 79;
        sArray[969] = 591;
        sArray[970] = 335;
        sArray[971] = 847;
        sArray[972] = 207;
        sArray[973] = 719;
        sArray[974] = 463;
        sArray[975] = 975;
        sArray[976] = 47;
        sArray[977] = 559;
        sArray[978] = 303;
        sArray[979] = 815;
        sArray[980] = 175;
        sArray[981] = 687;
        sArray[982] = 431;
        sArray[983] = 943;
        sArray[984] = 111;
        sArray[985] = 623;
        sArray[986] = 367;
        sArray[987] = 879;
        sArray[988] = 239;
        sArray[989] = 751;
        sArray[990] = 495;
        sArray[991] = 1007;
        sArray[992] = 31;
        sArray[993] = 543;
        sArray[994] = 287;
        sArray[995] = 799;
        sArray[996] = 159;
        sArray[997] = 671;
        sArray[998] = 415;
        sArray[999] = 927;
        sArray[1000] = 95;
        sArray[1001] = 607;
        sArray[1002] = 351;
        sArray[1003] = 863;
        sArray[1004] = 223;
        sArray[1005] = 735;
        sArray[1006] = 479;
        sArray[1007] = 991;
        sArray[1008] = 63;
        sArray[1009] = 575;
        sArray[1010] = 319;
        sArray[1011] = 831;
        sArray[1012] = 191;
        sArray[1013] = 703;
        sArray[1014] = 447;
        sArray[1015] = 959;
        sArray[1016] = 127;
        sArray[1017] = 639;
        sArray[1018] = 383;
        sArray[1019] = 895;
        sArray[1020] = 255;
        sArray[1021] = 767;
        sArray[1022] = 511;
        sArray[1023] = 1023;
        this.REV10 = sArray;
        long[] lArray = new long[27];
        lArray[0] = 1283868770400643928L;
        lArray[1] = 6416574995475331444L;
        lArray[2] = 4078260278032692663L;
        lArray[3] = 2353523259288686585L;
        lArray[4] = 1227179971273316331L;
        lArray[5] = 575931623374121527L;
        lArray[6] = 242543240509105209L;
        lArray[7] = 91437049221049666L;
        lArray[8] = 30799446349977173L;
        lArray[9] = 9255276791179340L;
        lArray[10] = 2478152334826140L;
        lArray[11] = 590642893610164L;
        lArray[12] = 125206034929641L;
        lArray[13] = 23590435911403L;
        lArray[14] = 3948334035941L;
        lArray[15] = 586753615614L;
        lArray[16] = 77391054539L;
        lArray[17] = 9056793210L;
        lArray[18] = 940121950L;
        lArray[19] = 86539696L;
        lArray[20] = 7062824L;
        lArray[21] = 510971L;
        lArray[22] = 32764L;
        lArray[23] = 1862L;
        lArray[24] = 94L;
        lArray[25] = 4L;
        this.gauss_1024_12289 = lArray;
        this.MAX_BL_SMALL = new int[]{1, 1, 2, 2, 4, 7, 14, 27, 53, 106, 209};
        this.MAX_BL_LARGE = new int[]{2, 2, 5, 7, 12, 21, 40, 78, 157, 308};
        this.bitlength_avg = new int[]{4, 11, 24, 50, 102, 202, 401, 794, 1577, 3138, 6308};
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 4;
        nArray[7] = 5;
        nArray[8] = 8;
        nArray[9] = 13;
        nArray[10] = 25;
        this.bitlength_std = nArray;
        this.DEPTH_INT_FG = 4;
        this.fpr = new FPREngine();
        this.primes = new FalconSmallPrimeList();
        this.fft = new FalconFFT();
        this.codec = new FalconCodec();
        this.vrfy = new FalconVrfy();
    }

    private static int mkn(int logn) {
        return 1 << logn;
    }

    int modp_set(int x, int p) {
        int w = x;
        w += p & -(w >>> 31);
        return w;
    }

    int modp_norm(int x, int p) {
        return x - (p & (x - (p + 1 >>> 1) >>> 31) - 1);
    }

    int modp_ninv31(int p) {
        int y = 2 - p;
        y *= 2 - p * y;
        y *= 2 - p * y;
        y *= 2 - p * y;
        y *= 2 - p * y;
        return Integer.MAX_VALUE & -y;
    }

    int modp_R(int p) {
        return Integer.MIN_VALUE - p;
    }

    int modp_add(int a, int b, int p) {
        int d = a + b - p;
        d += p & -(d >>> 31);
        return d;
    }

    int modp_sub(int a, int b, int p) {
        int d = a - b;
        d += p & -(d >>> 31);
        return d;
    }

    int modp_montymul(int a, int b, int p, int p0i) {
        long z = this.toUnsignedLong(a) * this.toUnsignedLong(b);
        long w = (z * (long)p0i & this.toUnsignedLong(Integer.MAX_VALUE)) * (long)p;
        int d = (int)(z + w >>> 31) - p;
        d += p & -(d >>> 31);
        return d;
    }

    int modp_R2(int p, int p0i) {
        int z = this.modp_R(p);
        z = this.modp_add(z, z, p);
        z = this.modp_montymul(z, z, p, p0i);
        z = this.modp_montymul(z, z, p, p0i);
        z = this.modp_montymul(z, z, p, p0i);
        z = this.modp_montymul(z, z, p, p0i);
        z = this.modp_montymul(z, z, p, p0i);
        z = z + (p & -(z & 1)) >>> 1;
        return z;
    }

    int modp_Rx(int x, int p, int p0i, int R2) {
        --x;
        int r = R2;
        int z = this.modp_R(p);
        int i = 0;
        while (1 << i <= x) {
            if ((x & 1 << i) != 0) {
                z = this.modp_montymul(z, r, p, p0i);
            }
            r = this.modp_montymul(r, r, p, p0i);
            ++i;
        }
        return z;
    }

    int modp_div(int a, int b, int p, int p0i, int R) {
        int e = p - 2;
        int z = R;
        int i = 30;
        while (i >= 0) {
            z = this.modp_montymul(z, z, p, p0i);
            int z2 = this.modp_montymul(z, b, p, p0i);
            z ^= (z ^ z2) & -(e >>> i & 1);
            --i;
        }
        z = this.modp_montymul(z, 1, p, p0i);
        return this.modp_montymul(a, z, p, p0i);
    }

    void modp_mkgm2(int[] srcgm, int gm, int[] srcigm, int igm, int logn, int g, int p, int p0i) {
        int x2;
        int n = FalconKeyGen.mkn(logn);
        int R2 = this.modp_R2(p, p0i);
        g = this.modp_montymul(g, R2, p, p0i);
        int k = logn;
        while (k < 10) {
            g = this.modp_montymul(g, g, p, p0i);
            ++k;
        }
        int ig = this.modp_div(R2, g, p, p0i, this.modp_R(p));
        k = 10 - logn;
        int x1 = x2 = this.modp_R(p);
        int u = 0;
        while (u < n) {
            short v = this.REV10[u << k];
            srcgm[gm + v] = x1;
            srcigm[igm + v] = x2;
            x1 = this.modp_montymul(x1, g, p, p0i);
            x2 = this.modp_montymul(x2, ig, p, p0i);
            ++u;
        }
    }

    void modp_NTT2_ext(int[] srca, int a, int stride, int[] srcgm, int gm, int logn, int p, int p0i) {
        int n;
        if (logn == 0) {
            return;
        }
        int t = n = FalconKeyGen.mkn(logn);
        int m = 1;
        while (m < n) {
            int ht = t >> 1;
            int u = 0;
            int v1 = 0;
            while (u < m) {
                int s = srcgm[gm + m + u];
                int r1 = a + v1 * stride;
                int r2 = r1 + ht * stride;
                int v = 0;
                while (v < ht) {
                    int x = srca[r1];
                    int y = this.modp_montymul(srca[r2], s, p, p0i);
                    srca[r1] = this.modp_add(x, y, p);
                    srca[r2] = this.modp_sub(x, y, p);
                    ++v;
                    r1 += stride;
                    r2 += stride;
                }
                ++u;
                v1 += t;
            }
            t = ht;
            m <<= 1;
        }
    }

    void modp_iNTT2_ext(int[] srca, int a, int stride, int[] srcigm, int igm, int logn, int p, int p0i) {
        if (logn == 0) {
            return;
        }
        int n = FalconKeyGen.mkn(logn);
        int t = 1;
        int m = n;
        while (m > 1) {
            int hm = m >> 1;
            int dt = t << 1;
            int u = 0;
            int v1 = 0;
            while (u < hm) {
                int s = srcigm[igm + hm + u];
                int r1 = a + v1 * stride;
                int r2 = r1 + t * stride;
                int v = 0;
                while (v < t) {
                    int x = srca[r1];
                    int y = srca[r2];
                    srca[r1] = this.modp_add(x, y, p);
                    srca[r2] = this.modp_montymul(this.modp_sub(x, y, p), s, p, p0i);
                    ++v;
                    r1 += stride;
                    r2 += stride;
                }
                ++u;
                v1 += dt;
            }
            t = dt;
            m >>= 1;
        }
        int ni = 1 << 31 - logn;
        int k = 0;
        int r = a;
        while (k < n) {
            srca[r] = this.modp_montymul(srca[r], ni, p, p0i);
            ++k;
            r += stride;
        }
    }

    void modp_NTT2(int[] srca, int a, int[] srcgm, int gm, int logn, int p, int p0i) {
        this.modp_NTT2_ext(srca, a, 1, srcgm, gm, logn, p, p0i);
    }

    void modp_iNTT2(int[] srca, int a, int[] srcigm, int igm, int logn, int p, int p0i) {
        this.modp_iNTT2_ext(srca, a, 1, srcigm, igm, logn, p, p0i);
    }

    void modp_poly_rec_res(int[] srcf, int f, int logn, int p, int p0i, int R2) {
        int hn = 1 << logn - 1;
        int u = 0;
        while (u < hn) {
            int w0 = srcf[f + (u << 1) + 0];
            int w1 = srcf[f + (u << 1) + 1];
            srcf[f + u] = this.modp_montymul(this.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
            ++u;
        }
    }

    int zint_sub(int[] srca, int a, int[] srcb, int b, int len, int ctl) {
        int cc = 0;
        int m = -ctl;
        int u = 0;
        while (u < len) {
            int aw = srca[a + u];
            int w = aw - srcb[b + u] - cc;
            cc = w >>> 31;
            aw ^= (w & Integer.MAX_VALUE ^ aw) & m;
            srca[a + u] = aw;
            ++u;
        }
        return cc;
    }

    int zint_mul_small(int[] srcm, int m, int mlen, int x) {
        int cc = 0;
        int u = 0;
        while (u < mlen) {
            long z = this.toUnsignedLong(srcm[m + u]) * this.toUnsignedLong(x) + (long)cc;
            srcm[m + u] = (int)z & Integer.MAX_VALUE;
            cc = (int)(z >> 31);
            ++u;
        }
        return cc;
    }

    int zint_mod_small_unsigned(int[] srcd, int d, int dlen, int p, int p0i, int R2) {
        int x = 0;
        int u = dlen;
        while (u-- > 0) {
            x = this.modp_montymul(x, R2, p, p0i);
            int w = srcd[d + u] - p;
            w += p & -(w >>> 31);
            x = this.modp_add(x, w, p);
        }
        return x;
    }

    int zint_mod_small_signed(int[] srcd, int d, int dlen, int p, int p0i, int R2, int Rx) {
        if (dlen == 0) {
            return 0;
        }
        int z = this.zint_mod_small_unsigned(srcd, d, dlen, p, p0i, R2);
        z = this.modp_sub(z, Rx & -(srcd[d + dlen - 1] >>> 30), p);
        return z;
    }

    void zint_add_mul_small(int[] srcx, int x, int[] srcy, int y, int len, int s) {
        int cc = 0;
        int u = 0;
        while (u < len) {
            int xw = srcx[x + u];
            int yw = srcy[y + u];
            long z = this.toUnsignedLong(yw) * this.toUnsignedLong(s) + this.toUnsignedLong(xw) + this.toUnsignedLong(cc);
            srcx[x + u] = (int)z & Integer.MAX_VALUE;
            cc = (int)(z >>> 31);
            ++u;
        }
        srcx[x + len] = cc;
    }

    void zint_norm_zero(int[] srcx, int x, int[] srcp, int p, int len) {
        int r = 0;
        int bb = 0;
        int u = len;
        while (u-- > 0) {
            int wx = srcx[x + u];
            int wp = srcp[p + u] >>> 1 | bb << 30;
            bb = srcp[p + u] & 1;
            int cc = wp - wx;
            cc = -cc >>> 31 | -(cc >>> 31);
            r |= cc & (r & 1) - 1;
        }
        this.zint_sub(srcx, x, srcp, p, len, r >>> 31);
    }

    void zint_rebuild_CRT(int[] srcxx, int xx, int xlen, int xstride, int num, FalconSmallPrime[] primes, int normalize_signed, int[] srctmp, int tmp) {
        int x;
        srctmp[tmp + 0] = primes[0].p;
        int u = 1;
        while (u < xlen) {
            int p = primes[u].p;
            int s = primes[u].s;
            int p0i = this.modp_ninv31(p);
            int R2 = this.modp_R2(p, p0i);
            int v = 0;
            x = xx;
            while (v < num) {
                int xp = srcxx[x + u];
                int xq = this.zint_mod_small_unsigned(srcxx, x, u, p, p0i, R2);
                int xr = this.modp_montymul(s, this.modp_sub(xp, xq, p), p, p0i);
                this.zint_add_mul_small(srcxx, x, srctmp, tmp, u, xr);
                ++v;
                x += xstride;
            }
            srctmp[tmp + u] = this.zint_mul_small(srctmp, tmp, u, p);
            ++u;
        }
        if (normalize_signed != 0) {
            u = 0;
            x = xx;
            while (u < num) {
                this.zint_norm_zero(srcxx, x, srctmp, tmp, xlen);
                ++u;
                x += xstride;
            }
        }
    }

    void zint_negate(int[] srca, int a, int len, int ctl) {
        int cc = ctl;
        int m = -ctl >>> 1;
        int u = 0;
        while (u < len) {
            int aw = srca[a + u];
            aw = (aw ^ m) + cc;
            srca[a + u] = aw & Integer.MAX_VALUE;
            cc = aw >>> 31;
            ++u;
        }
    }

    int zint_co_reduce(int[] srca, int a, int[] srcb, int b, int len, long xa, long xb, long ya, long yb) {
        long cca = 0L;
        long ccb = 0L;
        int u = 0;
        while (u < len) {
            int wa = srca[a + u];
            int wb = srcb[b + u];
            long za = (long)wa * xa + (long)wb * xb + cca;
            long zb = (long)wa * ya + (long)wb * yb + ccb;
            if (u > 0) {
                srca[a + u - 1] = (int)za & Integer.MAX_VALUE;
                srcb[b + u - 1] = (int)zb & Integer.MAX_VALUE;
            }
            cca = za >> 31;
            ccb = zb >> 31;
            ++u;
        }
        srca[a + len - 1] = (int)cca;
        srcb[b + len - 1] = (int)ccb;
        int nega = (int)(cca >>> 63);
        int negb = (int)(ccb >>> 63);
        this.zint_negate(srca, a, len, nega);
        this.zint_negate(srcb, b, len, negb);
        return nega | negb << 1;
    }

    void zint_finish_mod(int[] srca, int a, int len, int[] srcm, int m, int neg) {
        int cc = 0;
        int u = 0;
        while (u < len) {
            cc = srca[a + u] - srcm[m + u] - cc >>> 31;
            ++u;
        }
        int xm = -neg >>> 1;
        int ym = -(neg | 1 - cc);
        cc = neg;
        u = 0;
        while (u < len) {
            int aw = srca[a + u];
            int mw = (srcm[m + u] ^ xm) & ym;
            aw = aw - mw - cc;
            srca[a + u] = aw & Integer.MAX_VALUE;
            cc = aw >>> 31;
            ++u;
        }
    }

    void zint_co_reduce_mod(int[] srca, int a, int[] srcb, int b, int[] srcm, int m, int len, int m0i, long xa, long xb, long ya, long yb) {
        long cca = 0L;
        long ccb = 0L;
        int fa = (srca[a + 0] * (int)xa + srcb[b + 0] * (int)xb) * m0i & Integer.MAX_VALUE;
        int fb = (srca[a + 0] * (int)ya + srcb[b + 0] * (int)yb) * m0i & Integer.MAX_VALUE;
        int u = 0;
        while (u < len) {
            int wa = srca[a + u];
            int wb = srcb[b + u];
            long za = (long)wa * xa + (long)wb * xb + (long)srcm[m + u] * this.toUnsignedLong(fa) + cca;
            long zb = (long)wa * ya + (long)wb * yb + (long)srcm[m + u] * this.toUnsignedLong(fb) + ccb;
            if (u > 0) {
                srca[a + u - 1] = (int)za & Integer.MAX_VALUE;
                srcb[b + u - 1] = (int)zb & Integer.MAX_VALUE;
            }
            cca = za >> 31;
            ccb = zb >> 31;
            ++u;
        }
        srca[a + len - 1] = (int)cca;
        srcb[b + len - 1] = (int)ccb;
        this.zint_finish_mod(srca, a, len, srcm, m, (int)(cca >>> 63));
        this.zint_finish_mod(srcb, b, len, srcm, m, (int)(ccb >>> 63));
    }

    int zint_bezout(int[] srcu, int u, int[] srcv, int v, int[] srcx, int x, int[] srcy, int y, int len, int[] srctmp, int tmp) {
        int j;
        if (len == 0) {
            return 0;
        }
        int u0 = u;
        int v0 = v;
        int u1 = tmp;
        int v1 = u1 + len;
        int a = v1 + len;
        int b = a + len;
        int x0i = this.modp_ninv31(srcx[x + 0]);
        int y0i = this.modp_ninv31(srcy[y + 0]);
        System.arraycopy(srcx, x, srctmp, a, len);
        System.arraycopy(srcy, y, srctmp, b, len);
        srcu[u0 + 0] = 1;
        srcv[v0 + 0] = 0;
        int i = 1;
        while (i < len) {
            srcu[u0 + i] = 0;
            srcv[v0 + i] = 0;
            ++i;
        }
        System.arraycopy(srcy, y, srctmp, u1, len);
        System.arraycopy(srcx, x, srctmp, v1, len);
        int n = v1 + 0;
        srctmp[n] = srctmp[n] - 1;
        int num = 62 * len + 30;
        while (num >= 30) {
            int c0 = -1;
            int c1 = -1;
            int a0 = 0;
            int a1 = 0;
            int b0 = 0;
            int b1 = 0;
            j = len;
            while (j-- > 0) {
                int aw = srctmp[a + j];
                int bw = srctmp[b + j];
                a0 ^= (a0 ^ aw) & c0;
                a1 ^= (a1 ^ aw) & c1;
                b0 ^= (b0 ^ bw) & c0;
                b1 ^= (b1 ^ bw) & c1;
                c1 = c0;
                c0 &= ((aw | bw) + Integer.MAX_VALUE >>> 31) - 1;
            }
            a1 |= a0 & c1;
            b1 |= b0 & c1;
            long a_hi = (this.toUnsignedLong(a0 &= ~c1) << 31) + this.toUnsignedLong(a1);
            long b_hi = (this.toUnsignedLong(b0 &= ~c1) << 31) + this.toUnsignedLong(b1);
            int a_lo = srctmp[a + 0];
            int b_lo = srctmp[b + 0];
            long pa = 1L;
            long pb = 0L;
            long qa = 0L;
            long qb = 1L;
            int i2 = 0;
            while (i2 < 31) {
                long rz = b_hi - a_hi;
                int rt = (int)((rz ^ (a_hi ^ b_hi) & (a_hi ^ rz)) >>> 63);
                int oa = a_lo >> i2 & 1;
                int ob = b_lo >> i2 & 1;
                int cAB = oa & ob & rt;
                int cBA = oa & ob & ~rt;
                int cA = cAB | oa ^ 1;
                a_lo -= b_lo & -cAB;
                a_hi -= b_hi & -this.toUnsignedLong(cAB);
                pa -= qa & -((long)cAB);
                pb -= qb & -((long)cAB);
                b_lo -= a_lo & -cBA;
                b_hi -= a_hi & -this.toUnsignedLong(cBA);
                qa -= pa & -((long)cBA);
                qb -= pb & -((long)cBA);
                a_lo += a_lo & cA - 1;
                pa += pa & (long)cA - 1L;
                pb += pb & (long)cA - 1L;
                a_hi ^= (a_hi ^ a_hi >> 1) & -this.toUnsignedLong(cA);
                b_lo += b_lo & -cA;
                qa += qa & -((long)cA);
                qb += qb & -((long)cA);
                b_hi ^= (b_hi ^ b_hi >> 1) & this.toUnsignedLong(cA) - 1L;
                ++i2;
            }
            int r = this.zint_co_reduce(srctmp, a, srctmp, b, len, pa, pb, qa, qb);
            pa -= pa + pa & -((long)(r & 1));
            pb -= pb + pb & -((long)(r & 1));
            qa -= qa + qa & -((long)(r >>> 1));
            qb -= qb + qb & -((long)(r >>> 1));
            this.zint_co_reduce_mod(srcu, u0, srctmp, u1, srcy, y, len, y0i, pa, pb, qa, qb);
            this.zint_co_reduce_mod(srcv, v0, srctmp, v1, srcx, x, len, x0i, pa, pb, qa, qb);
            num -= 30;
        }
        int rc = srctmp[a + 0] ^ 1;
        j = 1;
        while (j < len) {
            rc |= srctmp[a + j];
            ++j;
        }
        return 1 - ((rc | -rc) >>> 31) & srcx[x + 0] & srcy[y + 0];
    }

    void zint_add_scaled_mul_small(int[] srcx, int x, int xlen, int[] srcy, int y, int ylen, int k, int sch, int scl) {
        if (ylen == 0) {
            return;
        }
        int ysign = -(srcy[y + ylen - 1] >>> 30) >>> 1;
        int tw = 0;
        int cc = 0;
        int u = sch;
        while (u < xlen) {
            int ccu;
            int v = u - sch;
            int wy = v < ylen ? srcy[y + v] : ysign;
            int wys = wy << scl & Integer.MAX_VALUE | tw;
            tw = wy >>> 31 - scl;
            long z = this.toUnsignedLong(wys) * (long)k + this.toUnsignedLong(srcx[x + u]) + (long)cc;
            srcx[x + u] = (int)z & Integer.MAX_VALUE;
            cc = ccu = (int)(z >>> 31);
            ++u;
        }
    }

    void zint_sub_scaled(int[] srcx, int x, int xlen, int[] srcy, int y, int ylen, int sch, int scl) {
        if (ylen == 0) {
            return;
        }
        int ysign = -(srcy[y + ylen - 1] >>> 30) >>> 1;
        int tw = 0;
        int cc = 0;
        int u = sch;
        while (u < xlen) {
            int v = u - sch;
            int wy = v < ylen ? srcy[y + v] : ysign;
            int wys = wy << scl & Integer.MAX_VALUE | tw;
            tw = wy >>> 31 - scl;
            int w = srcx[x + u] - wys - cc;
            srcx[x + u] = w & Integer.MAX_VALUE;
            cc = w >>> 31;
            ++u;
        }
    }

    int zint_one_to_plain(int[] srcx, int x) {
        int w = srcx[x + 0];
        w |= (w & 0x40000000) << 1;
        return w;
    }

    void poly_big_to_fp(FalconFPR[] srcd, int d, int[] srcf, int f, int flen, int fstride, int logn) {
        int n = FalconKeyGen.mkn(logn);
        if (flen == 0) {
            int u = 0;
            while (u < n) {
                srcd[d + u] = this.fpr.fpr_zero;
                ++u;
            }
            return;
        }
        int u = 0;
        while (u < n) {
            int neg = -(srcf[f + flen - 1] >>> 30);
            int xm = neg >>> 1;
            int cc = neg & 1;
            FalconFPR x = this.fpr.fpr_zero;
            FalconFPR fsc = this.fpr.fpr_one;
            int v = 0;
            while (v < flen) {
                int w = (srcf[f + v] ^ xm) + cc;
                cc = w >>> 31;
                w &= Integer.MAX_VALUE;
                w -= w << 1 & neg;
                x = this.fpr.fpr_add(x, this.fpr.fpr_mul(this.fpr.fpr_of(w), fsc));
                ++v;
                fsc = this.fpr.fpr_mul(fsc, this.fpr.fpr_ptwo31);
            }
            srcd[d + u] = x;
            ++u;
            f += fstride;
        }
    }

    int poly_big_to_small(byte[] srcd, int d, int[] srcs, int s, int lim, int logn) {
        int n = FalconKeyGen.mkn(logn);
        int u = 0;
        while (u < n) {
            int z = this.zint_one_to_plain(srcs, s + u);
            if (z < -lim || z > lim) {
                return 0;
            }
            srcd[d + u] = (byte)z;
            ++u;
        }
        return 1;
    }

    void poly_sub_scaled(int[] srcF, int F2, int Flen, int Fstride, int[] srcf, int f, int flen, int fstride, int[] srck, int k, int sch, int scl, int logn) {
        int n = FalconKeyGen.mkn(logn);
        int u = 0;
        while (u < n) {
            int kf = -srck[k + u];
            int x = F2 + u * Fstride;
            int y = f;
            int v = 0;
            while (v < n) {
                this.zint_add_scaled_mul_small(srcF, x, Flen, srcf, y, flen, kf, sch, scl);
                if (u + v == n - 1) {
                    x = F2;
                    kf = -kf;
                } else {
                    x += Fstride;
                }
                y += fstride;
                ++v;
            }
            ++u;
        }
    }

    void poly_sub_scaled_ntt(int[] srcF, int F2, int Flen, int Fstride, int[] srcf, int f, int flen, int fstride, int[] srck, int k, int sch, int scl, int logn, int[] srctmp, int tmp) {
        int x;
        int y;
        int n = FalconKeyGen.mkn(logn);
        int tlen = flen + 1;
        int gm = tmp;
        int igm = gm + FalconKeyGen.mkn(logn);
        int fk = igm + FalconKeyGen.mkn(logn);
        int t1 = fk + n * tlen;
        FalconSmallPrime[] primes = FalconSmallPrimeList.PRIMES;
        int u = 0;
        while (u < tlen) {
            int p = primes[u].p;
            int p0i = this.modp_ninv31(p);
            int R2 = this.modp_R2(p, p0i);
            int Rx = this.modp_Rx(flen, p, p0i, R2);
            this.modp_mkgm2(srctmp, gm, srctmp, igm, logn, primes[u].g, p, p0i);
            int v = 0;
            while (v < n) {
                srctmp[t1 + v] = this.modp_set(srck[k + v], p);
                ++v;
            }
            this.modp_NTT2(srctmp, t1, srctmp, gm, logn, p, p0i);
            v = 0;
            y = f;
            x = fk + u;
            while (v < n) {
                srctmp[x] = this.zint_mod_small_signed(srcf, y, flen, p, p0i, R2, Rx);
                ++v;
                y += fstride;
                x += tlen;
            }
            this.modp_NTT2_ext(srctmp, fk + u, tlen, srctmp, gm, logn, p, p0i);
            v = 0;
            x = fk + u;
            while (v < n) {
                srctmp[x] = this.modp_montymul(this.modp_montymul(srctmp[t1 + v], srctmp[x], p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            this.modp_iNTT2_ext(srctmp, fk + u, tlen, srctmp, igm, logn, p, p0i);
            ++u;
        }
        this.zint_rebuild_CRT(srctmp, fk, tlen, tlen, n, primes, 1, srctmp, t1);
        u = 0;
        x = F2;
        y = fk;
        while (u < n) {
            this.zint_sub_scaled(srcF, x, Flen, srctmp, y, tlen, sch, scl);
            ++u;
            x += Fstride;
            y += tlen;
        }
    }

    long get_rng_u64(SHAKE256 rng) {
        byte[] tmp = new byte[8];
        rng.inner_shake256_extract(tmp, 0, tmp.length);
        return (long)tmp[0] & 0xFFL | ((long)tmp[1] & 0xFFL) << 8 | ((long)tmp[2] & 0xFFL) << 16 | ((long)tmp[3] & 0xFFL) << 24 | ((long)tmp[4] & 0xFFL) << 32 | ((long)tmp[5] & 0xFFL) << 40 | ((long)tmp[6] & 0xFFL) << 48 | ((long)tmp[7] & 0xFFL) << 56;
    }

    int mkgauss(SHAKE256 rng, int logn) {
        int g = 1 << 10 - logn;
        int val = 0;
        int u = 0;
        while (u < g) {
            long r = this.get_rng_u64(rng);
            int neg = (int)(r >>> 63);
            int f = (int)((r &= Long.MAX_VALUE) - this.gauss_1024_12289[0] >>> 63);
            int v = 0;
            r = this.get_rng_u64(rng);
            r &= Long.MAX_VALUE;
            int k = 1;
            while (k < this.gauss_1024_12289.length) {
                int t = (int)(r - this.gauss_1024_12289[k] >>> 63) ^ 1;
                v |= k & -(t & (f ^ 1));
                f |= t;
                ++k;
            }
            v = (v ^ -neg) + neg;
            val += v;
            ++u;
        }
        return val;
    }

    int poly_small_sqnorm(byte[] srcf, int f, int logn) {
        int n = FalconKeyGen.mkn(logn);
        int s = 0;
        int ng = 0;
        int u = 0;
        while (u < n) {
            byte z = srcf[f + u];
            ng |= (s += z * z);
            ++u;
        }
        return s | -(ng >>> 31);
    }

    void poly_small_to_fp(FalconFPR[] srcx, int x, byte[] srcf, int f, int logn) {
        int n = FalconKeyGen.mkn(logn);
        int u = 0;
        while (u < n) {
            srcx[x + u] = this.fpr.fpr_of(srcf[f + u]);
            ++u;
        }
    }

    void make_fg_step(int[] srcdata, int data, int logn, int depth, int in_ntt, int out_ntt) {
        int R2;
        int p0i;
        int p;
        int n = 1 << logn;
        int hn = n >> 1;
        int slen = this.MAX_BL_SMALL[depth];
        int tlen = this.MAX_BL_SMALL[depth + 1];
        FalconSmallPrime[] primes = FalconSmallPrimeList.PRIMES;
        int fd = data;
        int gd = fd + hn * tlen;
        int fs = gd + hn * tlen;
        int gs = fs + n * slen;
        int gm = gs + n * slen;
        int igm = gm + n;
        int t1 = igm + n;
        System.arraycopy(srcdata, data, srcdata, fs, 2 * n * slen);
        int u = 0;
        while (u < slen) {
            int w1;
            int w0;
            p = primes[u].p;
            p0i = this.modp_ninv31(p);
            R2 = this.modp_R2(p, p0i);
            this.modp_mkgm2(srcdata, gm, srcdata, igm, logn, primes[u].g, p, p0i);
            int v = 0;
            int x = fs + u;
            while (v < n) {
                srcdata[t1 + v] = srcdata[x];
                ++v;
                x += slen;
            }
            if (in_ntt == 0) {
                this.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            }
            v = 0;
            x = fd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1) + 0];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = this.modp_montymul(this.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            if (in_ntt != 0) {
                this.modp_iNTT2_ext(srcdata, fs + u, slen, srcdata, igm, logn, p, p0i);
            }
            v = 0;
            x = gs + u;
            while (v < n) {
                srcdata[t1 + v] = srcdata[x];
                ++v;
                x += slen;
            }
            if (in_ntt == 0) {
                this.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            }
            v = 0;
            x = gd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1) + 0];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = this.modp_montymul(this.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            if (in_ntt != 0) {
                this.modp_iNTT2_ext(srcdata, gs + u, slen, srcdata, igm, logn, p, p0i);
            }
            if (out_ntt == 0) {
                this.modp_iNTT2_ext(srcdata, fd + u, tlen, srcdata, igm, logn - 1, p, p0i);
                this.modp_iNTT2_ext(srcdata, gd + u, tlen, srcdata, igm, logn - 1, p, p0i);
            }
            ++u;
        }
        this.zint_rebuild_CRT(srcdata, fs, slen, slen, n, primes, 1, srcdata, gm);
        this.zint_rebuild_CRT(srcdata, gs, slen, slen, n, primes, 1, srcdata, gm);
        u = slen;
        while (u < tlen) {
            int w1;
            int w0;
            p = primes[u].p;
            p0i = this.modp_ninv31(p);
            R2 = this.modp_R2(p, p0i);
            int Rx = this.modp_Rx(slen, p, p0i, R2);
            this.modp_mkgm2(srcdata, gm, srcdata, igm, logn, primes[u].g, p, p0i);
            int v = 0;
            int x = fs;
            while (v < n) {
                srcdata[t1 + v] = this.zint_mod_small_signed(srcdata, x, slen, p, p0i, R2, Rx);
                ++v;
                x += slen;
            }
            this.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            v = 0;
            x = fd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1) + 0];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = this.modp_montymul(this.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            v = 0;
            x = gs;
            while (v < n) {
                srcdata[t1 + v] = this.zint_mod_small_signed(srcdata, x, slen, p, p0i, R2, Rx);
                ++v;
                x += slen;
            }
            this.modp_NTT2(srcdata, t1, srcdata, gm, logn, p, p0i);
            v = 0;
            x = gd + u;
            while (v < hn) {
                w0 = srcdata[t1 + (v << 1) + 0];
                w1 = srcdata[t1 + (v << 1) + 1];
                srcdata[x] = this.modp_montymul(this.modp_montymul(w0, w1, p, p0i), R2, p, p0i);
                ++v;
                x += tlen;
            }
            if (out_ntt == 0) {
                this.modp_iNTT2_ext(srcdata, fd + u, tlen, srcdata, igm, logn - 1, p, p0i);
                this.modp_iNTT2_ext(srcdata, gd + u, tlen, srcdata, igm, logn - 1, p, p0i);
            }
            ++u;
        }
    }

    void make_fg(int[] srcdata, int data, byte[] srcf, int f, byte[] srcg, int g, int logn, int depth, int out_ntt) {
        int n = FalconKeyGen.mkn(logn);
        int ft = data;
        int gt = ft + n;
        FalconSmallPrime[] primes = FalconSmallPrimeList.PRIMES;
        int p0 = primes[0].p;
        int u = 0;
        while (u < n) {
            srcdata[ft + u] = this.modp_set(srcf[f + u], p0);
            srcdata[gt + u] = this.modp_set(srcg[g + u], p0);
            ++u;
        }
        if (depth == 0 && out_ntt != 0) {
            int p = primes[0].p;
            int p0i = this.modp_ninv31(p);
            int gm = gt + n;
            int igm = gm + n;
            this.modp_mkgm2(srcdata, gm, srcdata, igm, logn, primes[0].g, p, p0i);
            this.modp_NTT2(srcdata, ft, srcdata, gm, logn, p, p0i);
            this.modp_NTT2(srcdata, gt, srcdata, gm, logn, p, p0i);
            return;
        }
        int d = 0;
        while (d < depth) {
            this.make_fg_step(srcdata, data, logn - d, d, d != 0 ? 1 : 0, d + 1 < depth || out_ntt != 0 ? 1 : 0);
            ++d;
        }
    }

    int solve_NTRU_deepest(int logn_top, byte[] srcf, int f, byte[] srcg, int g, int[] srctmp, int tmp) {
        int len = this.MAX_BL_SMALL[logn_top];
        FalconSmallPrime[] primes = FalconSmallPrimeList.PRIMES;
        int Fp2 = tmp;
        int Gp = Fp2 + len;
        int fp = Gp + len;
        int gp = fp + len;
        int t1 = gp + len;
        this.make_fg(srctmp, fp, srcf, f, srcg, g, logn_top, logn_top, 0);
        this.zint_rebuild_CRT(srctmp, fp, len, len, 2, primes, 0, srctmp, t1);
        if (this.zint_bezout(srctmp, Gp, srctmp, Fp2, srctmp, fp, srctmp, gp, len, srctmp, t1) == 0) {
            return 0;
        }
        int q = 12289;
        if (this.zint_mul_small(srctmp, Fp2, len, q) != 0 || this.zint_mul_small(srctmp, Gp, len, q) != 0) {
            return 0;
        }
        return 1;
    }

    int solve_NTRU_intermediate(int logn_top, byte[] srcf, int f, byte[] srcg, int g, int depth, int[] srctmp, int tmp) {
        int y;
        int x;
        int R2;
        int p0i;
        int p;
        int logn = logn_top - depth;
        int n = 1 << logn;
        int hn = n >> 1;
        int slen = this.MAX_BL_SMALL[depth];
        int dlen = this.MAX_BL_SMALL[depth + 1];
        int llen = this.MAX_BL_LARGE[depth];
        FalconSmallPrime[] primes = FalconSmallPrimeList.PRIMES;
        int Fd = tmp;
        int Gd = Fd + dlen * hn;
        int ft = Gd + dlen * hn;
        this.make_fg(srctmp, ft, srcf, f, srcg, g, logn_top, depth, 1);
        int Ft = tmp;
        int Gt = Ft + n * llen;
        int t1 = Gt + n * llen;
        System.arraycopy(srctmp, ft, srctmp, t1, 2 * n * slen);
        ft = t1;
        int gt = ft + slen * n;
        t1 = gt + slen * n;
        System.arraycopy(srctmp, Fd, srctmp, t1, 2 * hn * dlen);
        Fd = t1;
        Gd = Fd + hn * dlen;
        int u = 0;
        while (u < llen) {
            p = primes[u].p;
            p0i = this.modp_ninv31(p);
            R2 = this.modp_R2(p, p0i);
            int Rx = this.modp_Rx(dlen, p, p0i, R2);
            int v = 0;
            int xs = Fd;
            int ys = Gd;
            int xd = Ft + u;
            int yd = Gt + u;
            while (v < hn) {
                srctmp[xd] = this.zint_mod_small_signed(srctmp, xs, dlen, p, p0i, R2, Rx);
                srctmp[yd] = this.zint_mod_small_signed(srctmp, ys, dlen, p, p0i, R2, Rx);
                ++v;
                xs += dlen;
                ys += dlen;
                xd += llen;
                yd += llen;
            }
            ++u;
        }
        u = 0;
        while (u < llen) {
            int v;
            p = primes[u].p;
            p0i = this.modp_ninv31(p);
            R2 = this.modp_R2(p, p0i);
            if (u == slen) {
                this.zint_rebuild_CRT(srctmp, ft, slen, slen, n, primes, 1, srctmp, t1);
                this.zint_rebuild_CRT(srctmp, gt, slen, slen, n, primes, 1, srctmp, t1);
            }
            int gm = t1;
            int igm = gm + n;
            int fx = igm + n;
            int gx = fx + n;
            this.modp_mkgm2(srctmp, gm, srctmp, igm, logn, primes[u].g, p, p0i);
            if (u < slen) {
                v = 0;
                x = ft + u;
                y = gt + u;
                while (v < n) {
                    srctmp[fx + v] = srctmp[x];
                    srctmp[gx + v] = srctmp[y];
                    ++v;
                    x += slen;
                    y += slen;
                }
                this.modp_iNTT2_ext(srctmp, ft + u, slen, srctmp, igm, logn, p, p0i);
                this.modp_iNTT2_ext(srctmp, gt + u, slen, srctmp, igm, logn, p, p0i);
            } else {
                int Rx = this.modp_Rx(slen, p, p0i, R2);
                v = 0;
                x = ft;
                y = gt;
                while (v < n) {
                    srctmp[fx + v] = this.zint_mod_small_signed(srctmp, x, slen, p, p0i, R2, Rx);
                    srctmp[gx + v] = this.zint_mod_small_signed(srctmp, y, slen, p, p0i, R2, Rx);
                    ++v;
                    x += slen;
                    y += slen;
                }
                this.modp_NTT2(srctmp, fx, srctmp, gm, logn, p, p0i);
                this.modp_NTT2(srctmp, gx, srctmp, gm, logn, p, p0i);
            }
            int Fp2 = gx + n;
            int Gp = Fp2 + hn;
            v = 0;
            x = Ft + u;
            y = Gt + u;
            while (v < hn) {
                srctmp[Fp2 + v] = srctmp[x];
                srctmp[Gp + v] = srctmp[y];
                ++v;
                x += llen;
                y += llen;
            }
            this.modp_NTT2(srctmp, Fp2, srctmp, gm, logn - 1, p, p0i);
            this.modp_NTT2(srctmp, Gp, srctmp, gm, logn - 1, p, p0i);
            v = 0;
            x = Ft + u;
            y = Gt + u;
            while (v < hn) {
                int ftA = srctmp[fx + (v << 1) + 0];
                int ftB = srctmp[fx + (v << 1) + 1];
                int gtA = srctmp[gx + (v << 1) + 0];
                int gtB = srctmp[gx + (v << 1) + 1];
                int mFp = this.modp_montymul(srctmp[Fp2 + v], R2, p, p0i);
                int mGp = this.modp_montymul(srctmp[Gp + v], R2, p, p0i);
                srctmp[x + 0] = this.modp_montymul(gtB, mFp, p, p0i);
                srctmp[x + llen] = this.modp_montymul(gtA, mFp, p, p0i);
                srctmp[y + 0] = this.modp_montymul(ftB, mGp, p, p0i);
                srctmp[y + llen] = this.modp_montymul(ftA, mGp, p, p0i);
                ++v;
                x += llen << 1;
                y += llen << 1;
            }
            this.modp_iNTT2_ext(srctmp, Ft + u, llen, srctmp, igm, logn, p, p0i);
            this.modp_iNTT2_ext(srctmp, Gt + u, llen, srctmp, igm, logn, p, p0i);
            ++u;
        }
        this.zint_rebuild_CRT(srctmp, Ft, llen, llen, n, primes, 1, srctmp, t1);
        this.zint_rebuild_CRT(srctmp, Gt, llen, llen, n, primes, 1, srctmp, t1);
        FalconFPR[] rt1 = new FalconFPR[n];
        FalconFPR[] rt2 = new FalconFPR[n];
        FalconFPR[] rt3 = new FalconFPR[n];
        FalconFPR[] rt4 = new FalconFPR[n];
        FalconFPR[] rt5 = new FalconFPR[n >> 1];
        int[] k = new int[n];
        int rlen = slen > 10 ? 10 : slen;
        this.poly_big_to_fp(rt3, 0, srctmp, ft + slen - rlen, rlen, slen, logn);
        this.poly_big_to_fp(rt4, 0, srctmp, gt + slen - rlen, rlen, slen, logn);
        int scale_fg = 31 * (slen - rlen);
        int minbl_fg = this.bitlength_avg[depth] - 6 * this.bitlength_std[depth];
        int maxbl_fg = this.bitlength_avg[depth] + 6 * this.bitlength_std[depth];
        this.fft.FFT(rt3, 0, logn);
        this.fft.FFT(rt4, 0, logn);
        this.fft.poly_invnorm2_fft(rt5, 0, rt3, 0, rt4, 0, logn);
        this.fft.poly_adj_fft(rt3, 0, logn);
        this.fft.poly_adj_fft(rt4, 0, logn);
        int FGlen = llen;
        int maxbl_FG = 31 * llen;
        int scale_k = maxbl_FG - minbl_fg;
        while (true) {
            FalconFPR pt;
            rlen = FGlen > 10 ? 10 : FGlen;
            int scale_FG = 31 * (FGlen - rlen);
            this.poly_big_to_fp(rt1, 0, srctmp, Ft + FGlen - rlen, rlen, llen, logn);
            this.poly_big_to_fp(rt2, 0, srctmp, Gt + FGlen - rlen, rlen, llen, logn);
            this.fft.FFT(rt1, 0, logn);
            this.fft.FFT(rt2, 0, logn);
            this.fft.poly_mul_fft(rt1, 0, rt3, 0, logn);
            this.fft.poly_mul_fft(rt2, 0, rt4, 0, logn);
            this.fft.poly_add(rt2, 0, rt1, 0, logn);
            this.fft.poly_mul_autoadj_fft(rt2, 0, rt5, 0, logn);
            this.fft.iFFT(rt2, 0, logn);
            int dc = scale_k - scale_FG + scale_fg;
            if (dc < 0) {
                dc = -dc;
                pt = this.fpr.fpr_two;
            } else {
                pt = this.fpr.fpr_onehalf;
            }
            FalconFPR pdc = this.fpr.fpr_one;
            while (dc != 0) {
                if ((dc & 1) != 0) {
                    pdc = this.fpr.fpr_mul(pdc, pt);
                }
                dc >>= 1;
                pt = this.fpr.fpr_sqr(pt);
            }
            u = 0;
            while (u < n) {
                FalconFPR xv = this.fpr.fpr_mul(rt2[u], pdc);
                if (!this.fpr.fpr_lt(this.fpr.fpr_mtwo31m1, xv) || !this.fpr.fpr_lt(xv, this.fpr.fpr_ptwo31m1)) {
                    return 0;
                }
                k[u] = (int)this.fpr.fpr_rint(xv);
                ++u;
            }
            int sch = scale_k / 31;
            int scl = scale_k % 31;
            if (depth <= 4) {
                this.poly_sub_scaled_ntt(srctmp, Ft, FGlen, llen, srctmp, ft, slen, slen, k, 0, sch, scl, logn, srctmp, t1);
                this.poly_sub_scaled_ntt(srctmp, Gt, FGlen, llen, srctmp, gt, slen, slen, k, 0, sch, scl, logn, srctmp, t1);
            } else {
                this.poly_sub_scaled(srctmp, Ft, FGlen, llen, srctmp, ft, slen, slen, k, 0, sch, scl, logn);
                this.poly_sub_scaled(srctmp, Gt, FGlen, llen, srctmp, gt, slen, slen, k, 0, sch, scl, logn);
            }
            int new_maxbl_FG = scale_k + maxbl_fg + 10;
            if (new_maxbl_FG < maxbl_FG && FGlen * 31 >= (maxbl_FG = new_maxbl_FG) + 31) {
                --FGlen;
            }
            if (scale_k <= 0) break;
            if ((scale_k -= 25) >= 0) continue;
            scale_k = 0;
        }
        if (FGlen < slen) {
            u = 0;
            while (u < n) {
                int sw = -(srctmp[Ft + FGlen - 1] >>> 30) >>> 1;
                int v = FGlen;
                while (v < slen) {
                    srctmp[Ft + v] = sw;
                    ++v;
                }
                sw = -(srctmp[Gt + FGlen - 1] >>> 30) >>> 1;
                v = FGlen;
                while (v < slen) {
                    srctmp[Gt + v] = sw;
                    ++v;
                }
                ++u;
                Ft += llen;
                Gt += llen;
            }
        }
        u = 0;
        x = tmp;
        y = tmp;
        while (u < n << 1) {
            System.arraycopy(srctmp, y, srctmp, x, slen);
            ++u;
            x += slen;
            y += llen;
        }
        return 1;
    }

    int solve_NTRU_binary_depth1(int logn_top, byte[] srcf, int f, byte[] srcg, int g, int[] srctmp, int tmp) {
        int R2;
        int p0i;
        int p;
        int depth = 1;
        int n_top = 1 << logn_top;
        int logn = logn_top - depth;
        int n = 1 << logn;
        int hn = n >> 1;
        int slen = this.MAX_BL_SMALL[depth];
        int dlen = this.MAX_BL_SMALL[depth + 1];
        int llen = this.MAX_BL_LARGE[depth];
        int Fd = tmp;
        int Gd = Fd + dlen * hn;
        int Ft = Gd + dlen * hn;
        int Gt = Ft + llen * n;
        int u = 0;
        while (u < llen) {
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = this.modp_ninv31(p);
            R2 = this.modp_R2(p, p0i);
            int Rx = this.modp_Rx(dlen, p, p0i, R2);
            int v = 0;
            int xs = Fd;
            int ys = Gd;
            int xd = Ft + u;
            int yd = Gt + u;
            while (v < hn) {
                srctmp[xd] = this.zint_mod_small_signed(srctmp, xs, dlen, p, p0i, R2, Rx);
                srctmp[yd] = this.zint_mod_small_signed(srctmp, ys, dlen, p, p0i, R2, Rx);
                ++v;
                xs += dlen;
                ys += dlen;
                xd += llen;
                yd += llen;
            }
            ++u;
        }
        System.arraycopy(srctmp, Ft, srctmp, tmp, llen * n);
        Ft = tmp;
        System.arraycopy(srctmp, Gt, srctmp, Ft + llen * n, llen * n);
        Gt = Ft + llen * n;
        int ft = Gt + llen * n;
        int gt = ft + slen * n;
        int t1 = gt + slen * n;
        u = 0;
        while (u < llen) {
            p = FalconSmallPrimeList.PRIMES[u].p;
            p0i = this.modp_ninv31(p);
            R2 = this.modp_R2(p, p0i);
            int gm = t1;
            int igm = gm + n_top;
            int fx = igm + n;
            int gx = fx + n_top;
            this.modp_mkgm2(srctmp, gm, srctmp, igm, logn_top, FalconSmallPrimeList.PRIMES[u].g, p, p0i);
            int v = 0;
            while (v < n_top) {
                srctmp[fx + v] = this.modp_set(srcf[f + v], p);
                srctmp[gx + v] = this.modp_set(srcg[g + v], p);
                ++v;
            }
            this.modp_NTT2(srctmp, fx, srctmp, gm, logn_top, p, p0i);
            this.modp_NTT2(srctmp, gx, srctmp, gm, logn_top, p, p0i);
            int e = logn_top;
            while (e > logn) {
                this.modp_poly_rec_res(srctmp, fx, e, p, p0i, R2);
                this.modp_poly_rec_res(srctmp, gx, e, p, p0i, R2);
                --e;
            }
            if (depth > 0) {
                System.arraycopy(srctmp, igm, srctmp, gm + n, n);
                igm = gm + n;
                System.arraycopy(srctmp, fx, srctmp, igm + n, n);
                fx = igm + n;
                System.arraycopy(srctmp, gx, srctmp, fx + n, n);
                gx = fx + n;
            }
            int Fp2 = gx + n;
            int Gp = Fp2 + hn;
            v = 0;
            int x = Ft + u;
            int y = Gt + u;
            while (v < hn) {
                srctmp[Fp2 + v] = srctmp[x];
                srctmp[Gp + v] = srctmp[y];
                ++v;
                x += llen;
                y += llen;
            }
            this.modp_NTT2(srctmp, Fp2, srctmp, gm, logn - 1, p, p0i);
            this.modp_NTT2(srctmp, Gp, srctmp, gm, logn - 1, p, p0i);
            v = 0;
            x = Ft + u;
            y = Gt + u;
            while (v < hn) {
                int ftA = srctmp[fx + (v << 1) + 0];
                int ftB = srctmp[fx + (v << 1) + 1];
                int gtA = srctmp[gx + (v << 1) + 0];
                int gtB = srctmp[gx + (v << 1) + 1];
                int mFp = this.modp_montymul(srctmp[Fp2 + v], R2, p, p0i);
                int mGp = this.modp_montymul(srctmp[Gp + v], R2, p, p0i);
                srctmp[x + 0] = this.modp_montymul(gtB, mFp, p, p0i);
                srctmp[x + llen] = this.modp_montymul(gtA, mFp, p, p0i);
                srctmp[y + 0] = this.modp_montymul(ftB, mGp, p, p0i);
                srctmp[y + llen] = this.modp_montymul(ftA, mGp, p, p0i);
                ++v;
                x += llen << 1;
                y += llen << 1;
            }
            this.modp_iNTT2_ext(srctmp, Ft + u, llen, srctmp, igm, logn, p, p0i);
            this.modp_iNTT2_ext(srctmp, Gt + u, llen, srctmp, igm, logn, p, p0i);
            if (u < slen) {
                this.modp_iNTT2(srctmp, fx, srctmp, igm, logn, p, p0i);
                this.modp_iNTT2(srctmp, gx, srctmp, igm, logn, p, p0i);
                v = 0;
                x = ft + u;
                y = gt + u;
                while (v < n) {
                    srctmp[x] = srctmp[fx + v];
                    srctmp[y] = srctmp[gx + v];
                    ++v;
                    x += slen;
                    y += slen;
                }
            }
            ++u;
        }
        this.zint_rebuild_CRT(srctmp, Ft, llen, llen, n << 1, FalconSmallPrimeList.PRIMES, 1, srctmp, t1);
        this.zint_rebuild_CRT(srctmp, ft, slen, slen, n << 1, FalconSmallPrimeList.PRIMES, 1, srctmp, t1);
        FalconFPR[] rt1 = new FalconFPR[n];
        FalconFPR[] rt2 = new FalconFPR[n];
        this.poly_big_to_fp(rt1, 0, srctmp, Ft, llen, llen, logn);
        this.poly_big_to_fp(rt2, 0, srctmp, Gt, llen, llen, logn);
        System.arraycopy(srctmp, ft, srctmp, tmp, 2 * slen * n);
        ft = tmp;
        gt = ft + slen * n;
        FalconFPR[] rt3 = new FalconFPR[n];
        FalconFPR[] rt4 = new FalconFPR[n];
        this.poly_big_to_fp(rt3, 0, srctmp, ft, slen, slen, logn);
        this.poly_big_to_fp(rt4, 0, srctmp, gt, slen, slen, logn);
        this.fft.FFT(rt1, 0, logn);
        this.fft.FFT(rt2, 0, logn);
        this.fft.FFT(rt3, 0, logn);
        this.fft.FFT(rt4, 0, logn);
        FalconFPR[] rt5 = new FalconFPR[n];
        FalconFPR[] rt6 = new FalconFPR[n >> 1];
        this.fft.poly_add_muladj_fft(rt5, 0, rt1, 0, rt2, 0, rt3, 0, rt4, 0, logn);
        this.fft.poly_invnorm2_fft(rt6, 0, rt3, 0, rt4, 0, logn);
        this.fft.poly_mul_autoadj_fft(rt5, 0, rt6, 0, logn);
        this.fft.iFFT(rt5, 0, logn);
        u = 0;
        while (u < n) {
            FalconFPR z = rt5[u];
            if (!this.fpr.fpr_lt(z, this.fpr.fpr_ptwo63m1) || !this.fpr.fpr_lt(this.fpr.fpr_mtwo63m1, z)) {
                return 0;
            }
            rt5[u] = this.fpr.fpr_of(this.fpr.fpr_rint(z));
            ++u;
        }
        this.fft.FFT(rt5, 0, logn);
        this.fft.poly_mul_fft(rt3, 0, rt5, 0, logn);
        this.fft.poly_mul_fft(rt4, 0, rt5, 0, logn);
        this.fft.poly_sub(rt1, 0, rt3, 0, logn);
        this.fft.poly_sub(rt2, 0, rt4, 0, logn);
        this.fft.iFFT(rt1, 0, logn);
        this.fft.iFFT(rt2, 0, logn);
        Ft = tmp;
        Gt = Ft + n;
        u = 0;
        while (u < n) {
            srctmp[Ft + u] = (int)this.fpr.fpr_rint(rt1[u]);
            srctmp[Gt + u] = (int)this.fpr.fpr_rint(rt2[u]);
            ++u;
        }
        return 1;
    }

    int solve_NTRU_binary_depth0(int logn, byte[] srcf, int f, byte[] srcg, int g, int[] srctmp, int tmp) {
        int w;
        int n = 1 << logn;
        int hn = n >> 1;
        int p = FalconSmallPrimeList.PRIMES[0].p;
        int p0i = this.modp_ninv31(p);
        int R2 = this.modp_R2(p, p0i);
        int Fp2 = tmp;
        int Gp = Fp2 + hn;
        int ft = Gp + hn;
        int gt = ft + n;
        int gm = gt + n;
        int igm = gm + n;
        this.modp_mkgm2(srctmp, gm, srctmp, igm, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        int u = 0;
        while (u < hn) {
            srctmp[Fp2 + u] = this.modp_set(this.zint_one_to_plain(srctmp, Fp2 + u), p);
            srctmp[Gp + u] = this.modp_set(this.zint_one_to_plain(srctmp, Gp + u), p);
            ++u;
        }
        this.modp_NTT2(srctmp, Fp2, srctmp, gm, logn - 1, p, p0i);
        this.modp_NTT2(srctmp, Gp, srctmp, gm, logn - 1, p, p0i);
        u = 0;
        while (u < n) {
            srctmp[ft + u] = this.modp_set(srcf[f + u], p);
            srctmp[gt + u] = this.modp_set(srcg[g + u], p);
            ++u;
        }
        this.modp_NTT2(srctmp, ft, srctmp, gm, logn, p, p0i);
        this.modp_NTT2(srctmp, gt, srctmp, gm, logn, p, p0i);
        u = 0;
        while (u < n) {
            int ftA = srctmp[ft + u + 0];
            int ftB = srctmp[ft + u + 1];
            int gtA = srctmp[gt + u + 0];
            int gtB = srctmp[gt + u + 1];
            int mFp = this.modp_montymul(srctmp[Fp2 + (u >> 1)], R2, p, p0i);
            int mGp = this.modp_montymul(srctmp[Gp + (u >> 1)], R2, p, p0i);
            srctmp[ft + u + 0] = this.modp_montymul(gtB, mFp, p, p0i);
            srctmp[ft + u + 1] = this.modp_montymul(gtA, mFp, p, p0i);
            srctmp[gt + u + 0] = this.modp_montymul(ftB, mGp, p, p0i);
            srctmp[gt + u + 1] = this.modp_montymul(ftA, mGp, p, p0i);
            u += 2;
        }
        this.modp_iNTT2(srctmp, ft, srctmp, igm, logn, p, p0i);
        this.modp_iNTT2(srctmp, gt, srctmp, igm, logn, p, p0i);
        Gp = Fp2 + n;
        int t1 = Gp + n;
        System.arraycopy(srctmp, ft, srctmp, Fp2, 2 * n);
        int t2 = t1 + n;
        int t3 = t2 + n;
        int t4 = t3 + n;
        int t5 = t4 + n;
        this.modp_mkgm2(srctmp, t1, srctmp, t2, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        this.modp_NTT2(srctmp, Fp2, srctmp, t1, logn, p, p0i);
        this.modp_NTT2(srctmp, Gp, srctmp, t1, logn, p, p0i);
        int n2 = this.modp_set(srcf[f + 0], p);
        srctmp[t5 + 0] = n2;
        srctmp[t4 + 0] = n2;
        u = 1;
        while (u < n) {
            srctmp[t4 + u] = this.modp_set(srcf[f + u], p);
            srctmp[t5 + n - u] = this.modp_set(-srcf[f + u], p);
            ++u;
        }
        this.modp_NTT2(srctmp, t4, srctmp, t1, logn, p, p0i);
        this.modp_NTT2(srctmp, t5, srctmp, t1, logn, p, p0i);
        u = 0;
        while (u < n) {
            w = this.modp_montymul(srctmp[t5 + u], R2, p, p0i);
            srctmp[t2 + u] = this.modp_montymul(w, srctmp[Fp2 + u], p, p0i);
            srctmp[t3 + u] = this.modp_montymul(w, srctmp[t4 + u], p, p0i);
            ++u;
        }
        int n3 = this.modp_set(srcg[g + 0], p);
        srctmp[t5 + 0] = n3;
        srctmp[t4 + 0] = n3;
        u = 1;
        while (u < n) {
            srctmp[t4 + u] = this.modp_set(srcg[g + u], p);
            srctmp[t5 + n - u] = this.modp_set(-srcg[g + u], p);
            ++u;
        }
        this.modp_NTT2(srctmp, t4, srctmp, t1, logn, p, p0i);
        this.modp_NTT2(srctmp, t5, srctmp, t1, logn, p, p0i);
        u = 0;
        while (u < n) {
            w = this.modp_montymul(srctmp[t5 + u], R2, p, p0i);
            srctmp[t2 + u] = this.modp_add(srctmp[t2 + u], this.modp_montymul(w, srctmp[Gp + u], p, p0i), p);
            srctmp[t3 + u] = this.modp_add(srctmp[t3 + u], this.modp_montymul(w, srctmp[t4 + u], p, p0i), p);
            ++u;
        }
        this.modp_mkgm2(srctmp, t1, srctmp, t4, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        this.modp_iNTT2(srctmp, t2, srctmp, t4, logn, p, p0i);
        this.modp_iNTT2(srctmp, t3, srctmp, t4, logn, p, p0i);
        u = 0;
        while (u < n) {
            srctmp[t1 + u] = this.modp_norm(srctmp[t2 + u], p);
            srctmp[t2 + u] = this.modp_norm(srctmp[t3 + u], p);
            ++u;
        }
        FalconFPR[] tmp2 = new FalconFPR[3 * n];
        int rt1 = 0;
        int rt2 = rt1 + n;
        int rt3 = rt2 + n;
        u = 0;
        while (u < n) {
            tmp2[rt3 + u] = this.fpr.fpr_of(srctmp[t2 + u]);
            ++u;
        }
        this.fft.FFT(tmp2, rt3, logn);
        System.arraycopy(tmp2, rt3, tmp2, rt2, hn);
        rt3 = rt2 + hn;
        u = 0;
        while (u < n) {
            tmp2[rt3 + u] = this.fpr.fpr_of(srctmp[t1 + u]);
            ++u;
        }
        this.fft.FFT(tmp2, rt3, logn);
        this.fft.poly_div_autoadj_fft(tmp2, rt3, tmp2, rt2, logn);
        this.fft.iFFT(tmp2, rt3, logn);
        u = 0;
        while (u < n) {
            srctmp[t1 + u] = this.modp_set((int)this.fpr.fpr_rint(tmp2[rt3 + u]), p);
            ++u;
        }
        t2 = t1 + n;
        t3 = t2 + n;
        t4 = t3 + n;
        t5 = t4 + n;
        this.modp_mkgm2(srctmp, t2, srctmp, t3, logn, FalconSmallPrimeList.PRIMES[0].g, p, p0i);
        u = 0;
        while (u < n) {
            srctmp[t4 + u] = this.modp_set(srcf[f + u], p);
            srctmp[t5 + u] = this.modp_set(srcg[g + u], p);
            ++u;
        }
        this.modp_NTT2(srctmp, t1, srctmp, t2, logn, p, p0i);
        this.modp_NTT2(srctmp, t4, srctmp, t2, logn, p, p0i);
        this.modp_NTT2(srctmp, t5, srctmp, t2, logn, p, p0i);
        u = 0;
        while (u < n) {
            int kw = this.modp_montymul(srctmp[t1 + u], R2, p, p0i);
            srctmp[Fp2 + u] = this.modp_sub(srctmp[Fp2 + u], this.modp_montymul(kw, srctmp[t4 + u], p, p0i), p);
            srctmp[Gp + u] = this.modp_sub(srctmp[Gp + u], this.modp_montymul(kw, srctmp[t5 + u], p, p0i), p);
            ++u;
        }
        this.modp_iNTT2(srctmp, Fp2, srctmp, t3, logn, p, p0i);
        this.modp_iNTT2(srctmp, Gp, srctmp, t3, logn, p, p0i);
        u = 0;
        while (u < n) {
            srctmp[Fp2 + u] = this.modp_norm(srctmp[Fp2 + u], p);
            srctmp[Gp + u] = this.modp_norm(srctmp[Gp + u], p);
            ++u;
        }
        return 1;
    }

    int solve_NTRU(int logn, byte[] srcF, int F2, byte[] srcG, int G, byte[] srcf, int f, byte[] srcg, int g, int lim, int[] srctmp, int tmp) {
        int depth;
        int n = FalconKeyGen.mkn(logn);
        if (this.solve_NTRU_deepest(logn, srcf, f, srcg, g, srctmp, tmp) == 0) {
            return 0;
        }
        if (logn <= 2) {
            depth = logn;
            while (depth-- > 0) {
                if (this.solve_NTRU_intermediate(logn, srcf, f, srcg, g, depth, srctmp, tmp) != 0) continue;
                return 0;
            }
        } else {
            depth = logn;
            while (depth-- > 2) {
                if (this.solve_NTRU_intermediate(logn, srcf, f, srcg, g, depth, srctmp, tmp) != 0) continue;
                return 0;
            }
            if (this.solve_NTRU_binary_depth1(logn, srcf, f, srcg, g, srctmp, tmp) == 0) {
                return 0;
            }
            if (this.solve_NTRU_binary_depth0(logn, srcf, f, srcg, g, srctmp, tmp) == 0) {
                return 0;
            }
        }
        if (srcG == null) {
            G = 0;
            srcG = new byte[n];
        }
        if (this.poly_big_to_small(srcF, F2, srctmp, tmp, lim, logn) == 0 || this.poly_big_to_small(srcG, G, srctmp, tmp + n, lim, logn) == 0) {
            return 0;
        }
        int Gt = tmp;
        int ft = Gt + n;
        int gt = ft + n;
        int Ft = gt + n;
        int gm = Ft + n;
        FalconSmallPrime[] primes = FalconSmallPrimeList.PRIMES;
        int p = primes[0].p;
        int p0i = this.modp_ninv31(p);
        this.modp_mkgm2(srctmp, gm, srctmp, tmp, logn, primes[0].g, p, p0i);
        int u = 0;
        while (u < n) {
            srctmp[Gt + u] = this.modp_set(srcG[G + u], p);
            ++u;
        }
        u = 0;
        while (u < n) {
            srctmp[ft + u] = this.modp_set(srcf[f + u], p);
            srctmp[gt + u] = this.modp_set(srcg[g + u], p);
            srctmp[Ft + u] = this.modp_set(srcF[F2 + u], p);
            ++u;
        }
        this.modp_NTT2(srctmp, ft, srctmp, gm, logn, p, p0i);
        this.modp_NTT2(srctmp, gt, srctmp, gm, logn, p, p0i);
        this.modp_NTT2(srctmp, Ft, srctmp, gm, logn, p, p0i);
        this.modp_NTT2(srctmp, Gt, srctmp, gm, logn, p, p0i);
        int r = this.modp_montymul(12289, 1, p, p0i);
        u = 0;
        while (u < n) {
            int z = this.modp_sub(this.modp_montymul(srctmp[ft + u], srctmp[Gt + u], p, p0i), this.modp_montymul(srctmp[gt + u], srctmp[Ft + u], p, p0i), p);
            if (z != r) {
                return 0;
            }
            ++u;
        }
        return 1;
    }

    void poly_small_mkgauss(SHAKE256 rng, byte[] srcf, int f, int logn) {
        int n = FalconKeyGen.mkn(logn);
        int mod2 = 0;
        int u = 0;
        while (u < n) {
            int s;
            block4: {
                while (true) {
                    if ((s = this.mkgauss(rng, logn)) < -127 || s > 127) {
                        continue;
                    }
                    if (u != n - 1) break;
                    if ((mod2 ^ s & 1) == 0) {
                        continue;
                    }
                    break block4;
                    break;
                }
                mod2 ^= s & 1;
            }
            srcf[f + u] = (byte)s;
            ++u;
        }
    }

    void keygen(SHAKE256 rng, byte[] srcf, int f, byte[] srcg, int g, byte[] srcF, int F2, byte[] srcG, int G, short[] srch, int h, int logn) {
        int n = FalconKeyGen.mkn(logn);
        SHAKE256 rc = rng;
        while (true) {
            int[] itmp;
            int tmp2;
            int h2;
            int normg;
            int normf;
            int norm;
            FalconFPR[] ftmp = new FalconFPR[3 * n];
            this.poly_small_mkgauss(rc, srcf, f, logn);
            this.poly_small_mkgauss(rc, srcg, g, logn);
            int lim = 1 << this.codec.max_fg_bits[logn] - 1;
            int u = 0;
            while (u < n) {
                if (srcf[f + u] >= lim || srcf[f + u] <= -lim || srcg[g + u] >= lim || srcg[g + u] <= -lim) {
                    lim = -1;
                    break;
                }
                ++u;
            }
            if (lim < 0 || ((long)(norm = (normf = this.poly_small_sqnorm(srcf, f, logn)) + (normg = this.poly_small_sqnorm(srcg, g, logn)) | -((normf | normg) >>> 31)) & 0xFFFFFFFFL) >= 16823L) continue;
            int rt1 = 0;
            int rt2 = rt1 + n;
            int rt3 = rt2 + n;
            this.poly_small_to_fp(ftmp, rt1, srcf, f, logn);
            this.poly_small_to_fp(ftmp, rt2, srcg, g, logn);
            this.fft.FFT(ftmp, rt1, logn);
            this.fft.FFT(ftmp, rt2, logn);
            this.fft.poly_invnorm2_fft(ftmp, rt3, ftmp, rt1, ftmp, rt2, logn);
            this.fft.poly_adj_fft(ftmp, rt1, logn);
            this.fft.poly_adj_fft(ftmp, rt2, logn);
            this.fft.poly_mulconst(ftmp, rt1, this.fpr.fpr_q, logn);
            this.fft.poly_mulconst(ftmp, rt2, this.fpr.fpr_q, logn);
            this.fft.poly_mul_autoadj_fft(ftmp, rt1, ftmp, rt3, logn);
            this.fft.poly_mul_autoadj_fft(ftmp, rt2, ftmp, rt3, logn);
            this.fft.iFFT(ftmp, rt1, logn);
            this.fft.iFFT(ftmp, rt2, logn);
            FalconFPR bnorm = this.fpr.fpr_zero;
            u = 0;
            while (u < n) {
                bnorm = this.fpr.fpr_add(bnorm, this.fpr.fpr_sqr(ftmp[rt1 + u]));
                bnorm = this.fpr.fpr_add(bnorm, this.fpr.fpr_sqr(ftmp[rt2 + u]));
                ++u;
            }
            if (!this.fpr.fpr_lt(bnorm, this.fpr.fpr_bnorm_max)) continue;
            short[] stmp = new short[2 * n];
            if (srch == null) {
                h2 = 0;
                srch = stmp;
                tmp2 = h2 + n;
            } else {
                h2 = h;
                tmp2 = 0;
            }
            if (this.vrfy.compute_public(srch, h2, srcf, f, srcg, g, logn, stmp, tmp2) != 0 && this.solve_NTRU(logn, srcF, F2, srcG, G, srcf, f, srcg, g, lim = (1 << this.codec.max_FG_bits[logn] - 1) - 1, itmp = logn > 2 ? new int[28 * n] : new int[28 * n * 3], 0) != 0) break;
        }
    }

    private long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }
}

