/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

class PolyVecL {
    Poly[] vec;
    private MLDSAEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumL;
    private int dilithiumK;

    public PolyVecL(MLDSAEngine engine) {
        this.engine = engine;
        this.mode = engine.getDilithiumMode();
        this.dilithiumL = engine.getDilithiumL();
        this.dilithiumK = engine.getDilithiumK();
        this.vec = new Poly[this.dilithiumL];
        int i = 0;
        while (i < this.dilithiumL) {
            this.vec[i] = new Poly(engine);
            ++i;
        }
    }

    public PolyVecL() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int i) {
        return this.vec[i];
    }

    public void expandMatrix(byte[] rho, int i) {
        int j = 0;
        while (j < this.dilithiumL) {
            this.vec[j].uniformBlocks(rho, (short)((i << 8) + j));
            ++j;
        }
    }

    public void uniformEta(byte[] seed, short nonce) {
        short n = nonce;
        int i = 0;
        while (i < this.dilithiumL) {
            short s = n;
            n = (short)(s + 1);
            this.getVectorIndex(i).uniformEta(seed, s);
            ++i;
        }
    }

    public void copyPolyVecL(PolyVecL outPoly) {
        int i = 0;
        while (i < this.dilithiumL) {
            int j = 0;
            while (j < 256) {
                outPoly.getVectorIndex(i).setCoeffIndex(j, this.getVectorIndex(i).getCoeffIndex(j));
                ++j;
            }
            ++i;
        }
    }

    public void polyVecNtt() {
        int i = 0;
        while (i < this.dilithiumL) {
            this.vec[i].polyNtt();
            ++i;
        }
    }

    public void uniformGamma1(byte[] seed, short nonce) {
        int i = 0;
        while (i < this.dilithiumL) {
            this.getVectorIndex(i).uniformGamma1(seed, (short)(this.dilithiumL * nonce + i));
            ++i;
        }
    }

    public void pointwisePolyMontgomery(Poly a, PolyVecL v) {
        int i = 0;
        while (i < this.dilithiumL) {
            this.getVectorIndex(i).pointwiseMontgomery(a, v.getVectorIndex(i));
            ++i;
        }
    }

    public void invNttToMont() {
        int i = 0;
        while (i < this.dilithiumL) {
            this.getVectorIndex(i).invNttToMont();
            ++i;
        }
    }

    public void addPolyVecL(PolyVecL v) {
        int i = 0;
        while (i < this.dilithiumL) {
            this.getVectorIndex(i).addPoly(v.getVectorIndex(i));
            ++i;
        }
    }

    public void reduce() {
        int i = 0;
        while (i < this.dilithiumL) {
            this.getVectorIndex(i).reduce();
            ++i;
        }
    }

    public boolean checkNorm(int bound) {
        int i = 0;
        while (i < this.dilithiumL) {
            if (this.getVectorIndex(i).checkNorm(bound)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        String out = "\n[";
        int i = 0;
        while (i < this.dilithiumL) {
            out = String.valueOf(out) + "Inner Matrix " + i + " " + this.getVectorIndex(i).toString();
            if (i != this.dilithiumL - 1) {
                out = String.valueOf(out) + ",\n";
            }
            ++i;
        }
        out = String.valueOf(out) + "]";
        return out;
    }

    public String toString(String name) {
        return String.valueOf(name) + ": " + this.toString();
    }
}

