/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincsplus;

import org.bouncycastle.pqc.crypto.sphincsplus.SIG_FORS;
import org.bouncycastle.pqc.crypto.sphincsplus.SIG_XMSS;

class SIG {
    private final byte[] r;
    private final SIG_FORS[] sig_fors;
    private final SIG_XMSS[] sig_ht;

    public SIG(int n, int k, int a, int d, int hPrime, int wots_len, byte[] signature) {
        int j;
        byte[][] authPath;
        this.r = new byte[n];
        System.arraycopy(signature, 0, this.r, 0, n);
        this.sig_fors = new SIG_FORS[k];
        int offset = n;
        int i = 0;
        while (i != k) {
            byte[] sk = new byte[n];
            System.arraycopy(signature, offset, sk, 0, n);
            offset += n;
            authPath = new byte[a][];
            j = 0;
            while (j != a) {
                authPath[j] = new byte[n];
                System.arraycopy(signature, offset, authPath[j], 0, n);
                offset += n;
                ++j;
            }
            this.sig_fors[i] = new SIG_FORS(sk, authPath);
            ++i;
        }
        this.sig_ht = new SIG_XMSS[d];
        i = 0;
        while (i != d) {
            byte[] sig = new byte[wots_len * n];
            System.arraycopy(signature, offset, sig, 0, sig.length);
            offset += sig.length;
            authPath = new byte[hPrime][];
            j = 0;
            while (j != hPrime) {
                authPath[j] = new byte[n];
                System.arraycopy(signature, offset, authPath[j], 0, n);
                offset += n;
                ++j;
            }
            this.sig_ht[i] = new SIG_XMSS(sig, authPath);
            ++i;
        }
        if (offset != signature.length) {
            throw new IllegalArgumentException("signature wrong length");
        }
    }

    public byte[] getR() {
        return this.r;
    }

    public SIG_FORS[] getSIG_FORS() {
        return this.sig_fors;
    }

    public SIG_XMSS[] getSIG_HT() {
        return this.sig_ht;
    }
}

