/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import java.security.SecureRandom;
import java.util.Random;
import java.util.Vector;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nField;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomial;
import org.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomialElement;
import org.bouncycastle.pqc.legacy.math.linearalgebra.IntegerFunctions;

public class GF2nONBField
extends GF2nField {
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private int mType;
    int[][] mMult;

    public GF2nONBField(int deg, SecureRandom random) throws RuntimeException {
        super(random);
        if (deg < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = deg;
        this.mLength = this.mDegree / 64;
        this.mBit = this.mDegree & 0x3F;
        if (this.mBit == 0) {
            this.mBit = 64;
        } else {
            ++this.mLength;
        }
        this.computeType();
        if (this.mType < 3) {
            this.mMult = new int[this.mDegree][2];
            int i = 0;
            while (i < this.mDegree) {
                this.mMult[i][0] = -1;
                this.mMult[i][1] = -1;
                ++i;
            }
        } else {
            throw new RuntimeException("\nThe type of this field is " + this.mType);
        }
        this.computeMultMatrix();
        this.computeFieldPolynomial();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    int getONBLength() {
        return this.mLength;
    }

    int getONBBit() {
        return this.mBit;
    }

    @Override
    protected GF2nElement getRandomRoot(GF2Polynomial polynomial) {
        GF2nPolynomial g = new GF2nPolynomial(polynomial, this);
        int gDegree = g.getDegree();
        while (gDegree > 1) {
            GF2nPolynomial h;
            int hDegree;
            do {
                GF2nONBElement u = new GF2nONBElement(this, this.random);
                GF2nPolynomial ut = new GF2nPolynomial(2, GF2nONBElement.ZERO(this));
                ut.set(1, u);
                GF2nPolynomial c = new GF2nPolynomial(ut);
                int i = 1;
                while (i <= this.mDegree - 1) {
                    c = c.multiplyAndReduce(c, g);
                    c = c.add(ut);
                    ++i;
                }
                h = c.gcd(g);
                hDegree = h.getDegree();
                gDegree = g.getDegree();
            } while (hDegree == 0 || hDegree == gDegree);
            g = hDegree << 1 > gDegree ? g.quotient(h) : new GF2nPolynomial(h);
            gDegree = g.getDegree();
        }
        return g.at(0);
    }

    @Override
    protected void computeCOBMatrix(GF2nField B1) {
        GF2nElement u;
        if (this.mDegree != B1.mDegree) {
            throw new IllegalArgumentException("GF2nField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        GF2Polynomial[] COBMatrix = new GF2Polynomial[this.mDegree];
        int i = 0;
        while (i < this.mDegree) {
            COBMatrix[i] = new GF2Polynomial(this.mDegree);
            ++i;
        }
        while ((u = B1.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        GF2nPolynomialElement[] gamma = new GF2nPolynomialElement[this.mDegree];
        gamma[0] = (GF2nElement)u.clone();
        i = 1;
        while (i < this.mDegree) {
            gamma[i] = ((GF2nElement)gamma[i - 1]).square();
            ++i;
        }
        i = 0;
        while (i < this.mDegree) {
            int j = 0;
            while (j < this.mDegree) {
                if (((GF2nElement)gamma[i]).testBit(j)) {
                    COBMatrix[this.mDegree - j - 1].setBit(this.mDegree - i - 1);
                }
                ++j;
            }
            ++i;
        }
        this.fields.addElement(B1);
        this.matrices.addElement(COBMatrix);
        B1.fields.addElement(this);
        B1.matrices.addElement(this.invertMatrix(COBMatrix));
    }

    @Override
    protected void computeFieldPolynomial() {
        if (this.mType == 1) {
            this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1, "ALL");
        } else if (this.mType == 2) {
            GF2Polynomial q = new GF2Polynomial(this.mDegree + 1, "ONE");
            GF2Polynomial p = new GF2Polynomial(this.mDegree + 1, "X");
            p.addToThis(q);
            int i = 1;
            while (i < this.mDegree) {
                GF2Polynomial r = q;
                q = p;
                p = q.shiftLeft();
                p.addToThis(r);
                ++i;
            }
            this.fieldPolynomial = p;
        }
    }

    int[][] invMatrix(int[][] a) {
        int[][] A = new int[this.mDegree][this.mDegree];
        A = a;
        int[][] inv = new int[this.mDegree][this.mDegree];
        int i = 0;
        while (i < this.mDegree) {
            inv[i][i] = 1;
            ++i;
        }
        i = 0;
        while (i < this.mDegree) {
            int j = i;
            while (j < this.mDegree) {
                A[this.mDegree - 1 - i][j] = A[i][i];
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void computeType() throws RuntimeException {
        if ((this.mDegree & 7) == 0) {
            throw new RuntimeException("The extension degree is divisible by 8!");
        }
        int s = 0;
        int k = 0;
        this.mType = 1;
        int d = 0;
        while (d != 1) {
            s = this.mType * this.mDegree + 1;
            if (IntegerFunctions.isPrime(s)) {
                k = IntegerFunctions.order(2, s);
                d = IntegerFunctions.gcd(this.mType * this.mDegree / k, this.mDegree);
            }
            ++this.mType;
        }
        --this.mType;
        if (this.mType == 1 && IntegerFunctions.isPrime(s = (this.mDegree << 1) + 1) && (d = IntegerFunctions.gcd((this.mDegree << 1) / (k = IntegerFunctions.order(2, s)), this.mDegree)) == 1) {
            ++this.mType;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeMultMatrix() {
        int k;
        if ((this.mType & 7) == 0) throw new RuntimeException("bisher nur fuer Gausssche Normalbasen implementiert");
        int p = this.mType * this.mDegree + 1;
        int[] F2 = new int[p];
        int u = this.mType == 1 ? 1 : (this.mType == 2 ? p - 1 : this.elementOfOrder(this.mType, p));
        int w = 1;
        int j = 0;
        while (j < this.mType) {
            int n = w;
            int i = 0;
            while (i < this.mDegree) {
                F2[n] = i;
                if ((n = (n << 1) % p) < 0) {
                    n += p;
                }
                ++i;
            }
            if ((w = u * w % p) < 0) {
                w += p;
            }
            ++j;
        }
        if (this.mType == 1) {
            k = 1;
            while (k < p - 1) {
                if (this.mMult[F2[k + 1]][0] == -1) {
                    this.mMult[F2[k + 1]][0] = F2[p - k];
                } else {
                    this.mMult[F2[k + 1]][1] = F2[p - k];
                }
                ++k;
            }
            int m_2 = this.mDegree >> 1;
            int k2 = 1;
            while (k2 <= m_2) {
                if (this.mMult[k2 - 1][0] == -1) {
                    this.mMult[k2 - 1][0] = m_2 + k2 - 1;
                } else {
                    this.mMult[k2 - 1][1] = m_2 + k2 - 1;
                }
                if (this.mMult[m_2 + k2 - 1][0] == -1) {
                    this.mMult[m_2 + k2 - 1][0] = k2 - 1;
                } else {
                    this.mMult[m_2 + k2 - 1][1] = k2 - 1;
                }
                ++k2;
            }
            return;
        } else {
            if (this.mType != 2) throw new RuntimeException("only type 1 or type 2 implemented");
            k = 1;
            while (k < p - 1) {
                if (this.mMult[F2[k + 1]][0] == -1) {
                    this.mMult[F2[k + 1]][0] = F2[p - k];
                } else {
                    this.mMult[F2[k + 1]][1] = F2[p - k];
                }
                ++k;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int elementOfOrder(int k, int p) {
        random = new Random();
        m = 0;
        while (m == 0) {
            m = random.nextInt();
            if ((m %= p - 1) >= 0) continue;
            m += p - 1;
        }
        l = IntegerFunctions.order(m, p);
        ** GOTO lbl16
        {
            m = random.nextInt();
            if ((m %= p - 1) < 0) {
                m += p - 1;
            }
            do {
                if (m == 0) continue block1;
                l = IntegerFunctions.order(m, p);
lbl16:
                // 2 sources

            } while (l % k != 0 || l == 0);
        }
        r = m;
        l = k / l;
        i = 2;
        while (i <= l) {
            r *= m;
            ++i;
        }
        return r;
    }
}

