/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class Data
extends Content
implements Cloneable {
    private byte[] data;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.Data";
    private volatile int cachedHashVal = 0;

    public Data() {
        if (debug != null) {
            debug.entry(16384L, className, "Data");
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Data", provider);
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Data", (Object)der);
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "Data", der, provider);
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "Data", filename, new Boolean(base64));
            debug.exit(16384L, className, "Data");
        }
    }

    public Data(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "Data", parms);
            debug.exit(16384L, className, "Data");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            Data result = new Data(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Data)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        byte[] data = ((Data)other).getData();
        if (this.data.length != data.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (this.data[i2] == data[i2]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            this.cachedHashVal = 17;
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                this.cachedHashVal = 37 * this.cachedHashVal + this.data[i2];
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.DATA_OID);
        }
        return PKCSOID.DATA_OID;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.data == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Data not specified.");
            }
            throw new IOException("Data not specified.");
        }
        if (this.data == null || this.data.length <= 0) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "error encoding data");
            }
            throw new IOException("error encoding data");
        }
        DerOutputStream tmpout = new DerOutputStream();
        tmpout.putOctetString(this.data);
        os.write(tmpout.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getData().available() != 0) {
            this.data = encoding.getOctetString();
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public synchronized void setData(byte[] data) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setData", (Object)data);
        }
        if (this.data != null) {
            if (debug != null) {
                debug.text(16384L, className, "setData", "Data byte array already set.");
            }
            throw new PKCSException("Data byte array already set.");
        }
        if (data == null || data.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setData", "Data byte array not specified.");
            }
            throw new IllegalArgumentException("Data byte array not specified.");
        }
        this.data = (byte[])data.clone();
        if (debug != null) {
            debug.exit(16384L, className, "setData");
        }
    }

    public byte[] getData() {
        if (debug != null) {
            debug.entry(16384L, className, "getData");
        }
        if (this.data == null || this.data.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getData", null);
            }
            return null;
        }
        byte[] data2 = new byte[this.data.length];
        System.arraycopy(this.data, 0, data2, 0, this.data.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getData", data2);
        }
        return data2;
    }

    @Override
    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS7 Data:\r\n";
        out = this.data != null ? out + hexDump.encodeBuffer(this.data) + "\r\n" : out + "null";
        return out;
    }
}

