/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.internal;

import com.lowagie.text.pdf.internal.PolylineShapeIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PolylineShape
implements Shape {
    protected int[] x;
    protected int[] y;
    protected int np;

    public PolylineShape(int[] nArray, int[] nArray2, int n2) {
        this.np = n2;
        this.x = new int[this.np];
        this.y = new int[this.np];
        System.arraycopy(nArray, 0, this.x, 0, this.np);
        System.arraycopy(nArray2, 0, this.y, 0, this.np);
    }

    public Rectangle2D getBounds2D() {
        int[] nArray = this.rect();
        return nArray == null ? null : new Rectangle2D.Double(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    private int[] rect() {
        if (this.np == 0) {
            return null;
        }
        int n2 = this.x[0];
        int n3 = this.y[0];
        int n4 = this.x[0];
        int n5 = this.y[0];
        for (int i2 = 1; i2 < this.np; ++i2) {
            if (this.x[i2] < n2) {
                n2 = this.x[i2];
            } else if (this.x[i2] > n4) {
                n4 = this.x[i2];
            }
            if (this.y[i2] < n3) {
                n3 = this.y[i2];
                continue;
            }
            if (this.y[i2] <= n5) continue;
            n5 = this.y[i2];
        }
        return new int[]{n2, n3, n4 - n2, n5 - n3};
    }

    public boolean contains(double d2, double d3) {
        return false;
    }

    public boolean contains(Point2D point2D) {
        return false;
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return false;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.intersects(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (this.np == 0) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double(this.x[0], this.y[0], this.x[0], this.y[0]);
        for (int i2 = 1; i2 < this.np; ++i2) {
            ((Line2D)double_).setLine(this.x[i2 - 1], this.y[i2 - 1], this.x[i2], this.y[i2]);
            if (!double_.intersects(rectangle2D)) continue;
            return true;
        }
        return false;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PolylineShapeIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new PolylineShapeIterator(this, affineTransform);
    }
}

