/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentsEnvironment {
    private static final Log log = LogFactory.getLog(ComponentsEnvironment.class);
    private static final ReferenceMap cache = new ReferenceMap(2, 0);

    public static Collection<ComponentsBundle> getComponentBundles() {
        Map<String, ComponentsBundle> components = ComponentsEnvironment.getCachedComponentBundles();
        return components.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, ComponentsBundle> getCachedComponentBundles() {
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = cache;
        synchronized (referenceMap) {
            Map<String, ComponentsBundle> components = (Map<String, ComponentsBundle>)cache.get(cacheKey);
            if (components == null) {
                components = ComponentsEnvironment.findComponentBundles();
                cache.put(cacheKey, components);
            }
            return components;
        }
    }

    protected static Map<String, ComponentsBundle> findComponentBundles() {
        HashMap<String, ComponentsBundle> components = new HashMap<String, ComponentsBundle>();
        ExtensionsRegistry extensionsRegistry = ExtensionsEnvironment.getExtensionsRegistry();
        List<ComponentsBundle> bundles = extensionsRegistry.getExtensions(ComponentsBundle.class);
        for (ComponentsBundle bundle : bundles) {
            String namespace = bundle.getXmlParser().getNamespace();
            if (components.containsKey(namespace)) {
                log.warn("Found two components for namespace " + namespace);
                continue;
            }
            components.put(namespace, bundle);
        }
        return components;
    }

    public static ComponentsBundle getComponentsBundle(String namespace) {
        Map<String, ComponentsBundle> components = ComponentsEnvironment.getCachedComponentBundles();
        ComponentsBundle componentsBundle = components.get(namespace);
        if (componentsBundle == null) {
            throw new JRRuntimeException("No components bundle registered for namespace " + namespace);
        }
        return componentsBundle;
    }

    public static ComponentManager getComponentManager(ComponentKey componentKey) {
        String namespace = componentKey.getNamespace();
        ComponentsBundle componentsBundle = ComponentsEnvironment.getComponentsBundle(namespace);
        String name = componentKey.getName();
        return componentsBundle.getComponentManager(name);
    }

    private ComponentsEnvironment() {
    }
}

