/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x501;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.harmony.security.Util;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;
import org.apache.harmony.security.internal.nls.Messages;
import org.apache.harmony.security.x501.AttributeValue;
import org.apache.harmony.security.x501.DirectoryString;

public class AttributeTypeAndValue {
    private static final org.apache.harmony.security.utils.ObjectIdentifier C;
    private static final org.apache.harmony.security.utils.ObjectIdentifier CN;
    private static final org.apache.harmony.security.utils.ObjectIdentifier DC;
    private static final org.apache.harmony.security.utils.ObjectIdentifier DNQ;
    private static final org.apache.harmony.security.utils.ObjectIdentifier DNQUALIFIER;
    private static final org.apache.harmony.security.utils.ObjectIdentifier EMAILADDRESS;
    private static final org.apache.harmony.security.utils.ObjectIdentifier GENERATION;
    private static final org.apache.harmony.security.utils.ObjectIdentifier GIVENNAME;
    private static final org.apache.harmony.security.utils.ObjectIdentifier INITIALS;
    private static final org.apache.harmony.security.utils.ObjectIdentifier L;
    private static final org.apache.harmony.security.utils.ObjectIdentifier O;
    private static final org.apache.harmony.security.utils.ObjectIdentifier OU;
    private static final org.apache.harmony.security.utils.ObjectIdentifier SERIALNUMBER;
    private static final org.apache.harmony.security.utils.ObjectIdentifier ST;
    private static final org.apache.harmony.security.utils.ObjectIdentifier STREET;
    private static final org.apache.harmony.security.utils.ObjectIdentifier SURNAME;
    private static final org.apache.harmony.security.utils.ObjectIdentifier T;
    private static final org.apache.harmony.security.utils.ObjectIdentifier UID;
    private static final int CAPACITY;
    private static final int SIZE;
    private static final org.apache.harmony.security.utils.ObjectIdentifier[][] KNOWN_OIDS;
    private static final HashMap KNOWN_NAMES;
    private static final HashMap RFC1779_NAMES;
    private static final HashMap RFC2253_NAMES;
    private static final HashMap RFC2459_NAMES;
    private final org.apache.harmony.security.utils.ObjectIdentifier oid;
    private AttributeValue value;
    public static final ASN1Type attributeValue;
    public static final ASN1Sequence ASN1;

    private AttributeTypeAndValue(int[] nArray, AttributeValue attributeValue) throws IOException {
        org.apache.harmony.security.utils.ObjectIdentifier objectIdentifier = AttributeTypeAndValue.getOID(nArray);
        if (objectIdentifier == null) {
            objectIdentifier = new org.apache.harmony.security.utils.ObjectIdentifier(nArray);
        }
        this.oid = objectIdentifier;
        this.value = attributeValue;
    }

    public AttributeTypeAndValue(String string, AttributeValue attributeValue) throws IOException {
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            int[] nArray = ObjectIdentifier.toIntArray(string);
            org.apache.harmony.security.utils.ObjectIdentifier objectIdentifier = AttributeTypeAndValue.getOID(nArray);
            if (objectIdentifier == null) {
                objectIdentifier = new org.apache.harmony.security.utils.ObjectIdentifier(nArray);
            }
            this.oid = objectIdentifier;
        } else {
            this.oid = (org.apache.harmony.security.utils.ObjectIdentifier)KNOWN_NAMES.get(Util.toUpperCase(string));
            if (this.oid == null) {
                throw new IOException(Messages.getString("security.178", string));
            }
        }
        this.value = attributeValue;
    }

    public void appendName(String string, StringBuffer stringBuffer) {
        boolean bl = false;
        if ("RFC1779".equals(string)) {
            if (RFC1779_NAMES == this.oid.getGroup()) {
                stringBuffer.append(this.oid.getName());
            } else {
                stringBuffer.append(this.oid.toOIDString());
            }
            stringBuffer.append('=');
            if (this.value.escapedString == this.value.getHexString()) {
                stringBuffer.append(Util.toUpperCase(this.value.getHexString()));
            } else if (this.value.escapedString.length() != this.value.rawString.length()) {
                this.value.appendQEString(stringBuffer);
            } else {
                stringBuffer.append(this.value.escapedString);
            }
        } else {
            Object object = this.oid.getGroup();
            if (RFC1779_NAMES == object || RFC2253_NAMES == object) {
                int n2;
                stringBuffer.append(this.oid.getName());
                if ("CANONICAL".equals(string) && !ASN1StringType.UTF8STRING.checkTag(n2 = this.value.getTag()) && !ASN1StringType.PRINTABLESTRING.checkTag(n2)) {
                    bl = true;
                }
            } else {
                stringBuffer.append(this.oid.toString());
                bl = true;
            }
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append(this.value.getHexString());
            } else if ("CANONICAL".equals(string)) {
                stringBuffer.append(this.value.makeCanonical());
            } else {
                stringBuffer.append(this.value.escapedString);
            }
        }
    }

    public org.apache.harmony.security.utils.ObjectIdentifier getType() {
        return this.oid;
    }

    private static org.apache.harmony.security.utils.ObjectIdentifier getOID(int[] nArray) {
        int n2 = AttributeTypeAndValue.hashIntArray(nArray) % CAPACITY;
        org.apache.harmony.security.utils.ObjectIdentifier[] objectIdentifierArray = KNOWN_OIDS[n2];
        int n3 = 0;
        while (objectIdentifierArray[n3] != null) {
            if (Arrays.equals(nArray, objectIdentifierArray[n3].getOid())) {
                return objectIdentifierArray[n3];
            }
            ++n3;
        }
        return null;
    }

    private static void addOID(org.apache.harmony.security.utils.ObjectIdentifier objectIdentifier) {
        int[] nArray = objectIdentifier.getOid();
        int n2 = AttributeTypeAndValue.hashIntArray(nArray) % CAPACITY;
        org.apache.harmony.security.utils.ObjectIdentifier[] objectIdentifierArray = KNOWN_OIDS[n2];
        int n3 = 0;
        while (objectIdentifierArray[n3] != null) {
            if (Arrays.equals(nArray, objectIdentifierArray[n3].getOid())) {
                throw new Error(Messages.getString("security.17B", objectIdentifier.getName(), objectIdentifierArray[n3].getName()));
            }
            ++n3;
        }
        if (n3 == CAPACITY - 1) {
            throw new Error(Messages.getString("security.17C"));
        }
        objectIdentifierArray[n3] = objectIdentifier;
    }

    private static int hashIntArray(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length && i2 < 4; ++i2) {
            n2 += nArray[i2] << 8 * i2;
        }
        return n2 & Integer.MAX_VALUE;
    }

    static {
        KNOWN_NAMES = new HashMap(30);
        RFC1779_NAMES = new HashMap(10);
        RFC2253_NAMES = new HashMap(10);
        RFC2459_NAMES = new HashMap(10);
        CAPACITY = 10;
        SIZE = 10;
        KNOWN_OIDS = new org.apache.harmony.security.utils.ObjectIdentifier[SIZE][CAPACITY];
        C = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 6}, "C", RFC1779_NAMES);
        CN = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 3}, "CN", RFC1779_NAMES);
        DC = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{0, 9, 2342, 19200300, 100, 1, 25}, "DC", RFC2253_NAMES);
        DNQ = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 46}, "DNQ", RFC2459_NAMES);
        DNQUALIFIER = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 46}, "DNQUALIFIER", RFC2459_NAMES);
        EMAILADDRESS = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 9, 1}, "EMAILADDRESS", RFC2459_NAMES);
        GENERATION = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 44}, "GENERATION", RFC2459_NAMES);
        GIVENNAME = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 42}, "GIVENNAME", RFC2459_NAMES);
        INITIALS = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 43}, "INITIALS", RFC2459_NAMES);
        L = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 7}, "L", RFC1779_NAMES);
        O = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 10}, "O", RFC1779_NAMES);
        OU = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 11}, "OU", RFC1779_NAMES);
        SERIALNUMBER = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 5}, "SERIALNUMBER", RFC2459_NAMES);
        ST = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 8}, "ST", RFC1779_NAMES);
        STREET = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 9}, "STREET", RFC1779_NAMES);
        SURNAME = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 4}, "SURNAME", RFC2459_NAMES);
        T = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 12}, "T", RFC2459_NAMES);
        UID = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{0, 9, 2342, 19200300, 100, 1, 1}, "UID", RFC2253_NAMES);
        RFC1779_NAMES.put(CN.getName(), CN);
        RFC1779_NAMES.put(L.getName(), L);
        RFC1779_NAMES.put(ST.getName(), ST);
        RFC1779_NAMES.put(O.getName(), O);
        RFC1779_NAMES.put(OU.getName(), OU);
        RFC1779_NAMES.put(C.getName(), C);
        RFC1779_NAMES.put(STREET.getName(), STREET);
        RFC2253_NAMES.putAll(RFC1779_NAMES);
        RFC2253_NAMES.put(DC.getName(), DC);
        RFC2253_NAMES.put(UID.getName(), UID);
        RFC2459_NAMES.put(DNQ.getName(), DNQ);
        RFC2459_NAMES.put(DNQUALIFIER.getName(), DNQUALIFIER);
        RFC2459_NAMES.put(EMAILADDRESS.getName(), EMAILADDRESS);
        RFC2459_NAMES.put(GENERATION.getName(), GENERATION);
        RFC2459_NAMES.put(GIVENNAME.getName(), GIVENNAME);
        RFC2459_NAMES.put(INITIALS.getName(), INITIALS);
        RFC2459_NAMES.put(SERIALNUMBER.getName(), SERIALNUMBER);
        RFC2459_NAMES.put(SURNAME.getName(), SURNAME);
        RFC2459_NAMES.put(T.getName(), T);
        Iterator iterator = RFC2253_NAMES.values().iterator();
        while (iterator.hasNext()) {
            AttributeTypeAndValue.addOID((org.apache.harmony.security.utils.ObjectIdentifier)iterator.next());
        }
        for (Object v2 : RFC2459_NAMES.values()) {
            if (v2 == DNQUALIFIER) continue;
            AttributeTypeAndValue.addOID((org.apache.harmony.security.utils.ObjectIdentifier)v2);
        }
        KNOWN_NAMES.putAll(RFC2253_NAMES);
        KNOWN_NAMES.putAll(RFC2459_NAMES);
        attributeValue = new ASN1Type(19){

            @Override
            public boolean checkTag(int n2) {
                return true;
            }

            @Override
            public Object decode(BerInputStream berInputStream) throws IOException {
                String string = null;
                if (DirectoryString.ASN1.checkTag(berInputStream.tag)) {
                    string = (String)DirectoryString.ASN1.decode(berInputStream);
                } else {
                    berInputStream.readContent();
                }
                byte[] byArray = new byte[berInputStream.getOffset() - berInputStream.getTagOffset()];
                System.arraycopy(berInputStream.getBuffer(), berInputStream.getTagOffset(), byArray, 0, byArray.length);
                return new AttributeValue(string, byArray, berInputStream.tag);
            }

            @Override
            public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
                throw new RuntimeException(Messages.getString("security.179"));
            }

            @Override
            public void encodeASN(BerOutputStream berOutputStream) {
                AttributeValue attributeValue = (AttributeValue)berOutputStream.content;
                if (attributeValue.encoded != null) {
                    berOutputStream.content = attributeValue.encoded;
                    berOutputStream.encodeANY();
                } else {
                    berOutputStream.encodeTag(attributeValue.getTag());
                    berOutputStream.content = attributeValue.bytes;
                    berOutputStream.encodeString();
                }
            }

            @Override
            public void setEncodingContent(BerOutputStream berOutputStream) {
                AttributeValue attributeValue = (AttributeValue)berOutputStream.content;
                if (attributeValue.encoded != null) {
                    berOutputStream.length = attributeValue.encoded.length;
                } else if (attributeValue.getTag() == 12) {
                    berOutputStream.content = attributeValue.rawString;
                    ASN1StringType.UTF8STRING.setEncodingContent(berOutputStream);
                    attributeValue.bytes = (byte[])berOutputStream.content;
                    berOutputStream.content = attributeValue;
                } else {
                    attributeValue.bytes = attributeValue.rawString.getBytes();
                    berOutputStream.length = attributeValue.bytes.length;
                }
            }

            @Override
            public void encodeContent(BerOutputStream berOutputStream) {
                throw new RuntimeException(Messages.getString("security.17A"));
            }

            @Override
            public int getEncodedLength(BerOutputStream berOutputStream) {
                AttributeValue attributeValue = (AttributeValue)berOutputStream.content;
                if (attributeValue.encoded != null) {
                    return berOutputStream.length;
                }
                return super.getEncodedLength(berOutputStream);
            }
        };
        ASN1 = new ASN1Sequence(new ASN1Type[]{ASN1Oid.getInstance(), attributeValue}){

            @Override
            protected Object getDecodedObject(BerInputStream berInputStream) throws IOException {
                Object[] objectArray = (Object[])berInputStream.content;
                return new AttributeTypeAndValue((int[])objectArray[0], (AttributeValue)objectArray[1]);
            }

            @Override
            protected void getValues(Object object, Object[] objectArray) {
                AttributeTypeAndValue attributeTypeAndValue = (AttributeTypeAndValue)object;
                objectArray[0] = attributeTypeAndValue.oid.getOid();
                objectArray[1] = attributeTypeAndValue.value;
            }
        };
    }
}

