/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Encodable {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        if (aSN1Sequence.size() > 1) {
            this.caPubs = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        this.response = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(n2));
    }

    public static CertRepMessage getInstance(Object object) {
        if (object instanceof CertRepMessage) {
            return (CertRepMessage)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertRepMessage((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.caPubs.size()];
        for (int i2 = 0; i2 != cMPCertificateArray.length; ++i2) {
            cMPCertificateArray[i2] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i2));
        }
        return cMPCertificateArray;
    }

    public CertResponse[] getResponse() {
        CertResponse[] certResponseArray = new CertResponse[this.caPubs.size()];
        for (int i2 = 0; i2 != certResponseArray.length; ++i2) {
            certResponseArray[i2] = CertResponse.getInstance(this.caPubs.getObjectAt(i2));
        }
        return certResponseArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.caPubs != null) {
            aSN1EncodableVector.add(this.caPubs);
        }
        aSN1EncodableVector.add(this.response);
        return new DERSequence(aSN1EncodableVector);
    }
}

