/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Info;
import com.ibm.pkcs11.PKCS11Slot;

public abstract class PKCS11 {
    protected PKCS11() {
    }

    public void libInitialize() throws PKCS11Exception {
    }

    public void libFinalize() throws PKCS11Exception {
    }

    public abstract PKCS11Info getInfo() throws PKCS11Exception;

    public abstract PKCS11Slot[] getSlotList(boolean var1) throws PKCS11Exception;

    public PKCS11Slot getFirstTokenSlot() throws PKCS11Exception {
        PKCS11Slot[] slots = this.getSlotList(true);
        return slots.length > 0 ? slots[0] : null;
    }

    public abstract PKCS11Slot waitForSlotEvent(boolean var1) throws PKCS11Exception;

    public String toString() {
        try {
            return this.getInfo().toString();
        }
        catch (PKCS11Exception e2) {
            throw new RuntimeException(e2.toString());
        }
    }

    protected void finalize() {
        try {
            this.libFinalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String flagsToString(int f2, int[] flagList, String[] flagNames, String separator) {
        if (f2 == 0) {
            return "0x0";
        }
        StringBuilder buf = new StringBuilder(64);
        String sep = "";
        for (int i2 = 0; i2 < flagList.length; ++i2) {
            if ((flagList[i2] & f2) == 0) continue;
            buf.append(sep);
            buf.append(flagNames[i2]);
            f2 &= ~flagList[i2];
            sep = separator;
        }
        if (f2 != 0) {
            buf.append(sep);
            buf.append("0x");
            buf.append(Integer.toString(f2, 16));
        }
        return buf.toString();
    }

    static String versionString(int version) {
        StringBuilder b2 = new StringBuilder();
        int major = version >> 8;
        int minor = version & 0xFF;
        b2.append(major);
        b2.append(".");
        b2.append(minor / 10);
        if (minor % 10 != 0) {
            b2.append(minor % 10);
        }
        return b2.toString();
    }
}

