/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.internal.nls.Messages;

public class AlgorithmParameters {
    private static final String SEVICE = "AlgorithmParameters";
    private static Engine engine = new Engine("AlgorithmParameters");
    private Provider provider;
    private AlgorithmParametersSpi spiImpl;
    private String algorithm;
    private boolean initialized;

    protected AlgorithmParameters(AlgorithmParametersSpi algorithmParametersSpi, Provider provider, String string) {
        this.provider = provider;
        this.algorithm = string;
        this.spiImpl = algorithmParametersSpi;
    }

    public static AlgorithmParameters getInstance(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, null);
        return new AlgorithmParameters((AlgorithmParametersSpi)serviceResult.spi, serviceResult.provider, string);
    }

    public static AlgorithmParameters getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(Messages.getString("security.03", string2));
        }
        return AlgorithmParameters.getInstance(string, provider);
    }

    public static AlgorithmParameters getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
        return new AlgorithmParameters((AlgorithmParametersSpi)serviceResult.spi, provider, string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (this.initialized) {
            throw new InvalidParameterSpecException(Messages.getString("security.1E"));
        }
        this.spiImpl.engineInit(algorithmParameterSpec);
        this.initialized = true;
    }

    public final void init(byte[] byArray) throws IOException {
        if (this.initialized) {
            throw new IOException(Messages.getString("security.1E"));
        }
        this.spiImpl.engineInit(byArray);
        this.initialized = true;
    }

    public final void init(byte[] byArray, String string) throws IOException {
        if (this.initialized) {
            throw new IOException(Messages.getString("security.1E"));
        }
        this.spiImpl.engineInit(byArray, string);
        this.initialized = true;
    }

    public final <T extends AlgorithmParameterSpec> T getParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (!this.initialized) {
            throw new InvalidParameterSpecException(Messages.getString("security.1F"));
        }
        return this.spiImpl.engineGetParameterSpec(clazz);
    }

    public final byte[] getEncoded() throws IOException {
        if (!this.initialized) {
            throw new IOException(Messages.getString("security.1F"));
        }
        return this.spiImpl.engineGetEncoded();
    }

    public final byte[] getEncoded(String string) throws IOException {
        if (!this.initialized) {
            throw new IOException(Messages.getString("security.1F"));
        }
        return this.spiImpl.engineGetEncoded(string);
    }

    public final String toString() {
        if (!this.initialized) {
            return null;
        }
        return this.spiImpl.engineToString();
    }
}

