/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import java.io.IOException;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeVisitor;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.FourStateBarcodeComponent;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class BarcodeXmlWriter
implements BarcodeVisitor {
    private final JRXmlWriteHelper xmlWriteHelper;
    private final BarcodeComponent barcodeComponent;
    private final ComponentKey componentKey;

    public BarcodeXmlWriter(JRXmlWriter reportWriter, BarcodeComponent barcode, ComponentKey componentKey) {
        this.xmlWriteHelper = reportWriter.getXmlWriteHelper();
        this.barcodeComponent = barcode;
        this.componentKey = componentKey;
    }

    public void writeBarcode() {
        this.barcodeComponent.receive(this);
    }

    protected void startBarcode(BarcodeComponent barcode) {
        XmlNamespace namespace = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/components", this.componentKey.getNamespacePrefix(), "http://jasperreports.sourceforge.net/xsd/components.xsd");
        this.xmlWriteHelper.startElement(this.componentKey.getName(), namespace);
        this.writeBaseAttributes(barcode);
    }

    protected void endBarcode() throws IOException {
        this.xmlWriteHelper.closeElement();
    }

    protected void writeBaseAttributes(BarcodeComponent barcode) {
        if (barcode.getEvaluationTimeValue() != EvaluationTimeEnum.NOW) {
            this.xmlWriteHelper.addAttribute("evaluationTime", barcode.getEvaluationTimeValue());
        }
        this.xmlWriteHelper.addAttribute("evaluationGroup", barcode.getEvaluationGroup());
        this.xmlWriteHelper.addAttribute("orientation", barcode.getOrientation(), 0);
        this.xmlWriteHelper.addAttribute("moduleWidth", barcode.getModuleWidth());
        this.xmlWriteHelper.addAttribute("textPosition", barcode.getTextPosition());
        this.xmlWriteHelper.addAttribute("quietZone", barcode.getQuietZone());
        this.xmlWriteHelper.addAttribute("verticalQuietZone", barcode.getVerticalQuietZone());
    }

    protected void writeBaseContents(BarcodeComponent barcode) throws IOException {
        this.xmlWriteHelper.writeExpression("codeExpression", barcode.getCodeExpression());
        this.xmlWriteHelper.writeExpression("patternExpression", barcode.getPatternExpression());
    }

    public void visitCodabar(CodabarComponent codabar) {
        try {
            this.startBarcode(codabar);
            this.xmlWriteHelper.addAttribute("wideFactor", codabar.getWideFactor());
            this.writeBaseContents(codabar);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitCode128(Code128Component code128) {
        try {
            this.startBarcode(code128);
            this.writeBaseContents(code128);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitDataMatrix(DataMatrixComponent dataMatrix) {
        try {
            this.startBarcode(dataMatrix);
            this.xmlWriteHelper.addAttribute("shape", dataMatrix.getShape());
            this.writeBaseContents(dataMatrix);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitEANCode128(EAN128Component ean128) {
        try {
            this.startBarcode(ean128);
            this.xmlWriteHelper.addAttribute("checksumMode", ean128.getChecksumMode());
            this.writeBaseContents(ean128);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitCode39(Code39Component code39) {
        try {
            this.startBarcode(code39);
            this.xmlWriteHelper.addAttribute("checksumMode", code39.getChecksumMode());
            this.xmlWriteHelper.addAttribute("displayChecksum", code39.isDisplayChecksum());
            this.xmlWriteHelper.addAttribute("displayStartStop", code39.isDisplayStartStop());
            this.xmlWriteHelper.addAttribute("extendedCharSetEnabled", code39.isExtendedCharSetEnabled());
            this.xmlWriteHelper.addAttribute("intercharGapWidth", code39.getIntercharGapWidth());
            this.xmlWriteHelper.addAttribute("wideFactor", code39.getWideFactor());
            this.writeBaseContents(code39);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitUPCA(UPCAComponent upcA) {
        try {
            this.startBarcode(upcA);
            this.xmlWriteHelper.addAttribute("checksumMode", upcA.getChecksumMode());
            this.writeBaseContents(upcA);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitUPCE(UPCEComponent upcE) {
        try {
            this.startBarcode(upcE);
            this.xmlWriteHelper.addAttribute("checksumMode", upcE.getChecksumMode());
            this.writeBaseContents(upcE);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitEAN13(EAN13Component ean13) {
        try {
            this.startBarcode(ean13);
            this.xmlWriteHelper.addAttribute("checksumMode", ean13.getChecksumMode());
            this.writeBaseContents(ean13);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitEAN8(EAN8Component ean8) {
        try {
            this.startBarcode(ean8);
            this.xmlWriteHelper.addAttribute("checksumMode", ean8.getChecksumMode());
            this.writeBaseContents(ean8);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitInterleaved2Of5(Interleaved2Of5Component interleaved2Of5) {
        try {
            this.startBarcode(interleaved2Of5);
            this.xmlWriteHelper.addAttribute("checksumMode", interleaved2Of5.getChecksumMode());
            this.xmlWriteHelper.addAttribute("displayChecksum", interleaved2Of5.isDisplayChecksum());
            this.xmlWriteHelper.addAttribute("wideFactor", interleaved2Of5.getWideFactor());
            this.writeBaseContents(interleaved2Of5);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    protected void writeFourStateAttributes(FourStateBarcodeComponent barcode) {
        this.xmlWriteHelper.addAttribute("ascenderHeight", barcode.getAscenderHeight());
        this.xmlWriteHelper.addAttribute("checksumMode", barcode.getChecksumMode());
        this.xmlWriteHelper.addAttribute("intercharGapWidth", barcode.getIntercharGapWidth());
        this.xmlWriteHelper.addAttribute("trackHeight", barcode.getTrackHeight());
    }

    public void visitRoyalMailCustomer(RoyalMailCustomerComponent royalMailCustomer) {
        try {
            this.startBarcode(royalMailCustomer);
            this.writeFourStateAttributes(royalMailCustomer);
            this.writeBaseContents(royalMailCustomer);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitUSPSIntelligentMail(USPSIntelligentMailComponent intelligentMail) {
        try {
            this.startBarcode(intelligentMail);
            this.writeFourStateAttributes(intelligentMail);
            this.writeBaseContents(intelligentMail);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitPostnet(POSTNETComponent postnet) {
        try {
            this.startBarcode(postnet);
            this.xmlWriteHelper.addAttribute("shortBarHeight", postnet.getShortBarHeight());
            this.xmlWriteHelper.addAttribute("baselinePosition", postnet.getBaselinePosition());
            this.xmlWriteHelper.addAttribute("checksumMode", postnet.getChecksumMode());
            this.xmlWriteHelper.addAttribute("displayChecksum", postnet.getDisplayChecksum());
            this.xmlWriteHelper.addAttribute("intercharGapWidth", postnet.getIntercharGapWidth());
            this.writeBaseContents(postnet);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public void visitPDF417(PDF417Component pdf417) {
        try {
            this.startBarcode(pdf417);
            this.xmlWriteHelper.addAttribute("minColumns", pdf417.getMinColumns());
            this.xmlWriteHelper.addAttribute("maxColumns", pdf417.getMaxColumns());
            this.xmlWriteHelper.addAttribute("minRows", pdf417.getMinRows());
            this.xmlWriteHelper.addAttribute("maxRows", pdf417.getMaxRows());
            this.xmlWriteHelper.addAttribute("widthToHeightRatio", pdf417.getWidthToHeightRatio());
            this.xmlWriteHelper.addAttribute("errorCorrectionLevel", pdf417.getErrorCorrectionLevel());
            this.writeBaseContents(pdf417);
            this.endBarcode();
        }
        catch (IOException e2) {
            throw new JRRuntimeException(e2);
        }
    }
}

