/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.base.JRBaseSection;
import net.sf.jasperreports.engine.design.JRDesignBand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRDesignSection
extends JRBaseSection {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BANDS = "bands";
    protected List<JRBand> bandsList = new ArrayList<JRBand>();
    private JROrigin origin;

    public JRDesignSection(JROrigin origin) {
        this.origin = origin;
    }

    public JROrigin getOrigin() {
        return this.origin;
    }

    protected void setOrigin(JROrigin origin) {
        this.origin = origin;
        if (this.bandsList != null && this.bandsList.size() > 0) {
            for (JRDesignBand jRDesignBand : this.bandsList) {
                jRDesignBand.setOrigin(origin);
            }
        }
    }

    @Override
    public JRBand[] getBands() {
        JRBand[] bandsArray = new JRBand[this.bandsList.size()];
        this.bandsList.toArray(bandsArray);
        return bandsArray;
    }

    public List<JRBand> getBandsList() {
        return this.bandsList;
    }

    public void addBand(JRBand band) {
        ((JRDesignBand)band).setOrigin(this.getOrigin());
        this.bandsList.add(band);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_BANDS, band, this.bandsList.size() - 1);
    }

    public void addBand(int index, JRBand band) {
        ((JRDesignBand)band).setOrigin(this.getOrigin());
        this.bandsList.add(index, band);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_BANDS, band, index);
    }

    public JRBand removeBand(JRBand band) {
        int idx;
        if (band != null && (idx = this.bandsList.indexOf(band)) >= 0) {
            this.bandsList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_BANDS, band, idx);
        }
        return band;
    }

    public JRBand removeBand(int index) {
        JRBand band = this.bandsList.remove(index);
        this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_BANDS, band, index);
        return band;
    }
}

