/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security;

import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.harmony.security.internal.nls.Messages;

public class SystemScope
extends IdentityScope {
    private static final long serialVersionUID = -4810285697932522607L;
    private Hashtable names = new Hashtable();
    private Hashtable keys = new Hashtable();

    public SystemScope() {
    }

    public SystemScope(String string) {
        super(string);
    }

    public SystemScope(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    @Override
    public int size() {
        return this.names.size();
    }

    @Override
    public synchronized Identity getIdentity(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return (Identity)this.names.get(string);
    }

    @Override
    public synchronized Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        return (Identity)this.keys.get(publicKey);
    }

    @Override
    public synchronized void addIdentity(Identity identity) throws KeyManagementException {
        if (identity == null) {
            throw new NullPointerException(Messages.getString("security.92"));
        }
        String string = identity.getName();
        if (this.names.containsKey(string)) {
            throw new KeyManagementException(Messages.getString("security.93", string));
        }
        PublicKey publicKey = identity.getPublicKey();
        if (publicKey != null && this.keys.containsKey(publicKey)) {
            throw new KeyManagementException(Messages.getString("security.94", publicKey));
        }
        this.names.put(string, identity);
        if (publicKey != null) {
            this.keys.put(publicKey, identity);
        }
    }

    @Override
    public synchronized void removeIdentity(Identity identity) throws KeyManagementException {
        if (identity == null) {
            throw new NullPointerException(Messages.getString("security.92"));
        }
        String string = identity.getName();
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.95"));
        }
        boolean bl = this.names.containsKey(string);
        this.names.remove(string);
        PublicKey publicKey = identity.getPublicKey();
        if (publicKey != null) {
            bl = bl || this.keys.containsKey(publicKey);
            this.keys.remove(publicKey);
        }
        if (!bl) {
            throw new KeyManagementException(Messages.getString("security.96"));
        }
    }

    public Enumeration identities() {
        return this.names.elements();
    }
}

