/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECParameters;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.ec.NamedCurve;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11ECKeyFactory
extends P11KeyFactory {
    P11ECKeyFactory(Token token, String string) {
        super(token, string);
    }

    static ECParameterSpec getECParameterSpec(String string) {
        return NamedCurve.getECParameterSpec((String)string);
    }

    static ECParameterSpec getECParameterSpec(int n2) {
        return NamedCurve.getECParameterSpec((int)n2);
    }

    static ECParameterSpec getECParameterSpec(ECParameterSpec eCParameterSpec) {
        return ECParameters.getNamedCurve((ECParameterSpec)eCParameterSpec);
    }

    static ECParameterSpec decodeParameters(byte[] byArray) throws IOException {
        return ECParameters.decodeParameters((byte[])byArray);
    }

    static byte[] encodeParameters(ECParameterSpec eCParameterSpec) {
        return ECParameters.encodeParameters((ECParameterSpec)eCParameterSpec);
    }

    static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        return ECParameters.decodePoint((byte[])byArray, (EllipticCurve)ellipticCurve);
    }

    static byte[] getEncodedPublicValue(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof ECPublicKeyImpl) {
            return ((ECPublicKeyImpl)publicKey).getEncodedPublicValue();
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            ECPoint eCPoint = eCPublicKey.getW();
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            return ECParameters.encodePoint((ECPoint)eCPoint, (EllipticCurve)eCParameterSpec.getCurve());
        }
        throw new InvalidKeyException("Key class not yet supported: " + publicKey.getClass().getName());
    }

    PublicKey implTranslatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        try {
            if (publicKey instanceof ECPublicKey) {
                ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
                return this.generatePublic(eCPublicKey.getW(), eCPublicKey.getParams());
            }
            if ("X.509".equals(publicKey.getFormat())) {
                byte[] byArray = publicKey.getEncoded();
                publicKey = new ECPublicKeyImpl(byArray);
                return this.implTranslatePublicKey(publicKey);
            }
            throw new InvalidKeyException("PublicKey must be instance of ECPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create EC public key", pKCS11Exception);
        }
    }

    PrivateKey implTranslatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        try {
            if (privateKey instanceof ECPrivateKey) {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                return this.generatePrivate(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            if ("PKCS#8".equals(privateKey.getFormat())) {
                byte[] byArray = privateKey.getEncoded();
                privateKey = new ECPrivateKeyImpl(byArray);
                return this.implTranslatePrivateKey(privateKey);
            }
            throw new InvalidKeyException("PrivateKey must be instance of ECPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create EC private key", pKCS11Exception);
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                ECPublicKeyImpl eCPublicKeyImpl = new ECPublicKeyImpl(byArray);
                return this.implTranslatePublicKey(eCPublicKeyImpl);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException("Could not create EC public key", invalidKeyException);
            }
        }
        if (!(keySpec instanceof ECPublicKeySpec)) {
            throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
        }
        try {
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
            return this.generatePublic(eCPublicKeySpec.getW(), eCPublicKeySpec.getParams());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create EC public key", pKCS11Exception);
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKeyImpl eCPrivateKeyImpl = new ECPrivateKeyImpl(byArray);
                return this.implTranslatePrivateKey(eCPrivateKeyImpl);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Could not create EC private key", generalSecurityException);
            }
        }
        if (!(keySpec instanceof ECPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
        }
        try {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
            return this.generatePrivate(eCPrivateKeySpec.getS(), eCPrivateKeySpec.getParams());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create EC private key", pKCS11Exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws PKCS11Exception {
        byte[] byArray = ECParameters.encodeParameters((ECParameterSpec)eCParameterSpec);
        byte[] byArray2 = ECParameters.encodePoint((ECPoint)eCPoint, (EllipticCurve)eCParameterSpec.getCurve());
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(385L, byArray2), new CK_ATTRIBUTE(384L, byArray)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 2L, 3L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l2 = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PublicKey publicKey = P11Key.publicKey(session, l2, "EC", eCParameterSpec.getCurve().getField().getFieldSize(), cK_ATTRIBUTEArray);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws PKCS11Exception {
        byte[] byArray = ECParameters.encodeParameters((ECParameterSpec)eCParameterSpec);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(17L, bigInteger), new CK_ATTRIBUTE(384L, byArray)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 3L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l2 = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PrivateKey privateKey = P11Key.privateKey(session, l2, "EC", eCParameterSpec.getCurve().getField().getFieldSize(), cK_ATTRIBUTEArray);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    KeySpec implGetPublicKeySpec(P11Key p11Key, Class clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (ECPublicKeySpec.class.isAssignableFrom(clazz)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L), new CK_ATTRIBUTE(384L)};
            this.token.p11.C_GetAttributeValue(sessionArray[0].id(), p11Key.keyID, cK_ATTRIBUTEArray);
            try {
                ECParameterSpec eCParameterSpec = P11ECKeyFactory.decodeParameters(cK_ATTRIBUTEArray[1].getByteArray());
                ECPoint eCPoint = P11ECKeyFactory.decodePoint(cK_ATTRIBUTEArray[0].getByteArray(), eCParameterSpec.getCurve());
                return new ECPublicKeySpec(eCPoint, eCParameterSpec);
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Could not parse key", iOException);
            }
        }
        throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
    }

    KeySpec implGetPrivateKeySpec(P11Key p11Key, Class clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (ECPrivateKeySpec.class.isAssignableFrom(clazz)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(384L)};
            this.token.p11.C_GetAttributeValue(sessionArray[0].id(), p11Key.keyID, cK_ATTRIBUTEArray);
            try {
                ECParameterSpec eCParameterSpec = P11ECKeyFactory.decodeParameters(cK_ATTRIBUTEArray[1].getByteArray());
                return new ECPrivateKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), eCParameterSpec);
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Could not parse key", iOException);
            }
        }
        throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
    }

    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return ECKeyFactory.INSTANCE;
    }
}

