/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class GUIUtils {
    public static Dimension infiniteDim = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

    public static JTextArea newTextAreaNote(Container parent, String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setLineWrap(true);
        textArea.setFont(new JLabel().getFont());
        textArea.setEditable(false);
        textArea.setBackground(parent.getBackground());
        return textArea;
    }

    public static void addBorder(JComponent comp) {
        comp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public static void setMaxSizeUnfinite(JComponent comp) {
        comp.setMaximumSize(infiniteDim);
    }

    public static ImageIcon getImageIcon(String filename, String description) {
        URL ressource = GUIUtils.class.getClassLoader().getResource(filename);
        if (ressource == null) {
            System.err.println("GUIUtils getImage : resource not found:" + filename);
            return null;
        }
        return new ImageIcon(ressource, description);
    }

    public static String getMessageProperties(String property) {
        String filename = "resources/message.properties";
        InputStream resource = GUIUtils.class.getClassLoader().getResourceAsStream(filename);
        if (resource == null) {
            System.err.println("GUIUtils getImage : resource not found:" + filename);
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(resource);
            resource.close();
            return properties.getProperty(property);
        }
        catch (IOException e2) {
            return null;
        }
    }
}

