/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.DerOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class PKCS7MimeDataSource
implements DataSource,
Cloneable {
    private ContentInfo contentInfo;
    private String provider = null;
    public static final String CONTENT_TYPE_PKCS7 = "application/x-pkcs7-mime";
    public static final String CONTENT_TYPE_PKCS7_SIGNATURE = "application/x-pkcs7-signature";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS7MimeDataSource";

    private PKCS7MimeDataSource(String provider) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "PKCS7MimeDataSource", provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(8192L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(ContentInfo contentInfo) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS7MimeDataSource", contentInfo);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "ContentInfo is null.");
            }
            throw new IllegalArgumentException("ContentInfo is null.");
        }
        this.contentInfo = contentInfo;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(ContentInfo contentInfo, String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7MimeDataSource", contentInfo, provider);
        }
        if (contentInfo == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "ContentInfo is null.");
            }
            throw new IllegalArgumentException("ContentInfo is null.");
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.contentInfo = contentInfo;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(byte[] encoding, boolean base64) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS7MimeDataSource", encoding, new Boolean(base64));
        }
        if (encoding == null || encoding.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        byte[] encoding2 = encoding;
        if (base64) {
            BASE64Decoder decoder = new BASE64Decoder();
            ByteArrayInputStream bais = new ByteArrayInputStream(encoding);
            encoding2 = decoder.decodeBuffer(bais);
        }
        this.contentInfo = new ContentInfo(encoding2, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public PKCS7MimeDataSource(byte[] encoding, boolean base64, String provider) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{encoding, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PKCS7MimeDataSource", parms);
        }
        if (encoding == null || encoding.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS7MimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        byte[] encoding2 = encoding;
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (base64) {
            BASE64Decoder decoder = new BASE64Decoder();
            ByteArrayInputStream bais = new ByteArrayInputStream(encoding);
            encoding2 = decoder.decodeBuffer(bais);
        }
        this.contentInfo = new ContentInfo(encoding2, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS7MimeDataSource");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            PKCS7MimeDataSource ds = new PKCS7MimeDataSource(this.provider);
            if (this.contentInfo != null) {
                ds.setContentInfo((ContentInfo)this.contentInfo.clone());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", ds);
            }
            return ds;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    private void setContentInfo(ContentInfo contentInfo) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setContentInfo", contentInfo);
        }
        this.contentInfo = (ContentInfo)contentInfo.clone();
        if (debug != null) {
            debug.exit(8192L, className, "setContentInfo");
        }
    }

    public ContentInfo getContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", (ContentInfo)this.contentInfo.clone());
        }
        return (ContentInfo)this.contentInfo.clone();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getInputStream");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getInputStream_1", null);
            }
            return null;
        }
        DerOutputStream bytes = new DerOutputStream();
        this.contentInfo.encode(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getInputStream", bais);
        }
        return bais;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOutputStream");
            debug.exit(16384L, (Object)className, "getOutputStream", new ByteArrayOutputStream());
        }
        return new ByteArrayOutputStream();
    }

    @Override
    public String getContentType() {
        String contentType = null;
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
        }
        if (this.contentInfo != null) {
            SignedData sd;
            contentType = CONTENT_TYPE_PKCS7;
            if (this.contentInfo.isSignedData() && !(sd = (SignedData)this.contentInfo.getContent()).hasContent()) {
                contentType = CONTENT_TYPE_PKCS7_SIGNATURE;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentType", contentType);
        }
        return contentType;
    }

    @Override
    public String getName() {
        String name = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        if (this.contentInfo != null) {
            name = this.contentInfo.getContentTypeString();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName", name);
        }
        return name;
    }

    public String toString() {
        String out = "PKCS7MimeDataSource:  ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = this.contentInfo != null ? out + this.contentInfo.toString() : out + "Does not contain a ContentInfo object.";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

