/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public final class JasperPrintManager {
    public static final String PROPERTY_CHECK_AVAILABLE_PRINTERS = "net.sf.jasperreports.awt.check.available.printers";
    protected static final boolean unixSunJDK;

    public static boolean printReport(String sourceFileName, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return JasperPrintManager.printReport(jasperPrint, withPrintDialog);
    }

    public static boolean printReport(InputStream inputStream, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printReport(jasperPrint, withPrintDialog);
    }

    public static boolean printReport(JasperPrint jasperPrint, boolean withPrintDialog) throws JRException {
        boolean checkAvailablePrinters = JRProperties.getBooleanProperty(jasperPrint, PROPERTY_CHECK_AVAILABLE_PRINTERS, true);
        if (checkAvailablePrinters && !unixSunJDK && !JRPrintServiceExporter.checkAvailablePrinters()) {
            throw new JRException("No printer available.");
        }
        return JasperPrintManager.printPages(jasperPrint, 0, jasperPrint.getPages().size() - 1, withPrintDialog);
    }

    public static boolean printPage(String sourceFileName, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return JasperPrintManager.printPage(jasperPrint, pageIndex, withPrintDialog);
    }

    public static boolean printPage(InputStream inputStream, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printPage(jasperPrint, pageIndex, withPrintDialog);
    }

    public static boolean printPage(JasperPrint jasperPrint, int pageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.printPages(jasperPrint, pageIndex, pageIndex, withPrintDialog);
    }

    public static boolean printPages(String sourceFileName, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return JasperPrintManager.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static boolean printPages(InputStream inputStream, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static boolean printPages(JasperPrint jasperPrint, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        return JRPrinterAWT.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static Image printPageToImage(String sourceFileName, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return JasperPrintManager.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    public static Image printPageToImage(InputStream inputStream, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    public static Image printPageToImage(JasperPrint jasperPrint, int pageIndex, float zoom) throws JRException {
        return JRPrinterAWT.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    private JasperPrintManager() {
    }

    static {
        boolean found = false;
        try {
            Class.forName("sun.print.UnixPrintServiceLookup");
            found = true;
        }
        catch (ClassNotFoundException e2) {
            found = false;
        }
        unixSunJDK = found;
    }
}

