/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRCalculable;

final class JRBigDecimalSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRBigDecimalSumIncrementer mainInstance = new JRBigDecimalSumIncrementer();

    private JRBigDecimalSumIncrementer() {
    }

    public static JRBigDecimalSumIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        BigDecimal value = (BigDecimal)variable.getIncrementedValue();
        BigDecimal newValue = JRBigDecimalIncrementerFactory.toBigDecimal(expressionValue);
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRBigDecimalIncrementerFactory.ZERO;
        }
        return value.add(newValue);
    }

    public Object initialValue() {
        return JRBigDecimalIncrementerFactory.ZERO;
    }
}

