/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.harmony.security.Util;
import org.apache.harmony.security.fortress.BootstrapHelper;
import org.apache.harmony.security.fortress.Engine;

public class Services {
    private static Provider bootstrapProvider = BootstrapHelper.getBootstrapProvider();
    private static final String IBMJCEFIPS = "com.ibm.crypto.fips.provider.IBMJCEFIPS";
    private static final String IBMJSSEFIPS = "com.ibm.fips.jsse.IBMJSSEFIPSProvider";
    private static final String IBMPKCSIMPLCLASSNAME = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";
    private static final String IBMJCECCA = "com.ibm.crypto.hdwrCCA.provider.IBMJCECCA";
    private static Object loadingAndRefreshLock = new Object();
    private static final int PROVIDER_UNLOADED = -1;
    private static final int PROVIDER_LOADING = 0;
    private static final int PROVIDER_CREATED = 1;
    private static final int PROVIDER_LOADED = 2;

    private static boolean isFIPS(String string) {
        return IBMJCEFIPS.equals(string) || IBMJSSEFIPS.equals(string);
    }

    public static void init() {
    }

    public static Provider[] getProviders() {
        List list = NormalServices.isDebugMode ? NormalServices.providers : NormalServices.loadAllProviders();
        return Services.getProviders(list);
    }

    public static Provider[] getCreatedProviders() {
        List list = NormalServices.providers;
        return Services.getProviders(list);
    }

    private static Provider[] getProviders(List<Provider> list) {
        if (BootstrapHelper.isInJarVerify()) {
            return new Provider[]{bootstrapProvider};
        }
        if (BootstrapHelper.isInFIPSLoading()) {
            Provider[] providerArray = new Provider[list.size() + 1];
            providerArray[0] = bootstrapProvider;
            for (int i2 = 1; i2 < providerArray.length; ++i2) {
                providerArray[i2] = list.get(i2 - 1);
            }
            return providerArray;
        }
        return list.toArray(new Provider[list.size()]);
    }

    public static List<Provider> getProvidersList() {
        List list = NormalServices.getProviderList();
        if (BootstrapHelper.isInJarVerify()) {
            ArrayList<Provider> arrayList = new ArrayList<Provider>();
            arrayList.add(bootstrapProvider);
            return arrayList;
        }
        if (BootstrapHelper.isInFIPSLoading()) {
            ArrayList<Provider> arrayList = new ArrayList<Provider>(list.size() + 1);
            arrayList.add(bootstrapProvider);
            arrayList.addAll(list);
            return arrayList;
        }
        return new ArrayList<Provider>(list);
    }

    public static Provider getProvider(String string) {
        if (string == null) {
            return null;
        }
        return NormalServices.getProvider(string);
    }

    public static int insertProviderAt(Provider provider, int n2) {
        int n3 = Services.getLoadedProviderCount();
        if (n2 < 1 || n2 > n3) {
            n2 = n3 + 1;
        }
        String string = provider.getName();
        String string2 = provider.getClass().getName();
        boolean bl = NormalServices.isDefaultProvider(string);
        if (bl) {
            NormalServices.defaultNameProviderMap.put(string, provider);
        } else {
            NormalServices.extNameProviderMap.put(string, provider);
        }
        if (bl) {
            ProviderInfo providerInfo = NormalServices.getDefaultProviderInfoByName(string);
            if (providerInfo == null) {
                providerInfo = new ProviderInfo(string2, n2);
                NormalServices.defaultOrderedProviderInfoList.add(providerInfo);
                Collections.sort(NormalServices.defaultOrderedProviderInfoList, ProviderInfo.getComparator());
            }
            providerInfo.setProviderName(string);
            providerInfo.setLoaded();
            Services.increaseTheLowPriorityProviderIndex(n2);
            providerInfo.setIndex(n2);
        } else {
            ProviderInfo providerInfo = NormalServices.getExtProviderInfo(string2, string);
            if (providerInfo == null) {
                providerInfo = new ProviderInfo(string2, n2);
                NormalServices.extOrderedProviderInfoList.add(providerInfo);
                Collections.sort(NormalServices.extOrderedProviderInfoList, ProviderInfo.getComparator());
            }
            providerInfo.setProviderName(string);
            Services.increaseTheLowPriorityProviderIndex(n2);
            providerInfo.setLoaded();
            providerInfo.setIndex(n2);
        }
        NormalServices.addToProviders(provider);
        Engine.door.renumProviders();
        Services.setNeedRefresh();
        return n2;
    }

    private static int getLoadedProviderCount() {
        int n2 = 0;
        for (ProviderInfo providerInfo : NormalServices.defaultOrderedProviderInfoList) {
            if (providerInfo.isRemoved()) continue;
            ++n2;
        }
        for (ProviderInfo providerInfo : NormalServices.extOrderedProviderInfoList) {
            if (providerInfo.isRemoved()) continue;
            ++n2;
        }
        return n2;
    }

    private static void increaseTheLowPriorityProviderIndex(int n2) {
        for (ProviderInfo providerInfo : NormalServices.extOrderedProviderInfoList) {
            if (providerInfo.getIndex() < n2) continue;
            providerInfo.increaseIndexByOne();
        }
        for (ProviderInfo providerInfo : NormalServices.defaultOrderedProviderInfoList) {
            if (providerInfo.getIndex() < n2) continue;
            providerInfo.increaseIndexByOne();
        }
    }

    private static void decreaseTheLowPriorityProviderIndex(int n2) {
        for (ProviderInfo providerInfo : NormalServices.extOrderedProviderInfoList) {
            if (providerInfo.getIndex() <= n2) continue;
            providerInfo.decreaseIndexByOne();
        }
        for (ProviderInfo providerInfo : NormalServices.defaultOrderedProviderInfoList) {
            if (providerInfo.getIndex() <= n2) continue;
            providerInfo.decreaseIndexByOne();
        }
    }

    public static void removeProvider(int n2) {
        LinkedList linkedList = new LinkedList(NormalServices.providers);
        String string = ((Provider)linkedList.get(n2 - 1)).getName();
        boolean bl = NormalServices.isDefaultProvider(string);
        HashMap hashMap = bl ? new HashMap(NormalServices.defaultNameProviderMap) : new HashMap(NormalServices.extNameProviderMap);
        Provider provider = (Provider)linkedList.remove(n2 - 1);
        hashMap.remove(provider.getName());
        if (bl) {
            ProviderInfo providerInfo = NormalServices.getDefaultProviderInfoByName(provider.getName());
            if (providerInfo != null) {
                providerInfo.setRemoved();
                providerInfo.setIndex(Integer.MAX_VALUE);
            }
            NormalServices.defaultNameProviderMap = hashMap;
        } else {
            NormalServices.extNameProviderMap = hashMap;
            ProviderInfo providerInfo = NormalServices.getExtProviderInfoByName(provider.getName());
            if (providerInfo != null) {
                providerInfo.setRemoved();
                providerInfo.setIndex(Integer.MAX_VALUE);
            }
        }
        NormalServices.providers = linkedList;
        Services.decreaseTheLowPriorityProviderIndex(n2);
        Engine.door.renumProviders();
        Services.setNeedRefresh();
    }

    public static void initServiceInfo(Provider provider) {
        StringBuilder stringBuilder = new StringBuilder(128);
        String string = provider.getClass().getName();
        String string2 = provider.getName();
        ProviderInfo providerInfo = NormalServices.getDefaultProviderInfoByClassName(string);
        if (providerInfo == null) {
            providerInfo = NormalServices.getExtProviderInfo(string, string2);
        }
        if (providerInfo == null) {
            throw new NullPointerException();
        }
        for (Provider.Service service : provider.getServices()) {
            String string3 = service.getType();
            stringBuilder.delete(0, stringBuilder.length());
            String string4 = stringBuilder.append(string3).append(".").append(Util.toUpperCase(service.getAlgorithm())).toString();
            if (!NormalServices.services.containsKey(string4)) {
                NormalServices.services.put(string4, service);
            } else {
                Services.putServiceToCacheAfterCheckPriority(service, string4, providerInfo);
            }
            Iterator<String> iterator = Engine.door.getAliases(service);
            while (iterator.hasNext()) {
                String string5 = iterator.next();
                stringBuilder.delete(0, stringBuilder.length());
                string4 = stringBuilder.append(string3).append(".").append(Util.toUpperCase(string5)).toString();
                if (!NormalServices.services.containsKey(string4)) {
                    NormalServices.services.put(string4, service);
                    continue;
                }
                Services.putServiceToCacheAfterCheckPriority(service, string4, providerInfo);
            }
        }
    }

    private static void putServiceToCacheAfterCheckPriority(Provider.Service service, String string, ProviderInfo providerInfo) {
        Provider.Service service2 = (Provider.Service)NormalServices.services.get(string);
        Provider provider = service2.getProvider();
        String string2 = provider.getClass().getName();
        String string3 = provider.getName();
        ProviderInfo providerInfo2 = NormalServices.getDefaultProviderInfoByClassName(string2);
        if (providerInfo2 == null) {
            providerInfo2 = NormalServices.getExtProviderInfo(string2, string3);
        }
        if (providerInfo2 == null) {
            throw new NullPointerException();
        }
        if (providerInfo2.getIndex() < providerInfo.getIndex()) {
            int n2 = 1;
            while (NormalServices.services.containsKey(string + "." + n2)) {
                ++n2;
            }
            NormalServices.services.put(string + "." + n2, service);
        } else {
            int n3 = 1;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(NormalServices.services.get(string));
            while (NormalServices.services.containsKey(string + "." + n3)) {
                arrayList.add(NormalServices.getService(string + "." + n3));
                ++n3;
            }
            NormalServices.services.put(string, service);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n4 = i2 + 1;
                NormalServices.services.put(string + "." + n4, arrayList.get(i2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void updateServiceInfo() {
        Object object = loadingAndRefreshLock;
        synchronized (object) {
            NormalServices.services.clear();
            List list = NormalServices.providers;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Services.initServiceInfo((Provider)iterator.next());
            }
            NormalServices.needRefresh = false;
        }
    }

    public static Provider.Service getService(String string) {
        return NormalServices.getService(string);
    }

    public static void printServices() {
        Services.refresh();
        Set set = NormalServices.services.keySet();
        for (String string : set) {
            System.out.println(string + "=" + NormalServices.services.get(string));
        }
    }

    public static void setNeedRefresh() {
        NormalServices.needRefresh = true;
    }

    public static void refresh() {
        if (NormalServices.needRefresh) {
            NormalServices.refreshNumber++;
            Services.updateServiceInfo();
        }
    }

    static int getRefreshNumber() {
        return NormalServices.refreshNumber;
    }

    private static Provider newInstance(String string, ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String string2;
        String string3;
        int n2 = string.indexOf(32);
        if (n2 == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2, string.length()).trim();
        }
        final Class<?> clazz = Class.forName(string3, true, classLoader);
        if (string2.length() > 0) {
            try {
                Class[] classArray = new Class[]{String.class};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                return (Provider)constructor.newInstance(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<Provider>(){

            @Override
            public Provider run() {
                try {
                    return (Provider)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private static class NormalServices {
        private static Map<String, Provider> defaultNameProviderMap = new HashMap<String, Provider>(20);
        private static Map<String, Provider> extNameProviderMap = new HashMap<String, Provider>(5);
        private static Map<String, Provider.Service> services = new HashMap<String, Provider.Service>(512);
        private static boolean needRefresh = false;
        private static int refreshNumber = 1;
        private static List<Provider> providers = new LinkedList<Provider>();
        private static ArrayList<ProviderInfo> defaultOrderedProviderInfoList = new ArrayList();
        private static ArrayList<ProviderInfo> extOrderedProviderInfoList = new ArrayList();
        private static Properties serviceProviderClassNameMap;
        private static Properties defaultProviderNameAndClassNameMap;
        private static ClassLoader cl;
        private static boolean isDebugMode;

        private NormalServices() {
        }

        private static List<Provider> getProviderList() {
            AccessController.doPrivileged(new PrivilegedAction<Provider>(){

                @Override
                public Provider run() {
                    NormalServices.loadAllProviders();
                    return null;
                }
            });
            return providers;
        }

        private static List<Provider> loadAllProviders() {
            for (ProviderInfo providerInfo : defaultOrderedProviderInfoList) {
                if (providerInfo.isLoading() || providerInfo.isLoaded() || providerInfo.isRemoved()) continue;
                NormalServices.createDefaultProviderInstance(providerInfo);
            }
            for (ProviderInfo providerInfo : extOrderedProviderInfoList) {
                if (providerInfo.isLoading() || providerInfo.isLoaded() || providerInfo.isRemoved()) continue;
                NormalServices.createExtProviderInstance(providerInfo);
            }
            Engine.door.renumProviders();
            return providers;
        }

        private static Provider getProvider(String string) {
            if (NormalServices.isRemoved(string)) {
                return null;
            }
            if (defaultNameProviderMap.containsKey(string)) {
                return defaultNameProviderMap.get(string);
            }
            if (extNameProviderMap.containsKey(string)) {
                return extNameProviderMap.get(string);
            }
            if (NormalServices.isDefaultProvider(string)) {
                String string2 = defaultProviderNameAndClassNameMap.getProperty(string);
                ProviderInfo providerInfo = NormalServices.getDefaultProviderInfoByClassName(string2);
                if (providerInfo == null) {
                    return null;
                }
                Provider provider = NormalServices.createDefaultProviderInstance(providerInfo);
                return provider;
            }
            Provider provider = extNameProviderMap.get(string);
            return provider;
        }

        private static boolean isDefaultProvider(String string) {
            return defaultProviderNameAndClassNameMap.containsKey(string);
        }

        private static boolean isRemoved(String string) {
            for (ProviderInfo providerInfo : defaultOrderedProviderInfoList) {
                if (!string.equals(providerInfo.getProviderName())) continue;
                return providerInfo.isRemoved();
            }
            for (ProviderInfo providerInfo : extOrderedProviderInfoList) {
                if (!string.equals(providerInfo.getProviderName())) continue;
                return providerInfo.isRemoved() && !extNameProviderMap.containsKey(string);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Provider createDefaultProviderInstance(ProviderInfo providerInfo) {
            Object object = loadingAndRefreshLock;
            synchronized (object) {
                if (providerInfo.isLoaded()) {
                    return defaultNameProviderMap.get(providerInfo.getProviderName());
                }
                providerInfo.setLoading();
                String string = providerInfo.getProviderClassName();
                Provider provider = NormalServices.createProviderInstance(string, defaultNameProviderMap);
                if (provider != null) {
                    for (ProviderInfo providerInfo2 : defaultOrderedProviderInfoList) {
                        if (!providerInfo2.getProviderClassName().equals(string)) continue;
                        providerInfo2.setProviderName(provider.getName());
                        providerInfo2.setLoaded();
                    }
                }
                return provider;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Provider createExtProviderInstance(ProviderInfo providerInfo) {
            Object object = loadingAndRefreshLock;
            synchronized (object) {
                if (providerInfo.isLoaded()) {
                    return extNameProviderMap.get(providerInfo.getProviderName());
                }
                providerInfo.setLoading();
                String string = providerInfo.getProviderClassName();
                Provider provider = NormalServices.createProviderInstance(string, extNameProviderMap);
                if (provider != null) {
                    for (ProviderInfo providerInfo2 : extOrderedProviderInfoList) {
                        if (!providerInfo2.getProviderClassName().equals(string)) continue;
                        providerInfo2.setProviderName(provider.getName());
                        providerInfo2.setLoaded();
                    }
                }
                return provider;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Provider createProviderInstance(String string, Map<String, Provider> map) {
            boolean bl = Services.isFIPS(string);
            if (bl) {
                BootstrapHelper.beginFIPSLoading();
            }
            try {
                Provider provider = Services.newInstance(string, NormalServices.cl);
                if (provider != null) {
                    map.put(provider.getName(), provider);
                    NormalServices.addToProviders(provider);
                    Services.initServiceInfo(provider);
                    Engine.door.renumProviders();
                }
                Provider provider2 = provider;
                return provider2;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            finally {
                if (bl) {
                    BootstrapHelper.endFIPSLoading();
                }
            }
            return null;
        }

        private static void addToProviders(Provider provider) {
            ProviderInfo providerInfo = null;
            int n2 = 0;
            boolean bl = false;
            String string = provider.getClass().getName();
            String string2 = provider.getName();
            ProviderInfo providerInfo2 = NormalServices.getDefaultProviderInfoByClassName(string);
            if (providerInfo2 == null) {
                providerInfo2 = NormalServices.getExtProviderInfo(string, string2);
            }
            for (int i2 = 0; i2 < providers.size(); ++i2) {
                Provider provider2 = providers.get(i2);
                String string3 = provider2.getName();
                providerInfo = defaultNameProviderMap.containsKey(string3) ? NormalServices.getDefaultProviderInfoByName(string3) : NormalServices.getExtProviderInfoByName(string3);
                if (providerInfo2.getIndex() >= providerInfo.getIndex()) continue;
                bl = true;
                n2 = i2;
                break;
            }
            if (!bl) {
                providers.add(provider);
            } else {
                providers.add(n2, provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static Provider.Service getService(String string) {
            Object object;
            Cloneable cloneable;
            Object object2;
            Object object3 = null;
            if (services.containsKey(string) && !serviceProviderClassNameMap.containsKey(string)) {
                return services.get(string);
            }
            boolean bl = false;
            if (services.containsKey(string)) {
                object2 = services.get(string);
                cloneable = ((Provider.Service)object2).getProvider();
                boolean bl2 = NormalServices.isDefaultProvider(((Provider)cloneable).getName());
                if (!bl2) {
                    bl = true;
                    object3 = object2;
                }
            } else {
                object2 = extNameProviderMap.keySet();
                cloneable = object2.iterator();
                block3: while (cloneable.hasNext()) {
                    Provider provider = extNameProviderMap.get(cloneable.next());
                    for (Provider.Service object4 : provider.getServices()) {
                        object = object4.getType() + "." + Util.toUpperCase(object4.getAlgorithm());
                        if (!string.equals(object)) continue;
                        bl = true;
                        object3 = object4;
                        continue block3;
                    }
                }
            }
            if (bl) {
                void var7_13;
                Object object4;
                if (!serviceProviderClassNameMap.containsKey(string)) {
                    return object3;
                }
                object2 = ((Provider.Service)object3).getProvider();
                cloneable = object2.getClass().getName();
                String string2 = ((Provider)object2).getName();
                Object object8 = null;
                Object var7_11 = null;
                for (ProviderInfo providerInfo : extOrderedProviderInfoList) {
                    object4 = providerInfo.getProviderClassName();
                    String string3 = providerInfo.getProviderName();
                    if (providerInfo.isRemoved()) continue;
                    if (NormalServices.isIBMExtProvider(cloneable)) {
                        boolean bl2 = NormalServices.equalClassName((String)object4, cloneable);
                        if (!bl2 || string3 != null && !string2.equals(string3)) continue;
                        object8 = providerInfo;
                        continue;
                    }
                    if (!((String)object4).equals(cloneable)) continue;
                    object8 = providerInfo;
                }
                object = serviceProviderClassNameMap.getProperty(string);
                String string4 = defaultProviderNameAndClassNameMap.getProperty((String)object);
                for (ProviderInfo providerInfo : defaultOrderedProviderInfoList) {
                    if (providerInfo.isRemoved() || !providerInfo.getProviderClassName().equals(string4)) continue;
                    ProviderInfo providerInfo2 = providerInfo;
                    break;
                }
                if (var7_13 == null) {
                    return object3;
                }
                if (((ProviderInfo)object8).getIndex() < var7_13.getIndex()) {
                    return object3;
                }
                object4 = defaultProviderNameAndClassNameMap.getProperty((String)object);
                ProviderInfo providerInfo = NormalServices.getDefaultProviderInfoByClassName((String)object4);
                NormalServices.createDefaultProviderInstance(providerInfo);
                return services.get(string);
            }
            if (serviceProviderClassNameMap.containsKey(string)) {
                object2 = serviceProviderClassNameMap.getProperty(string);
                cloneable = NormalServices.sortDefaultProviderInfos((String)object2);
                Provider provider = null;
                for (ProviderInfo providerInfo : cloneable) {
                    object = NormalServices.getDefaultProviderNameByProviderClassName(providerInfo.getProviderClassName());
                    if (defaultNameProviderMap.containsKey(object)) {
                        provider = defaultNameProviderMap.get(object);
                    } else {
                        String string5 = defaultProviderNameAndClassNameMap.getProperty((String)object);
                        Object object5 = loadingAndRefreshLock;
                        synchronized (object5) {
                            ProviderInfo providerInfo3 = NormalServices.getDefaultProviderInfoByClassName(string5);
                            if (providerInfo3.isLoading()) {
                                return null;
                            }
                            provider = NormalServices.createDefaultProviderInstance(providerInfo3);
                        }
                    }
                    if (provider == null) continue;
                    return services.get(string);
                }
                return null;
            }
            return null;
        }

        private static String getDefaultProviderNameByProviderClassName(String string) {
            Set<Object> set = defaultProviderNameAndClassNameMap.keySet();
            for (String string2 : set) {
                if (!defaultProviderNameAndClassNameMap.get(string2).equals(string)) continue;
                return string2;
            }
            return null;
        }

        private static ArrayList<ProviderInfo> sortDefaultProviderInfos(String string) {
            ArrayList<ProviderInfo> arrayList = null;
            String[] stringArray = string.split(":");
            ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
            arrayList = new ArrayList<ProviderInfo>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList2.add(defaultProviderNameAndClassNameMap.getProperty(stringArray[i2]));
            }
            for (ProviderInfo providerInfo : defaultOrderedProviderInfoList) {
                String string2 = providerInfo.getProviderClassName();
                for (String string3 : arrayList2) {
                    if (!string3.equals(string2) || providerInfo.isRemoved()) continue;
                    arrayList.add(providerInfo);
                    arrayList2.remove(string3);
                }
            }
            return arrayList;
        }

        private static void loadDefaultServicesProperties() {
            serviceProviderClassNameMap = NormalServices.loadPropertyFiles("org.apache.harmony.security.fortress.services");
        }

        private static void loadDefaultProviderClassNameProperties() {
            defaultProviderNameAndClassNameMap = NormalServices.loadPropertyFiles("org.apache.harmony.security.fortress.providerClassName");
        }

        private static void loadExtProviders() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (extNameProviderMap.size() == 0) {
                        String string;
                        Collection<Object> collection = defaultProviderNameAndClassNameMap.values();
                        ArrayList<String> arrayList = new ArrayList<String>(5);
                        int n2 = 1;
                        while ((string = Security.getProperty("security.provider." + n2++)) != null) {
                            if (collection.contains(string)) continue;
                            arrayList.add(string);
                        }
                        for (String string2 : arrayList) {
                            for (ProviderInfo providerInfo : extOrderedProviderInfoList) {
                                if (!providerInfo.getProviderClassName().equals(string2) || providerInfo.isLoaded() || providerInfo.isRemoved() || providerInfo.isLoading()) continue;
                                NormalServices.createExtProviderInstance(providerInfo);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        private static ProviderInfo getDefaultProviderInfoByName(String string) {
            for (ProviderInfo providerInfo : defaultOrderedProviderInfoList) {
                if (!string.equals(providerInfo.getProviderName())) continue;
                return providerInfo;
            }
            return null;
        }

        private static ProviderInfo getDefaultProviderInfoByClassName(String string) {
            for (ProviderInfo providerInfo : defaultOrderedProviderInfoList) {
                if (!string.equals(providerInfo.getProviderClassName())) continue;
                return providerInfo;
            }
            return null;
        }

        private static ProviderInfo getExtProviderInfoByName(String string) {
            for (ProviderInfo providerInfo : extOrderedProviderInfoList) {
                if (!string.equals(providerInfo.getProviderName())) continue;
                return providerInfo;
            }
            return null;
        }

        private static boolean isIBMExtProvider(String string) {
            return string.equals(Services.IBMJCECCA) || string.equals(Services.IBMPKCSIMPLCLASSNAME);
        }

        private static ProviderInfo getExtProviderInfo(String string, String string2) {
            for (ProviderInfo providerInfo : extOrderedProviderInfoList) {
                String string3;
                String string4 = providerInfo.getProviderClassName();
                if (!NormalServices.equalClassName(string4, string) || (string3 = providerInfo.getProviderName()) != null && !string3.equals(string2)) continue;
                return providerInfo;
            }
            return null;
        }

        private static boolean equalClassName(String string, String string2) {
            int n2 = string.indexOf(" ");
            if (n2 > 0) {
                String string3 = string.substring(0, n2);
                return string3.equals(string2);
            }
            return string.equals(string2);
        }

        private static void initProviderInfoList() {
            String string;
            Collection<Object> collection = defaultProviderNameAndClassNameMap.values();
            int n2 = 1;
            while ((string = Security.getProperty("security.provider." + n2)) != null) {
                ProviderInfo providerInfo;
                if (collection.contains(string)) {
                    providerInfo = new ProviderInfo(string, n2);
                    defaultOrderedProviderInfoList.add(providerInfo);
                } else {
                    providerInfo = new ProviderInfo(string, n2);
                    extOrderedProviderInfoList.add(providerInfo);
                }
                ++n2;
            }
            Collections.sort(defaultOrderedProviderInfoList, ProviderInfo.getComparator());
            Collections.sort(extOrderedProviderInfoList, ProviderInfo.getComparator());
        }

        private static Properties loadPropertyFiles(String string) {
            final String string2 = string.replace('.', '/');
            return (Properties)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        InputStream inputStream = cl.getResourceAsStream(string2 + ".properties");
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        return properties;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
        }

        static {
            isDebugMode = false;
            cl = ClassLoader.getSystemClassLoader();
            if (cl == null) {
                cl = com.ibm.jvm.ClassLoader.getLastClassLoader();
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    NormalServices.loadDefaultServicesProperties();
                    NormalServices.loadDefaultProviderClassNameProperties();
                    NormalServices.initProviderInfoList();
                    NormalServices.loadExtProviders();
                    if (System.getProperty("java.security.auth.debug") != null) {
                        isDebugMode = true;
                        BootstrapHelper.beginProvidersLoading();
                        NormalServices.loadAllProviders();
                        BootstrapHelper.endProvidersLoading();
                    }
                    return null;
                }
            });
        }
    }

    private static class ProviderInfo {
        private String providerClassName;
        private int index;
        private static final ProviderComparator pc = new ProviderComparator();
        private String providerName = null;
        private int status = -1;

        public ProviderInfo(String string, int n2) {
            this.providerClassName = string;
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n2) {
            this.index = n2;
        }

        public void increaseIndexByOne() {
            ++this.index;
        }

        public void decreaseIndexByOne() {
            --this.index;
        }

        public String getProviderClassName() {
            return this.providerClassName;
        }

        public boolean isLoaded() {
            return this.status == 2;
        }

        public boolean isRemoved() {
            return this.status == 1;
        }

        public void setLoaded() {
            this.status = 2;
        }

        public void setRemoved() {
            this.status = 1;
        }

        public void setLoading() {
            this.status = 0;
        }

        public boolean isLoading() {
            return this.status == 0;
        }

        public void setProviderName(String string) {
            this.providerName = string;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public static ProviderComparator getComparator() {
            return pc;
        }

        static class ProviderComparator
        implements Comparator<ProviderInfo> {
            ProviderComparator() {
            }

            @Override
            public int compare(ProviderInfo providerInfo, ProviderInfo providerInfo2) {
                return providerInfo.getIndex() - providerInfo2.getIndex();
            }
        }
    }
}

