/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.xml.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XfaForm {
    private Xml2SomTemplate templateSom;
    private Node templateNode;
    private Xml2SomDatasets datasetsSom;
    private Node datasetsNode;
    private AcroFieldsSearch acroFieldsSom;
    private PdfReader reader;
    private boolean xfaPresent;
    private Document domDocument;
    private boolean changed;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
    }

    public static PdfObject getXfaObject(PdfReader reader) {
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            return null;
        }
        return PdfReader.getPdfObjectRelease(af.get(PdfName.XFA));
    }

    public XfaForm(PdfReader reader) throws IOException, ParserConfigurationException, SAXException {
        this.reader = reader;
        PdfObject xfa = XfaForm.getXfaObject(reader);
        if (xfa == null) {
            this.xfaPresent = false;
            return;
        }
        this.xfaPresent = true;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            int k2 = 1;
            while (k2 < ar.size()) {
                PdfObject ob = ar.getDirectObject(k2);
                if (ob instanceof PRStream) {
                    byte[] b2 = PdfReader.getStreamBytes((PRStream)ob);
                    bout.write(b2);
                }
                k2 += 2;
            }
        } else if (xfa instanceof PRStream) {
            byte[] b3 = PdfReader.getStreamBytes((PRStream)xfa);
            bout.write(b3);
        }
        bout.close();
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        DocumentBuilder db = fact.newDocumentBuilder();
        this.domDocument = db.parse(new ByteArrayInputStream(bout.toByteArray()));
        this.extractNodes();
    }

    private void extractNodes() {
        Node n2 = this.domDocument.getFirstChild();
        while (n2.getChildNodes().getLength() == 0) {
            n2 = n2.getNextSibling();
        }
        n2 = n2.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                String s2 = n2.getLocalName();
                if ("template".equals(s2)) {
                    this.templateNode = n2;
                    this.templateSom = new Xml2SomTemplate(n2);
                } else if ("datasets".equals(s2)) {
                    this.datasetsNode = n2;
                    this.datasetsSom = new Xml2SomDatasets(n2.getFirstChild());
                }
            }
            n2 = n2.getNextSibling();
        }
    }

    public static void setXfa(XfaForm form, PdfReader reader, PdfWriter writer) throws IOException {
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            return;
        }
        PdfObject xfa = XfaForm.getXfaObject(reader);
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            int t2 = -1;
            int d2 = -1;
            int k2 = 0;
            while (k2 < ar.size()) {
                PdfString s2 = ar.getAsString(k2);
                if ("template".equals(s2.toString())) {
                    t2 = k2 + 1;
                }
                if ("datasets".equals(s2.toString())) {
                    d2 = k2 + 1;
                }
                k2 += 2;
            }
            if (t2 > -1 && d2 > -1) {
                reader.killXref(ar.getAsIndirectObject(t2));
                reader.killXref(ar.getAsIndirectObject(d2));
                PdfStream tStream = new PdfStream(XfaForm.serializeDoc(form.templateNode));
                tStream.flateCompress(writer.getCompressionLevel());
                ar.set(t2, writer.addToBody(tStream).getIndirectReference());
                PdfStream dStream = new PdfStream(XfaForm.serializeDoc(form.datasetsNode));
                dStream.flateCompress(writer.getCompressionLevel());
                ar.set(d2, writer.addToBody(dStream).getIndirectReference());
                af.put(PdfName.XFA, new PdfArray(ar));
                return;
            }
        }
        reader.killXref(af.get(PdfName.XFA));
        PdfStream str = new PdfStream(XfaForm.serializeDoc(form.domDocument));
        str.flateCompress(writer.getCompressionLevel());
        PdfIndirectReference ref = writer.addToBody(str).getIndirectReference();
        af.put(PdfName.XFA, ref);
    }

    public void setXfa(PdfWriter writer) throws IOException {
        XfaForm.setXfa(this, this.reader, writer);
    }

    public static byte[] serializeDoc(Node n2) throws IOException {
        XmlDomWriter xw = new XmlDomWriter();
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        xw.setOutput(fout, null);
        xw.setCanonical(false);
        xw.write(n2);
        fout.close();
        return fout.toByteArray();
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public Document getDomDocument() {
        return this.domDocument;
    }

    public String findFieldName(String name, AcroFields af) {
        HashMap<String, AcroFields.Item> items = af.getFields();
        if (items.containsKey(name)) {
            return name;
        }
        if (this.acroFieldsSom == null) {
            this.acroFieldsSom = items.isEmpty() && this.xfaPresent ? new AcroFieldsSearch(this.datasetsSom.getName2Node().keySet()) : new AcroFieldsSearch(items.keySet());
        }
        if (this.acroFieldsSom.getAcroShort2LongName().containsKey(name)) {
            return this.acroFieldsSom.getAcroShort2LongName().get(name);
        }
        return this.acroFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public String findDatasetsName(String name) {
        if (this.datasetsSom.getName2Node().containsKey(name)) {
            return name;
        }
        return this.datasetsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public Node findDatasetsNode(String name) {
        if (name == null) {
            return null;
        }
        if ((name = this.findDatasetsName(name)) == null) {
            return null;
        }
        return this.datasetsSom.getName2Node().get(name);
    }

    public static String getNodeText(Node n2) {
        if (n2 == null) {
            return "";
        }
        return XfaForm.getNodeText(n2, "");
    }

    private static String getNodeText(Node n2, String name) {
        Node n22 = n2.getFirstChild();
        while (n22 != null) {
            if (n22.getNodeType() == 1) {
                name = XfaForm.getNodeText(n22, name);
            } else if (n22.getNodeType() == 3) {
                name = String.valueOf(name) + n22.getNodeValue();
            }
            n22 = n22.getNextSibling();
        }
        return name;
    }

    public void setNodeText(Node n2, String text) {
        if (n2 == null) {
            return;
        }
        Node nc = null;
        while ((nc = n2.getFirstChild()) != null) {
            n2.removeChild(nc);
        }
        if (n2.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            n2.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        n2.appendChild(this.domDocument.createTextNode(text));
        this.changed = true;
    }

    public void setXfaPresent(boolean xfaPresent) {
        this.xfaPresent = xfaPresent;
    }

    public void setDomDocument(Document domDocument) {
        this.domDocument = domDocument;
        this.extractNodes();
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public void setReader(PdfReader reader) {
        this.reader = reader;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Xml2SomTemplate getTemplateSom() {
        return this.templateSom;
    }

    public void setTemplateSom(Xml2SomTemplate templateSom) {
        this.templateSom = templateSom;
    }

    public Xml2SomDatasets getDatasetsSom() {
        return this.datasetsSom;
    }

    public void setDatasetsSom(Xml2SomDatasets datasetsSom) {
        this.datasetsSom = datasetsSom;
    }

    public AcroFieldsSearch getAcroFieldsSom() {
        return this.acroFieldsSom;
    }

    public void setAcroFieldsSom(AcroFieldsSearch acroFieldsSom) {
        this.acroFieldsSom = acroFieldsSom;
    }

    public Node getDatasetsNode() {
        return this.datasetsNode;
    }

    public void fillXfaForm(File file) throws IOException {
        this.fillXfaForm(new FileInputStream(file));
    }

    public void fillXfaForm(InputStream is) throws IOException {
        this.fillXfaForm(new InputSource(is));
    }

    public void fillXfaForm(InputSource is) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document newdoc = db.parse(is);
            this.fillXfaForm(newdoc.getDocumentElement());
        }
        catch (ParserConfigurationException e2) {
            throw new ExceptionConverter(e2);
        }
        catch (SAXException e3) {
            throw new ExceptionConverter(e3);
        }
    }

    public void fillXfaForm(Node node) {
        Node data = this.datasetsNode.getFirstChild();
        NodeList list = data.getChildNodes();
        if (list.getLength() == 0) {
            data.appendChild(this.domDocument.importNode(node, true));
        } else {
            data.replaceChild(this.domDocument.importNode(node, true), data.getFirstChild());
        }
        this.extractNodes();
        this.setChanged(true);
    }

    public static class AcroFieldsSearch
    extends Xml2Som {
        private HashMap<String, String> acroShort2LongName;

        public AcroFieldsSearch(Collection<String> items) {
            this.inverseSearch = new HashMap();
            this.acroShort2LongName = new HashMap();
            Iterator<String> iterator = items.iterator();
            while (iterator.hasNext()) {
                String string;
                String itemName = string = iterator.next();
                String itemShort = AcroFieldsSearch.getShortName(itemName);
                this.acroShort2LongName.put(itemShort, itemName);
                AcroFieldsSearch.inverseSearchAdd(this.inverseSearch, AcroFieldsSearch.splitParts(itemShort), itemName);
            }
        }

        public HashMap<String, String> getAcroShort2LongName() {
            return this.acroShort2LongName;
        }

        public void setAcroShort2LongName(HashMap<String, String> acroShort2LongName) {
            this.acroShort2LongName = acroShort2LongName;
        }
    }

    public static class InverseStore {
        protected ArrayList<String> part = new ArrayList();
        protected ArrayList<Object> follow = new ArrayList();

        public String getDefaultName() {
            InverseStore store = this;
            Object obj;
            while (!((obj = store.follow.get(0)) instanceof String)) {
                store = (InverseStore)obj;
            }
            return (String)obj;
        }

        public boolean isSimilar(String name) {
            int idx = name.indexOf(91);
            name = name.substring(0, idx + 1);
            int k2 = 0;
            while (k2 < this.part.size()) {
                if (this.part.get(k2).startsWith(name)) {
                    return true;
                }
                ++k2;
            }
            return false;
        }
    }

    public static class Stack2<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -7451476576174095212L;

        public T peek() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(this.size() - 1);
        }

        public T pop() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Object ret = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            return (T)ret;
        }

        public T push(T item) {
            this.add(item);
            return item;
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    public static class Xml2Som {
        protected ArrayList<String> order;
        protected HashMap<String, Node> name2Node;
        protected HashMap<String, InverseStore> inverseSearch;
        protected Stack2<String> stack;
        protected int anform;

        public static String escapeSom(String s2) {
            if (s2 == null) {
                return "";
            }
            int idx = s2.indexOf(46);
            if (idx < 0) {
                return s2;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s2.substring(last, idx));
                sb.append('\\');
                last = idx;
                idx = s2.indexOf(46, idx + 1);
            }
            sb.append(s2.substring(last));
            return sb.toString();
        }

        public static String unescapeSom(String s2) {
            int idx = s2.indexOf(92);
            if (idx < 0) {
                return s2;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s2.substring(last, idx));
                last = idx + 1;
                idx = s2.indexOf(92, idx + 1);
            }
            sb.append(s2.substring(last));
            return sb.toString();
        }

        protected String printStack() {
            if (this.stack.empty()) {
                return "";
            }
            StringBuffer s2 = new StringBuffer();
            int k2 = 0;
            while (k2 < this.stack.size()) {
                s2.append('.').append((String)this.stack.get(k2));
                ++k2;
            }
            return s2.substring(1);
        }

        public static String getShortName(String s2) {
            int idx = s2.indexOf(".#subform[");
            if (idx < 0) {
                return s2;
            }
            int last = 0;
            StringBuffer sb = new StringBuffer();
            while (idx >= 0) {
                sb.append(s2.substring(last, idx));
                idx = s2.indexOf("]", idx + 10);
                if (idx < 0) {
                    return sb.toString();
                }
                last = idx + 1;
                idx = s2.indexOf(".#subform[", last);
            }
            sb.append(s2.substring(last));
            return sb.toString();
        }

        public void inverseSearchAdd(String unstack) {
            Xml2Som.inverseSearchAdd(this.inverseSearch, this.stack, unstack);
        }

        public static void inverseSearchAdd(HashMap<String, InverseStore> inverseSearch, Stack2<String> stack, String unstack) {
            String last = stack.peek();
            InverseStore store = inverseSearch.get(last);
            if (store == null) {
                store = new InverseStore();
                inverseSearch.put(last, store);
            }
            int k2 = stack.size() - 2;
            while (k2 >= 0) {
                InverseStore store2;
                last = (String)stack.get(k2);
                int idx = store.part.indexOf(last);
                if (idx < 0) {
                    store.part.add(last);
                    store2 = new InverseStore();
                    store.follow.add(store2);
                } else {
                    store2 = (InverseStore)store.follow.get(idx);
                }
                store = store2;
                --k2;
            }
            store.part.add("");
            store.follow.add(unstack);
        }

        public String inverseSearchGlobal(ArrayList<String> parts) {
            if (parts.isEmpty()) {
                return null;
            }
            InverseStore store = this.inverseSearch.get(parts.get(parts.size() - 1));
            if (store == null) {
                return null;
            }
            int k2 = parts.size() - 2;
            while (k2 >= 0) {
                String part = parts.get(k2);
                int idx = store.part.indexOf(part);
                if (idx < 0) {
                    if (store.isSimilar(part)) {
                        return null;
                    }
                    return store.getDefaultName();
                }
                store = (InverseStore)store.follow.get(idx);
                --k2;
            }
            return store.getDefaultName();
        }

        public static Stack2<String> splitParts(String name) {
            String part;
            while (name.startsWith(".")) {
                name = name.substring(1);
            }
            Stack2<String> parts = new Stack2<String>();
            int last = 0;
            int pos = 0;
            while (true) {
                pos = last;
                while ((pos = name.indexOf(46, pos)) >= 0 && name.charAt(pos - 1) == '\\') {
                    ++pos;
                }
                if (pos < 0) break;
                part = name.substring(last, pos);
                if (!part.endsWith("]")) {
                    part = String.valueOf(part) + "[0]";
                }
                parts.add(part);
                last = pos + 1;
            }
            part = name.substring(last);
            if (!part.endsWith("]")) {
                part = String.valueOf(part) + "[0]";
            }
            parts.add(part);
            return parts;
        }

        public ArrayList<String> getOrder() {
            return this.order;
        }

        public void setOrder(ArrayList<String> order) {
            this.order = order;
        }

        public HashMap<String, Node> getName2Node() {
            return this.name2Node;
        }

        public void setName2Node(HashMap<String, Node> name2Node) {
            this.name2Node = name2Node;
        }

        public HashMap<String, InverseStore> getInverseSearch() {
            return this.inverseSearch;
        }

        public void setInverseSearch(HashMap<String, InverseStore> inverseSearch) {
            this.inverseSearch = inverseSearch;
        }
    }

    public static class Xml2SomDatasets
    extends Xml2Som {
        public Xml2SomDatasets(Node n2) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.inverseSearch = new HashMap();
            this.processDatasetsInternal(n2);
        }

        public Node insertNode(Node n2, String shortName) {
            Stack2<String> stack = Xml2SomDatasets.splitParts(shortName);
            Document doc = n2.getOwnerDocument();
            Node n22 = null;
            n2 = n2.getFirstChild();
            int k2 = 0;
            while (k2 < stack.size()) {
                String part = (String)stack.get(k2);
                int idx = part.lastIndexOf(91);
                String name = part.substring(0, idx);
                idx = Integer.parseInt(part.substring(idx + 1, part.length() - 1));
                int found = -1;
                n22 = n2.getFirstChild();
                while (n22 != null) {
                    String s2;
                    if (n22.getNodeType() == 1 && (s2 = Xml2SomDatasets.escapeSom(n22.getLocalName())).equals(name) && ++found == idx) break;
                    n22 = n22.getNextSibling();
                }
                while (found < idx) {
                    n22 = doc.createElementNS(null, name);
                    n22 = n2.appendChild(n22);
                    Attr attr = doc.createAttributeNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
                    attr.setNodeValue("dataGroup");
                    n22.getAttributes().setNamedItemNS(attr);
                    ++found;
                }
                n2 = n22;
                ++k2;
            }
            Xml2SomDatasets.inverseSearchAdd(this.inverseSearch, stack, shortName);
            this.name2Node.put(shortName, n22);
            this.order.add(shortName);
            return n22;
        }

        private static boolean hasChildren(Node n2) {
            Node dataNodeN = n2.getAttributes().getNamedItemNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
            if (dataNodeN != null) {
                String dataNode = dataNodeN.getNodeValue();
                if ("dataGroup".equals(dataNode)) {
                    return true;
                }
                if ("dataValue".equals(dataNode)) {
                    return false;
                }
            }
            if (!n2.hasChildNodes()) {
                return false;
            }
            Node n22 = n2.getFirstChild();
            while (n22 != null) {
                if (n22.getNodeType() == 1) {
                    return true;
                }
                n22 = n22.getNextSibling();
            }
            return false;
        }

        private void processDatasetsInternal(Node n2) {
            HashMap<String, Integer> ss = new HashMap<String, Integer>();
            Node n22 = n2.getFirstChild();
            while (n22 != null) {
                if (n22.getNodeType() == 1) {
                    String s2 = Xml2SomDatasets.escapeSom(n22.getLocalName());
                    Integer i2 = (Integer)ss.get(s2);
                    i2 = i2 == null ? new Integer(0) : new Integer(i2 + 1);
                    ss.put(s2, i2);
                    if (Xml2SomDatasets.hasChildren(n22)) {
                        this.stack.push(String.valueOf(s2) + "[" + i2.toString() + "]");
                        this.processDatasetsInternal(n22);
                        this.stack.pop();
                    } else {
                        this.stack.push(String.valueOf(s2) + "[" + i2.toString() + "]");
                        String unstack = this.printStack();
                        this.order.add(unstack);
                        this.inverseSearchAdd(unstack);
                        this.name2Node.put(unstack, n22);
                        this.stack.pop();
                    }
                }
                n22 = n22.getNextSibling();
            }
        }
    }

    public static class Xml2SomTemplate
    extends Xml2Som {
        private boolean dynamicForm;
        private int templateLevel;

        public Xml2SomTemplate(Node n2) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.templateLevel = 0;
            this.inverseSearch = new HashMap();
            this.processTemplate(n2, null);
        }

        public String getFieldType(String s2) {
            Node n2 = (Node)this.name2Node.get(s2);
            if (n2 == null) {
                return null;
            }
            if ("exclGroup".equals(n2.getLocalName())) {
                return "exclGroup";
            }
            Node ui = n2.getFirstChild();
            while (ui != null) {
                if (ui.getNodeType() == 1 && "ui".equals(ui.getLocalName())) break;
                ui = ui.getNextSibling();
            }
            if (ui == null) {
                return null;
            }
            Node type = ui.getFirstChild();
            while (type != null) {
                if (!(type.getNodeType() != 1 || "extras".equals(type.getLocalName()) && "picture".equals(type.getLocalName()))) {
                    return type.getLocalName();
                }
                type = type.getNextSibling();
            }
            return null;
        }

        private void processTemplate(Node n2, HashMap<String, Integer> ff) {
            if (ff == null) {
                ff = new HashMap();
            }
            HashMap<String, Integer> ss = new HashMap<String, Integer>();
            Node n22 = n2.getFirstChild();
            while (n22 != null) {
                if (n22.getNodeType() == 1) {
                    String s2 = n22.getLocalName();
                    if ("subform".equals(s2)) {
                        Integer i2;
                        Node name = n22.getAttributes().getNamedItem("name");
                        String nn = "#subform";
                        boolean annon = true;
                        if (name != null) {
                            nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                            annon = false;
                        }
                        if (annon) {
                            i2 = new Integer(this.anform);
                            ++this.anform;
                        } else {
                            i2 = (Integer)ss.get(nn);
                            i2 = i2 == null ? new Integer(0) : new Integer(i2 + 1);
                            ss.put(nn, i2);
                        }
                        this.stack.push(String.valueOf(nn) + "[" + i2.toString() + "]");
                        ++this.templateLevel;
                        if (annon) {
                            this.processTemplate(n22, ff);
                        } else {
                            this.processTemplate(n22, null);
                        }
                        --this.templateLevel;
                        this.stack.pop();
                    } else if ("field".equals(s2) || "exclGroup".equals(s2)) {
                        Node name = n22.getAttributes().getNamedItem("name");
                        if (name != null) {
                            String nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                            Integer i3 = ff.get(nn);
                            i3 = i3 == null ? new Integer(0) : new Integer(i3 + 1);
                            ff.put(nn, i3);
                            this.stack.push(String.valueOf(nn) + "[" + i3.toString() + "]");
                            String unstack = this.printStack();
                            this.order.add(unstack);
                            this.inverseSearchAdd(unstack);
                            this.name2Node.put(unstack, n22);
                            this.stack.pop();
                        }
                    } else if (!this.dynamicForm && this.templateLevel > 0 && "occur".equals(s2)) {
                        int initial = 1;
                        int min = 1;
                        int max = 1;
                        Node a2 = n22.getAttributes().getNamedItem("initial");
                        if (a2 != null) {
                            try {
                                initial = Integer.parseInt(a2.getNodeValue().trim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((a2 = n22.getAttributes().getNamedItem("min")) != null) {
                            try {
                                min = Integer.parseInt(a2.getNodeValue().trim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((a2 = n22.getAttributes().getNamedItem("max")) != null) {
                            try {
                                max = Integer.parseInt(a2.getNodeValue().trim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (initial != min || min != max) {
                            this.dynamicForm = true;
                        }
                    }
                }
                n22 = n22.getNextSibling();
            }
        }

        public boolean isDynamicForm() {
            return this.dynamicForm;
        }

        public void setDynamicForm(boolean dynamicForm) {
            this.dynamicForm = dynamicForm;
        }
    }
}

