/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class JBIG2SegmentReader {
    public static final int SYMBOL_DICTIONARY = 0;
    public static final int INTERMEDIATE_TEXT_REGION = 4;
    public static final int IMMEDIATE_TEXT_REGION = 6;
    public static final int IMMEDIATE_LOSSLESS_TEXT_REGION = 7;
    public static final int PATTERN_DICTIONARY = 16;
    public static final int INTERMEDIATE_HALFTONE_REGION = 20;
    public static final int IMMEDIATE_HALFTONE_REGION = 22;
    public static final int IMMEDIATE_LOSSLESS_HALFTONE_REGION = 23;
    public static final int INTERMEDIATE_GENERIC_REGION = 36;
    public static final int IMMEDIATE_GENERIC_REGION = 38;
    public static final int IMMEDIATE_LOSSLESS_GENERIC_REGION = 39;
    public static final int INTERMEDIATE_GENERIC_REFINEMENT_REGION = 40;
    public static final int IMMEDIATE_GENERIC_REFINEMENT_REGION = 42;
    public static final int IMMEDIATE_LOSSLESS_GENERIC_REFINEMENT_REGION = 43;
    public static final int PAGE_INFORMATION = 48;
    public static final int END_OF_PAGE = 49;
    public static final int END_OF_STRIPE = 50;
    public static final int END_OF_FILE = 51;
    public static final int PROFILES = 52;
    public static final int TABLES = 53;
    public static final int EXTENSION = 62;
    private final SortedMap segments = new TreeMap();
    private final SortedMap pages = new TreeMap();
    private final SortedSet globals = new TreeSet();
    private RandomAccessFileOrArray ra;
    private boolean sequential;
    private boolean number_of_pages_known;
    private int number_of_pages = -1;
    private boolean read = false;

    public JBIG2SegmentReader(RandomAccessFileOrArray randomAccessFileOrArray) throws IOException {
        this.ra = randomAccessFileOrArray;
    }

    public static byte[] copyByteArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public void read() throws IOException {
        if (this.read) {
            throw new IllegalStateException("already attempted a read() on this Jbig2 File");
        }
        this.read = true;
        this.readFileHeader();
        if (this.sequential) {
            do {
                JBIG2Segment jBIG2Segment = this.readHeader();
                this.readSegment(jBIG2Segment);
                this.segments.put(new Integer(jBIG2Segment.segmentNumber), jBIG2Segment);
            } while (this.ra.getFilePointer() < this.ra.length());
        } else {
            JBIG2Segment jBIG2Segment;
            do {
                jBIG2Segment = this.readHeader();
                this.segments.put(new Integer(jBIG2Segment.segmentNumber), jBIG2Segment);
            } while (jBIG2Segment.type != 51);
            Iterator iterator = this.segments.keySet().iterator();
            while (iterator.hasNext()) {
                this.readSegment((JBIG2Segment)this.segments.get(iterator.next()));
            }
        }
    }

    void readSegment(JBIG2Segment jBIG2Segment) throws IOException {
        int n2 = this.ra.getFilePointer();
        if (jBIG2Segment.dataLength == 0xFFFFFFFFL) {
            return;
        }
        byte[] byArray = new byte[(int)jBIG2Segment.dataLength];
        this.ra.read(byArray);
        jBIG2Segment.data = byArray;
        if (jBIG2Segment.type == 48) {
            int n3 = this.ra.getFilePointer();
            this.ra.seek(n2);
            int n4 = this.ra.readInt();
            int n5 = this.ra.readInt();
            this.ra.seek(n3);
            JBIG2Page jBIG2Page = (JBIG2Page)this.pages.get(new Integer(jBIG2Segment.page));
            if (jBIG2Page == null) {
                throw new IllegalStateException("referring to widht/height of page we havent seen yet? " + jBIG2Segment.page);
            }
            jBIG2Page.pageBitmapWidth = n4;
            jBIG2Page.pageBitmapHeight = n5;
        }
    }

    JBIG2Segment readHeader() throws IOException {
        long l2;
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5 = this.ra.getFilePointer();
        int n6 = this.ra.readInt();
        JBIG2Segment jBIG2Segment = new JBIG2Segment(n6);
        int n7 = this.ra.read();
        jBIG2Segment.deferredNonRetain = bl = (n7 & 0x80) == 128;
        boolean bl2 = (n7 & 0x40) == 64;
        jBIG2Segment.type = n4 = n7 & 0x3F;
        int n8 = this.ra.read();
        int n9 = (n8 & 0xE0) >> 5;
        int[] nArray = null;
        boolean[] blArray = null;
        if (n9 == 7) {
            this.ra.seek(this.ra.getFilePointer() - 1);
            n9 = this.ra.readInt() & 0x1FFFFFFF;
            blArray = new boolean[n9 + 1];
            n3 = 0;
            n2 = 0;
            do {
                int n10;
                if ((n10 = n3 % 8) == 0) {
                    n2 = this.ra.read();
                }
                boolean bl3 = blArray[n3] = (1 << n10 & n2) >> n10 == 1;
            } while (++n3 <= n9);
        } else if (n9 <= 4) {
            blArray = new boolean[n9 + 1];
            n8 &= 0x1F;
            for (n3 = 0; n3 <= n9; ++n3) {
                blArray[n3] = (1 << n3 & n8) >> n3 == 1;
            }
        } else if (n9 == 5 || n9 == 6) {
            throw new IllegalStateException("count of referred-to segments had bad value in header for segment " + n6 + " starting at " + n5);
        }
        jBIG2Segment.segmentRetentionFlags = blArray;
        jBIG2Segment.countOfReferredToSegments = n9;
        nArray = new int[n9 + 1];
        for (n3 = 1; n3 <= n9; ++n3) {
            nArray[n3] = n6 <= 256 ? this.ra.read() : (n6 <= 65536 ? this.ra.readUnsignedShort() : (int)this.ra.readUnsignedInt());
        }
        jBIG2Segment.referredToSegmentNumbers = nArray;
        n2 = this.ra.getFilePointer() - n5;
        n3 = bl2 ? this.ra.readInt() : this.ra.read();
        if (n3 < 0) {
            throw new IllegalStateException("page " + n3 + " invalid for segment " + n6 + " starting at " + n5);
        }
        jBIG2Segment.page = n3;
        jBIG2Segment.page_association_size = bl2;
        jBIG2Segment.page_association_offset = n2;
        if (n3 > 0 && !this.pages.containsKey(new Integer(n3))) {
            this.pages.put(new Integer(n3), new JBIG2Page(n3, this));
        }
        if (n3 > 0) {
            ((JBIG2Page)this.pages.get(new Integer(n3))).addSegment(jBIG2Segment);
        } else {
            this.globals.add(jBIG2Segment);
        }
        jBIG2Segment.dataLength = l2 = this.ra.readUnsignedInt();
        int n11 = this.ra.getFilePointer();
        this.ra.seek(n5);
        byte[] byArray = new byte[n11 - n5];
        this.ra.read(byArray);
        jBIG2Segment.headerData = byArray;
        return jBIG2Segment;
    }

    void readFileHeader() throws IOException {
        int n2;
        this.ra.seek(0);
        byte[] byArray = new byte[8];
        this.ra.read(byArray);
        byte[] byArray2 = new byte[]{-105, 74, 66, 50, 13, 10, 26, 10};
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] == byArray2[n2]) continue;
            throw new IllegalStateException("file header idstring not good at byte " + n2);
        }
        n2 = this.ra.read();
        this.sequential = (n2 & 1) == 1;
        boolean bl = this.number_of_pages_known = (n2 & 2) == 0;
        if ((n2 & 0xFC) != 0) {
            throw new IllegalStateException("file header flags bits 2-7 not 0");
        }
        if (this.number_of_pages_known) {
            this.number_of_pages = this.ra.readInt();
        }
    }

    public int numberOfPages() {
        return this.pages.size();
    }

    public int getPageHeight(int n2) {
        return ((JBIG2Page)this.pages.get((Object)new Integer((int)n2))).pageBitmapHeight;
    }

    public int getPageWidth(int n2) {
        return ((JBIG2Page)this.pages.get((Object)new Integer((int)n2))).pageBitmapWidth;
    }

    public JBIG2Page getPage(int n2) {
        return (JBIG2Page)this.pages.get(new Integer(n2));
    }

    public byte[] getGlobal(boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Iterator iterator = this.globals.iterator();
            while (iterator.hasNext()) {
                JBIG2Segment jBIG2Segment = (JBIG2Segment)iterator.next();
                if (bl && (jBIG2Segment.type == 51 || jBIG2Segment.type == 49)) continue;
                byteArrayOutputStream.write(jBIG2Segment.headerData);
                byteArrayOutputStream.write(jBIG2Segment.data);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (byteArrayOutputStream.size() <= 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        if (this.read) {
            return "Jbig2SegmentReader: number of pages: " + this.numberOfPages();
        }
        return "Jbig2SegmentReader in indeterminate state.";
    }

    public static class JBIG2Page {
        public final int page;
        private final JBIG2SegmentReader sr;
        private final SortedMap segs = new TreeMap();
        public int pageBitmapWidth = -1;
        public int pageBitmapHeight = -1;

        public JBIG2Page(int n2, JBIG2SegmentReader jBIG2SegmentReader) {
            this.page = n2;
            this.sr = jBIG2SegmentReader;
        }

        public byte[] getData(boolean bl) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Iterator iterator = this.segs.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                JBIG2Segment jBIG2Segment = (JBIG2Segment)this.segs.get(n2);
                if (bl && (jBIG2Segment.type == 51 || jBIG2Segment.type == 49)) continue;
                if (bl) {
                    byte[] byArray = JBIG2SegmentReader.copyByteArray(jBIG2Segment.headerData);
                    if (jBIG2Segment.page_association_size) {
                        byArray[jBIG2Segment.page_association_offset] = 0;
                        byArray[jBIG2Segment.page_association_offset + 1] = 0;
                        byArray[jBIG2Segment.page_association_offset + 2] = 0;
                        byArray[jBIG2Segment.page_association_offset + 3] = 1;
                    } else {
                        byArray[jBIG2Segment.page_association_offset] = 1;
                    }
                    byteArrayOutputStream.write(byArray);
                } else {
                    byteArrayOutputStream.write(jBIG2Segment.headerData);
                }
                byteArrayOutputStream.write(jBIG2Segment.data);
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }

        public void addSegment(JBIG2Segment jBIG2Segment) {
            this.segs.put(new Integer(jBIG2Segment.segmentNumber), jBIG2Segment);
        }
    }

    public static class JBIG2Segment
    implements Comparable {
        public final int segmentNumber;
        public long dataLength = -1L;
        public int page = -1;
        public int[] referredToSegmentNumbers = null;
        public boolean[] segmentRetentionFlags = null;
        public int type = -1;
        public boolean deferredNonRetain = false;
        public int countOfReferredToSegments = -1;
        public byte[] data = null;
        public byte[] headerData = null;
        public boolean page_association_size = false;
        public int page_association_offset = -1;

        public JBIG2Segment(int n2) {
            this.segmentNumber = n2;
        }

        public int compareTo(Object object) {
            return this.compareTo((JBIG2Segment)object);
        }

        public int compareTo(JBIG2Segment jBIG2Segment) {
            return this.segmentNumber - jBIG2Segment.segmentNumber;
        }
    }
}

