/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.harmony.security.fortress.PolicyUtils;
import org.apache.harmony.security.internal.nls.Messages;

public final class UnresolvedPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -4821973115467008846L;
    private String type;
    private String name;
    private String actions;
    private transient Certificate[] targetCerts;
    private transient int hash;

    public UnresolvedPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        this.checkType(string);
        this.type = string;
        this.name = string2;
        this.actions = string3;
        this.targetCerts = certificateArray;
        this.hash = 0;
    }

    private final void checkType(String string) {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.2F"));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UnresolvedPermission) {
            UnresolvedPermission unresolvedPermission = (UnresolvedPermission)object;
            if (this.getName().equals(unresolvedPermission.getName()) && (this.name == null ? unresolvedPermission.name == null : this.name.equals(unresolvedPermission.name)) && (this.actions == null ? unresolvedPermission.actions == null : this.actions.equals(unresolvedPermission.actions)) && this.equalsCertificates(this.targetCerts, unresolvedPermission.targetCerts)) {
                return true;
            }
        }
        return false;
    }

    private boolean equalsCertificates(Certificate[] certificateArray, Certificate[] certificateArray2) {
        if (certificateArray == null || certificateArray2 == null) {
            return certificateArray == certificateArray2;
        }
        int n2 = certificateArray.length;
        if (n2 != certificateArray2.length) {
            return false;
        }
        if (n2 > 0) {
            int n3;
            boolean bl;
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                bl = false;
                for (n3 = 0; n3 < n2; ++n3) {
                    if (!certificateArray[n4].equals(certificateArray2[n3])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                bl = false;
                for (n3 = 0; n3 < n2; ++n3) {
                    if (!certificateArray2[n4].equals(certificateArray[n3])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.getName().hashCode();
            if (this.name != null) {
                this.hash ^= this.name.hashCode();
            }
            if (this.actions != null) {
                this.hash ^= this.actions.hashCode();
            }
        }
        return this.hash;
    }

    @Override
    public String getActions() {
        return "";
    }

    public String getUnresolvedName() {
        return this.name;
    }

    public String getUnresolvedActions() {
        return this.actions;
    }

    public String getUnresolvedType() {
        return super.getName();
    }

    public Certificate[] getUnresolvedCerts() {
        if (this.targetCerts != null) {
            Certificate[] certificateArray = new Certificate[this.targetCerts.length];
            System.arraycopy(this.targetCerts, 0, certificateArray, 0, certificateArray.length);
            return certificateArray;
        }
        return null;
    }

    @Override
    public boolean implies(Permission permission) {
        return false;
    }

    @Override
    public String toString() {
        return "(unresolved " + this.type + " " + this.name + " " + this.actions + ")";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new UnresolvedPermissionCollection();
    }

    Permission resolve(Class clazz) {
        if (PolicyUtils.matchSubset(this.targetCerts, clazz.getSigners())) {
            try {
                return PolicyUtils.instantiatePermission(clazz, this.name, this.actions);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.targetCerts == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.targetCerts.length);
            for (int i2 = 0; i2 < this.targetCerts.length; ++i2) {
                try {
                    byte[] byArray = this.targetCerts[i2].getEncoded();
                    objectOutputStream.writeUTF(this.targetCerts[i2].getType());
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw (IOException)new NotSerializableException(Messages.getString("security.30", this.targetCerts[i2])).initCause(certificateEncodingException);
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.checkType(this.getUnresolvedType());
        int n2 = objectInputStream.readInt();
        if (n2 != 0) {
            this.targetCerts = new Certificate[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    String string = objectInputStream.readUTF();
                    int n3 = objectInputStream.readInt();
                    byte[] byArray = new byte[n3];
                    objectInputStream.readFully(byArray, 0, n3);
                    this.targetCerts[i2] = CertificateFactory.getInstance(string).generateCertificate(new ByteArrayInputStream(byArray));
                    continue;
                }
                catch (CertificateException certificateException) {
                    throw (IOException)new IOException(Messages.getString("security.32")).initCause(certificateException);
                }
            }
        }
    }
}

