/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.ECField;
import java.util.Arrays;
import org.apache.harmony.security.internal.nls.Messages;

public class ECFieldF2m
implements ECField {
    private static final int TPB_MID_LEN = 1;
    private static final int PPB_MID_LEN = 3;
    private static final int TPB_LEN = 3;
    private static final int PPB_LEN = 5;
    private final int m;
    private final BigInteger rp;
    private final int[] ks;

    public ECFieldF2m(int n2) {
        this.m = n2;
        if (this.m <= 0) {
            throw new IllegalArgumentException(Messages.getString("security.75"));
        }
        this.rp = null;
        this.ks = null;
    }

    public ECFieldF2m(int n2, BigInteger bigInteger) {
        this.m = n2;
        if (this.m <= 0) {
            throw new IllegalArgumentException(Messages.getString("security.75"));
        }
        this.rp = bigInteger;
        if (this.rp == null) {
            throw new NullPointerException(Messages.getString("security.76"));
        }
        int n3 = this.rp.bitCount();
        if (this.rp.bitLength() != n2 + 1 || n3 != 3 && n3 != 5 || !this.rp.testBit(0) || !this.rp.testBit(n2)) {
            throw new IllegalArgumentException(Messages.getString("security.77"));
        }
        this.ks = new int[n3 - 2];
        BigInteger bigInteger2 = bigInteger.clearBit(0);
        for (int i2 = this.ks.length - 1; i2 >= 0; --i2) {
            this.ks[i2] = bigInteger2.getLowestSetBit();
            bigInteger2 = bigInteger2.clearBit(this.ks[i2]);
        }
    }

    public ECFieldF2m(int n2, int[] nArray) {
        this.m = n2;
        if (this.m <= 0) {
            throw new IllegalArgumentException(Messages.getString("security.75"));
        }
        this.ks = new int[nArray.length];
        System.arraycopy(nArray, 0, this.ks, 0, this.ks.length);
        if (this.ks.length != 1 && this.ks.length != 3) {
            throw new IllegalArgumentException(Messages.getString("security.78"));
        }
        boolean bl = false;
        int n3 = this.m;
        for (int i2 = 0; i2 < this.ks.length; ++i2) {
            if (this.ks[i2] >= n3) {
                bl = true;
                break;
            }
            n3 = this.ks[i2];
        }
        if (bl || n3 < 1) {
            throw new IllegalArgumentException(Messages.getString("security.79"));
        }
        BigInteger bigInteger = BigInteger.ONE.setBit(this.m);
        for (int i3 = 0; i3 < this.ks.length; ++i3) {
            bigInteger = bigInteger.setBit(this.ks[i3]);
        }
        this.rp = bigInteger;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ECFieldF2m) {
            ECFieldF2m eCFieldF2m = (ECFieldF2m)object;
            if (this.m == eCFieldF2m.m) {
                if (this.rp == null) {
                    if (eCFieldF2m.rp == null) {
                        return true;
                    }
                } else {
                    return Arrays.equals(this.ks, eCFieldF2m.ks);
                }
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return this.m;
    }

    public int getM() {
        return this.m;
    }

    public int[] getMidTermsOfReductionPolynomial() {
        if (this.ks == null) {
            return null;
        }
        int[] nArray = new int[this.ks.length];
        System.arraycopy(this.ks, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public BigInteger getReductionPolynomial() {
        return this.rp;
    }

    public int hashCode() {
        return this.rp == null ? this.m : this.m + this.rp.hashCode();
    }
}

