/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.sasn1.Asn1Integer;
import org.bouncycastle.sasn1.Asn1Null;
import org.bouncycastle.sasn1.Asn1Object;
import org.bouncycastle.sasn1.Asn1ObjectIdentifier;
import org.bouncycastle.sasn1.Asn1TaggedObject;
import org.bouncycastle.sasn1.BerOctetString;
import org.bouncycastle.sasn1.BerSequence;
import org.bouncycastle.sasn1.BerSet;
import org.bouncycastle.sasn1.DefiniteLengthInputStream;
import org.bouncycastle.sasn1.DerOctetString;
import org.bouncycastle.sasn1.DerSequence;
import org.bouncycastle.sasn1.DerSet;
import org.bouncycastle.sasn1.IndefiniteLengthInputStream;

public class Asn1InputStream {
    InputStream _in;
    private int _limit;
    private boolean _eofFound;

    public Asn1InputStream(InputStream inputStream) {
        this._in = inputStream;
        this._limit = Integer.MAX_VALUE;
    }

    public Asn1InputStream(InputStream inputStream, int n2) {
        this._in = inputStream;
        this._limit = n2;
    }

    public Asn1InputStream(byte[] byArray) {
        this._in = new ByteArrayInputStream(byArray);
        this._limit = byArray.length;
    }

    InputStream getParentStream() {
        return this._in;
    }

    private int readLength() throws IOException {
        int n2 = this._in.read();
        if (n2 < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n2 == 128) {
            return -1;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n2 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this._in.read();
                if (n4 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n2 = (n2 << 8) + n4;
            }
            if (n2 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n2 >= this._limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n2;
    }

    public Asn1Object readObject() throws IOException {
        int n2;
        int n3;
        int n4 = this._in.read();
        if (n4 == -1) {
            if (this._eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this._eofFound = true;
            return null;
        }
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(false);
        }
        int n5 = n3 = n4 & 0xFFFFFFDF;
        if ((n4 & 0x80) != 0 && (n5 = n4 & 0x1F) == 31) {
            n5 = 0;
            n2 = this._in.read();
            while (n2 >= 0 && (n2 & 0x80) != 0) {
                n5 |= n2 & 0x7F;
                n5 <<= 7;
                n2 = this._in.read();
            }
            if (n2 < 0) {
                this._eofFound = true;
                throw new EOFException("EOF encountered inside tag value.");
            }
            n5 |= n2 & 0x7F;
        }
        if ((n2 = this.readLength()) < 0) {
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in);
            switch (n3) {
                case 5: {
                    return new Asn1Null(n4);
                }
                case 4: {
                    return new BerOctetString(n4, indefiniteLengthInputStream);
                }
                case 16: {
                    return new BerSequence(n4, indefiniteLengthInputStream);
                }
                case 17: {
                    return new BerSet(n4, indefiniteLengthInputStream);
                }
            }
            return new Asn1TaggedObject(n4, n5, indefiniteLengthInputStream);
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n2);
        switch (n3) {
            case 2: {
                return new Asn1Integer(n4, definiteLengthInputStream.toByteArray());
            }
            case 5: {
                return new Asn1Null(n4);
            }
            case 6: {
                return new Asn1ObjectIdentifier(n4, definiteLengthInputStream.toByteArray());
            }
            case 4: {
                return new DerOctetString(n4, definiteLengthInputStream.toByteArray());
            }
            case 16: {
                return new DerSequence(n4, definiteLengthInputStream.toByteArray());
            }
            case 17: {
                return new DerSet(n4, definiteLengthInputStream.toByteArray());
            }
        }
        return new Asn1TaggedObject(n4, n5, definiteLengthInputStream);
    }
}

