/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.crypto;

public class ARCFOUREncryption {
    private byte[] state = new byte[256];
    private int x;
    private int y;

    public void prepareARCFOURKey(byte[] key) {
        this.prepareARCFOURKey(key, 0, key.length);
    }

    public void prepareARCFOURKey(byte[] key, int off, int len) {
        int index1 = 0;
        int index2 = 0;
        int k2 = 0;
        while (k2 < 256) {
            this.state[k2] = (byte)k2;
            ++k2;
        }
        this.x = 0;
        this.y = 0;
        int k3 = 0;
        while (k3 < 256) {
            index2 = key[index1 + off] + this.state[k3] + index2 & 0xFF;
            byte tmp = this.state[k3];
            this.state[k3] = this.state[index2];
            this.state[index2] = tmp;
            index1 = (index1 + 1) % len;
            ++k3;
        }
    }

    public void encryptARCFOUR(byte[] dataIn, int off, int len, byte[] dataOut, int offOut) {
        int length = len + off;
        int k2 = off;
        while (k2 < length) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte tmp = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = tmp;
            dataOut[k2 - off + offOut] = (byte)(dataIn[k2] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
            ++k2;
        }
    }

    public void encryptARCFOUR(byte[] data, int off, int len) {
        this.encryptARCFOUR(data, off, len, data, off);
    }

    public void encryptARCFOUR(byte[] dataIn, byte[] dataOut) {
        this.encryptARCFOUR(dataIn, 0, dataIn.length, dataOut, 0);
    }

    public void encryptARCFOUR(byte[] data) {
        this.encryptARCFOUR(data, 0, data.length, data, 0);
    }
}

