/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRException;

public abstract class AbstractSampleApp {
    public abstract void test() throws JRException;

    public String usage() {
        Method[] methods;
        StringBuffer sbuffer = new StringBuffer();
        String appName = this.getClass().getName();
        sbuffer.append(appName + " usage:" + "\n\tjava " + appName + " task" + "\n\tTasks : ");
        TreeSet<String> tasks = new TreeSet<String>();
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getDeclaringClass().getName().equals(this.getClass().getName()) || (method.getModifiers() & 8) != 0) continue;
            tasks.add(method.getName());
        }
        for (String task : tasks) {
            sbuffer.append(task).append(" | ");
        }
        return sbuffer.toString().substring(0, sbuffer.length() - 3);
    }

    public void executeTask(String taskName) {
        try {
            Method method = this.getClass().getMethod(taskName, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e2) {
            System.out.println(this.usage());
        }
        catch (IllegalAccessException e3) {
            e3.getCause().printStackTrace();
        }
        catch (InvocationTargetException e4) {
            e4.getCause().printStackTrace();
        }
    }

    protected File[] getFiles(File parentFile, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        String[] files = parentFile.list();
        if (files != null) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                String reportFile = files[i2];
                if (!reportFile.endsWith("." + extension)) continue;
                fileList.add(new File(parentFile, reportFile));
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    protected Connection getDemoHsqldbConnection() throws JRException {
        Connection conn;
        try {
            String driver = "org.hsqldb.jdbcDriver";
            String connectString = "jdbc:hsqldb:hsql://localhost";
            String user = "sa";
            String password = "";
            Class.forName(driver);
            conn = DriverManager.getConnection(connectString, user, password);
        }
        catch (ClassNotFoundException e2) {
            throw new JRException(e2);
        }
        catch (SQLException e3) {
            throw new JRException(e3);
        }
        return conn;
    }

    public static void main(AbstractSampleApp app, String[] args) {
        try {
            if (args.length != 1) {
                System.out.println(app.usage());
                return;
            }
            app.executeTask(args[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

