/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public enum BucketOrder implements NamedEnum
{
    ASCENDING("Ascending"),
    DESCENDING("Descending"),
    NONE("None");

    private static final long serialVersionUID = 10200L;
    private final transient String name;

    private BucketOrder(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static SortOrderEnum toSortOrderEnum(BucketOrder order) {
        SortOrderEnum sortOrder;
        if (order == null) {
            sortOrder = null;
        } else {
            switch (order) {
                case ASCENDING: {
                    sortOrder = SortOrderEnum.ASCENDING;
                    break;
                }
                case DESCENDING: {
                    sortOrder = SortOrderEnum.DESCENDING;
                    break;
                }
                case NONE: {
                    throw new JRRuntimeException("Cannot translate NONE to SortOrderEnum");
                }
                default: {
                    throw new JRRuntimeException("Unknown order enum " + order);
                }
            }
        }
        return sortOrder;
    }

    public static BucketOrder fromSortOrderEnum(SortOrderEnum orderValue) {
        BucketOrder order;
        if (orderValue == null) {
            order = null;
        } else {
            switch (orderValue) {
                case ASCENDING: {
                    order = ASCENDING;
                    break;
                }
                case DESCENDING: {
                    order = DESCENDING;
                    break;
                }
                default: {
                    throw new JRRuntimeException("Unknown order enum " + orderValue);
                }
            }
        }
        return order;
    }
}

