/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.BaseInputStream;

public class ZipInputStream
extends InputStream {
    private BaseInputStream is;

    public ZipInputStream(BaseInputStream is) {
        this.is = is;
    }

    public int read() throws IOException {
        int readByte = this.is.read();
        if (readByte != -1) {
            this.is.getUnzipEngine().updateCRC(readByte);
        }
        return readByte;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int readLen = this.is.read(b2, off, len);
        if (readLen > 0 && this.is.getUnzipEngine() != null) {
            this.is.getUnzipEngine().updateCRC(b2, off, readLen);
        }
        return readLen;
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean skipCRCCheck) throws IOException {
        try {
            this.is.close();
            if (!skipCRCCheck && this.is.getUnzipEngine() != null) {
                this.is.getUnzipEngine().checkCRC();
            }
        }
        catch (ZipException e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public long skip(long n2) throws IOException {
        return this.is.skip(n2);
    }
}

