/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FastTreeMap
extends TreeMap {
    protected TreeMap map = null;
    protected boolean fast = false;

    public FastTreeMap() {
        this.map = new TreeMap();
    }

    public FastTreeMap(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public FastTreeMap(Map map) {
        this.map = new TreeMap(map);
    }

    public FastTreeMap(SortedMap map) {
        this.map = new TreeMap(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    public Object get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v2 = this.map.get(key);
            return v2;
        }
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n2 = this.map.size();
            return n2;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.isEmpty();
            return bl;
        }
    }

    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
    }

    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.containsValue(value);
            return bl;
        }
    }

    public Comparator comparator() {
        if (this.fast) {
            return this.map.comparator();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Comparator comparator = this.map.comparator();
            return comparator;
        }
    }

    public Object firstKey() {
        if (this.fast) {
            return this.map.firstKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k2 = this.map.firstKey();
            return k2;
        }
    }

    public Object lastKey() {
        if (this.fast) {
            return this.map.lastKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k2 = this.map.lastKey();
            return k2;
        }
    }

    public Object put(Object key, Object value) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap temp = (TreeMap)this.map.clone();
                Object result = temp.put(key, value);
                this.map = temp;
                Object object = result;
                return object;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object object = this.map.put(key, value);
            return object;
        }
    }

    public void putAll(Map in) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap temp = (TreeMap)this.map.clone();
                temp.putAll(in);
                this.map = temp;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.putAll(in);
        }
    }

    public Object remove(Object key) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap temp = (TreeMap)this.map.clone();
                Object result = temp.remove(key);
                this.map = temp;
                Object v2 = result;
                return v2;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v3 = this.map.remove(key);
            return v3;
        }
    }

    public void clear() {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                this.map = new TreeMap();
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map mo = (Map)o2;
        if (this.fast) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            Iterator i2 = this.map.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry e2 = i2.next();
                Object key = e2.getKey();
                Object value = e2.getValue();
                if (!(value == null ? mo.get(key) != null || !mo.containsKey(key) : !value.equals(mo.get(key)))) continue;
                return false;
            }
            return true;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            if (mo.size() != this.map.size()) {
                boolean e2 = false;
                return e2;
            }
            Iterator i3 = this.map.entrySet().iterator();
            while (i3.hasNext()) {
                Map.Entry e3 = i3.next();
                Object key = e3.getKey();
                Object value = e3.getValue();
                if (value == null) {
                    if (mo.get(key) == null && mo.containsKey(key)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (value.equals(mo.get(key))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public int hashCode() {
        if (this.fast) {
            int h2 = 0;
            Iterator i2 = this.map.entrySet().iterator();
            while (i2.hasNext()) {
                h2 += ((Object)i2.next()).hashCode();
            }
            return h2;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int h3 = 0;
            Iterator i3 = this.map.entrySet().iterator();
            while (i3.hasNext()) {
                h3 += ((Object)i3.next()).hashCode();
            }
            int n2 = h3;
            return n2;
        }
    }

    public Object clone() {
        FastTreeMap results = null;
        if (this.fast) {
            results = new FastTreeMap((SortedMap)this.map);
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                results = new FastTreeMap((SortedMap)this.map);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    public SortedMap headMap(Object key) {
        if (this.fast) {
            return this.map.headMap(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.headMap(key);
            return sortedMap;
        }
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (this.fast) {
            return this.map.subMap(fromKey, toKey);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.subMap(fromKey, toKey);
            return sortedMap;
        }
    }

    public SortedMap tailMap(Object key) {
        if (this.fast) {
            return this.map.tailMap(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.tailMap(key);
            return sortedMap;
        }
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public Set keySet() {
        return new KeySet();
    }

    public Collection values() {
        return new Values();
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private EntrySet() {
        }

        protected Collection get(Map map) {
            return map.entrySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry;
        }
    }

    private class Values
    extends CollectionView {
        private Values() {
        }

        protected Collection get(Map map) {
            return map.values();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private KeySet() {
        }

        protected Collection get(Map map) {
            return map.keySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }
    }

    private abstract class CollectionView
    implements Collection {
        protected abstract Collection get(Map var1);

        protected abstract Object iteratorNext(Map.Entry var1);

        public void clear() {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    FastTreeMap.this.map = new TreeMap();
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                this.get(FastTreeMap.this.map).clear();
            }
        }

        public boolean remove(Object o2) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap temp = (TreeMap)FastTreeMap.this.map.clone();
                    boolean r2 = this.get(temp).remove(o2);
                    FastTreeMap.this.map = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).remove(o2);
                return bl;
            }
        }

        public boolean removeAll(Collection o2) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap temp = (TreeMap)FastTreeMap.this.map.clone();
                    boolean r2 = this.get(temp).removeAll(o2);
                    FastTreeMap.this.map = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).removeAll(o2);
                return bl;
            }
        }

        public boolean retainAll(Collection o2) {
            if (FastTreeMap.this.fast) {
                FastTreeMap fastTreeMap = FastTreeMap.this;
                synchronized (fastTreeMap) {
                    TreeMap temp = (TreeMap)FastTreeMap.this.map.clone();
                    boolean r2 = this.get(temp).retainAll(o2);
                    FastTreeMap.this.map = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).retainAll(o2);
                return bl;
            }
        }

        public int size() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).size();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                int n2 = this.get(FastTreeMap.this.map).size();
                return n2;
            }
        }

        public boolean isEmpty() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).isEmpty();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).isEmpty();
                return bl;
            }
        }

        public boolean contains(Object o2) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).contains(o2);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).contains(o2);
                return bl;
            }
        }

        public boolean containsAll(Collection o2) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).containsAll(o2);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).containsAll(o2);
                return bl;
            }
        }

        public Object[] toArray(Object[] o2) {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).toArray(o2);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                Object[] objectArray = this.get(FastTreeMap.this.map).toArray(o2);
                return objectArray;
            }
        }

        public Object[] toArray() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).toArray();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                Object[] objectArray = this.get(FastTreeMap.this.map).toArray();
                return objectArray;
            }
        }

        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).equals(o2);
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                boolean bl = this.get(FastTreeMap.this.map).equals(o2);
                return bl;
            }
        }

        public int hashCode() {
            if (FastTreeMap.this.fast) {
                return this.get(FastTreeMap.this.map).hashCode();
            }
            TreeMap treeMap = FastTreeMap.this.map;
            synchronized (treeMap) {
                int n2 = this.get(FastTreeMap.this.map).hashCode();
                return n2;
            }
        }

        public boolean add(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new CollectionViewIterator();
        }

        private class CollectionViewIterator
        implements Iterator {
            private Map expected;
            private Map.Entry lastReturned = null;
            private Iterator iterator;

            public CollectionViewIterator() {
                this.expected = ((CollectionView)CollectionView.this).FastTreeMap.this.map;
                this.iterator = this.expected.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.expected != ((CollectionView)CollectionView.this).FastTreeMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != ((CollectionView)CollectionView.this).FastTreeMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return CollectionView.this.iteratorNext(this.lastReturned);
            }

            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (((CollectionView)CollectionView.this).FastTreeMap.this.fast) {
                    FastTreeMap fastTreeMap = FastTreeMap.this;
                    synchronized (fastTreeMap) {
                        if (this.expected != ((CollectionView)CollectionView.this).FastTreeMap.this.map) {
                            throw new ConcurrentModificationException();
                        }
                        FastTreeMap.this.remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = ((CollectionView)CollectionView.this).FastTreeMap.this.map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }
}

