/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DLOutputStream;

class DEROutputStream
extends DLOutputStream {
    DEROutputStream(OutputStream os) {
        super(os);
    }

    @Override
    DEROutputStream getDERSubStream() {
        return this;
    }

    @Override
    void writeElements(ASN1Encodable[] elements) throws IOException {
        int i = 0;
        int count = elements.length;
        while (i < count) {
            elements[i].toASN1Primitive().toDERObject().encode(this, true);
            ++i;
        }
    }

    @Override
    void writePrimitive(ASN1Primitive primitive, boolean withTag) throws IOException {
        primitive.toDERObject().encode(this, withTag);
    }

    @Override
    void writePrimitives(ASN1Primitive[] primitives) throws IOException {
        int count = primitives.length;
        int i = 0;
        while (i < count) {
            primitives[i].toDERObject().encode(this, true);
            ++i;
        }
    }
}

