/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.AsconBaseDigest;
import org.bouncycastle.util.Pack;

public class AsconCXof128
extends AsconBaseDigest
implements Xof {
    private boolean m_squeezing = false;
    private final long z0;
    private final long z1;
    private final long z2;
    private final long z3;
    private final long z4;

    public AsconCXof128() {
        this(new byte[0], 0, 0);
    }

    public AsconCXof128(byte[] s) {
        this(s, 0, s.length);
    }

    public AsconCXof128(byte[] s, int off, int len) {
        if (off + len > s.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (len > 256) {
            throw new DataLengthException("customized string is too long");
        }
        this.initState(s, off, len);
        this.z0 = this.x0;
        this.z1 = this.x1;
        this.z2 = this.x2;
        this.z3 = this.x3;
        this.z4 = this.x4;
    }

    @Override
    public void update(byte in) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(input, inOff, len);
    }

    @Override
    protected long pad(int i) {
        return 1L << (i << 3);
    }

    @Override
    protected long loadBytes(byte[] bytes, int inOff) {
        return Pack.littleEndianToLong(bytes, inOff);
    }

    @Override
    protected long loadBytes(byte[] bytes, int inOff, int n) {
        return Pack.littleEndianToLong(bytes, inOff, n);
    }

    @Override
    protected void setBytes(long w, byte[] bytes, int inOff) {
        Pack.longToLittleEndian(w, bytes, inOff);
    }

    @Override
    protected void setBytes(long w, byte[] bytes, int inOff, int n) {
        Pack.longToLittleEndian(w, bytes, inOff, n);
    }

    @Override
    protected void padAndAbsorb() {
        this.m_squeezing = true;
        super.padAndAbsorb();
    }

    @Override
    public String getAlgorithmName() {
        return "Ascon-CXOF128";
    }

    @Override
    public int doOutput(byte[] output, int outOff, int outLen) {
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        this.padAndAbsorb();
        this.squeeze(output, outOff, outLen);
        return outLen;
    }

    @Override
    public int doFinal(byte[] output, int outOff, int outLen) {
        int rlt = this.doOutput(output, outOff, outLen);
        this.reset();
        return rlt;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_squeezing = false;
        this.x0 = this.z0;
        this.x1 = this.z1;
        this.x2 = this.z2;
        this.x3 = this.z3;
        this.x4 = this.z4;
    }

    private void initState(byte[] z, int zOff, int zLen) {
        this.x0 = 7445901275803737603L;
        this.x1 = 4886737088792722364L;
        this.x2 = -1616759365661982283L;
        this.x3 = 3076320316797452470L;
        this.x4 = -8124743304765850554L;
        long bitLength = (long)zLen << 3;
        Pack.longToLittleEndian(bitLength, this.m_buf, 0);
        this.p(12);
        this.update(z, zOff, zLen);
        this.padAndAbsorb();
        this.m_squeezing = false;
    }
}

