/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Arrays;

abstract class AEADBufferBaseEngine
extends AEADBaseEngine {
    protected byte[] m_buf;
    protected byte[] m_aad;
    protected int m_bufPos;
    protected int m_aadPos;
    protected boolean aadFinished;
    protected boolean initialised = false;
    protected int AADBufferSize;
    protected int BlockSize;
    protected State m_state = State.Uninitialized;

    AEADBufferBaseEngine() {
    }

    @Override
    public void processAADByte(byte input) {
        this.checkAAD();
        if (this.m_aadPos == this.AADBufferSize) {
            this.processBufferAAD(this.m_aad, 0);
            this.m_aadPos = 0;
        }
        this.m_aad[this.m_aadPos++] = input;
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.checkAAD();
        if (this.m_aadPos > 0) {
            int available = this.AADBufferSize - this.m_aadPos;
            if (len <= available) {
                System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, len);
                this.m_aadPos += len;
                return;
            }
            System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, available);
            inOff += available;
            len -= available;
            this.processBufferAAD(this.m_aad, 0);
            this.m_aadPos = 0;
        }
        while (len > this.AADBufferSize) {
            this.processBufferAAD(input, inOff);
            inOff += this.AADBufferSize;
            len -= this.AADBufferSize;
        }
        System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, len);
        this.m_aadPos += len;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        block10: {
            block11: {
                block9: {
                    if (inOff + len > input.length) {
                        throw new DataLengthException("input buffer too short");
                    }
                    forEncryption = this.checkData();
                    resultLength = 0;
                    if (!forEncryption) break block9;
                    if (this.m_bufPos > 0) {
                        available = this.BlockSize - this.m_bufPos;
                        if (len <= available) {
                            System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                            this.m_bufPos += len;
                            return 0;
                        }
                        System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                        inOff += available;
                        len -= available;
                        this.validateAndProcessBuffer(this.m_buf, 0, output, outOff);
                        resultLength = this.BlockSize;
                    }
                    while (len > this.BlockSize) {
                        this.validateAndProcessBuffer(input, inOff, output, outOff + resultLength);
                        inOff += this.BlockSize;
                        len -= this.BlockSize;
                        resultLength += this.BlockSize;
                    }
                    break block10;
                }
                available = this.BlockSize + this.MAC_SIZE - this.m_bufPos;
                if (len <= available) {
                    System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return 0;
                }
                if (this.BlockSize < this.MAC_SIZE) ** GOTO lbl50
                if (this.m_bufPos > this.BlockSize) {
                    this.validateAndProcessBuffer(this.m_buf, 0, output, outOff);
                    this.m_bufPos -= this.BlockSize;
                    System.arraycopy(this.m_buf, this.BlockSize, this.m_buf, 0, this.m_bufPos);
                    resultLength = this.BlockSize;
                    if (len <= (available += this.BlockSize)) {
                        System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                        this.m_bufPos += len;
                        return resultLength;
                    }
                }
                available = this.BlockSize - this.m_bufPos;
                System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.validateAndProcessBuffer(this.m_buf, 0, output, outOff + resultLength);
                resultLength += this.BlockSize;
                ** GOTO lbl70
lbl-1000:
                // 1 sources

                {
                    this.validateAndProcessBuffer(this.m_buf, resultLength, output, outOff + resultLength);
                    this.m_bufPos -= this.BlockSize;
                    resultLength += this.BlockSize;
lbl50:
                    // 2 sources

                    ** while (this.m_bufPos > this.BlockSize && len + this.m_bufPos > this.BlockSize + this.MAC_SIZE)
                }
lbl51:
                // 1 sources

                if (this.m_bufPos == 0) ** GOTO lbl70
                System.arraycopy(this.m_buf, resultLength, this.m_buf, 0, this.m_bufPos);
                if (this.m_bufPos + len <= this.BlockSize + this.MAC_SIZE) break block11;
                available = Math.max(this.BlockSize - this.m_bufPos, 0);
                System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                this.validateAndProcessBuffer(this.m_buf, 0, output, outOff + resultLength);
                resultLength += this.BlockSize;
                len -= available;
                if (true) ** GOTO lbl70
            }
            System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
            this.m_bufPos += len;
            return resultLength;
            do {
                this.validateAndProcessBuffer(input, inOff, output, outOff + resultLength);
                inOff += this.BlockSize;
                len -= this.BlockSize;
                resultLength += this.BlockSize;
lbl70:
                // 4 sources

            } while (len > this.BlockSize + this.MAC_SIZE);
        }
        System.arraycopy(input, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
        return resultLength;
    }

    @Override
    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int resultLength;
        boolean forEncryption = this.checkData();
        if (forEncryption) {
            resultLength = this.m_bufPos + this.MAC_SIZE;
        } else {
            if (this.m_bufPos < this.MAC_SIZE) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.MAC_SIZE;
            resultLength = this.m_bufPos;
        }
        if (outOff > output.length - resultLength) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processFinalBlock(output, outOff);
        if (forEncryption) {
            System.arraycopy(this.mac, 0, output, outOff + resultLength - this.MAC_SIZE, this.MAC_SIZE);
        } else if (!Arrays.constantTimeAreEqual(this.MAC_SIZE, this.mac, 0, this.m_buf, this.m_bufPos)) {
            throw new InvalidCipherTextException(String.valueOf(this.algorithmName) + " mac does not match");
        }
        this.reset(!forEncryption);
        return resultLength;
    }

    public int getBlockSize() {
        return this.BlockSize;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int total = Math.max(0, len) - 1;
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                total = Math.max(0, total - this.MAC_SIZE);
                break;
            }
            case DecData: 
            case DecFinal: {
                total = Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
                break;
            }
            case EncData: 
            case EncFinal: {
                total = Math.max(0, total + this.m_bufPos);
                break;
            }
        }
        return total - total % this.BlockSize;
    }

    @Override
    public int getOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                return Math.max(0, total - this.MAC_SIZE);
            }
            case DecData: 
            case DecFinal: {
                return Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
            }
            case EncData: 
            case EncFinal: {
                return total + this.m_bufPos + this.MAC_SIZE;
            }
        }
        return total + this.MAC_SIZE;
    }

    protected void checkAAD() {
        switch (this.m_state) {
            case DecInit: {
                this.m_state = State.DecAad;
                break;
            }
            case EncInit: {
                this.m_state = State.EncAad;
                break;
            }
            case EncAad: 
            case DecAad: {
                break;
            }
            case EncFinal: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " needs to be initialized");
            }
        }
    }

    protected boolean checkData() {
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                this.finishAAD(State.DecData);
                return false;
            }
            case EncInit: 
            case EncAad: {
                this.finishAAD(State.EncData);
                return true;
            }
            case DecData: {
                return false;
            }
            case EncData: {
                return true;
            }
            case EncFinal: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " needs to be initialized");
    }

    private void finishAAD(State nextState) {
        switch (this.m_state) {
            case EncAad: 
            case DecAad: {
                this.processFinalAAD();
                break;
            }
        }
        this.m_aadPos = 0;
        this.m_state = nextState;
    }

    protected void bufferReset() {
        Arrays.fill(this.m_buf, (byte)0);
        Arrays.fill(this.m_aad, (byte)0);
        this.m_bufPos = 0;
        this.m_aadPos = 0;
        switch (this.m_state) {
            case EncInit: 
            case DecInit: {
                break;
            }
            case DecAad: 
            case DecData: 
            case DecFinal: {
                this.m_state = State.DecInit;
                break;
            }
            case EncAad: 
            case EncData: 
            case EncFinal: {
                this.m_state = State.EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " needs to be initialized");
            }
        }
    }

    protected void validateAndProcessBuffer(byte[] input, int inOff, byte[] output, int outOff) {
        if (outOff > output.length - this.BlockSize) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processBuffer(input, inOff, output, outOff);
    }

    protected abstract void processFinalBlock(byte[] var1, int var2);

    protected abstract void processBufferAAD(byte[] var1, int var2);

    protected abstract void processFinalAAD();

    protected abstract void processBuffer(byte[] var1, int var2, byte[] var3, int var4);

    protected static enum State {
        Uninitialized,
        EncInit,
        EncAad,
        EncData,
        EncFinal,
        DecInit,
        DecAad,
        DecData,
        DecFinal;

    }
}

