/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.AEADBufferBaseEngine;

public class PhotonBeetleEngine
extends AEADBufferBaseEngine {
    private boolean input_empty;
    private byte[] K;
    private byte[] N;
    private byte[] state;
    private byte[][] state_2d;
    private int aadLen;
    private int messageLen;
    private final int RATE_INBYTES_HALF;
    private final int STATE_INBYTES;
    private final int LAST_THREE_BITS_OFFSET;
    private final int D = 8;
    private final byte[][] RC;
    private final byte[][] MixColMatrix;
    private final byte[] sbox;

    public PhotonBeetleEngine(PhotonBeetleParameters pbp) {
        byte[][] byArrayArray = new byte[8][];
        byArrayArray[0] = new byte[]{1, 3, 7, 14, 13, 11, 6, 12, 9, 2, 5, 10};
        byte[] byArray = new byte[12];
        byArray[1] = 2;
        byArray[2] = 6;
        byArray[3] = 15;
        byArray[4] = 12;
        byArray[5] = 10;
        byArray[6] = 7;
        byArray[7] = 13;
        byArray[8] = 8;
        byArray[9] = 3;
        byArray[10] = 4;
        byArray[11] = 11;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 2;
        byArray2[2] = 4;
        byArray2[3] = 13;
        byArray2[4] = 14;
        byArray2[5] = 8;
        byArray2[6] = 5;
        byArray2[7] = 15;
        byArray2[8] = 10;
        byArray2[9] = 1;
        byArray2[10] = 6;
        byArray2[11] = 9;
        byArrayArray[2] = byArray2;
        byte[] byArray3 = new byte[12];
        byArray3[0] = 6;
        byArray3[1] = 4;
        byArray3[3] = 9;
        byArray3[4] = 10;
        byArray3[5] = 12;
        byArray3[6] = 1;
        byArray3[7] = 11;
        byArray3[8] = 14;
        byArray3[9] = 5;
        byArray3[10] = 2;
        byArray3[11] = 13;
        byArrayArray[3] = byArray3;
        byArrayArray[4] = new byte[]{14, 12, 8, 1, 2, 4, 9, 3, 6, 13, 10, 5};
        byte[] byArray4 = new byte[12];
        byArray4[0] = 15;
        byArray4[1] = 13;
        byArray4[2] = 9;
        byArray4[4] = 3;
        byArray4[5] = 5;
        byArray4[6] = 8;
        byArray4[7] = 2;
        byArray4[8] = 7;
        byArray4[9] = 12;
        byArray4[10] = 11;
        byArray4[11] = 4;
        byArrayArray[5] = byArray4;
        byte[] byArray5 = new byte[12];
        byArray5[0] = 13;
        byArray5[1] = 15;
        byArray5[2] = 11;
        byArray5[3] = 2;
        byArray5[4] = 1;
        byArray5[5] = 7;
        byArray5[6] = 10;
        byArray5[8] = 5;
        byArray5[9] = 14;
        byArray5[10] = 9;
        byArray5[11] = 6;
        byArrayArray[6] = byArray5;
        byArrayArray[7] = new byte[]{9, 11, 15, 6, 5, 3, 14, 4, 1, 10, 13, 2};
        this.RC = byArrayArray;
        this.MixColMatrix = new byte[][]{{2, 4, 2, 11, 2, 8, 5, 6}, {12, 9, 8, 13, 7, 7, 5, 2}, {4, 4, 13, 13, 9, 4, 13, 9}, {1, 6, 5, 1, 12, 13, 15, 14}, {15, 12, 9, 13, 14, 5, 14, 13}, {9, 14, 5, 15, 4, 12, 9, 6}, {12, 2, 2, 10, 3, 1, 1, 14}, {15, 1, 13, 10, 5, 10, 2, 3}};
        byte[] byArray6 = new byte[16];
        byArray6[0] = 12;
        byArray6[1] = 5;
        byArray6[2] = 6;
        byArray6[3] = 11;
        byArray6[4] = 9;
        byArray6[6] = 10;
        byArray6[7] = 13;
        byArray6[8] = 3;
        byArray6[9] = 14;
        byArray6[10] = 15;
        byArray6[11] = 8;
        byArray6[12] = 4;
        byArray6[13] = 7;
        byArray6[14] = 1;
        byArray6[15] = 2;
        this.sbox = byArray6;
        this.KEY_SIZE = 16;
        this.IV_SIZE = 16;
        this.MAC_SIZE = 16;
        int CAPACITY_INBITS = 0;
        int RATE_INBITS = 0;
        switch (pbp) {
            case pb32: {
                RATE_INBITS = 32;
                CAPACITY_INBITS = 224;
                break;
            }
            case pb128: {
                RATE_INBITS = 128;
                CAPACITY_INBITS = 128;
            }
        }
        this.AADBufferSize = this.BlockSize = RATE_INBITS + 7 >>> 3;
        this.RATE_INBYTES_HALF = this.BlockSize >>> 1;
        int STATE_INBITS = RATE_INBITS + CAPACITY_INBITS;
        this.STATE_INBYTES = STATE_INBITS + 7 >>> 3;
        this.LAST_THREE_BITS_OFFSET = STATE_INBITS - (this.STATE_INBYTES - 1 << 3) - 3;
        this.initialised = false;
        this.algorithmName = "Photon-Beetle AEAD";
        this.m_aad = new byte[this.AADBufferSize];
    }

    @Override
    protected void init(byte[] key, byte[] iv) throws IllegalArgumentException {
        this.K = key;
        this.N = iv;
        this.state = new byte[this.STATE_INBYTES];
        this.state_2d = new byte[8][8];
        this.mac = new byte[this.MAC_SIZE];
        this.initialised = true;
        this.m_buf = new byte[this.BlockSize + (this.forEncryption ? 0 : this.MAC_SIZE)];
        this.m_state = this.forEncryption ? AEADBufferBaseEngine.State.EncInit : AEADBufferBaseEngine.State.DecInit;
        this.reset(false);
    }

    @Override
    protected void processBufferAAD(byte[] input, int inOff) {
        this.PHOTON_Permutation();
        this.XOR(input, inOff, this.BlockSize);
    }

    @Override
    protected void processBuffer(byte[] input, int inOff, byte[] output, int outOff) {
        this.PHOTON_Permutation();
        this.rhoohr(output, outOff, input, inOff, this.BlockSize);
    }

    @Override
    public void processAADByte(byte input) {
        ++this.aadLen;
        super.processAADByte(input);
    }

    @Override
    public void processAADBytes(byte[] input, int inOff, int len) {
        this.aadLen += len;
        super.processAADBytes(input, inOff, len);
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        this.messageLen += len;
        return super.processBytes(input, inOff, len, output, outOff);
    }

    @Override
    protected void processFinalBlock(byte[] output, int outOff) {
        int len = this.messageLen - (this.forEncryption ? 0 : this.MAC_SIZE);
        int bufferLen = this.m_bufPos;
        if (this.aadLen != 0 || len != 0) {
            this.input_empty = false;
        }
        byte c1 = this.select(this.aadLen != 0, len % this.BlockSize == 0, (byte)5, (byte)6);
        if (len != 0) {
            if (bufferLen != 0) {
                this.PHOTON_Permutation();
                this.rhoohr(output, outOff, this.m_buf, 0, bufferLen);
                if (bufferLen < this.BlockSize) {
                    int n = bufferLen;
                    this.state[n] = (byte)(this.state[n] ^ 1);
                }
            }
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ c1 << this.LAST_THREE_BITS_OFFSET);
        }
        if (this.input_empty) {
            int n = this.STATE_INBYTES - 1;
            this.state[n] = (byte)(this.state[n] ^ 1 << this.LAST_THREE_BITS_OFFSET);
        }
        this.PHOTON_Permutation();
        this.mac = new byte[this.MAC_SIZE];
        System.arraycopy(this.state, 0, this.mac, 0, this.MAC_SIZE);
    }

    @Override
    protected void processFinalAAD() {
        if (!this.aadFinished) {
            if (this.aadLen != 0) {
                if (this.m_aadPos != 0) {
                    this.PHOTON_Permutation();
                    this.XOR(this.m_aad, 0, this.m_aadPos);
                    if (this.m_aadPos < this.BlockSize) {
                        int n = this.m_aadPos;
                        this.state[n] = (byte)(this.state[n] ^ 1);
                    }
                }
                int n = this.STATE_INBYTES - 1;
                this.state[n] = (byte)(this.state[n] ^ this.select(this.messageLen - (this.forEncryption ? 0 : this.MAC_SIZE) > 0, this.aadLen % this.BlockSize == 0, (byte)3, (byte)4) << this.LAST_THREE_BITS_OFFSET);
            }
            this.m_aadPos = 0;
            this.aadFinished = true;
        }
    }

    @Override
    protected void reset(boolean clearMac) {
        if (!this.initialised) {
            throw new IllegalArgumentException("Need call init function before encryption/decryption");
        }
        this.bufferReset();
        this.input_empty = true;
        this.aadLen = 0;
        this.aadFinished = false;
        this.messageLen = 0;
        System.arraycopy(this.K, 0, this.state, 0, this.K.length);
        System.arraycopy(this.N, 0, this.state, this.K.length, this.N.length);
        super.reset(clearMac);
    }

    private void PHOTON_Permutation() {
        int dq = 3;
        int dr = 7;
        int DSquare = 64;
        int i = 0;
        while (i < DSquare) {
            this.state_2d[i >>> dq][i & dr] = (byte)((this.state[i >> 1] & 0xFF) >>> 4 * (i & 1) & 0xF);
            ++i;
        }
        int ROUND = 12;
        int round = 0;
        while (round < ROUND) {
            int j;
            i = 0;
            while (i < 8) {
                byte[] byArray = this.state_2d[i];
                byArray[0] = (byte)(byArray[0] ^ this.RC[i][round]);
                ++i;
            }
            i = 0;
            while (i < 8) {
                j = 0;
                while (j < 8) {
                    this.state_2d[i][j] = this.sbox[this.state_2d[i][j]];
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < 8) {
                System.arraycopy(this.state_2d[i], 0, this.state, 0, 8);
                System.arraycopy(this.state, i, this.state_2d[i], 0, 8 - i);
                System.arraycopy(this.state, 0, this.state_2d[i], 8 - i, i);
                ++i;
            }
            j = 0;
            while (j < 8) {
                i = 0;
                while (i < 8) {
                    int sum = 0;
                    int k = 0;
                    while (k < 8) {
                        byte x = this.MixColMatrix[i][k];
                        byte b = this.state_2d[k][j];
                        sum ^= x * (b & 1);
                        sum ^= x * (b & 2);
                        sum ^= x * (b & 4);
                        sum ^= x * (b & 8);
                        ++k;
                    }
                    int t0 = sum >>> 4;
                    sum = sum & 0xF ^ t0 ^ t0 << 1;
                    int t1 = sum >>> 4;
                    sum = sum & 0xF ^ t1 ^ t1 << 1;
                    this.state[i] = (byte)sum;
                    ++i;
                }
                i = 0;
                while (i < 8) {
                    this.state_2d[i][j] = this.state[i];
                    ++i;
                }
                ++j;
            }
            ++round;
        }
        i = 0;
        while (i < DSquare) {
            this.state[i >>> 1] = (byte)(this.state_2d[i >>> dq][i & dr] & 0xF | (this.state_2d[i >>> dq][i + 1 & dr] & 0xF) << 4);
            i += 2;
        }
    }

    private byte select(boolean condition1, boolean condition2, byte option3, byte option4) {
        if (condition1 && condition2) {
            return 1;
        }
        if (condition1) {
            return 2;
        }
        if (condition2) {
            return option3;
        }
        return option4;
    }

    private void rhoohr(byte[] ciphertext, int outOff, byte[] plaintext, int inOff, int DBlen_inbytes) {
        byte[] OuterState_part1_ROTR1 = this.state_2d[0];
        int loop_end = Math.min(DBlen_inbytes, this.RATE_INBYTES_HALF);
        int i = 0;
        while (i < this.RATE_INBYTES_HALF - 1) {
            OuterState_part1_ROTR1[i] = (byte)((this.state[i] & 0xFF) >>> 1 | (this.state[i + 1] & 1) << 7);
            ++i;
        }
        OuterState_part1_ROTR1[this.RATE_INBYTES_HALF - 1] = (byte)((this.state[i] & 0xFF) >>> 1 | (this.state[0] & 1) << 7);
        i = 0;
        while (i < loop_end) {
            ciphertext[i + outOff] = (byte)(this.state[i + this.RATE_INBYTES_HALF] ^ plaintext[i++ + inOff]);
        }
        while (i < DBlen_inbytes) {
            ciphertext[i + outOff] = (byte)(OuterState_part1_ROTR1[i - this.RATE_INBYTES_HALF] ^ plaintext[i++ + inOff]);
        }
        if (this.forEncryption) {
            this.XOR(plaintext, inOff, DBlen_inbytes);
        } else {
            this.XOR(ciphertext, outOff, DBlen_inbytes);
        }
    }

    private void XOR(byte[] in_right, int rOff, int iolen_inbytes) {
        int i = 0;
        while (i < iolen_inbytes) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ in_right[rOff++]);
        }
    }

    public static enum PhotonBeetleParameters {
        pb32,
        pb128;

    }
}

