/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.compositesignatures;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;

public class CompositeIndex {
    private static Map<ASN1ObjectIdentifier, String[]> pairings = new HashMap<ASN1ObjectIdentifier, String[]>();
    private static Map<ASN1ObjectIdentifier, AlgorithmParameterSpec[]> kpgInitSpecs = new HashMap<ASN1ObjectIdentifier, AlgorithmParameterSpec[]>();
    private static Map<ASN1ObjectIdentifier, String> algorithmNames = new HashMap<ASN1ObjectIdentifier, String>();

    static {
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PSS_SHA256, new String[]{"ML-DSA-44", "SHA256withRSAandMGF1"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PKCS15_SHA256, new String[]{"ML-DSA-44", "SHA256withRSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_Ed25519_SHA512, new String[]{"ML-DSA-44", "Ed25519"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA44_ECDSA_P256_SHA256, new String[]{"ML-DSA-44", "SHA256withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PSS_SHA256, new String[]{"ML-DSA-65", "SHA256withRSAandMGF1"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PKCS15_SHA256, new String[]{"ML-DSA-65", "SHA256withRSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PSS_SHA384, new String[]{"ML-DSA-65", "SHA384withRSAandMGF1"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PKCS15_SHA384, new String[]{"ML-DSA-65", "SHA384withRSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_P384_SHA384, new String[]{"ML-DSA-65", "SHA384withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_brainpoolP256r1_SHA256, new String[]{"ML-DSA-65", "SHA256withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA65_Ed25519_SHA512, new String[]{"ML-DSA-65", "Ed25519"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_P384_SHA384, new String[]{"ML-DSA-87", "SHA384withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_brainpoolP384r1_SHA384, new String[]{"ML-DSA-87", "SHA384withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_MLDSA87_Ed448_SHA512, new String[]{"ML-DSA-87", "Ed448"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA44_RSA2048_PSS_SHA256, new String[]{"ML-DSA-44", "SHA256withRSAandMGF1"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA44_RSA2048_PKCS15_SHA256, new String[]{"ML-DSA-44", "SHA256withRSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA44_Ed25519_SHA512, new String[]{"ML-DSA-44", "Ed25519"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA44_ECDSA_P256_SHA256, new String[]{"ML-DSA-44", "SHA256withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA3072_PSS_SHA512, new String[]{"ML-DSA-65", "SHA256withRSAandMGF1"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA3072_PKCS15_SHA512, new String[]{"ML-DSA-65", "SHA256withRSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA4096_PSS_SHA512, new String[]{"ML-DSA-65", "SHA384withRSAandMGF1"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA4096_PKCS15_SHA512, new String[]{"ML-DSA-65", "SHA384withRSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA65_ECDSA_P384_SHA512, new String[]{"ML-DSA-65", "SHA384withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA65_ECDSA_brainpoolP256r1_SHA512, new String[]{"ML-DSA-65", "SHA256withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA65_Ed25519_SHA512, new String[]{"ML-DSA-65", "Ed25519"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA87_ECDSA_P384_SHA512, new String[]{"ML-DSA-87", "SHA384withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA87_ECDSA_brainpoolP384r1_SHA512, new String[]{"ML-DSA-87", "SHA384withECDSA"});
        pairings.put(MiscObjectIdentifiers.id_HashMLDSA87_Ed448_SHA512, new String[]{"ML-DSA-87", "Ed448"});
        AlgorithmParameterSpec[] algorithmParameterSpecArray = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray[1] = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PSS_SHA256, algorithmParameterSpecArray);
        AlgorithmParameterSpec[] algorithmParameterSpecArray2 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray2[1] = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PKCS15_SHA256, algorithmParameterSpecArray2);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA44_Ed25519_SHA512, new AlgorithmParameterSpec[2]);
        AlgorithmParameterSpec[] algorithmParameterSpecArray3 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray3[1] = new ECNamedCurveGenParameterSpec("P-256");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA44_ECDSA_P256_SHA256, algorithmParameterSpecArray3);
        AlgorithmParameterSpec[] algorithmParameterSpecArray4 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray4[1] = new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PSS_SHA256, algorithmParameterSpecArray4);
        AlgorithmParameterSpec[] algorithmParameterSpecArray5 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray5[1] = new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PKCS15_SHA256, algorithmParameterSpecArray5);
        AlgorithmParameterSpec[] algorithmParameterSpecArray6 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray6[1] = new RSAKeyGenParameterSpec(4096, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PSS_SHA384, algorithmParameterSpecArray6);
        AlgorithmParameterSpec[] algorithmParameterSpecArray7 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray7[1] = new RSAKeyGenParameterSpec(4096, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PKCS15_SHA384, algorithmParameterSpecArray7);
        AlgorithmParameterSpec[] algorithmParameterSpecArray8 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray8[1] = new ECNamedCurveGenParameterSpec("P-384");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_P384_SHA384, algorithmParameterSpecArray8);
        AlgorithmParameterSpec[] algorithmParameterSpecArray9 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray9[1] = new ECNamedCurveGenParameterSpec("brainpoolP256r1");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_brainpoolP256r1_SHA256, algorithmParameterSpecArray9);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA65_Ed25519_SHA512, new AlgorithmParameterSpec[2]);
        AlgorithmParameterSpec[] algorithmParameterSpecArray10 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray10[1] = new ECNamedCurveGenParameterSpec("P-384");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_P384_SHA384, algorithmParameterSpecArray10);
        AlgorithmParameterSpec[] algorithmParameterSpecArray11 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray11[1] = new ECNamedCurveGenParameterSpec("brainpoolP384r1");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_brainpoolP384r1_SHA384, algorithmParameterSpecArray11);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_MLDSA87_Ed448_SHA512, new AlgorithmParameterSpec[2]);
        AlgorithmParameterSpec[] algorithmParameterSpecArray12 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray12[1] = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA44_RSA2048_PSS_SHA256, algorithmParameterSpecArray12);
        AlgorithmParameterSpec[] algorithmParameterSpecArray13 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray13[1] = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA44_RSA2048_PKCS15_SHA256, algorithmParameterSpecArray13);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA44_Ed25519_SHA512, new AlgorithmParameterSpec[2]);
        AlgorithmParameterSpec[] algorithmParameterSpecArray14 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray14[1] = new ECNamedCurveGenParameterSpec("P-256");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA44_ECDSA_P256_SHA256, algorithmParameterSpecArray14);
        AlgorithmParameterSpec[] algorithmParameterSpecArray15 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray15[1] = new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA3072_PSS_SHA512, algorithmParameterSpecArray15);
        AlgorithmParameterSpec[] algorithmParameterSpecArray16 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray16[1] = new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA3072_PKCS15_SHA512, algorithmParameterSpecArray16);
        AlgorithmParameterSpec[] algorithmParameterSpecArray17 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray17[1] = new RSAKeyGenParameterSpec(4096, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA4096_PSS_SHA512, algorithmParameterSpecArray17);
        AlgorithmParameterSpec[] algorithmParameterSpecArray18 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray18[1] = new RSAKeyGenParameterSpec(4096, RSAKeyGenParameterSpec.F4);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA4096_PKCS15_SHA512, algorithmParameterSpecArray18);
        AlgorithmParameterSpec[] algorithmParameterSpecArray19 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray19[1] = new ECNamedCurveGenParameterSpec("P-384");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA65_ECDSA_P384_SHA512, algorithmParameterSpecArray19);
        AlgorithmParameterSpec[] algorithmParameterSpecArray20 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray20[1] = new ECNamedCurveGenParameterSpec("brainpoolP256r1");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA65_ECDSA_brainpoolP256r1_SHA512, algorithmParameterSpecArray20);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA65_Ed25519_SHA512, new AlgorithmParameterSpec[2]);
        AlgorithmParameterSpec[] algorithmParameterSpecArray21 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray21[1] = new ECNamedCurveGenParameterSpec("P-384");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA87_ECDSA_P384_SHA512, algorithmParameterSpecArray21);
        AlgorithmParameterSpec[] algorithmParameterSpecArray22 = new AlgorithmParameterSpec[2];
        algorithmParameterSpecArray22[1] = new ECNamedCurveGenParameterSpec("brainpoolP384r1");
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA87_ECDSA_brainpoolP384r1_SHA512, algorithmParameterSpecArray22);
        kpgInitSpecs.put(MiscObjectIdentifiers.id_HashMLDSA87_Ed448_SHA512, new AlgorithmParameterSpec[2]);
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PSS_SHA256, "MLDSA44-RSA2048-PSS-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA44_RSA2048_PKCS15_SHA256, "MLDSA44-RSA2048-PKCS15-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA44_Ed25519_SHA512, "MLDSA44-Ed25519-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA44_ECDSA_P256_SHA256, "MLDSA44-ECDSA-P256-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PSS_SHA256, "MLDSA65-RSA3072-PSS-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA65_RSA3072_PKCS15_SHA256, "MLDSA65-RSA3072-PKCS15-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PSS_SHA384, "MLDSA65-RSA4096-PSS-SHA384");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA65_RSA4096_PKCS15_SHA384, "MLDSA65-RSA4096-PKCS15-SHA384");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_P384_SHA384, "MLDSA65-ECDSA-P384-SHA384");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA65_ECDSA_brainpoolP256r1_SHA256, "MLDSA65-ECDSA-brainpoolP256r1-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA65_Ed25519_SHA512, "MLDSA65-Ed25519-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_P384_SHA384, "MLDSA87-ECDSA-P384-SHA384");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA87_ECDSA_brainpoolP384r1_SHA384, "MLDSA87-ECDSA-brainpoolP384r1-SHA384");
        algorithmNames.put(MiscObjectIdentifiers.id_MLDSA87_Ed448_SHA512, "MLDSA87-Ed448-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA44_RSA2048_PSS_SHA256, "HashMLDSA44-RSA2048-PSS-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA44_RSA2048_PKCS15_SHA256, "HashMLDSA44-RSA2048-PKCS15-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA44_Ed25519_SHA512, "HashMLDSA44-Ed25519-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA44_ECDSA_P256_SHA256, "HashMLDSA44-ECDSA-P256-SHA256");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA3072_PSS_SHA512, "HashMLDSA65-RSA3072-PSS-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA3072_PKCS15_SHA512, "HashMLDSA65-RSA3072-PKCS15-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA4096_PSS_SHA512, "HashMLDSA65-RSA4096-PSS-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA65_RSA4096_PKCS15_SHA512, "HashMLDSA65-RSA4096-PKCS15-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA65_ECDSA_P384_SHA512, "HashMLDSA65-ECDSA-P384-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA65_ECDSA_brainpoolP256r1_SHA512, "HashMLDSA65-ECDSA-brainpoolP256r1-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA65_Ed25519_SHA512, "HashMLDSA65-Ed25519-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA87_ECDSA_P384_SHA512, "HashMLDSA87-ECDSA-P384-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA87_ECDSA_brainpoolP384r1_SHA512, "HashMLDSA87-ECDSA-brainpoolP384r1-SHA512");
        algorithmNames.put(MiscObjectIdentifiers.id_HashMLDSA87_Ed448_SHA512, "HashMLDSA87-Ed448-SHA512");
    }

    public static boolean isAlgorithmSupported(ASN1ObjectIdentifier algorithm) {
        return pairings.containsKey(algorithm);
    }

    public static Set<ASN1ObjectIdentifier> getSupportedIdentifiers() {
        return pairings.keySet();
    }

    public static String getAlgorithmName(ASN1ObjectIdentifier algorithm) {
        return algorithmNames.get(algorithm);
    }

    static String[] getPairing(ASN1ObjectIdentifier algorithm) {
        return pairings.get(algorithm);
    }

    static AlgorithmParameterSpec[] getKeyPairSpecs(ASN1ObjectIdentifier algorithm) {
        return kpgInitSpecs.get(algorithm);
    }

    static String getBaseName(String name) {
        if (name.indexOf("RSA") >= 0) {
            return "RSA";
        }
        if (name.indexOf("ECDSA") >= 0) {
            return "EC";
        }
        return name;
    }
}

