/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.digest;

import org.bouncycastle.crypto.digests.Blake2bDigest;
import org.bouncycastle.internal.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;

public class Blake2b {
    private Blake2b() {
    }

    public static class Blake2b160
    extends BCMessageDigest
    implements Cloneable {
        public Blake2b160() {
            super(new Blake2bDigest(160));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Blake2b160 d = (Blake2b160)super.clone();
            d.digest = new Blake2bDigest((Blake2bDigest)this.digest);
            return d;
        }
    }

    public static class Blake2b256
    extends BCMessageDigest
    implements Cloneable {
        public Blake2b256() {
            super(new Blake2bDigest(256));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Blake2b256 d = (Blake2b256)super.clone();
            d.digest = new Blake2bDigest((Blake2bDigest)this.digest);
            return d;
        }
    }

    public static class Blake2b384
    extends BCMessageDigest
    implements Cloneable {
        public Blake2b384() {
            super(new Blake2bDigest(384));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Blake2b384 d = (Blake2b384)super.clone();
            d.digest = new Blake2bDigest((Blake2bDigest)this.digest);
            return d;
        }
    }

    public static class Blake2b512
    extends BCMessageDigest
    implements Cloneable {
        public Blake2b512() {
            super(new Blake2bDigest(512));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Blake2b512 d = (Blake2b512)super.clone();
            d.digest = new Blake2bDigest((Blake2bDigest)this.digest);
            return d;
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Blake2b.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.BLAKE2B-512", String.valueOf(PREFIX) + "$Blake2b512");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + MiscObjectIdentifiers.id_blake2b512, "BLAKE2B-512");
            provider.addAlgorithm("MessageDigest.BLAKE2B-384", String.valueOf(PREFIX) + "$Blake2b384");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + MiscObjectIdentifiers.id_blake2b384, "BLAKE2B-384");
            provider.addAlgorithm("MessageDigest.BLAKE2B-256", String.valueOf(PREFIX) + "$Blake2b256");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + MiscObjectIdentifiers.id_blake2b256, "BLAKE2B-256");
            provider.addAlgorithm("MessageDigest.BLAKE2B-160", String.valueOf(PREFIX) + "$Blake2b160");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + MiscObjectIdentifiers.id_blake2b160, "BLAKE2B-160");
        }
    }
}

