/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

abstract class BENES {
    private static final long[] TRANSPOSE_MASKS = new long[]{0x5555555555555555L, 0x3333333333333333L, 0xF0F0F0F0F0F0F0FL, 0xFF00FF00FF00FFL, 0xFFFF0000FFFFL, 0xFFFFFFFFL};
    protected final int SYS_N;
    protected final int SYS_T;
    protected final int GFBITS;

    public BENES(int n, int t, int m) {
        this.SYS_N = n;
        this.SYS_T = t;
        this.GFBITS = m;
    }

    static void transpose_64x64(long[] out, long[] in) {
        BENES.transpose_64x64(out, in, 0);
    }

    static void transpose_64x64(long[] out, long[] in, int offset) {
        int j;
        int i;
        int s;
        long m;
        System.arraycopy(in, offset, out, offset, 64);
        int d = 5;
        do {
            m = TRANSPOSE_MASKS[d];
            s = 1 << d;
            i = offset;
            while (i < offset + 64) {
                j = i;
                while (j < i + s) {
                    long lo0 = out[j + 0];
                    long lo1 = out[j + 1];
                    long lo2 = out[j + 2];
                    long lo3 = out[j + 3];
                    long hi0 = out[j + s + 0];
                    long hi1 = out[j + s + 1];
                    long hi2 = out[j + s + 2];
                    long hi3 = out[j + s + 3];
                    long t0 = (lo0 >>> s ^ hi0) & m;
                    long t1 = (lo1 >>> s ^ hi1) & m;
                    long t2 = (lo2 >>> s ^ hi2) & m;
                    long t3 = (lo3 >>> s ^ hi3) & m;
                    out[j + 0] = lo0 ^ t0 << s;
                    out[j + 1] = lo1 ^ t1 << s;
                    out[j + 2] = lo2 ^ t2 << s;
                    out[j + 3] = lo3 ^ t3 << s;
                    out[j + s + 0] = hi0 ^ t0;
                    out[j + s + 1] = hi1 ^ t1;
                    out[j + s + 2] = hi2 ^ t2;
                    out[j + s + 3] = hi3 ^ t3;
                    j += 4;
                }
                i += s * 2;
            }
        } while (--d >= 2);
        do {
            m = TRANSPOSE_MASKS[d];
            s = 1 << d;
            i = offset;
            while (i < offset + 64) {
                j = i;
                while (j < i + s) {
                    long lo = out[j + 0];
                    long hi = out[j + s];
                    long t = (lo >>> s ^ hi) & m;
                    out[j + 0] = lo ^ t << s;
                    out[j + s] = hi ^ t;
                    ++j;
                }
                i += s * 2;
            }
        } while (--d >= 0);
    }

    protected abstract void support_gen(short[] var1, byte[] var2);
}

