/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.ComplexNumberWrapper;
import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconFPR;

class FalconFFT {
    FPREngine fpr = new FPREngine();

    FalconFFT() {
    }

    ComplexNumberWrapper FPC_ADD(FalconFPR a_re, FalconFPR a_im, FalconFPR b_re, FalconFPR b_im) {
        FalconFPR fpct_re = this.fpr.fpr_add(a_re, b_re);
        FalconFPR fpct_im = this.fpr.fpr_add(a_im, b_im);
        return new ComplexNumberWrapper(fpct_re, fpct_im);
    }

    ComplexNumberWrapper FPC_SUB(FalconFPR a_re, FalconFPR a_im, FalconFPR b_re, FalconFPR b_im) {
        FalconFPR fpct_re = this.fpr.fpr_sub(a_re, b_re);
        FalconFPR fpct_im = this.fpr.fpr_sub(a_im, b_im);
        return new ComplexNumberWrapper(fpct_re, fpct_im);
    }

    ComplexNumberWrapper FPC_MUL(FalconFPR a_re, FalconFPR a_im, FalconFPR b_re, FalconFPR b_im) {
        FalconFPR fpct_a_re = a_re;
        FalconFPR fpct_a_im = a_im;
        FalconFPR fpct_b_re = b_re;
        FalconFPR fpct_b_im = b_im;
        FalconFPR fpct_d_re = this.fpr.fpr_sub(this.fpr.fpr_mul(fpct_a_re, fpct_b_re), this.fpr.fpr_mul(fpct_a_im, fpct_b_im));
        FalconFPR fpct_d_im = this.fpr.fpr_add(this.fpr.fpr_mul(fpct_a_re, fpct_b_im), this.fpr.fpr_mul(fpct_a_im, fpct_b_re));
        return new ComplexNumberWrapper(fpct_d_re, fpct_d_im);
    }

    ComplexNumberWrapper FPC_SQR(FalconFPR a_re, FalconFPR a_im) {
        FalconFPR fpct_a_re = a_re;
        FalconFPR fpct_a_im = a_im;
        FalconFPR fpct_d_re = this.fpr.fpr_sub(this.fpr.fpr_sqr(fpct_a_re), this.fpr.fpr_sqr(fpct_a_im));
        FalconFPR fpct_d_im = this.fpr.fpr_double(this.fpr.fpr_mul(fpct_a_re, fpct_a_im));
        return new ComplexNumberWrapper(fpct_d_re, fpct_d_im);
    }

    ComplexNumberWrapper FPC_INV(FalconFPR a_re, FalconFPR a_im) {
        FalconFPR fpct_a_re = a_re;
        FalconFPR fpct_a_im = a_im;
        FalconFPR fpct_m = this.fpr.fpr_add(this.fpr.fpr_sqr(fpct_a_re), this.fpr.fpr_sqr(fpct_a_im));
        fpct_m = this.fpr.fpr_inv(fpct_m);
        FalconFPR fpct_d_re = this.fpr.fpr_mul(fpct_a_re, fpct_m);
        FalconFPR fpct_d_im = this.fpr.fpr_mul(this.fpr.fpr_neg(fpct_a_im), fpct_m);
        return new ComplexNumberWrapper(fpct_d_re, fpct_d_im);
    }

    ComplexNumberWrapper FPC_DIV(FalconFPR a_re, FalconFPR a_im, FalconFPR b_re, FalconFPR b_im) {
        FalconFPR fpct_a_re = a_re;
        FalconFPR fpct_a_im = a_im;
        FalconFPR fpct_b_re = b_re;
        FalconFPR fpct_b_im = b_im;
        FalconFPR fpct_m = this.fpr.fpr_add(this.fpr.fpr_sqr(fpct_b_re), this.fpr.fpr_sqr(fpct_b_im));
        fpct_m = this.fpr.fpr_inv(fpct_m);
        fpct_b_re = this.fpr.fpr_mul(fpct_b_re, fpct_m);
        fpct_b_im = this.fpr.fpr_mul(this.fpr.fpr_neg(fpct_b_im), fpct_m);
        FalconFPR fpct_d_re = this.fpr.fpr_sub(this.fpr.fpr_mul(fpct_a_re, fpct_b_re), this.fpr.fpr_mul(fpct_a_im, fpct_b_im));
        FalconFPR fpct_d_im = this.fpr.fpr_add(this.fpr.fpr_mul(fpct_a_re, fpct_b_im), this.fpr.fpr_mul(fpct_a_im, fpct_b_re));
        return new ComplexNumberWrapper(fpct_d_re, fpct_d_im);
    }

    void FFT(FalconFPR[] srcf, int f, int logn) {
        int hn;
        int n = 1 << logn;
        int t = hn = n >> 1;
        int u = 1;
        int m = 2;
        while (u < logn) {
            int ht = t >> 1;
            int hm = m >> 1;
            int i1 = 0;
            int j1 = 0;
            while (i1 < hm) {
                int j2 = j1 + ht;
                FalconFPR s_re = this.fpr.fpr_gm_tab[(m + i1 << 1) + 0];
                FalconFPR s_im = this.fpr.fpr_gm_tab[(m + i1 << 1) + 1];
                int j = j1;
                while (j < j2) {
                    FalconFPR x_re = srcf[f + j];
                    FalconFPR x_im = srcf[f + j + hn];
                    FalconFPR y_re = srcf[f + j + ht];
                    FalconFPR y_im = srcf[f + j + ht + hn];
                    ComplexNumberWrapper res = this.FPC_MUL(y_re, y_im, s_re, s_im);
                    y_re = res.re;
                    y_im = res.im;
                    res = this.FPC_ADD(x_re, x_im, y_re, y_im);
                    srcf[f + j] = res.re;
                    srcf[f + j + hn] = res.im;
                    res = this.FPC_SUB(x_re, x_im, y_re, y_im);
                    srcf[f + j + ht] = res.re;
                    srcf[f + j + ht + hn] = res.im;
                    ++j;
                }
                ++i1;
                j1 += t;
            }
            t = ht;
            ++u;
            m <<= 1;
        }
    }

    void iFFT(FalconFPR[] srcf, int f, int logn) {
        int n = 1 << logn;
        int t = 1;
        int m = n;
        int hn = n >> 1;
        int u = logn;
        while (u > 1) {
            int hm = m >> 1;
            int dt = t << 1;
            int i1 = 0;
            int j1 = 0;
            while (j1 < hn) {
                int j2 = j1 + t;
                FalconFPR s_re = this.fpr.fpr_gm_tab[(hm + i1 << 1) + 0];
                FalconFPR s_im = this.fpr.fpr_neg(this.fpr.fpr_gm_tab[(hm + i1 << 1) + 1]);
                int j = j1;
                while (j < j2) {
                    FalconFPR x_re = srcf[f + j];
                    FalconFPR x_im = srcf[f + j + hn];
                    FalconFPR y_re = srcf[f + j + t];
                    FalconFPR y_im = srcf[f + j + t + hn];
                    ComplexNumberWrapper res = this.FPC_ADD(x_re, x_im, y_re, y_im);
                    srcf[f + j] = res.re;
                    srcf[f + j + hn] = res.im;
                    res = this.FPC_SUB(x_re, x_im, y_re, y_im);
                    x_re = res.re;
                    x_im = res.im;
                    res = this.FPC_MUL(x_re, x_im, s_re, s_im);
                    srcf[f + j + t] = res.re;
                    srcf[f + j + t + hn] = res.im;
                    ++j;
                }
                ++i1;
                j1 += dt;
            }
            t = dt;
            m = hm;
            --u;
        }
        if (logn > 0) {
            FalconFPR ni = this.fpr.fpr_p2_tab[logn];
            u = 0;
            while (u < n) {
                srcf[f + u] = this.fpr.fpr_mul(srcf[f + u], ni);
                ++u;
            }
        }
    }

    void poly_add(FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int u = 0;
        while (u < n) {
            srca[a + u] = this.fpr.fpr_add(srca[a + u], srcb[b + u]);
            ++u;
        }
    }

    void poly_sub(FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int u = 0;
        while (u < n) {
            srca[a + u] = this.fpr.fpr_sub(srca[a + u], srcb[b + u]);
            ++u;
        }
    }

    void poly_neg(FalconFPR[] srca, int a, int logn) {
        int n = 1 << logn;
        int u = 0;
        while (u < n) {
            srca[a + u] = this.fpr.fpr_neg(srca[a + u]);
            ++u;
        }
    }

    void poly_adj_fft(FalconFPR[] srca, int a, int logn) {
        int n = 1 << logn;
        int u = n >> 1;
        while (u < n) {
            srca[a + u] = this.fpr.fpr_neg(srca[a + u]);
            ++u;
        }
    }

    void poly_mul_fft(FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR a_re = srca[a + u];
            FalconFPR a_im = srca[a + u + hn];
            FalconFPR b_re = srcb[b + u];
            FalconFPR b_im = srcb[b + u + hn];
            ComplexNumberWrapper res = this.FPC_MUL(a_re, a_im, b_re, b_im);
            srca[a + u] = res.re;
            srca[a + u + hn] = res.im;
            ++u;
        }
    }

    void poly_muladj_fft(FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR a_re = srca[a + u];
            FalconFPR a_im = srca[a + u + hn];
            FalconFPR b_re = srcb[b + u];
            FalconFPR b_im = this.fpr.fpr_neg(srcb[b + u + hn]);
            ComplexNumberWrapper res = this.FPC_MUL(a_re, a_im, b_re, b_im);
            srca[a + u] = res.re;
            srca[a + u + hn] = res.im;
            ++u;
        }
    }

    void poly_mulselfadj_fft(FalconFPR[] srca, int a, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR a_re = srca[a + u];
            FalconFPR a_im = srca[a + u + hn];
            srca[a + u] = this.fpr.fpr_add(this.fpr.fpr_sqr(a_re), this.fpr.fpr_sqr(a_im));
            srca[a + u + hn] = this.fpr.fpr_zero;
            ++u;
        }
    }

    void poly_mulconst(FalconFPR[] srca, int a, FalconFPR x, int logn) {
        int n = 1 << logn;
        int u = 0;
        while (u < n) {
            srca[a + u] = this.fpr.fpr_mul(srca[a + u], x);
            ++u;
        }
    }

    void poly_div_fft(FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR a_re = srca[a + u];
            FalconFPR a_im = srca[a + u + hn];
            FalconFPR b_re = srcb[b + u];
            FalconFPR b_im = srcb[b + u + hn];
            ComplexNumberWrapper res = this.FPC_DIV(a_re, a_im, b_re, b_im);
            srca[a + u] = res.re;
            srca[a + u + hn] = res.im;
            ++u;
        }
    }

    void poly_invnorm2_fft(FalconFPR[] srcd, int d, FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR a_re = srca[a + u];
            FalconFPR a_im = srca[a + u + hn];
            FalconFPR b_re = srcb[b + u];
            FalconFPR b_im = srcb[b + u + hn];
            srcd[d + u] = this.fpr.fpr_inv(this.fpr.fpr_add(this.fpr.fpr_add(this.fpr.fpr_sqr(a_re), this.fpr.fpr_sqr(a_im)), this.fpr.fpr_add(this.fpr.fpr_sqr(b_re), this.fpr.fpr_sqr(b_im))));
            ++u;
        }
    }

    void poly_add_muladj_fft(FalconFPR[] srcd, int d, FalconFPR[] srcF, int F2, FalconFPR[] srcG, int G, FalconFPR[] srcf, int f, FalconFPR[] srcg, int g, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR F_re = srcF[F2 + u];
            FalconFPR F_im = srcF[F2 + u + hn];
            FalconFPR G_re = srcG[G + u];
            FalconFPR G_im = srcG[G + u + hn];
            FalconFPR f_re = srcf[f + u];
            FalconFPR f_im = srcf[f + u + hn];
            FalconFPR g_re = srcg[g + u];
            FalconFPR g_im = srcg[g + u + hn];
            ComplexNumberWrapper res = this.FPC_MUL(F_re, F_im, f_re, this.fpr.fpr_neg(f_im));
            FalconFPR a_re = res.re;
            FalconFPR a_im = res.im;
            res = this.FPC_MUL(G_re, G_im, g_re, this.fpr.fpr_neg(g_im));
            FalconFPR b_re = res.re;
            FalconFPR b_im = res.im;
            srcd[d + u] = this.fpr.fpr_add(a_re, b_re);
            srcd[d + u + hn] = this.fpr.fpr_add(a_im, b_im);
            ++u;
        }
    }

    void poly_mul_autoadj_fft(FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            srca[a + u] = this.fpr.fpr_mul(srca[a + u], srcb[b + u]);
            srca[a + u + hn] = this.fpr.fpr_mul(srca[a + u + hn], srcb[b + u]);
            ++u;
        }
    }

    void poly_div_autoadj_fft(FalconFPR[] srca, int a, FalconFPR[] srcb, int b, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR ib = this.fpr.fpr_inv(srcb[b + u]);
            srca[a + u] = this.fpr.fpr_mul(srca[a + u], ib);
            srca[a + u + hn] = this.fpr.fpr_mul(srca[a + u + hn], ib);
            ++u;
        }
    }

    void poly_LDL_fft(FalconFPR[] srcg00, int g00, FalconFPR[] srcg01, int g01, FalconFPR[] srcg11, int g11, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR g00_re = srcg00[g00 + u];
            FalconFPR g00_im = srcg00[g00 + u + hn];
            FalconFPR g01_re = srcg01[g01 + u];
            FalconFPR g01_im = srcg01[g01 + u + hn];
            FalconFPR g11_re = srcg11[g11 + u];
            FalconFPR g11_im = srcg11[g11 + u + hn];
            ComplexNumberWrapper res = this.FPC_DIV(g01_re, g01_im, g00_re, g00_im);
            FalconFPR mu_re = res.re;
            FalconFPR mu_im = res.im;
            res = this.FPC_MUL(mu_re, mu_im, g01_re, this.fpr.fpr_neg(g01_im));
            g01_re = res.re;
            g01_im = res.im;
            res = this.FPC_SUB(g11_re, g11_im, g01_re, g01_im);
            srcg11[g11 + u] = res.re;
            srcg11[g11 + u + hn] = res.im;
            srcg01[g01 + u] = mu_re;
            srcg01[g01 + u + hn] = this.fpr.fpr_neg(mu_im);
            ++u;
        }
    }

    void poly_LDLmv_fft(FalconFPR[] srcd11, int d11, FalconFPR[] srcl10, int l10, FalconFPR[] srcg00, int g00, FalconFPR[] srcg01, int g01, FalconFPR[] srcg11, int g11, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int u = 0;
        while (u < hn) {
            FalconFPR g00_re = srcg00[g00 + u];
            FalconFPR g00_im = srcg00[g00 + u + hn];
            FalconFPR g01_re = srcg01[g01 + u];
            FalconFPR g01_im = srcg01[g01 + u + hn];
            FalconFPR g11_re = srcg11[g11 + u];
            FalconFPR g11_im = srcg11[g11 + u + hn];
            ComplexNumberWrapper res = this.FPC_DIV(g01_re, g01_im, g00_re, g00_im);
            FalconFPR mu_re = res.re;
            FalconFPR mu_im = res.im;
            res = this.FPC_MUL(mu_re, mu_im, g01_re, this.fpr.fpr_neg(g01_im));
            g01_re = res.re;
            g01_im = res.im;
            res = this.FPC_SUB(g11_re, g11_im, g01_re, g01_im);
            srcd11[d11 + u] = res.re;
            srcd11[d11 + u + hn] = res.im;
            srcl10[l10 + u] = mu_re;
            srcl10[l10 + u + hn] = this.fpr.fpr_neg(mu_im);
            ++u;
        }
    }

    void poly_split_fft(FalconFPR[] srcf0, int f0, FalconFPR[] srcf1, int f1, FalconFPR[] srcf, int f, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int qn = hn >> 1;
        srcf0[f0 + 0] = srcf[f + 0];
        srcf1[f1 + 0] = srcf[f + hn];
        int u = 0;
        while (u < qn) {
            FalconFPR a_re = srcf[f + (u << 1) + 0];
            FalconFPR a_im = srcf[f + (u << 1) + 0 + hn];
            FalconFPR b_re = srcf[f + (u << 1) + 1];
            FalconFPR b_im = srcf[f + (u << 1) + 1 + hn];
            ComplexNumberWrapper res = this.FPC_ADD(a_re, a_im, b_re, b_im);
            FalconFPR t_re = res.re;
            FalconFPR t_im = res.im;
            srcf0[f0 + u] = this.fpr.fpr_half(t_re);
            srcf0[f0 + u + qn] = this.fpr.fpr_half(t_im);
            res = this.FPC_SUB(a_re, a_im, b_re, b_im);
            t_re = res.re;
            t_im = res.im;
            res = this.FPC_MUL(t_re, t_im, this.fpr.fpr_gm_tab[(u + hn << 1) + 0], this.fpr.fpr_neg(this.fpr.fpr_gm_tab[(u + hn << 1) + 1]));
            t_re = res.re;
            t_im = res.im;
            srcf1[f1 + u] = this.fpr.fpr_half(t_re);
            srcf1[f1 + u + qn] = this.fpr.fpr_half(t_im);
            ++u;
        }
    }

    void poly_merge_fft(FalconFPR[] srcf, int f, FalconFPR[] srcf0, int f0, FalconFPR[] srcf1, int f1, int logn) {
        int n = 1 << logn;
        int hn = n >> 1;
        int qn = hn >> 1;
        srcf[f + 0] = srcf0[f0 + 0];
        srcf[f + hn] = srcf1[f1 + 0];
        int u = 0;
        while (u < qn) {
            FalconFPR a_re = srcf0[f0 + u];
            FalconFPR a_im = srcf0[f0 + u + qn];
            ComplexNumberWrapper res = this.FPC_MUL(srcf1[f1 + u], srcf1[f1 + u + qn], this.fpr.fpr_gm_tab[(u + hn << 1) + 0], this.fpr.fpr_gm_tab[(u + hn << 1) + 1]);
            FalconFPR b_re = res.re;
            FalconFPR b_im = res.im;
            res = this.FPC_ADD(a_re, a_im, b_re, b_im);
            FalconFPR t_re = res.re;
            FalconFPR t_im = res.im;
            srcf[f + (u << 1) + 0] = t_re;
            srcf[f + (u << 1) + 0 + hn] = t_im;
            res = this.FPC_SUB(a_re, a_im, b_re, b_im);
            t_re = res.re;
            t_im = res.im;
            srcf[f + (u << 1) + 1] = t_re;
            srcf[f + (u << 1) + 1 + hn] = t_im;
            ++u;
        }
    }
}

