/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

class SHAKE256 {
    long[] A;
    byte[] dbuf;
    long dptr = 0L;
    private long[] RC = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};

    SHAKE256() {
        this.A = new long[25];
        this.dbuf = new byte[200];
    }

    void process_block(long[] A) {
        A[1] = A[1] ^ 0xFFFFFFFFFFFFFFFFL;
        A[2] = A[2] ^ 0xFFFFFFFFFFFFFFFFL;
        A[8] = A[8] ^ 0xFFFFFFFFFFFFFFFFL;
        A[12] = A[12] ^ 0xFFFFFFFFFFFFFFFFL;
        A[17] = A[17] ^ 0xFFFFFFFFFFFFFFFFL;
        A[20] = A[20] ^ 0xFFFFFFFFFFFFFFFFL;
        int j = 0;
        while (j < 24) {
            long tt0 = A[1] ^ A[6];
            long tt1 = A[11] ^ A[16];
            tt0 ^= A[21] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            long tt2 = A[4] ^ A[9];
            long tt3 = A[14] ^ A[19];
            long t0 = (tt0 ^= A[24]) ^ (tt2 ^= tt3);
            tt0 = A[2] ^ A[7];
            tt1 = A[12] ^ A[17];
            tt0 ^= A[22] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[0] ^ A[5];
            tt3 = A[10] ^ A[15];
            long t1 = (tt0 ^= A[20]) ^ (tt2 ^= tt3);
            tt0 = A[3] ^ A[8];
            tt1 = A[13] ^ A[18];
            tt0 ^= A[23] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[1] ^ A[6];
            tt3 = A[11] ^ A[16];
            long t2 = (tt0 ^= A[21]) ^ (tt2 ^= tt3);
            tt0 = A[4] ^ A[9];
            tt1 = A[14] ^ A[19];
            tt0 ^= A[24] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[2] ^ A[7];
            tt3 = A[12] ^ A[17];
            long t3 = (tt0 ^= A[22]) ^ (tt2 ^= tt3);
            tt0 = A[0] ^ A[5];
            tt1 = A[10] ^ A[15];
            tt0 ^= A[20] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[3] ^ A[8];
            tt3 = A[13] ^ A[18];
            long t4 = (tt0 ^= A[23]) ^ (tt2 ^= tt3);
            A[0] = A[0] ^ t0;
            A[5] = A[5] ^ t0;
            A[10] = A[10] ^ t0;
            A[15] = A[15] ^ t0;
            A[20] = A[20] ^ t0;
            A[1] = A[1] ^ t1;
            A[6] = A[6] ^ t1;
            A[11] = A[11] ^ t1;
            A[16] = A[16] ^ t1;
            A[21] = A[21] ^ t1;
            A[2] = A[2] ^ t2;
            A[7] = A[7] ^ t2;
            A[12] = A[12] ^ t2;
            A[17] = A[17] ^ t2;
            A[22] = A[22] ^ t2;
            A[3] = A[3] ^ t3;
            A[8] = A[8] ^ t3;
            A[13] = A[13] ^ t3;
            A[18] = A[18] ^ t3;
            A[23] = A[23] ^ t3;
            A[4] = A[4] ^ t4;
            A[9] = A[9] ^ t4;
            A[14] = A[14] ^ t4;
            A[19] = A[19] ^ t4;
            A[24] = A[24] ^ t4;
            A[5] = A[5] << 36 | A[5] >>> 28;
            A[10] = A[10] << 3 | A[10] >>> 61;
            A[15] = A[15] << 41 | A[15] >>> 23;
            A[20] = A[20] << 18 | A[20] >>> 46;
            A[1] = A[1] << 1 | A[1] >>> 63;
            A[6] = A[6] << 44 | A[6] >>> 20;
            A[11] = A[11] << 10 | A[11] >>> 54;
            A[16] = A[16] << 45 | A[16] >>> 19;
            A[21] = A[21] << 2 | A[21] >>> 62;
            A[2] = A[2] << 62 | A[2] >>> 2;
            A[7] = A[7] << 6 | A[7] >>> 58;
            A[12] = A[12] << 43 | A[12] >>> 21;
            A[17] = A[17] << 15 | A[17] >>> 49;
            A[22] = A[22] << 61 | A[22] >>> 3;
            A[3] = A[3] << 28 | A[3] >>> 36;
            A[8] = A[8] << 55 | A[8] >>> 9;
            A[13] = A[13] << 25 | A[13] >>> 39;
            A[18] = A[18] << 21 | A[18] >>> 43;
            A[23] = A[23] << 56 | A[23] >>> 8;
            A[4] = A[4] << 27 | A[4] >>> 37;
            A[9] = A[9] << 20 | A[9] >>> 44;
            A[14] = A[14] << 39 | A[14] >>> 25;
            A[19] = A[19] << 8 | A[19] >>> 56;
            A[24] = A[24] << 14 | A[24] >>> 50;
            long bnn = A[12] ^ 0xFFFFFFFFFFFFFFFFL;
            long kt = A[6] | A[12];
            long c0 = A[0] ^ kt;
            kt = bnn | A[18];
            long c1 = A[6] ^ kt;
            kt = A[18] & A[24];
            long c2 = A[12] ^ kt;
            kt = A[24] | A[0];
            long c3 = A[18] ^ kt;
            kt = A[0] & A[6];
            long c4 = A[24] ^ kt;
            A[0] = c0;
            A[6] = c1;
            A[12] = c2;
            A[18] = c3;
            A[24] = c4;
            bnn = A[22] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = A[9] | A[10];
            c0 = A[3] ^ kt;
            kt = A[10] & A[16];
            c1 = A[9] ^ kt;
            kt = A[16] | bnn;
            c2 = A[10] ^ kt;
            kt = A[22] | A[3];
            c3 = A[16] ^ kt;
            kt = A[3] & A[9];
            c4 = A[22] ^ kt;
            A[3] = c0;
            A[9] = c1;
            A[10] = c2;
            A[16] = c3;
            A[22] = c4;
            bnn = A[19] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = A[7] | A[13];
            c0 = A[1] ^ kt;
            kt = A[13] & A[19];
            c1 = A[7] ^ kt;
            kt = bnn & A[20];
            c2 = A[13] ^ kt;
            kt = A[20] | A[1];
            c3 = bnn ^ kt;
            kt = A[1] & A[7];
            c4 = A[20] ^ kt;
            A[1] = c0;
            A[7] = c1;
            A[13] = c2;
            A[19] = c3;
            A[20] = c4;
            bnn = A[17] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = A[5] & A[11];
            c0 = A[4] ^ kt;
            kt = A[11] | A[17];
            c1 = A[5] ^ kt;
            kt = bnn | A[23];
            c2 = A[11] ^ kt;
            kt = A[23] & A[4];
            c3 = bnn ^ kt;
            kt = A[4] | A[5];
            c4 = A[23] ^ kt;
            A[4] = c0;
            A[5] = c1;
            A[11] = c2;
            A[17] = c3;
            A[23] = c4;
            bnn = A[8] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = bnn & A[14];
            c0 = A[2] ^ kt;
            kt = A[14] | A[15];
            c1 = bnn ^ kt;
            kt = A[15] & A[21];
            c2 = A[14] ^ kt;
            kt = A[21] | A[2];
            c3 = A[15] ^ kt;
            kt = A[2] & A[8];
            c4 = A[21] ^ kt;
            A[2] = c0;
            A[8] = c1;
            A[14] = c2;
            A[15] = c3;
            A[21] = c4;
            A[0] = A[0] ^ this.RC[j + 0];
            tt0 = A[6] ^ A[9];
            tt1 = A[7] ^ A[5];
            tt0 ^= A[8] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[24] ^ A[22];
            tt3 = A[20] ^ A[23];
            t0 = (tt0 ^= A[21]) ^ (tt2 ^= tt3);
            tt0 = A[12] ^ A[10];
            tt1 = A[13] ^ A[11];
            tt0 ^= A[14] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[0] ^ A[3];
            tt3 = A[1] ^ A[4];
            t1 = (tt0 ^= A[2]) ^ (tt2 ^= tt3);
            tt0 = A[18] ^ A[16];
            tt1 = A[19] ^ A[17];
            tt0 ^= A[15] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[6] ^ A[9];
            tt3 = A[7] ^ A[5];
            t2 = (tt0 ^= A[8]) ^ (tt2 ^= tt3);
            tt0 = A[24] ^ A[22];
            tt1 = A[20] ^ A[23];
            tt0 ^= A[21] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[12] ^ A[10];
            tt3 = A[13] ^ A[11];
            t3 = (tt0 ^= A[14]) ^ (tt2 ^= tt3);
            tt0 = A[0] ^ A[3];
            tt1 = A[1] ^ A[4];
            tt0 ^= A[2] ^ tt1;
            tt0 = tt0 << 1 | tt0 >>> 63;
            tt2 = A[18] ^ A[16];
            tt3 = A[19] ^ A[17];
            t4 = (tt0 ^= A[15]) ^ (tt2 ^= tt3);
            A[0] = A[0] ^ t0;
            A[3] = A[3] ^ t0;
            A[1] = A[1] ^ t0;
            A[4] = A[4] ^ t0;
            A[2] = A[2] ^ t0;
            A[6] = A[6] ^ t1;
            A[9] = A[9] ^ t1;
            A[7] = A[7] ^ t1;
            A[5] = A[5] ^ t1;
            A[8] = A[8] ^ t1;
            A[12] = A[12] ^ t2;
            A[10] = A[10] ^ t2;
            A[13] = A[13] ^ t2;
            A[11] = A[11] ^ t2;
            A[14] = A[14] ^ t2;
            A[18] = A[18] ^ t3;
            A[16] = A[16] ^ t3;
            A[19] = A[19] ^ t3;
            A[17] = A[17] ^ t3;
            A[15] = A[15] ^ t3;
            A[24] = A[24] ^ t4;
            A[22] = A[22] ^ t4;
            A[20] = A[20] ^ t4;
            A[23] = A[23] ^ t4;
            A[21] = A[21] ^ t4;
            A[3] = A[3] << 36 | A[3] >>> 28;
            A[1] = A[1] << 3 | A[1] >>> 61;
            A[4] = A[4] << 41 | A[4] >>> 23;
            A[2] = A[2] << 18 | A[2] >>> 46;
            A[6] = A[6] << 1 | A[6] >>> 63;
            A[9] = A[9] << 44 | A[9] >>> 20;
            A[7] = A[7] << 10 | A[7] >>> 54;
            A[5] = A[5] << 45 | A[5] >>> 19;
            A[8] = A[8] << 2 | A[8] >>> 62;
            A[12] = A[12] << 62 | A[12] >>> 2;
            A[10] = A[10] << 6 | A[10] >>> 58;
            A[13] = A[13] << 43 | A[13] >>> 21;
            A[11] = A[11] << 15 | A[11] >>> 49;
            A[14] = A[14] << 61 | A[14] >>> 3;
            A[18] = A[18] << 28 | A[18] >>> 36;
            A[16] = A[16] << 55 | A[16] >>> 9;
            A[19] = A[19] << 25 | A[19] >>> 39;
            A[17] = A[17] << 21 | A[17] >>> 43;
            A[15] = A[15] << 56 | A[15] >>> 8;
            A[24] = A[24] << 27 | A[24] >>> 37;
            A[22] = A[22] << 20 | A[22] >>> 44;
            A[20] = A[20] << 39 | A[20] >>> 25;
            A[23] = A[23] << 8 | A[23] >>> 56;
            A[21] = A[21] << 14 | A[21] >>> 50;
            bnn = A[13] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = A[9] | A[13];
            c0 = A[0] ^ kt;
            kt = bnn | A[17];
            c1 = A[9] ^ kt;
            kt = A[17] & A[21];
            c2 = A[13] ^ kt;
            kt = A[21] | A[0];
            c3 = A[17] ^ kt;
            kt = A[0] & A[9];
            c4 = A[21] ^ kt;
            A[0] = c0;
            A[9] = c1;
            A[13] = c2;
            A[17] = c3;
            A[21] = c4;
            bnn = A[14] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = A[22] | A[1];
            c0 = A[18] ^ kt;
            kt = A[1] & A[5];
            c1 = A[22] ^ kt;
            kt = A[5] | bnn;
            c2 = A[1] ^ kt;
            kt = A[14] | A[18];
            c3 = A[5] ^ kt;
            kt = A[18] & A[22];
            c4 = A[14] ^ kt;
            A[18] = c0;
            A[22] = c1;
            A[1] = c2;
            A[5] = c3;
            A[14] = c4;
            bnn = A[23] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = A[10] | A[19];
            c0 = A[6] ^ kt;
            kt = A[19] & A[23];
            c1 = A[10] ^ kt;
            kt = bnn & A[2];
            c2 = A[19] ^ kt;
            kt = A[2] | A[6];
            c3 = bnn ^ kt;
            kt = A[6] & A[10];
            c4 = A[2] ^ kt;
            A[6] = c0;
            A[10] = c1;
            A[19] = c2;
            A[23] = c3;
            A[2] = c4;
            bnn = A[11] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = A[3] & A[7];
            c0 = A[24] ^ kt;
            kt = A[7] | A[11];
            c1 = A[3] ^ kt;
            kt = bnn | A[15];
            c2 = A[7] ^ kt;
            kt = A[15] & A[24];
            c3 = bnn ^ kt;
            kt = A[24] | A[3];
            c4 = A[15] ^ kt;
            A[24] = c0;
            A[3] = c1;
            A[7] = c2;
            A[11] = c3;
            A[15] = c4;
            bnn = A[16] ^ 0xFFFFFFFFFFFFFFFFL;
            kt = bnn & A[20];
            c0 = A[12] ^ kt;
            kt = A[20] | A[4];
            c1 = bnn ^ kt;
            kt = A[4] & A[8];
            c2 = A[20] ^ kt;
            kt = A[8] | A[12];
            c3 = A[4] ^ kt;
            kt = A[12] & A[16];
            c4 = A[8] ^ kt;
            A[12] = c0;
            A[16] = c1;
            A[20] = c2;
            A[4] = c3;
            A[8] = c4;
            A[0] = A[0] ^ this.RC[j + 1];
            long t = A[5];
            A[5] = A[18];
            A[18] = A[11];
            A[11] = A[10];
            A[10] = A[6];
            A[6] = A[22];
            A[22] = A[20];
            A[20] = A[12];
            A[12] = A[19];
            A[19] = A[15];
            A[15] = A[24];
            A[24] = A[8];
            A[8] = t;
            t = A[1];
            A[1] = A[9];
            A[9] = A[14];
            A[14] = A[2];
            A[2] = A[13];
            A[13] = A[23];
            A[23] = A[4];
            A[4] = A[21];
            A[21] = A[16];
            A[16] = A[3];
            A[3] = A[17];
            A[17] = A[7];
            A[7] = t;
            j += 2;
        }
        A[1] = A[1] ^ 0xFFFFFFFFFFFFFFFFL;
        A[2] = A[2] ^ 0xFFFFFFFFFFFFFFFFL;
        A[8] = A[8] ^ 0xFFFFFFFFFFFFFFFFL;
        A[12] = A[12] ^ 0xFFFFFFFFFFFFFFFFL;
        A[17] = A[17] ^ 0xFFFFFFFFFFFFFFFFL;
        A[20] = A[20] ^ 0xFFFFFFFFFFFFFFFFL;
    }

    void inner_shake256_init() {
        this.dptr = 0L;
        int i = 0;
        while (i < this.A.length) {
            this.A[i] = 0L;
            ++i;
        }
    }

    void inner_shake256_inject(byte[] srcin, int in, int len) {
        long dptr = this.dptr;
        while (len > 0) {
            long clen = 136L - dptr;
            if (clen > (long)len) {
                clen = len;
            }
            long u = 0L;
            while (u < clen) {
                long v = u + dptr;
                int n = (int)(v >> 3);
                this.A[n] = this.A[n] ^ ((long)srcin[in + (int)u] & 0xFFL) << (int)((v & 7L) << 3);
                ++u;
            }
            in = (int)((long)in + clen);
            len = (int)((long)len - clen);
            if ((dptr += clen) != 136L) continue;
            this.process_block(this.A);
            dptr = 0L;
        }
        this.dptr = dptr;
    }

    void i_shake256_flip() {
        int v = (int)this.dptr;
        int n = v >> 3;
        this.A[n] = this.A[n] ^ 31L << ((v & 7) << 3);
        this.A[16] = this.A[16] ^ Long.MIN_VALUE;
        this.dptr = 136L;
    }

    void inner_shake256_extract(byte[] srcout, int out, int len) {
        int o = out;
        int dptr = (int)this.dptr;
        while (len > 0) {
            int clen;
            if (dptr == 136) {
                this.process_block(this.A);
                dptr = 0;
            }
            if ((clen = 136 - dptr) > len) {
                clen = len;
            }
            len -= clen;
            while (clen-- > 0) {
                srcout[o++] = (byte)(this.A[dptr >> 3] >>> ((dptr & 7) << 3));
                ++dptr;
            }
        }
        this.dptr = dptr;
    }
}

