/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gemss;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.gemss.GeMSSUtils;
import org.bouncycastle.pqc.crypto.gemss.Mul_GF2x;
import org.bouncycastle.pqc.crypto.gemss.Pointer;
import org.bouncycastle.pqc.crypto.gemss.PointerUnion;
import org.bouncycastle.pqc.crypto.gemss.Rem_GF2n;
import org.bouncycastle.pqc.crypto.gemss.SecretKeyHFE;
import org.bouncycastle.util.Pack;

class GeMSSEngine {
    private SecureRandom random;
    final int HFEn;
    final int HFEv;
    final int HFEDELTA;
    final int NB_ITE;
    final int HFEDeg;
    final int HFEDegI;
    final int HFEDegJ;
    final int HFEnv;
    final int HFEm;
    final int NB_BITS_UINT = 64;
    final int HFEnq;
    final int HFEnr;
    int HFE_odd_degree;
    int NB_WORD_GFqn;
    int NB_WORD_GF2nv;
    int NB_MONOMIAL_VINEGAR;
    int NB_MONOMIAL_PK;
    final int HFEnvq;
    final int HFEnvr;
    int LTRIANGULAR_NV_SIZE;
    final int LTRIANGULAR_N_SIZE;
    final int SIZE_SEED_SK;
    final int NB_WORD_MUL;
    int NB_WORD_MMUL;
    int MQv_GFqn_SIZE;
    final boolean ENABLED_REMOVE_ODD_DEGREE;
    final int MATRIXnv_SIZE;
    final int HFEmq;
    final int HFEmr;
    int NB_WORD_GF2m;
    final int HFEvq;
    final int HFEvr;
    final int NB_WORD_GFqv;
    final int HFEmq8;
    final int HFEmr8;
    final int NB_BYTES_GFqm;
    final int ACCESS_last_equations8;
    final int NB_BYTES_EQUATION;
    final int HFENr8;
    final int NB_WORD_UNCOMP_EQ;
    final int HFENr8c;
    final int LOST_BITS;
    final int NB_WORD_GF2nvm;
    final int SIZE_SIGN_UNCOMPRESSED;
    final int SIZE_DIGEST;
    final int SIZE_DIGEST_UINT;
    final int HFEnvr8;
    final int NB_BYTES_GFqnv;
    final int VAL_BITS_M;
    final long MASK_GF2m;
    final int LEN_UNROLLED_64 = 4;
    int NB_COEFS_HFEPOLY;
    int NB_UINT_HFEVPOLY;
    final int MATRIXn_SIZE;
    final long MASK_GF2n;
    final int NB_BYTES_GFqn;
    private int buffer;
    final int SIZE_ROW;
    final int ShakeBitStrength;
    final int Sha3BitStrength;
    SHA3Digest sha3Digest;
    final int MLv_GFqn_SIZE;
    int II;
    int POW_II;
    int KP;
    int KX;
    int HFEn_1rightmost;
    int HFEn1h_rightmost;
    Mul_GF2x mul;
    Rem_GF2n rem;
    Pointer Buffer_NB_WORD_MUL;
    Pointer Buffer_NB_WORD_GFqn;

    public GeMSSEngine(int K, int HFEn, int HFEv, int HFEDELTA, int NB_ITE, int HFEDeg, int HFEDegI, int HFEDegJ) {
        int K3;
        this.HFEn = HFEn;
        this.HFEv = HFEv;
        this.HFEDELTA = HFEDELTA;
        this.NB_ITE = NB_ITE;
        this.HFEDeg = HFEDeg;
        this.HFEDegI = HFEDegI;
        this.HFEDegJ = HFEDegJ;
        this.NB_BYTES_GFqn = (HFEn >>> 3) + ((HFEn & 7) != 0 ? 1 : 0);
        this.SIZE_ROW = HFEDegI + 1;
        this.HFEnv = HFEn + HFEv;
        this.HFEnq = HFEn >>> 6;
        this.HFEnr = HFEn & 0x3F;
        this.HFEnvq = this.HFEnv >>> 6;
        this.HFEnvr = this.HFEnv & 0x3F;
        this.SIZE_SEED_SK = K >>> 3;
        this.NB_WORD_MUL = (HFEn - 1 << 1 >>> 6) + 1;
        switch (this.NB_WORD_MUL) {
            case 6: {
                this.mul = new Mul_GF2x.Mul6();
                break;
            }
            case 9: {
                this.mul = new Mul_GF2x.Mul9();
                break;
            }
            case 12: {
                this.mul = new Mul_GF2x.Mul12();
                break;
            }
            case 13: {
                this.mul = new Mul_GF2x.Mul13();
                break;
            }
            case 17: {
                this.mul = new Mul_GF2x.Mul17();
            }
        }
        int KI = HFEn & 0x3F;
        int KI64 = 64 - KI;
        this.HFEm = HFEn - HFEDELTA;
        this.HFEmq = this.HFEm >>> 6;
        this.HFEmr = this.HFEm & 0x3F;
        this.HFEvq = HFEv >>> 6;
        this.HFEvr = HFEv & 0x3F;
        this.NB_WORD_GFqv = this.HFEvr != 0 ? this.HFEvq + 1 : this.HFEvq;
        this.HFEmq8 = this.HFEm >>> 3;
        this.HFEmr8 = this.HFEm & 7;
        this.NB_BYTES_GFqm = this.HFEmq8 + (this.HFEmr8 != 0 ? 1 : 0);
        this.NB_WORD_UNCOMP_EQ = (this.HFEnvq * (this.HFEnvq + 1) >>> 1) * 64 + (this.HFEnvq + 1) * this.HFEnvr;
        this.HFEnvr8 = this.HFEnv & 7;
        this.NB_BYTES_GFqnv = (this.HFEnv >>> 3) + (this.HFEnvr8 != 0 ? 1 : 0);
        this.VAL_BITS_M = Math.min(HFEDELTA + HFEv, 8 - this.HFEmr8);
        this.MASK_GF2m = GeMSSUtils.maskUINT(this.HFEmr);
        this.MASK_GF2n = GeMSSUtils.maskUINT(this.HFEnr);
        this.NB_WORD_GFqn = this.HFEnq + (this.HFEnr != 0 ? 1 : 0);
        this.LTRIANGULAR_N_SIZE = (this.HFEnq * (this.HFEnq + 1) >>> 1) * 64 + this.NB_WORD_GFqn * this.HFEnr;
        this.MATRIXn_SIZE = HFEn * this.NB_WORD_GFqn;
        this.NB_WORD_GF2nv = this.HFEnvq + (this.HFEnvr != 0 ? 1 : 0);
        this.MATRIXnv_SIZE = this.HFEnv * this.NB_WORD_GF2nv;
        this.LTRIANGULAR_NV_SIZE = (this.HFEnvq * (this.HFEnvq + 1) >>> 1) * 64 + this.NB_WORD_GF2nv * this.HFEnvr;
        this.NB_MONOMIAL_VINEGAR = (HFEv * (HFEv + 1) >>> 1) + 1;
        this.NB_MONOMIAL_PK = (this.HFEnv * (this.HFEnv + 1) >>> 1) + 1;
        this.MQv_GFqn_SIZE = this.NB_MONOMIAL_VINEGAR * this.NB_WORD_GFqn;
        this.ACCESS_last_equations8 = this.NB_MONOMIAL_PK * this.HFEmq8;
        this.NB_BYTES_EQUATION = this.NB_MONOMIAL_PK + 7 >>> 3;
        this.HFENr8 = this.NB_MONOMIAL_PK & 7;
        this.HFENr8c = 8 - this.HFENr8 & 7;
        this.LOST_BITS = (this.HFEmr8 - 1) * this.HFENr8c;
        this.NB_WORD_MMUL = (HFEn - 1 << 1 >>> 6) + 1;
        int K1 = 0;
        int K2 = 0;
        int K164 = 0;
        int K264 = 0;
        switch (HFEn) {
            case 174: {
                K3 = 13;
                break;
            }
            case 175: {
                K3 = 16;
                break;
            }
            case 177: {
                K3 = 8;
                break;
            }
            case 178: {
                K3 = 31;
                break;
            }
            case 265: {
                K3 = 42;
                break;
            }
            case 266: {
                K3 = 47;
                break;
            }
            case 268: {
                K3 = 25;
                break;
            }
            case 270: {
                K3 = 53;
                break;
            }
            case 271: {
                K3 = 58;
                break;
            }
            case 354: {
                K3 = 99;
                break;
            }
            case 358: {
                K3 = 57;
                break;
            }
            case 364: {
                K3 = 9;
                break;
            }
            case 366: {
                K3 = 29;
                break;
            }
            case 402: {
                K3 = 171;
                break;
            }
            case 537: {
                K3 = 10;
                K2 = 2;
                K1 = 1;
                break;
            }
            case 544: {
                K3 = 128;
                K2 = 3;
                K1 = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("error: need to add support for HFEn=" + HFEn);
            }
        }
        if (K2 != 0) {
            K164 = 64 - K1;
            K264 = 64 - K2;
        }
        int K364 = 64 - (K3 & 0x3F);
        if ((HFEDeg & 1) == 0) {
            this.ENABLED_REMOVE_ODD_DEGREE = true;
            this.HFE_odd_degree = (1 << HFEDegI) + 1;
            if ((HFEDeg & 1) != 0) {
                throw new IllegalArgumentException("HFEDeg is odd, so to remove the leading term would decrease the degree.");
            }
            if (this.HFE_odd_degree > HFEDeg) {
                throw new IllegalArgumentException("It is useless to remove 0 term.");
            }
            if (this.HFE_odd_degree <= 1) {
                throw new IllegalArgumentException("The case where the term X^3 is removing is not implemented.");
            }
            this.NB_COEFS_HFEPOLY = 2 + HFEDegJ + (HFEDegI * (HFEDegI - 1) >>> 1) + HFEDegI;
        } else {
            this.ENABLED_REMOVE_ODD_DEGREE = false;
            this.NB_COEFS_HFEPOLY = 2 + HFEDegJ + (HFEDegI * (HFEDegI + 1) >>> 1);
        }
        this.NB_WORD_GF2m = this.HFEmq + (this.HFEmr != 0 ? 1 : 0);
        this.NB_WORD_GF2nvm = this.NB_WORD_GF2nv - this.NB_WORD_GF2m + (this.HFEmr != 0 ? 1 : 0);
        this.SIZE_SIGN_UNCOMPRESSED = this.NB_WORD_GF2nv + (NB_ITE - 1) * this.NB_WORD_GF2nvm;
        if (K <= 128) {
            this.SIZE_DIGEST = 32;
            this.SIZE_DIGEST_UINT = 4;
            this.ShakeBitStrength = 128;
            this.Sha3BitStrength = 256;
        } else if (K <= 192) {
            this.SIZE_DIGEST = 48;
            this.SIZE_DIGEST_UINT = 6;
            this.ShakeBitStrength = 256;
            this.Sha3BitStrength = 384;
        } else {
            this.SIZE_DIGEST = 64;
            this.SIZE_DIGEST_UINT = 8;
            this.ShakeBitStrength = 256;
            this.Sha3BitStrength = 512;
        }
        this.sha3Digest = new SHA3Digest(this.Sha3BitStrength);
        this.NB_UINT_HFEVPOLY = (this.NB_COEFS_HFEPOLY + (this.NB_MONOMIAL_VINEGAR - 1) + (HFEDegI + 1) * HFEv) * this.NB_WORD_GFqn;
        this.MLv_GFqn_SIZE = (HFEv + 1) * this.NB_WORD_GFqn;
        if (HFEDeg <= 34 || HFEn > 196 && HFEDeg < 256) {
            this.II = HFEDeg == 17 ? 4 : 6;
            this.POW_II = 1 << this.II;
            this.KP = (HFEDeg >>> this.II) + (HFEDeg % this.POW_II != 0 ? 1 : 0);
            this.KX = HFEDeg - this.KP;
        }
        if (K2 != 0) {
            this.rem = HFEn == 544 && K3 == 128 ? new Rem_GF2n.REM544_PENTANOMIAL_K3_IS_128_GF2X(K1, K2, KI, KI64, K164, K264, this.MASK_GF2n) : new Rem_GF2n.REM544_PENTANOMIAL_GF2X(K1, K2, K3, KI, KI64, K164, K264, K364, this.MASK_GF2n);
        } else if (HFEn > 256 && HFEn < 289 && K3 > 32 && K3 < 64) {
            this.rem = new Rem_GF2n.REM288_SPECIALIZED_TRINOMIAL_GF2X(K3, KI, KI64, K364, this.MASK_GF2n);
        } else if (HFEn == 354) {
            this.rem = new Rem_GF2n.REM384_SPECIALIZED_TRINOMIAL_GF2X(K3, KI, KI64, K364, this.MASK_GF2n);
        } else if (HFEn == 358) {
            this.rem = new Rem_GF2n.REM384_SPECIALIZED358_TRINOMIAL_GF2X(K3, KI, KI64, K364, this.MASK_GF2n);
        } else if (HFEn == 402) {
            this.rem = new Rem_GF2n.REM402_SPECIALIZED_TRINOMIAL_GF2X(K3, KI, KI64, K364, this.MASK_GF2n);
        } else {
            switch (this.NB_WORD_MUL) {
                case 6: {
                    this.rem = new Rem_GF2n.REM192_SPECIALIZED_TRINOMIAL_GF2X(K3, KI, KI64, K364, this.MASK_GF2n);
                    break;
                }
                case 9: {
                    this.rem = new Rem_GF2n.REM288_SPECIALIZED_TRINOMIAL_GF2X(K3, KI, KI64, K364, this.MASK_GF2n);
                    break;
                }
                case 12: {
                    this.rem = new Rem_GF2n.REM384_TRINOMIAL_GF2X(K3, KI, KI64, K364, this.MASK_GF2n);
                }
            }
        }
        this.Buffer_NB_WORD_MUL = new Pointer(this.NB_WORD_MUL);
        this.Buffer_NB_WORD_GFqn = new Pointer(this.NB_WORD_GFqn);
        this.HFEn_1rightmost = 31;
        int e = HFEn - 1;
        while (e >>> this.HFEn_1rightmost == 0) {
            --this.HFEn_1rightmost;
        }
        e = HFEn + 1 >>> 1;
        this.HFEn1h_rightmost = 31;
        while (e >>> this.HFEn1h_rightmost == 0) {
            --this.HFEn1h_rightmost;
        }
        --this.HFEn1h_rightmost;
    }

    void genSecretMQS_gf2_opt(Pointer MQS, Pointer F2) {
        int k;
        Pointer tmp3 = new Pointer(this.NB_WORD_GFqn);
        Pointer F_lin = new Pointer((this.HFEDegI + 1) * (this.HFEv + 1) * this.NB_WORD_GFqn);
        Pointer F_cp = new Pointer(F2, this.MQv_GFqn_SIZE);
        int i = 0;
        while (i <= this.HFEDegI) {
            k = 0;
            while (k <= this.HFEv) {
                F_lin.copyFrom((k * (this.HFEDegI + 1) + i) * this.NB_WORD_GFqn, F_cp, 0, this.NB_WORD_GFqn);
                F_cp.move(this.NB_WORD_GFqn);
                ++k;
            }
            F_cp.move(i * this.NB_WORD_GFqn);
            ++i;
        }
        Pointer alpha_vec = new Pointer(this.SIZE_ROW * (this.HFEn - 1) * this.NB_WORD_GFqn);
        i = 1;
        while (i < this.HFEn) {
            alpha_vec.set(i >>> 6, 1L << (i & 0x3F));
            int j = 0;
            while (j < this.HFEDegI) {
                this.sqr_gf2n(alpha_vec, this.NB_WORD_GFqn, alpha_vec, 0);
                alpha_vec.move(this.NB_WORD_GFqn);
                ++j;
            }
            alpha_vec.move(this.NB_WORD_GFqn);
            ++i;
        }
        alpha_vec.indexReset();
        MQS.copyFrom(F2, this.NB_WORD_GFqn);
        F2.move(this.MQv_GFqn_SIZE);
        MQS.move(this.NB_WORD_GFqn);
        Pointer buf = new Pointer(this.HFEDegI * this.HFEn * this.NB_WORD_GFqn);
        this.special_buffer(buf, F2, alpha_vec);
        Pointer buf_k = new Pointer(buf);
        Pointer buf_kp = new Pointer(buf);
        MQS.copyFrom(buf_kp, this.NB_WORD_GFqn);
        buf_kp.move(this.NB_WORD_GFqn);
        MQS.setXorMatrix_NoMove(buf_kp, this.NB_WORD_GFqn, this.HFEDegI - 1);
        F_cp.changeIndex(F_lin);
        MQS.setXorMatrix(F_cp, this.NB_WORD_GFqn, this.HFEDegI + 1);
        Pointer a_vec_kp = new Pointer(alpha_vec, this.NB_WORD_GFqn);
        int kp = 1;
        while (kp < this.HFEn) {
            this.dotProduct_gf2n(MQS, a_vec_kp, buf_k, this.HFEDegI);
            a_vec_kp.move(this.SIZE_ROW * this.NB_WORD_GFqn);
            MQS.setXorMatrix(buf_kp, this.NB_WORD_GFqn, this.HFEDegI);
            ++kp;
        }
        while (kp < this.HFEnv) {
            MQS.copyFrom(F_cp, this.NB_WORD_GFqn);
            F_cp.move(this.NB_WORD_GFqn);
            MQS.setXorMatrix(F_cp, this.NB_WORD_GFqn, this.HFEDegI);
            ++kp;
        }
        Pointer a_vec_k = new Pointer(alpha_vec, this.NB_WORD_GFqn);
        Pointer acc = new Pointer(this.NB_WORD_MUL);
        k = 1;
        while (k < this.HFEn) {
            buf_k.move(this.HFEDegI * this.NB_WORD_GFqn);
            a_vec_kp.changeIndex(a_vec_k);
            buf_kp.changeIndex(buf_k);
            this.mul.mul_gf2x(this.Buffer_NB_WORD_MUL, F_lin, new Pointer(a_vec_kp, -this.NB_WORD_GFqn));
            i = 1;
            while (i <= this.HFEDegI) {
                tmp3.setRangeFromXor(0, buf_kp, 0, F_lin, i * this.NB_WORD_GFqn, this.NB_WORD_GFqn);
                this.mul_xorrange(this.Buffer_NB_WORD_MUL, tmp3, a_vec_kp);
                buf_kp.move(this.NB_WORD_GFqn);
                a_vec_kp.move(this.NB_WORD_GFqn);
                ++i;
            }
            a_vec_kp.move(this.NB_WORD_GFqn);
            this.rem_gf2n(MQS, 0, this.Buffer_NB_WORD_MUL);
            MQS.move(this.NB_WORD_GFqn);
            kp = k + 1;
            while (kp < this.HFEn) {
                int a_vec_kp_orig = a_vec_kp.getIndex();
                int buf_k_orig = buf_k.getIndex();
                int a_vec_k_orig = a_vec_k.getIndex();
                int buf_kp_orig = buf_kp.getIndex();
                this.mul_move(acc, a_vec_kp, buf_k);
                this.for_mul_xorrange_move(acc, a_vec_kp, buf_k, this.HFEDegI - 1);
                this.for_mul_xorrange_move(acc, a_vec_k, buf_kp, this.HFEDegI);
                this.rem_gf2n(MQS, 0, acc);
                a_vec_kp.changeIndex(a_vec_kp_orig + this.SIZE_ROW * this.NB_WORD_GFqn);
                buf_k.changeIndex(buf_k_orig);
                a_vec_k.changeIndex(a_vec_k_orig);
                buf_kp.changeIndex(buf_kp_orig + this.HFEDegI * this.NB_WORD_GFqn);
                MQS.move(this.NB_WORD_GFqn);
                ++kp;
            }
            F_cp.changeIndex(F_lin);
            a_vec_k.move(-this.NB_WORD_GFqn);
            while (kp < this.HFEnv) {
                F_cp.move((this.HFEDegI + 1) * this.NB_WORD_GFqn);
                this.dotProduct_gf2n(MQS, a_vec_k, F_cp, this.HFEDegI + 1);
                MQS.move(this.NB_WORD_GFqn);
                ++kp;
            }
            a_vec_k.move(this.NB_WORD_GFqn + this.SIZE_ROW * this.NB_WORD_GFqn);
            ++k;
        }
        F2.move(this.NB_WORD_GFqn - this.MQv_GFqn_SIZE);
        MQS.copyFrom(F2, this.NB_WORD_GFqn * (this.NB_MONOMIAL_VINEGAR - 1));
        MQS.indexReset();
        F2.indexReset();
    }

    private void special_buffer(Pointer buf, Pointer F2, Pointer alpha_vec) {
        int F_orig = F2.getIndex();
        F2.move(this.NB_WORD_GFqn * (this.HFEv + 1) << 1);
        buf.copyFrom(F2, this.NB_WORD_GFqn);
        buf.move(this.NB_WORD_GFqn);
        Pointer F_cp = new Pointer(F2, this.NB_WORD_GFqn * (this.HFEv + 2));
        int i = 2;
        while (i < this.SIZE_ROW - 1) {
            this.copy_move_matrix_move(buf, F_cp, i - 1);
            ++i;
        }
        if (this.ENABLED_REMOVE_ODD_DEGREE) {
            while (i < this.SIZE_ROW - 1) {
                this.copy_move_matrix_move(buf, F_cp, i - 2);
                ++i;
            }
        }
        buf.set1_gf2n(0, this.NB_WORD_GFqn);
        buf.setXorMatrix(F_cp, this.NB_WORD_GFqn, this.HFEDegJ);
        int k = 0;
        while (k < this.HFEn - 1) {
            this.mul_gf2n(buf, alpha_vec, F2);
            buf.move(this.NB_WORD_GFqn);
            F_cp.changeIndex(F2, this.NB_WORD_GFqn * (this.HFEv + 2));
            i = 2;
            while (i < this.HFEDegI) {
                this.dotproduct_move_move(buf, F_cp, alpha_vec, i);
                ++i;
            }
            if (this.ENABLED_REMOVE_ODD_DEGREE) {
                alpha_vec.move(this.NB_WORD_GFqn);
                while (i < this.SIZE_ROW - 1) {
                    this.dotproduct_move_move(buf, F_cp, alpha_vec, i - 1);
                    ++i;
                }
                alpha_vec.move(-this.NB_WORD_GFqn);
            }
            if (this.HFEDegJ == 0) {
                buf.copyFrom(alpha_vec, this.NB_WORD_GFqn);
                buf.move(this.NB_WORD_GFqn);
                alpha_vec.move(this.SIZE_ROW * this.NB_WORD_GFqn);
            } else {
                this.dotProduct_gf2n(buf, alpha_vec, F_cp, this.HFEDegJ);
                alpha_vec.move(this.HFEDegJ * this.NB_WORD_GFqn);
                buf.setXorRange_SelfMove(alpha_vec, this.NB_WORD_GFqn);
                alpha_vec.move((this.SIZE_ROW - this.HFEDegJ) * this.NB_WORD_GFqn);
            }
            ++k;
        }
        buf.indexReset();
        F2.changeIndex(F_orig);
        alpha_vec.indexReset();
    }

    private void copy_move_matrix_move(Pointer buf, Pointer F_cp, int len) {
        buf.copyFrom(F_cp, this.NB_WORD_GFqn);
        F_cp.move(this.NB_WORD_GFqn);
        buf.setXorMatrix(F_cp, this.NB_WORD_GFqn, len);
        F_cp.move(this.NB_WORD_GFqn * (this.HFEv + 1));
    }

    private void dotproduct_move_move(Pointer buf, Pointer F_cp, Pointer alpha_vec, int len) {
        this.dotProduct_gf2n(buf, alpha_vec, F_cp, len);
        buf.move(this.NB_WORD_GFqn);
        F_cp.move((len + this.HFEv + 1) * this.NB_WORD_GFqn);
    }

    private void dotProduct_gf2n(Pointer res, Pointer vec_x, Pointer vec_y, int len) {
        Pointer tmp_mul = new Pointer(this.NB_WORD_MUL);
        int vec_x_orig = vec_x.getIndex();
        int vec_y_orig = vec_y.getIndex();
        this.mul_move(tmp_mul, vec_x, vec_y);
        this.for_mul_xorrange_move(tmp_mul, vec_x, vec_y, len - 1);
        this.rem_gf2n(res, 0, tmp_mul);
        vec_x.changeIndex(vec_x_orig);
        vec_y.changeIndex(vec_y_orig);
    }

    void mul_gf2n(Pointer P, Pointer A, int AOff, Pointer B) {
        int A_orig = A.getIndex();
        A.move(AOff);
        this.mul.mul_gf2x(this.Buffer_NB_WORD_MUL, A, B);
        A.changeIndex(A_orig);
        this.rem_gf2n(P, 0, this.Buffer_NB_WORD_MUL);
    }

    void mul_gf2n(Pointer P, Pointer A, Pointer B) {
        this.mul.mul_gf2x(this.Buffer_NB_WORD_MUL, A, B);
        this.rem_gf2n(P, 0, this.Buffer_NB_WORD_MUL);
    }

    void for_mul_xorrange_move(Pointer res, Pointer A, Pointer B, int len) {
        int i = 0;
        while (i < len) {
            this.mul.mul_gf2x_xor(res, A, B);
            A.move(this.NB_WORD_GFqn);
            B.move(this.NB_WORD_GFqn);
            ++i;
        }
    }

    void mul_move(Pointer res, Pointer A, Pointer B) {
        this.mul.mul_gf2x(res, A, B);
        A.move(this.NB_WORD_GFqn);
        B.move(this.NB_WORD_GFqn);
    }

    public void mul_xorrange(Pointer res, Pointer A, Pointer B) {
        this.mul.mul_gf2x_xor(res, A, B);
    }

    public void mul_rem_xorrange(Pointer res, Pointer A, Pointer B) {
        this.mul.mul_gf2x(this.Buffer_NB_WORD_MUL, A, B);
        this.rem.rem_gf2n_xor(res.array, res.cp, this.Buffer_NB_WORD_MUL.array);
    }

    public void mul_rem_xorrange(Pointer res, Pointer A, Pointer B, int b_cp) {
        int B_orig = B.getIndex();
        B.move(b_cp);
        this.mul.mul_gf2x(this.Buffer_NB_WORD_MUL, A, B);
        this.rem.rem_gf2n_xor(res.array, res.cp, this.Buffer_NB_WORD_MUL.array);
        B.changeIndex(B_orig);
    }

    private void rem_gf2n(Pointer P, int p_cp, Pointer Pol) {
        this.rem.rem_gf2n(P.array, p_cp += P.getIndex(), Pol.array);
    }

    private void sqr_gf2n(Pointer C, int c_shift, Pointer A, int a_shift) {
        this.mul.sqr_gf2x(this.Buffer_NB_WORD_MUL.array, A.array, a_shift += A.cp);
        this.rem_gf2n(C, c_shift, this.Buffer_NB_WORD_MUL);
    }

    private void sqr_gf2n(Pointer C, Pointer A) {
        this.mul.sqr_gf2x(this.Buffer_NB_WORD_MUL.array, A.array, A.cp);
        this.rem.rem_gf2n(C.array, C.cp, this.Buffer_NB_WORD_MUL.array);
    }

    void cleanLowerMatrix(Pointer L, FunctionParams cleanLowerMatrix) {
        int nr;
        int nq;
        switch (cleanLowerMatrix) {
            case N: {
                nq = this.HFEnq;
                nr = this.HFEnr;
                break;
            }
            case NV: {
                nq = this.HFEnvq;
                nr = this.HFEnvr;
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        Pointer L_cp = new Pointer(L);
        int iq = 1;
        while (iq <= nq) {
            this.for_and_xor_shift_incre_move(L_cp, iq, 64);
            L_cp.moveIncremental();
            ++iq;
        }
        this.for_and_xor_shift_incre_move(L_cp, iq, nr);
    }

    private void for_and_xor_shift_incre_move(Pointer L_cp, int iq, int len) {
        long mask = 0L;
        int ir = 0;
        while (ir < len) {
            L_cp.setAnd(mask);
            L_cp.setXor(1L << ir);
            mask <<= 1;
            ++mask;
            L_cp.move(iq);
            ++ir;
        }
    }

    void invMatrixLU_gf2(Pointer S, Pointer L_orig, Pointer U_orig, FunctionParams imluParams) {
        int endOfU;
        int ifCondition;
        int nextrow;
        int innerloopbound;
        int outloopbound;
        Pointer L_cpj = new Pointer(L_orig);
        Pointer L = new Pointer(L_orig);
        Pointer U = new Pointer(U_orig);
        switch (imluParams) {
            case NV: {
                outloopbound = this.HFEnvq;
                innerloopbound = this.HFEnv - 1;
                nextrow = this.NB_WORD_GF2nv;
                ifCondition = this.HFEnvr;
                endOfU = this.LTRIANGULAR_NV_SIZE;
                break;
            }
            case N: {
                S.setRangeClear(0, this.MATRIXn_SIZE);
                outloopbound = this.HFEnq;
                innerloopbound = this.HFEn - 1;
                nextrow = this.NB_WORD_GFqn;
                ifCondition = this.HFEnr;
                endOfU = this.LTRIANGULAR_N_SIZE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Input");
            }
        }
        Pointer Sinv_cpi = new Pointer(S);
        Pointer Sinv_cpj = new Pointer(S);
        int i = 0;
        int iq = 0;
        while (iq < outloopbound) {
            i = this.loop_xor_loop_move_xorandmask_move(Sinv_cpi, Sinv_cpj, L_cpj, L, i, iq, 64, innerloopbound, nextrow);
            L.moveIncremental();
            ++iq;
        }
        if (ifCondition > 1) {
            this.loop_xor_loop_move_xorandmask_move(Sinv_cpi, Sinv_cpj, L_cpj, L, i, iq, ifCondition - 1, innerloopbound, nextrow);
            Sinv_cpi.setXor(iq, 1L << ifCondition - 1);
            Sinv_cpi.move(nextrow);
        } else if (ifCondition == 1) {
            Sinv_cpi.set(iq, 1L);
            Sinv_cpi.move(nextrow);
        }
        U.move(endOfU);
        i = innerloopbound;
        while (i > 0) {
            U.move(-1 - (i >>> 6));
            Sinv_cpi.move(-nextrow);
            Sinv_cpj.changeIndex(S);
            int j = 0;
            while (j < i) {
                Sinv_cpj.setXorRangeAndMask(Sinv_cpi, nextrow, -(U.get(j >>> 6) >>> (j & 0x3F) & 1L));
                Sinv_cpj.move(nextrow);
                ++j;
            }
            --i;
        }
    }

    private int loop_xor_loop_move_xorandmask_move(Pointer Sinv_cpi, Pointer Sinv_cpj, Pointer L_cpj, Pointer L, int i, int iq, int len, int innerloopbound, int nextrow) {
        int ir = 0;
        while (ir < len) {
            Sinv_cpi.setXor(iq, 1L << ir);
            Sinv_cpj.changeIndex(Sinv_cpi);
            L_cpj.changeIndex(L);
            int j = i;
            while (j < innerloopbound) {
                Sinv_cpj.move(nextrow);
                L_cpj.move((j >>> 6) + 1);
                Sinv_cpj.setXorRangeAndMask(Sinv_cpi, iq + 1, -(L_cpj.get() >>> ir & 1L));
                ++j;
            }
            Sinv_cpi.move(nextrow);
            L.move(iq + 1);
            ++ir;
            ++i;
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    void vecMatProduct(Pointer res, Pointer vec, Pointer S_orig, FunctionParams vecMatProduct) {
        iq = 0;
        ir = 0;
        S = new Pointer(S_orig);
        switch (GeMSSEngine.$SWITCH_TABLE$org$bouncycastle$pqc$crypto$gemss$GeMSSEngine$FunctionParams()[vecMatProduct.ordinal()]) {
            case 1: {
                res.setRangeClear(0, this.NB_WORD_GF2nv);
                nq = this.HFEnvq;
                gf2_len = this.NB_WORD_GF2nv;
                S_cp_increase = this.NB_WORD_GF2nv;
                ** GOTO lbl41
            }
            case 2: {
                res.setRangeClear(0, this.NB_WORD_GFqn);
                gf2_len = this.NB_WORD_GFqn;
                S_cp_increase = this.NB_WORD_GFqn;
                nq = this.HFEvq;
                ** GOTO lbl41
            }
            case 3: {
                res.setRangeClear(0, this.NB_WORD_GFqn);
                gf2_len = this.NB_WORD_GFqn;
                S_cp_increase = this.NB_WORD_GFqn;
                nq = this.HFEnq;
                ** GOTO lbl41
            }
            case 4: {
                res.setRangeClear(0, this.NB_WORD_GF2m);
                nq = this.HFEnq;
                gf2_len = this.NB_WORD_GF2m;
                S_cp_increase = this.NB_WORD_GFqn;
                if (true) ** GOTO lbl41
            }
            default: {
                throw new IllegalArgumentException("Invalid input for vecMatProduct");
            }
        }
        do {
            bit_ir = vec.get(iq);
            while (ir < 64) {
                res.setXorRangeAndMask(S, gf2_len, -(bit_ir & 1L));
                S.move(S_cp_increase);
                bit_ir >>>= 1;
                ++ir;
            }
            ir = 0;
            ++iq;
lbl41:
            // 5 sources

        } while (iq < nq);
        switch (GeMSSEngine.$SWITCH_TABLE$org$bouncycastle$pqc$crypto$gemss$GeMSSEngine$FunctionParams()[vecMatProduct.ordinal()]) {
            case 1: {
                if (this.HFEnvr == 0) {
                    return;
                }
                bit_ir = vec.get(this.HFEnvq);
                loopir_param = this.HFEnvr;
                ** GOTO lbl66
            }
            case 2: {
                if (this.HFEvr == 0) {
                    return;
                }
                bit_ir = vec.get(this.HFEvq);
                loopir_param = this.HFEvr;
                ** GOTO lbl66
            }
            case 3: 
            case 4: {
                bit_ir = vec.get(this.HFEnq);
                loopir_param = this.HFEnr;
                if (true) ** GOTO lbl66
            }
            default: {
                throw new IllegalArgumentException("Invalid input for vecMatProduct");
            }
        }
        do {
            res.setXorRangeAndMask(S, gf2_len, -(bit_ir & 1L));
            S.move(S_cp_increase);
            bit_ir >>>= 1;
            ++ir;
lbl66:
            // 4 sources

        } while (ir < loopir_param);
        if (vecMatProduct == FunctionParams.M && this.HFEmr != 0) {
            res.setAnd(this.NB_WORD_GF2m - 1, this.MASK_GF2m);
        }
    }

    private long convMQ_uncompressL_gf2(Pointer pk2, PointerUnion pk) {
        PointerUnion pk64 = new PointerUnion(pk);
        int nb_bits = this.for_setpk2_end_move_plus(pk2, pk64, this.HFEnvq);
        if (this.HFEnvr != 0) {
            this.setPk2Value(pk2, pk64, nb_bits, this.HFEnvq, this.HFEnvr + 1);
        }
        return pk.get() & 1L;
    }

    private int setPk2Value(Pointer pk2, PointerUnion pk64, int nb_bits, int iq, int len) {
        int ir = 1;
        while (ir < len) {
            if ((nb_bits & 0x3F) != 0) {
                pk2.setRangePointerUnion(pk64, iq, nb_bits & 0x3F);
                pk2.set(iq, pk64.get(iq) >>> (nb_bits & 0x3F));
                if ((nb_bits & 0x3F) + ir > 64) {
                    pk2.setXor(iq, pk64.get(iq + 1) << 64 - (nb_bits & 0x3F));
                }
                if ((nb_bits & 0x3F) + ir >= 64) {
                    pk64.moveIncremental();
                }
            } else {
                pk2.setRangePointerUnion(pk64, iq + 1);
            }
            pk64.move(iq);
            pk2.setAnd(iq, (1L << ir) - 1L);
            pk2.move(iq + 1);
            nb_bits += (iq << 6) + ir;
            ++ir;
        }
        return nb_bits;
    }

    private void setPk2_endValue(Pointer pk2, PointerUnion pk64, int nb_bits, int iq) {
        if ((nb_bits & 0x3F) != 0) {
            pk2.setRangePointerUnion(pk64, iq + 1, nb_bits & 0x3F);
        } else {
            pk2.setRangePointerUnion(pk64, iq + 1);
        }
    }

    private long convMQ_last_uncompressL_gf2(Pointer pk2, PointerUnion pk) {
        PointerUnion pk64 = new PointerUnion(pk);
        int k = this.HFEnv - 1;
        int HFEnvqm1 = k >>> 6;
        int HFEnvrm1 = k & 0x3F;
        int nb_bits = this.for_setpk2_end_move_plus(pk2, pk64, HFEnvqm1);
        if (HFEnvrm1 != 0) {
            nb_bits = this.setPk2Value(pk2, pk64, nb_bits, HFEnvqm1, HFEnvrm1 + 1);
        }
        k = this.HFEnv - this.LOST_BITS;
        int LAST_ROW_Q = k >>> 6;
        int LAST_ROW_R = k & 0x3F;
        int iq = LAST_ROW_Q;
        if (LAST_ROW_R != 0) {
            int ir = LAST_ROW_R;
            if ((nb_bits & 0x3F) != 0) {
                if ((this.NB_MONOMIAL_PK - this.LOST_BITS + 7 >>> 3 & 7) != 0) {
                    int NB_WHOLE_BLOCKS = this.HFEnv - (64 - (this.NB_MONOMIAL_PK - this.LOST_BITS - this.HFEnvr & 0x3F) & 0x3F) >>> 6;
                    pk2.setRangePointerUnion_Check(pk64, NB_WHOLE_BLOCKS, nb_bits);
                    k = NB_WHOLE_BLOCKS;
                    pk2.set(k, pk64.getWithCheck(k) >>> (nb_bits & 0x3F));
                    if (NB_WHOLE_BLOCKS < LAST_ROW_Q) {
                        long end = pk64.getWithCheck(k + 1);
                        pk2.setXor(k, end << 64 - (nb_bits & 0x3F));
                        pk2.set(k + 1, end >>> (nb_bits & 0x3F));
                    } else if ((nb_bits & 0x3F) + ir > 64) {
                        pk2.setXor(k, pk64.getWithCheck(k + 1) << 64 - (nb_bits & 0x3F));
                    }
                } else {
                    pk2.setRangePointerUnion(pk64, iq, nb_bits & 0x3F);
                    pk2.set(iq, pk64.get(iq) >>> (nb_bits & 0x3F));
                    if ((nb_bits & 0x3F) + ir > 64) {
                        pk2.setXor(iq, pk64.get(iq + 1) << 64 - (nb_bits & 0x3F));
                    }
                }
            } else if ((this.NB_MONOMIAL_PK - this.LOST_BITS + 7 >>> 3 & 7) != 0) {
                pk2.setRangePointerUnion(pk64, iq);
                pk2.set(iq, pk64.getWithCheck(iq));
            } else {
                pk2.setRangePointerUnion(pk64, iq + 1);
            }
        } else if (LAST_ROW_Q != 0) {
            if ((nb_bits & 0x3F) != 0) {
                if ((this.NB_MONOMIAL_PK - this.LOST_BITS + 7 >>> 3 & 7) != 0) {
                    pk2.setRangePointerUnion(pk64, iq - 1, nb_bits & 0x3F);
                    k = iq - 1;
                    pk2.set(k, pk64.get(k) >>> (nb_bits & 0x3F));
                    pk2.setXor(k, pk64.getWithCheck(k + 1) << 64 - (nb_bits & 0x3F));
                } else {
                    pk2.setRangePointerUnion(pk64, iq, nb_bits & 0x3F);
                }
            } else {
                pk2.setRangePointerUnion(pk64, iq);
            }
        }
        return pk.get() & 1L;
    }

    private int for_setpk2_end_move_plus(Pointer pk2, PointerUnion pk64, int len) {
        int nb_bits = 1;
        int iq = 0;
        while (iq < len) {
            nb_bits = this.setPk2Value(pk2, pk64, nb_bits, iq, 64);
            this.setPk2_endValue(pk2, pk64, nb_bits, iq);
            pk64.move(iq + 1);
            pk2.move(iq + 1);
            nb_bits += iq + 1 << 6;
            ++iq;
        }
        return nb_bits;
    }

    public int sign_openHFE_huncomp_pk(byte[] m, int len, byte[] sm8, PointerUnion pk, PointerUnion hpk) {
        Pointer sm = new Pointer(this.SIZE_SIGN_UNCOMPRESSED);
        Pointer Si_tab = new Pointer(this.NB_WORD_GF2nv);
        Pointer Si1_tab = new Pointer(this.NB_WORD_GF2nv);
        Pointer Si = new Pointer(Si_tab);
        Pointer Si1 = new Pointer(Si1_tab);
        byte[] hash = new byte[64];
        Pointer D = new Pointer(this.NB_ITE * this.SIZE_DIGEST_UINT);
        int m_cp = 0;
        long cst = hpk.get();
        hpk.move(1);
        this.uncompress_signHFE(sm, sm8);
        this.getSHA3Hash(D, 0, 64, m, m_cp, len, hash);
        int i = 1;
        while (i < this.NB_ITE) {
            this.getSHA3Hash(D, i * this.SIZE_DIGEST_UINT, 64, hash, 0, this.SIZE_DIGEST, hash);
            D.setAnd(this.SIZE_DIGEST_UINT * (i - 1) + this.NB_WORD_GF2m - 1, this.MASK_GF2m);
            ++i;
        }
        D.setAnd(this.SIZE_DIGEST_UINT * (i - 1) + this.NB_WORD_GF2m - 1, this.MASK_GF2m);
        this.evalMQShybrid8_uncomp_nocst_gf2_m(Si, sm, pk, hpk);
        Si.setXor(this.HFEmq, cst);
        i = this.NB_ITE - 1;
        while (i > 0) {
            Si.setXorRange(D, i * this.SIZE_DIGEST_UINT, this.NB_WORD_GF2m);
            int index = this.NB_WORD_GF2nv + (this.NB_ITE - 1 - i) * this.NB_WORD_GF2nvm;
            Si.setAnd(this.NB_WORD_GF2m - 1, this.MASK_GF2m);
            Si.setXor(this.NB_WORD_GF2m - 1, sm.get(index));
            if (this.NB_WORD_GF2nvm != 1) {
                Si.copyFrom(this.NB_WORD_GF2m, sm, ++index, this.NB_WORD_GF2nvm - 1);
            }
            this.evalMQShybrid8_uncomp_nocst_gf2_m(Si1, Si, pk, hpk);
            Si1.setXor(this.HFEmq, cst);
            Si1.swap(Si);
            --i;
        }
        return Si.isEqual_nocst_gf2(D, this.NB_WORD_GF2m);
    }

    private void getSHA3Hash(Pointer output, int outOff, int outLength, byte[] input, int inOff, int inputLenth, byte[] hash) {
        this.sha3Digest.update(input, inOff, inputLenth);
        this.sha3Digest.doFinal(hash, 0);
        output.fill(outOff, hash, 0, outLength);
    }

    private void evalMQShybrid8_uncomp_nocst_gf2_m(Pointer res, Pointer x, PointerUnion mq_quo, PointerUnion mq_rem_orig) {
        PointerUnion mq_rem = new PointerUnion(mq_rem_orig);
        this.evalMQSnocst8_quo_gf2(res, x, mq_quo);
        if (this.HFEmr < 8) {
            res.set(this.HFEmq, 0L);
        }
        int i = this.HFEmr - this.HFEmr8;
        while (i < this.HFEmr) {
            res.setXor(this.HFEmq, this.evalMQnocst_unrolled_no_simd_gf2(x, mq_rem) << i);
            mq_rem.move(this.NB_WORD_UNCOMP_EQ);
            ++i;
        }
    }

    private void uncompress_signHFE(Pointer sm, byte[] sm8) {
        PointerUnion sm64 = new PointerUnion(sm);
        int MASK8_GF2nv = (1 << this.HFEnvr8) - 1;
        sm64.fillBytes(0, sm8, 0, this.NB_BYTES_GFqnv);
        if (this.HFEnvr8 != 0) {
            sm64.setAndByte(this.NB_BYTES_GFqnv - 1, MASK8_GF2nv);
        }
        int nb_bits = this.HFEnv;
        sm64.moveNextBytes((this.NB_WORD_GF2nv << 3) + (this.HFEmq8 & 7));
        int k1 = 1;
        while (k1 < this.NB_ITE) {
            int k2;
            int val_n = Math.min(this.HFEDELTA + this.HFEv, 8 - (nb_bits & 7) & 7);
            if ((nb_bits & 7) != 0) {
                sm64.setXorByte((sm8[nb_bits >>> 3] & 0xFF) >>> (nb_bits & 7) << this.HFEmr8);
                int nb_rem = val_n - this.VAL_BITS_M;
                if (nb_rem >= 0) {
                    sm64.moveNextByte();
                }
                if (nb_rem > 0) {
                    sm64.setXorByte((sm8[(nb_bits += this.VAL_BITS_M) >>> 3] & 0xFF) >>> (nb_bits & 7));
                    nb_bits += nb_rem;
                } else {
                    nb_bits += val_n;
                }
            }
            int nb_rem2 = this.HFEDELTA + this.HFEv - val_n;
            int nb_rem_m = this.HFEm + val_n & 7;
            if (nb_rem_m != 0) {
                k2 = 0;
                while (k2 < nb_rem2 - 1 >>> 3) {
                    sm64.setXorByte((sm8[nb_bits >>> 3] & 0xFF) << nb_rem_m);
                    sm64.moveNextByte();
                    sm64.setXorByte((sm8[nb_bits >>> 3] & 0xFF) >>> 8 - nb_rem_m);
                    nb_bits += 8;
                    ++k2;
                }
                sm64.setXorByte((sm8[nb_bits >>> 3] & 0xFF) << nb_rem_m);
                sm64.moveNextByte();
                nb_rem2 = (nb_rem2 + 7 & 7) + 1;
                if (nb_rem2 > 8 - nb_rem_m) {
                    sm64.setByte((sm8[nb_bits >>> 3] & 0xFF) >>> 8 - nb_rem_m);
                    sm64.moveNextByte();
                }
                nb_bits += nb_rem2;
            } else {
                k2 = 0;
                while (k2 < nb_rem2 + 7 >>> 3) {
                    sm64.setByte(sm8[nb_bits >>> 3]);
                    nb_bits += 8;
                    sm64.moveNextByte();
                    ++k2;
                }
                nb_bits -= 8 - (nb_rem2 & 7) & 7;
            }
            if (this.HFEnvr8 != 0) {
                sm64.setAndByte(-1, MASK8_GF2nv);
            }
            sm64.moveNextBytes((8 - (this.NB_BYTES_GFqnv & 7) & 7) + (this.HFEmq8 & 7));
            ++k1;
        }
    }

    private void evalMQSnocst8_quo_gf2(Pointer c, Pointer m, PointerUnion pk_orig) {
        int ir;
        long xi;
        int i = this.HFEnv;
        int NB_EQ = this.HFEm >>> 3 != 0 ? this.HFEm >>> 3 << 3 : this.HFEm;
        int NB_BYTES_EQ = (NB_EQ & 7) != 0 ? (NB_EQ >>> 3) + 1 : NB_EQ >>> 3;
        int NB_WORD_EQ = (NB_BYTES_EQ >>> 3) + ((NB_BYTES_EQ & 7) != 0 ? 1 : 0);
        PointerUnion pk = new PointerUnion(pk_orig);
        System.arraycopy(pk.getArray(), 0, c.getArray(), c.getIndex(), NB_WORD_EQ);
        pk.moveNextBytes(NB_BYTES_EQ);
        int iq = 0;
        while (iq < this.HFEnvq) {
            xi = m.get(iq);
            ir = 0;
            while (ir < 64) {
                if ((xi & 1L) != 0L) {
                    c.setXorRange(0, pk, 0, NB_WORD_EQ);
                    pk.moveNextBytes(NB_BYTES_EQ);
                    long xj = xi >>> 1;
                    this.LOOPJR_UNROLLED_64(c, pk, ir + 1, 64, xj, NB_BYTES_EQ, NB_WORD_EQ);
                    int jq = iq + 1;
                    while (jq < this.HFEnvq) {
                        xj = m.get(jq);
                        this.LOOPJR_UNROLLED_64(c, pk, 0, 64, xj, NB_BYTES_EQ, NB_WORD_EQ);
                        ++jq;
                    }
                    if (this.HFEnvr != 0) {
                        this.choose_LOOPJR(c, pk, 0, m.get(this.HFEnvq), NB_BYTES_EQ, NB_WORD_EQ);
                    }
                } else {
                    pk.moveNextBytes(i * NB_BYTES_EQ);
                }
                xi >>>= 1;
                ++ir;
                --i;
            }
            ++iq;
        }
        if (this.HFEnvr != 0) {
            xi = m.get(this.HFEnvq);
            ir = 0;
            while (ir < this.HFEnvr) {
                if ((xi & 1L) != 0L) {
                    c.setXorRange(0, pk, 0, NB_WORD_EQ);
                    pk.moveNextBytes(NB_BYTES_EQ);
                    this.choose_LOOPJR(c, pk, ir + 1, xi >>> 1, NB_BYTES_EQ, NB_WORD_EQ);
                } else {
                    pk.moveNextBytes(i * NB_BYTES_EQ);
                }
                xi >>>= 1;
                ++ir;
                --i;
            }
        }
        if ((NB_EQ & 0x3F) != 0) {
            c.setAnd(NB_WORD_EQ - 1, (1L << (NB_EQ & 0x3F)) - 1L);
        }
    }

    private void choose_LOOPJR(Pointer c, PointerUnion pk, int START, long xj, int NB_BYTES_EQ, int NB_WORD_EQ) {
        if (this.HFEnvr < 8) {
            this.LOOPJR_NOCST_64(c, pk, START, this.HFEnvr, xj, NB_BYTES_EQ, NB_WORD_EQ);
        } else {
            this.LOOPJR_UNROLLED_64(c, pk, START, this.HFEnvr, xj, NB_BYTES_EQ, NB_WORD_EQ);
        }
    }

    private void LOOPJR_UNROLLED_64(Pointer c, PointerUnion pk64, int START, int NB_IT, long xj, int NB_BYTES_EQ, int NB_WORD_EQ) {
        int jr = START;
        while (jr < NB_IT - 4 + 1) {
            xj = this.LOOPJR_NOCST_64(c, pk64, 0, 4, xj, NB_BYTES_EQ, NB_WORD_EQ);
            jr += 4;
        }
        this.LOOPJR_NOCST_64(c, pk64, jr, NB_IT, xj, NB_BYTES_EQ, NB_WORD_EQ);
    }

    private long LOOPJR_NOCST_64(Pointer c, PointerUnion pk64, int START, int NB_IT, long xj, int NB_BYTES_EQ, int NB_WORD_EQ) {
        int jr = START;
        while (jr < NB_IT) {
            if ((xj & 1L) != 0L) {
                c.setXorRange(0, pk64, 0, NB_WORD_EQ);
            }
            pk64.moveNextBytes(NB_BYTES_EQ);
            xj >>>= 1;
            ++jr;
        }
        return xj;
    }

    private long evalMQnocst_unrolled_no_simd_gf2(Pointer m, PointerUnion mq_orig) {
        long acc = 0L;
        int loop_end = 64;
        PointerUnion mq = new PointerUnion(mq_orig);
        long mj = m.get();
        int i = 0;
        while (i < loop_end) {
            if ((mj >>> i & 1L) != 0L) {
                acc ^= mq.get(i) & mj;
            }
            ++i;
        }
        mq.move(64);
        int j = 1;
        while (j < this.NB_WORD_GF2nv) {
            loop_end = this.NB_WORD_GF2nv == j + 1 && this.HFEnvr != 0 ? this.HFEnvr : 64;
            mj = m.get(j);
            i = 0;
            while (i < loop_end) {
                if ((mj >>> i & 1L) != 0L) {
                    acc ^= mq.getDotProduct(0, m, 0, j + 1);
                }
                mq.move(j + 1);
                ++i;
            }
            ++j;
        }
        acc = GeMSSUtils.XORBITS_UINT(acc);
        return acc;
    }

    public void signHFE_FeistelPatarin(SecureRandom random, byte[] sm8, byte[] m, int m_cp, int len, byte[] sk) {
        this.random = random;
        Pointer U = new Pointer(this.NB_WORD_GFqn);
        Pointer Hi_tab = new Pointer(this.SIZE_DIGEST_UINT);
        Pointer Hi1_tab = new Pointer(this.SIZE_DIGEST_UINT);
        Pointer Hi1 = new Pointer(Hi1_tab);
        int HFEvr8 = this.HFEv & 7;
        int NB_BYTES_GFqv = (this.HFEv >>> 3) + (HFEvr8 != 0 ? 1 : 0);
        long HFE_MASKv = GeMSSUtils.maskUINT(this.HFEvr);
        long rem_char = 0L;
        SecretKeyHFE sk_HFE = new SecretKeyHFE(this);
        Pointer V = new Pointer(this.NB_WORD_GFqv);
        Pointer[] linear_coefs = new Pointer[this.HFEDegI + 1];
        this.precSignHFE(sk_HFE, linear_coefs, sk);
        Pointer F2 = new Pointer(sk_HFE.F_struct.poly);
        Pointer Hi = new Pointer(Hi_tab);
        byte[] hash = new byte[this.Sha3BitStrength >>> 3];
        this.getSHA3Hash(Hi, 0, hash.length, m, m_cp, len, hash);
        Pointer sm = new Pointer(this.SIZE_SIGN_UNCOMPRESSED);
        Pointer DR = new Pointer(this.NB_WORD_GF2nv);
        PointerUnion DR_cp = new PointerUnion(DR);
        int k = 1;
        while (k <= this.NB_ITE) {
            DR.setRangeFromXor(sm, Hi, this.NB_WORD_GF2m);
            if (this.HFEmr8 != 0) {
                DR.setAnd(this.NB_WORD_GF2m - 1, this.MASK_GF2m);
                rem_char = DR_cp.getByte(this.HFEmq8);
            }
            do {
                if (this.HFEmr8 != 0) {
                    DR_cp.fillRandomBytes(this.HFEmq8, random, this.NB_BYTES_GFqn - this.NB_BYTES_GFqm + 1);
                    DR_cp.setAndThenXorByte(this.HFEmq8, -(1L << this.HFEmr8), rem_char);
                } else {
                    DR_cp.fillRandomBytes(this.NB_BYTES_GFqm, random, this.NB_BYTES_GFqn - this.NB_BYTES_GFqm);
                }
                if ((this.HFEn & 7) != 0) {
                    DR.setAnd(this.NB_WORD_GFqn - 1, this.MASK_GF2n);
                }
                this.vecMatProduct(U, DR, sk_HFE.T, FunctionParams.N);
                V.fillRandom(0, random, NB_BYTES_GFqv);
                if (HFEvr8 != 0) {
                    V.setAnd(this.NB_WORD_GFqv - 1, HFE_MASKv);
                }
                this.evalMQSv_unrolled_gf2(F2, V, sk_HFE.F_HFEv);
                int i = 0;
                while (i <= this.HFEDegI) {
                    this.vecMatProduct(this.Buffer_NB_WORD_GFqn, V, new Pointer(linear_coefs[i], this.NB_WORD_GFqn), FunctionParams.V);
                    F2.setRangeFromXor(this.NB_WORD_GFqn * ((i * (i + 1) >>> 1) + 1), linear_coefs[i], 0, this.Buffer_NB_WORD_GFqn, 0, this.NB_WORD_GFqn);
                    ++i;
                }
            } while (this.chooseRootHFE_gf2nx(DR, sk_HFE.F_struct, U) == 0);
            DR.setXor(this.NB_WORD_GFqn - 1, V.get() << this.HFEnr);
            DR.setRangeRotate(this.NB_WORD_GFqn, V, 0, this.NB_WORD_GFqv - 1, 64 - this.HFEnr);
            if (this.NB_WORD_GFqn + this.NB_WORD_GFqv == this.NB_WORD_GF2nv) {
                DR.set(this.NB_WORD_GFqn + this.NB_WORD_GFqv - 1, V.get(this.NB_WORD_GFqv - 1) >>> 64 - this.HFEnr);
            }
            this.vecMatProduct(sm, DR, sk_HFE.S, FunctionParams.NV);
            if (k != this.NB_ITE) {
                int index = this.NB_WORD_GF2nv + (this.NB_ITE - 1 - k) * this.NB_WORD_GF2nvm;
                sm.copyFrom(index, sm, this.NB_WORD_GF2nv - this.NB_WORD_GF2nvm, this.NB_WORD_GF2nvm);
                if (this.HFEmr != 0) {
                    sm.setAnd(index, this.MASK_GF2m ^ 0xFFFFFFFFFFFFFFFFL);
                }
                byte[] Hi_bytes = Hi.toBytes(this.SIZE_DIGEST);
                this.getSHA3Hash(Hi1, 0, this.SIZE_DIGEST, Hi_bytes, 0, Hi_bytes.length, Hi_bytes);
                Hi1.swap(Hi);
            }
            ++k;
        }
        if (this.NB_ITE == 1) {
            byte[] sm64 = sm.toBytes(sm.getLength() << 3);
            System.arraycopy(sm64, 0, sm8, 0, this.NB_BYTES_GFqnv);
        } else {
            this.compress_signHFE(sm8, sm);
        }
    }

    private void precSignHFE(SecretKeyHFE sk_HFE, Pointer[] linear_coefs, byte[] sk) {
        int j;
        this.precSignHFESeed(sk_HFE, sk);
        this.initListDifferences_gf2nx(sk_HFE.F_struct.L);
        Pointer F_HFEv = new Pointer(sk_HFE.F_HFEv);
        int NB_UINT_HFEPOLY = this.NB_COEFS_HFEPOLY * this.NB_WORD_GFqn;
        Pointer F2 = new Pointer(NB_UINT_HFEPOLY);
        linear_coefs[0] = new Pointer(F_HFEv, this.MQv_GFqn_SIZE);
        F_HFEv.changeIndex(linear_coefs[0], this.MLv_GFqn_SIZE);
        Pointer F_cp = new Pointer(F2, 2 * this.NB_WORD_GFqn);
        int i = 0;
        while (i < this.HFEDegI) {
            j = i - ((1 << i) + 1 > this.HFE_odd_degree && this.ENABLED_REMOVE_ODD_DEGREE ? 1 : 0);
            F_cp.copyFrom(F_HFEv, j * this.NB_WORD_GFqn);
            F_HFEv.move(j * this.NB_WORD_GFqn);
            F_cp.move(j * this.NB_WORD_GFqn);
            linear_coefs[i + 1] = new Pointer(F_HFEv);
            F_HFEv.move(this.MLv_GFqn_SIZE);
            F_cp.move(this.NB_WORD_GFqn);
            ++i;
        }
        if (this.HFEDegJ != 0) {
            j = (1 << i) + 1 <= this.HFE_odd_degree ? 0 : 1;
            F_cp.copyFrom(F_HFEv, (this.HFEDegJ - j) * this.NB_WORD_GFqn);
        }
        sk_HFE.F_struct.poly = new Pointer(F2);
    }

    private void precSignHFESeed(SecretKeyHFE sk_HFE, byte[] sk) {
        int length_tmp = this.NB_UINT_HFEVPOLY + (this.LTRIANGULAR_NV_SIZE + this.LTRIANGULAR_N_SIZE << 1);
        sk_HFE.sk_uncomp = new Pointer(length_tmp + this.MATRIXnv_SIZE + this.MATRIXn_SIZE);
        SHAKEDigest shakeDigest = new SHAKEDigest(this.ShakeBitStrength);
        shakeDigest.update(sk, 0, this.SIZE_SEED_SK);
        byte[] sk_uncomp_byte = new byte[length_tmp << 3];
        shakeDigest.doFinal(sk_uncomp_byte, 0, sk_uncomp_byte.length);
        sk_HFE.sk_uncomp.fill(0, sk_uncomp_byte, 0, sk_uncomp_byte.length);
        sk_HFE.S = new Pointer(sk_HFE.sk_uncomp, length_tmp);
        sk_HFE.T = new Pointer(sk_HFE.S, this.MATRIXnv_SIZE);
        sk_HFE.F_HFEv = new Pointer(sk_HFE.sk_uncomp);
        this.cleanMonicHFEv_gf2nx(sk_HFE.F_HFEv);
        Pointer L = new Pointer(sk_HFE.sk_uncomp, this.NB_UINT_HFEVPOLY);
        Pointer U = new Pointer(L, this.LTRIANGULAR_NV_SIZE);
        this.cleanLowerMatrix(L, FunctionParams.NV);
        this.cleanLowerMatrix(U, FunctionParams.NV);
        this.mulMatricesLU_gf2(sk_HFE.S, L, U, FunctionParams.NV);
        L.move(this.LTRIANGULAR_NV_SIZE << 1);
        U.changeIndex(L, this.LTRIANGULAR_N_SIZE);
        this.cleanLowerMatrix(L, FunctionParams.N);
        this.cleanLowerMatrix(U, FunctionParams.N);
        this.mulMatricesLU_gf2(sk_HFE.T, L, U, FunctionParams.N);
    }

    void cleanMonicHFEv_gf2nx(Pointer F2) {
        int F_idx = this.NB_WORD_GFqn - 1;
        while (F_idx < this.NB_UINT_HFEVPOLY) {
            F2.setAnd(F_idx, this.MASK_GF2n);
            F_idx += this.NB_WORD_GFqn;
        }
    }

    private void mulMatricesLU_gf2(Pointer S, Pointer L, Pointer U, FunctionParams functionParams) {
        boolean REM;
        int nr;
        int nq;
        int S_orig = S.getIndex();
        switch (functionParams) {
            case N: {
                nq = this.HFEnq;
                nr = this.HFEnr;
                REM = true;
                break;
            }
            case NV: {
                nq = this.HFEnvq;
                nr = this.HFEnvr;
                REM = this.HFEnvr != 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter for MULMATRICESLU_GF2");
            }
        }
        Pointer L_cp = new Pointer(L);
        int iq = 1;
        while (iq <= nq) {
            this.LOOPIR(S, L_cp, U, 64, nq, nr, iq, REM);
            ++iq;
        }
        this.LOOPIR(S, L_cp, U, nr, nq, nr, iq, REM);
        S.changeIndex(S_orig);
    }

    private void LOOPIR(Pointer S, Pointer L_cp, Pointer U, int NB_IT, int nq, int nr, int iq, boolean REM) {
        int ir = 0;
        while (ir < NB_IT) {
            Pointer U_cp = new Pointer(U);
            int jq = 1;
            while (jq <= nq) {
                this.LOOPJR(S, L_cp, U_cp, 64, iq, jq);
                ++jq;
            }
            if (REM) {
                this.LOOPJR(S, L_cp, U_cp, nr, iq, jq);
            }
            L_cp.move(iq);
            ++ir;
        }
    }

    private void LOOPJR(Pointer S, Pointer L, Pointer U, int NB_IT, int iq, int jq) {
        int mini = Math.min(iq, jq);
        S.set(0L);
        int jr = 0;
        while (jr < NB_IT) {
            long tmp = L.getDotProduct(0, U, 0, mini);
            tmp = GeMSSUtils.XORBITS_UINT(tmp);
            S.setXor(tmp << jr);
            U.move(jq);
            ++jr;
        }
        S.moveIncremental();
    }

    private int setArrayL(int[] L, int k, int pos, int len) {
        int j = pos;
        while (j < len) {
            L[k++] = this.NB_WORD_GFqn << j;
            ++j;
        }
        return k;
    }

    private void initListDifferences_gf2nx(int[] L) {
        int k = 2;
        L[1] = this.NB_WORD_GFqn;
        int i = 0;
        while (i < this.HFEDegI) {
            if (this.ENABLED_REMOVE_ODD_DEGREE && (1 << i) + 1 > this.HFE_odd_degree) {
                if (i != 0) {
                    L[k++] = this.NB_WORD_GFqn << 1;
                }
                k = this.setArrayL(L, k, 1, i);
            } else {
                L[k++] = this.NB_WORD_GFqn;
                k = this.setArrayL(L, k, 0, i);
            }
            ++i;
        }
        if (this.HFEDegJ != 0) {
            if (this.ENABLED_REMOVE_ODD_DEGREE && (1 << i) + 1 > this.HFE_odd_degree) {
                L[k++] = this.NB_WORD_GFqn << 1;
                this.setArrayL(L, k, 1, this.HFEDegJ - 1);
            } else {
                L[k++] = this.NB_WORD_GFqn;
                this.setArrayL(L, k, 0, this.HFEDegJ - 1);
            }
        }
    }

    void evalMQSv_unrolled_gf2(Pointer c, Pointer m, Pointer pk) {
        Pointer x = new Pointer(this.HFEv);
        int NB_VARq = this.HFEv >>> 6;
        int NB_VARr = this.HFEv & 0x3F;
        int NB_WORD_EQ = (this.HFEn >>> 6) + ((this.HFEn & 0x3F) != 0 ? 1 : 0);
        int pk_orig = pk.getIndex();
        Pointer tmp = new Pointer(NB_WORD_EQ);
        int i = 0;
        int k = 0;
        while (i < NB_VARq) {
            k = x.setRange_xi(m.get(i), k, 64);
            ++i;
        }
        if (NB_VARr != 0) {
            x.setRange_xi(m.get(i), k, NB_VARr);
        }
        c.copyFrom(pk, NB_WORD_EQ);
        pk.move(NB_WORD_EQ);
        i = 0;
        while (i < this.HFEv) {
            tmp.copyFrom(pk, NB_WORD_EQ);
            pk.move(NB_WORD_EQ);
            int j = i + 1;
            while (j < this.HFEv - 3) {
                tmp.setXorRangeAndMaskMove(pk, NB_WORD_EQ, x.get(j));
                tmp.setXorRangeAndMaskMove(pk, NB_WORD_EQ, x.get(j + 1));
                tmp.setXorRangeAndMaskMove(pk, NB_WORD_EQ, x.get(j + 2));
                tmp.setXorRangeAndMaskMove(pk, NB_WORD_EQ, x.get(j + 3));
                j += 4;
            }
            while (j < this.HFEv) {
                tmp.setXorRangeAndMaskMove(pk, NB_WORD_EQ, x.get(j));
                ++j;
            }
            c.setXorRangeAndMask(tmp, NB_WORD_EQ, x.get(i));
            ++i;
        }
        pk.changeIndex(pk_orig);
    }

    private int chooseRootHFE_gf2nx(Pointer root, SecretKeyHFE.complete_sparse_monic_gf2nx F2, Pointer U) {
        Pointer hash = new Pointer(this.SIZE_DIGEST_UINT);
        Pointer poly = new Pointer(((this.HFEDeg << 1) - 1) * this.NB_WORD_GFqn);
        Pointer poly2 = new Pointer((this.HFEDeg + 1) * this.NB_WORD_GFqn);
        Pointer cst = new Pointer(this.NB_WORD_GFqn);
        cst.setRangeFromXor(F2.poly, U, this.NB_WORD_GFqn);
        if (this.HFEDeg <= 34 || this.HFEn > 196 && this.HFEDeg < 256) {
            this.frobeniusMap_multisqr_HFE_gf2nx(poly, F2, cst);
        } else {
            int i = 2 << this.HFEDegI;
            poly.set(i * this.NB_WORD_GFqn, 1L);
            this.divsqr_r_HFE_cstdeg_gf2nx(poly, i, i, this.HFEDeg, F2, cst);
            this.for_sqr_divsqr(poly, this.HFEDegI + 1, this.HFEn, F2, cst);
        }
        poly.setXor(this.NB_WORD_GFqn, 1L);
        int l = poly2.getIndex();
        poly2.copyFrom(F2.poly, this.NB_WORD_GFqn);
        this.for_copy_move(poly2, F2);
        poly2.changeIndex(l);
        poly2.set(this.HFEDeg * this.NB_WORD_GFqn, 1L);
        poly2.setXorRange(U, this.NB_WORD_GFqn);
        l = poly.getD_for_not0_or_plus(this.NB_WORD_GFqn, this.HFEDeg - 1);
        l = this.gcd_gf2nx(poly2, this.HFEDeg, poly, l);
        if (this.buffer != 0) {
            poly.swap(poly2);
        }
        if (poly.is0_gf2n(0, this.NB_WORD_GFqn) == 0) {
            return 0;
        }
        this.convMonic_gf2nx(poly2, l);
        Pointer roots = new Pointer(l * this.NB_WORD_GFqn);
        this.findRootsSplit_gf2nx(roots, poly2, l);
        if (l == 1) {
            root.copyFrom(roots, this.NB_WORD_GFqn);
        } else {
            this.fast_sort_gf2n(roots, l);
            this.getSHA3Hash(hash, 0, this.Sha3BitStrength >>> 3, U.toBytes(this.NB_BYTES_GFqn), 0, this.NB_BYTES_GFqn, new byte[this.Sha3BitStrength >>> 3]);
            root.copyFrom(0, roots, (int)GeMSSEngine.remainderUnsigned(hash.get(), l) * this.NB_WORD_GFqn, this.NB_WORD_GFqn);
        }
        return l;
    }

    private int gcd_gf2nx(Pointer A, int da, Pointer B, int db) {
        Pointer inv = new Pointer(this.NB_WORD_GFqn);
        this.buffer = 0;
        while (db != 0) {
            if (db << 1 > da) {
                da = this.div_r_gf2nx(A, da, B, db);
            } else {
                this.inv_gf2n(inv, B, db * this.NB_WORD_GFqn);
                B.set1_gf2n(db * this.NB_WORD_GFqn, this.NB_WORD_GFqn);
                this.for_mul(B, inv, db - 1);
                da = this.div_r_monic_gf2nx(A, da, B, db);
            }
            Pointer tmp = A;
            A = B;
            B = tmp;
            int tmp_word = da;
            da = db;
            db = tmp_word;
            this.buffer = 1 - this.buffer;
        }
        return da;
    }

    private void for_mul(Pointer res_orig, Pointer inv, int start) {
        Pointer res = new Pointer(res_orig, start * this.NB_WORD_GFqn);
        int i = start;
        while (i != -1) {
            this.mul_gf2n(res, res, inv);
            res.move(-this.NB_WORD_GFqn);
            --i;
        }
    }

    private void frobeniusMap_multisqr_HFE_gf2nx(Pointer Xqn, SecretKeyHFE.complete_sparse_monic_gf2nx F2, Pointer cst) {
        Pointer Xqn_cp = new Pointer();
        Pointer Xqn_sqr = new Pointer(this.HFEDeg * this.NB_WORD_GFqn);
        Pointer current_coef = new Pointer();
        Pointer table = new Pointer((this.KX * this.HFEDeg + this.POW_II) * this.NB_WORD_GFqn);
        int j = this.POW_II * this.KP - this.HFEDeg;
        Pointer table_cp = new Pointer(table, this.NB_WORD_GFqn * j);
        table_cp.copyFrom(cst, this.NB_WORD_GFqn);
        this.for_copy_move(table_cp, F2);
        this.divsqr_r_HFE_cstdeg_gf2nx(table, j - 1 + this.HFEDeg, j - 1, 0, F2, cst);
        int k = this.KP + 1;
        while (k < this.HFEDeg) {
            table_cp.changeIndex(table, this.HFEDeg * this.NB_WORD_GFqn);
            table_cp.setRangeClear(0, this.POW_II * this.NB_WORD_GFqn);
            table_cp.copyFrom(this.POW_II * this.NB_WORD_GFqn, table, 0, this.HFEDeg * this.NB_WORD_GFqn);
            table.changeIndex(table_cp);
            this.divsqr_r_HFE_cstdeg_gf2nx(table, this.POW_II - 1 + this.HFEDeg, this.POW_II - 1, 0, F2, cst);
            ++k;
        }
        table.indexReset();
        Xqn.copyFrom(0, table, ((1 << this.HFEDegI) - this.KP) * this.HFEDeg * this.NB_WORD_GFqn, this.HFEDeg * this.NB_WORD_GFqn);
        int i = 0;
        while (i < (this.HFEn - this.HFEDegI - this.II) / this.II) {
            this.loop_sqr(Xqn_sqr, Xqn);
            j = 1;
            while (j < this.II) {
                this.loop_sqr(Xqn_sqr, Xqn_sqr);
                ++j;
            }
            current_coef.changeIndex(Xqn_sqr, this.KP * this.NB_WORD_GFqn);
            table_cp.changeIndex(table);
            Xqn_cp.changeIndex(Xqn);
            k = 0;
            while (k < this.HFEDeg) {
                this.mul_gf2n(Xqn_cp, table_cp, current_coef);
                Xqn_cp.move(this.NB_WORD_GFqn);
                table_cp.move(this.NB_WORD_GFqn);
                ++k;
            }
            j = this.KP + 1;
            while (j < this.HFEDeg) {
                current_coef.move(this.NB_WORD_GFqn);
                Xqn_cp.changeIndex(Xqn);
                k = 0;
                while (k < this.HFEDeg) {
                    this.mul_rem_xorrange(Xqn_cp, table_cp, current_coef);
                    Xqn_cp.move(this.NB_WORD_GFqn);
                    table_cp.move(this.NB_WORD_GFqn);
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < this.KP) {
                Xqn.setXorRange(j * this.POW_II * this.NB_WORD_GFqn, Xqn_sqr, j * this.NB_WORD_GFqn, this.NB_WORD_GFqn);
                ++j;
            }
            ++i;
        }
        this.for_sqr_divsqr(Xqn, 0, (this.HFEn - this.HFEDegI) % this.II, F2, cst);
    }

    private void for_sqr_divsqr(Pointer Xqn, int start, int end, SecretKeyHFE.complete_sparse_monic_gf2nx F2, Pointer cst) {
        int i = start;
        while (i < end) {
            this.sqr_gf2nx(Xqn, this.HFEDeg - 1);
            this.divsqr_r_HFE_cstdeg_gf2nx(Xqn, this.HFEDeg - 1 << 1, this.HFEDeg - 1 << 1, this.HFEDeg, F2, cst);
            ++i;
        }
    }

    private void loop_sqr(Pointer Xqn_sqr, Pointer Xqn) {
        int k = 0;
        while (k < this.HFEDeg) {
            this.sqr_gf2n(Xqn_sqr, k * this.NB_WORD_GFqn, Xqn, k * this.NB_WORD_GFqn);
            ++k;
        }
    }

    private void for_copy_move(Pointer table, SecretKeyHFE.complete_sparse_monic_gf2nx F2) {
        int i = 1;
        int shift = this.NB_WORD_GFqn;
        while (i < this.NB_COEFS_HFEPOLY) {
            table.move(F2.L[i]);
            table.copyFrom(0, F2.poly, i * this.NB_WORD_GFqn, this.NB_WORD_GFqn);
            ++i;
            shift += this.NB_WORD_GFqn;
        }
    }

    private void divsqr_r_HFE_cstdeg_gf2nx(Pointer poly, int idx, int start, int end, SecretKeyHFE.complete_sparse_monic_gf2nx F2, Pointer cst) {
        Pointer leading_coef = new Pointer(poly, idx * this.NB_WORD_GFqn);
        Pointer res = new Pointer();
        int j = start;
        while (j >= end) {
            res.changeIndex(leading_coef, -this.HFEDeg * this.NB_WORD_GFqn);
            this.mul_rem_xorrange(res, leading_coef, cst);
            int i = 1;
            while (i < this.NB_COEFS_HFEPOLY) {
                res.move(F2.L[i]);
                this.mul_rem_xorrange(res, leading_coef, F2.poly, i * this.NB_WORD_GFqn);
                ++i;
            }
            leading_coef.move(-this.NB_WORD_GFqn);
            --j;
        }
    }

    private void sqr_gf2nx(Pointer poly, int d) {
        int i = this.NB_WORD_GFqn * d;
        int poly_orig = poly.getIndex();
        poly.move(i);
        Pointer poly_2i = new Pointer(poly, i);
        i = 0;
        while (i < d) {
            this.sqr_gf2n(poly_2i, poly);
            poly.move(-this.NB_WORD_GFqn);
            poly_2i.move(-this.NB_WORD_GFqn);
            poly_2i.setRangeClear(0, this.NB_WORD_GFqn);
            poly_2i.move(-this.NB_WORD_GFqn);
            ++i;
        }
        this.sqr_gf2n(poly, poly);
        poly.changeIndex(poly_orig);
    }

    int div_r_gf2nx(Pointer A, int da, Pointer B, int db) {
        Pointer leading_coef = new Pointer(this.NB_WORD_GFqn);
        Pointer inv = new Pointer(this.NB_WORD_GFqn);
        Pointer res = new Pointer(A);
        this.inv_gf2n(inv, B, db * this.NB_WORD_GFqn);
        while (da >= db) {
            if ((da = A.searchDegree(da, db, this.NB_WORD_GFqn)) < db) break;
            res.changeIndex((da - db) * this.NB_WORD_GFqn);
            this.mul_gf2n(leading_coef, A, da * this.NB_WORD_GFqn, inv);
            this.for_mul_rem_xor_move(res, leading_coef, B, 0, db);
            --da;
        }
        da = A.searchDegree(da, 1, this.NB_WORD_GFqn);
        return da;
    }

    private void div_q_monic_gf2nx(Pointer A, int da, Pointer B, int db) {
        Pointer leading_coef = new Pointer();
        Pointer res = new Pointer();
        while (da >= db) {
            if ((da = A.searchDegree(da, db, this.NB_WORD_GFqn)) < db) break;
            leading_coef.changeIndex(A, da * this.NB_WORD_GFqn);
            int i = Math.max(0, (db << 1) - da);
            res.changeIndex(A, (da - db + i) * this.NB_WORD_GFqn);
            this.for_mul_rem_xor_move(res, leading_coef, B, i, db);
            --da;
        }
    }

    private int div_r_monic_gf2nx(Pointer A, int da, Pointer B, int db) {
        Pointer leading_coef = new Pointer();
        Pointer res = new Pointer();
        while (da >= db) {
            if ((da = A.searchDegree(da, db, this.NB_WORD_GFqn)) < db) break;
            leading_coef.changeIndex(A, da * this.NB_WORD_GFqn);
            res.changeIndex(leading_coef, -db * this.NB_WORD_GFqn);
            this.for_mul_rem_xor_move(res, leading_coef, B, 0, db);
            --da;
        }
        if (da == -1) {
            ++da;
        }
        da = A.searchDegree(da, 1, this.NB_WORD_GFqn);
        return da;
    }

    private void for_mul_rem_xor_move(Pointer res, Pointer leading_coef, Pointer B, int start, int end) {
        int i = start;
        int shift = start * this.NB_WORD_GFqn;
        while (i < end) {
            this.mul_rem_xorrange(res, leading_coef, B, shift);
            res.move(this.NB_WORD_GFqn);
            ++i;
            shift += this.NB_WORD_GFqn;
        }
    }

    private void inv_gf2n(Pointer res, Pointer A, int AOff) {
        int A_orig = A.getIndex();
        A.move(AOff);
        Pointer multi_sqr = new Pointer(this.NB_WORD_GFqn);
        res.copyFrom(A, this.NB_WORD_GFqn);
        int i = this.HFEn_1rightmost - 1;
        while (i != -1) {
            int nb_sqr = this.HFEn - 1 >>> i + 1;
            this.sqr_gf2n(multi_sqr, res);
            int j = 1;
            while (j < nb_sqr) {
                this.sqr_gf2n(multi_sqr, multi_sqr);
                ++j;
            }
            this.mul_gf2n(res, res, multi_sqr);
            if ((this.HFEn - 1 >>> i & 1) != 0) {
                this.sqr_gf2n(multi_sqr, res);
                this.mul_gf2n(res, A, multi_sqr);
            }
            --i;
        }
        this.sqr_gf2n(res, res);
        A.changeIndex(A_orig);
    }

    private void convMonic_gf2nx(Pointer F2, int d) {
        Pointer inv = new Pointer(this.NB_WORD_GFqn);
        int F_orig = F2.getIndex();
        F2.move(d * this.NB_WORD_GFqn);
        this.inv_gf2n(inv, F2, 0);
        F2.set1_gf2n(0, this.NB_WORD_GFqn);
        int i = d - 1;
        while (i != -1) {
            F2.move(-this.NB_WORD_GFqn);
            this.mul_gf2n(F2, F2, inv);
            --i;
        }
        F2.changeIndex(F_orig);
    }

    private void findRootsSplit_gf2nx(Pointer roots, Pointer f, int deg) {
        int b;
        int l;
        if (deg == 1) {
            roots.copyFrom(f, this.NB_WORD_GFqn);
            return;
        }
        if ((this.HFEn & 1) != 0 && deg == 2) {
            this.findRootsSplit2_HT_gf2nx(roots, f);
            return;
        }
        Pointer poly_frob = new Pointer(((deg << 1) - 1) * this.NB_WORD_GFqn);
        Pointer poly_trace = new Pointer(deg * this.NB_WORD_GFqn);
        Pointer f_cp = new Pointer((deg + 1) * this.NB_WORD_GFqn);
        Pointer inv = new Pointer(this.NB_WORD_GFqn);
        do {
            poly_frob.setRangeClear(0, ((deg << 1) - 1) * this.NB_WORD_GFqn);
            poly_trace.setRangeClear(0, deg * this.NB_WORD_GFqn);
            do {
                poly_trace.fillRandom(this.NB_WORD_GFqn, this.random, this.NB_BYTES_GFqn);
                poly_trace.setAnd((this.NB_WORD_GFqn << 1) - 1, this.MASK_GF2n);
            } while (poly_trace.is0_gf2n(this.NB_WORD_GFqn, this.NB_WORD_GFqn) != 0);
            f_cp.copyFrom(f, (deg + 1) * this.NB_WORD_GFqn);
            this.traceMap_gf2nx(poly_trace, poly_frob, f_cp, deg);
            int d = poly_trace.searchDegree(deg - 1, 1, this.NB_WORD_GFqn);
            l = this.gcd_gf2nx(f_cp, deg, poly_trace, d);
            b = this.buffer;
        } while (l == 0 || l == deg);
        if (b != 0) {
            poly_trace.swap(f_cp);
        }
        this.inv_gf2n(inv, f_cp, l * this.NB_WORD_GFqn);
        f_cp.set1_gf2n(l * this.NB_WORD_GFqn, this.NB_WORD_GFqn);
        this.for_mul(f_cp, inv, l - 1);
        this.div_q_monic_gf2nx(f, deg, f_cp, l);
        this.findRootsSplit_gf2nx(roots, f_cp, l);
        this.findRootsSplit_gf2nx(new Pointer(roots, l * this.NB_WORD_GFqn), new Pointer(f, l * this.NB_WORD_GFqn), deg - l);
    }

    void findRootsSplit2_HT_gf2nx(Pointer roots, Pointer f) {
        Pointer c = new Pointer(this.NB_WORD_GFqn);
        Pointer alpha = new Pointer(this.NB_WORD_GFqn);
        int f_orig = f.getIndex();
        this.sqr_gf2n(c, 0, f, this.NB_WORD_GFqn);
        this.inv_gf2n(roots, c, 0);
        this.mul_gf2n(c, f, roots);
        this.findRootsSplit_x2_x_c_HT_gf2nx(alpha, c);
        f.move(this.NB_WORD_GFqn);
        this.mul_gf2n(roots, alpha, f);
        roots.setRangeFromXor(this.NB_WORD_GFqn, roots, 0, f, 0, this.NB_WORD_GFqn);
        f.changeIndex(f_orig);
    }

    void findRootsSplit_x2_x_c_HT_gf2nx(Pointer root, Pointer c) {
        Pointer alpha = new Pointer(this.NB_WORD_GFqn);
        int e = this.HFEn + 1 >>> 1;
        root.copyFrom(c, this.NB_WORD_GFqn);
        int i = this.HFEn1h_rightmost;
        int e2 = 1;
        while (i != -1) {
            e2 <<= 1;
            this.sqr_gf2n(alpha, root);
            int j = 1;
            while (j < e2) {
                this.sqr_gf2n(alpha, alpha);
                ++j;
            }
            root.setXorRange(alpha, this.NB_WORD_GFqn);
            e2 = e >>> i;
            if ((e2 & 1) != 0) {
                this.sqr_gf2n(alpha, root);
                this.sqr_gf2n(root, alpha);
                root.setXorRange(c, this.NB_WORD_GFqn);
            }
            --i;
        }
    }

    private void traceMap_gf2nx(Pointer poly_trace, Pointer poly_frob, Pointer f, int deg) {
        int i = 1;
        while (1 << i < deg) {
            this.sqr_gf2n(poly_trace, this.NB_WORD_GFqn << i, poly_trace, this.NB_WORD_GFqn << i - 1);
            ++i;
        }
        if (i < this.HFEn) {
            this.sqr_gf2n(poly_frob, this.NB_WORD_GFqn << i, poly_trace, this.NB_WORD_GFqn << i - 1);
            this.div_r_monic_cst_gf2nx(poly_frob, 1 << i, f, deg);
            poly_trace.setXorRange(poly_frob, deg * this.NB_WORD_GFqn);
            ++i;
            while (i < this.HFEn) {
                this.sqr_gf2nx(poly_frob, deg - 1);
                this.div_r_monic_cst_gf2nx(poly_frob, deg - 1 << 1, f, deg);
                poly_trace.setXorRange(poly_frob, deg * this.NB_WORD_GFqn);
                ++i;
            }
        }
    }

    private void div_r_monic_cst_gf2nx(Pointer A, int da, Pointer B, int db) {
        Pointer res = new Pointer();
        int A_orig = A.getIndex();
        A.move(da * this.NB_WORD_GFqn);
        while (da >= db) {
            res.changeIndex(A, -db * this.NB_WORD_GFqn);
            this.for_mul_rem_xor_move(res, A, B, 0, db);
            A.move(-this.NB_WORD_GFqn);
            --da;
        }
        A.changeIndex(A_orig);
    }

    /*
     * Unable to fully structure code
     */
    void fast_sort_gf2n(Pointer tab, int l) {
        tmp = new Pointer(this.NB_WORD_GFqn);
        prod = new Pointer(this.NB_WORD_GFqn);
        tab_i = new Pointer();
        tab_ipa = new Pointer();
        pa = pow2_prev = GeMSSUtils.Highest_One(l - 1);
        while (pa > 1) {
            quo = l / (pa << 1);
            rem = Math.max(0, l - (pa << 1) * quo - pa);
            tab_i.changeIndex(tab);
            tab_ipa.changeIndex(tab, pa * this.NB_WORD_GFqn);
            i = 0;
            while (i < quo) {
                this.for_casct_move(tab_i, tab_ipa, prod, pa, 1);
                tab_i.move(pa * this.NB_WORD_GFqn);
                tab_ipa.move(pa * this.NB_WORD_GFqn);
                ++i;
            }
            this.for_casct_move(tab_i, tab_ipa, prod, rem, 1);
            pb = pow2_prev;
            i = 0;
            ** GOTO lbl30
            {
                if ((i & pa) == 0) {
                    tab_ipa.changeIndex(tab, (i + pa) * this.NB_WORD_GFqn);
                    this.copy_for_casct(tmp, tab_ipa, tab, tab_i, prod, pb, i);
                    tab_ipa.copyFrom(tmp, this.NB_WORD_GFqn);
                }
                ++i;
                do {
                    if (i < l - pb) continue block2;
                    pb >>>= 1;
lbl30:
                    // 2 sources

                } while (pb > pa);
            }
            pa >>>= 1;
        }
        tab_i.changeIndex(tab);
        tab_ipa.changeIndex(tab, this.NB_WORD_GFqn);
        this.for_casct_move(tab_i, tab_ipa, prod, l - 1, 2);
        tab_ipa.changeIndex(tab, this.NB_WORD_GFqn);
        pb = pow2_prev;
        i = 0;
        ** GOTO lbl47
        {
            this.copy_for_casct(tmp, tab_ipa, tab, tab_i, prod, pb, i);
            tab_ipa.copyFrom(tmp, this.NB_WORD_GFqn);
            tab_ipa.move(this.NB_WORD_GFqn << 1);
            i += 2;
            do {
                if (i < l - pb) continue block4;
                pb >>>= 1;
lbl47:
                // 2 sources

            } while (pb > 1);
        }
    }

    private void copy_for_casct(Pointer tmp, Pointer tab_ipa, Pointer tab, Pointer tab_i, Pointer prod, int pb, int i) {
        tmp.copyFrom(tab_ipa, this.NB_WORD_GFqn);
        int pc = pb;
        while (pc > 1) {
            tab_i.changeIndex(tab, (i + pc) * this.NB_WORD_GFqn);
            this.CMP_AND_SWAP_CST_TIME(tmp, tab_i, prod);
            pc >>>= 1;
        }
    }

    private void for_casct_move(Pointer tab_i, Pointer tab_ipa, Pointer prod, int len, int shift) {
        int move = this.NB_WORD_GFqn * shift;
        int j = 0;
        while (j < len) {
            this.CMP_AND_SWAP_CST_TIME(tab_i, tab_ipa, prod);
            tab_i.move(move);
            tab_ipa.move(move);
            j += shift;
        }
    }

    private void CMP_AND_SWAP_CST_TIME(Pointer tab, Pointer tab_j, Pointer prod) {
        long bo;
        int i = this.NB_WORD_GFqn - 1;
        long mask = 0L;
        long d = 0L;
        while (i > 0) {
            bo = tab_j.get(i) ^ tab.get(i);
            bo = GeMSSUtils.ORBITS_UINT(bo);
            d += (mask |= bo);
            --i;
        }
        i = 0;
        mask = 0L;
        while (i < this.NB_WORD_GFqn) {
            bo = (long)i ^ d;
            bo = GeMSSUtils.NORBITS_UINT(bo);
            mask |= -bo & GeMSSUtils.CMP_LT_UINT(tab_j.get(i), tab.get(i));
            ++i;
        }
        prod.setRangeFromXorAndMask_xor(tab, tab_j, -mask, this.NB_WORD_GFqn);
    }

    public void compress_signHFE(byte[] sm8, Pointer sm) {
        byte[] sm64 = sm.toBytes(sm.getLength() << 3);
        System.arraycopy(sm64, 0, sm8, 0, this.NB_BYTES_GFqnv);
        int nb_bits = this.HFEnv;
        int sm64_cp = (this.NB_WORD_GF2nv << 3) + (this.HFEmq8 & 7);
        int k1 = 1;
        while (k1 < this.NB_ITE) {
            int k2;
            int val_n = Math.min(this.HFEDELTA + this.HFEv, 8 - (nb_bits & 7) & 7);
            if ((nb_bits & 7) != 0) {
                if (this.HFEmr8 != 0) {
                    int n = nb_bits >>> 3;
                    sm8[n] = (byte)(sm8[n] ^ (sm64[sm64_cp] & 0xFF) >>> this.HFEmr8 << (nb_bits & 7));
                    int nb_rem = val_n - this.VAL_BITS_M;
                    if (nb_rem >= 0) {
                        ++sm64_cp;
                    }
                    if (nb_rem > 0) {
                        int n2 = (nb_bits += this.VAL_BITS_M) >>> 3;
                        sm8[n2] = (byte)(sm8[n2] ^ (sm64[sm64_cp] & 0xFF) << (nb_bits & 7));
                        nb_bits += nb_rem;
                    } else {
                        nb_bits += val_n;
                    }
                } else {
                    int n = nb_bits >>> 3;
                    sm8[n] = (byte)(sm8[n] ^ (sm64[sm64_cp] & 0xFF) << (nb_bits & 7));
                    nb_bits += val_n;
                }
            }
            int nb_rem2 = this.HFEDELTA + this.HFEv - val_n;
            int nb_rem_m = this.HFEm + val_n & 7;
            if (nb_rem_m != 0) {
                k2 = 0;
                while (k2 < nb_rem2 - 1 >>> 3) {
                    sm8[nb_bits >>> 3] = (byte)((sm64[sm64_cp] & 0xFF) >>> nb_rem_m ^ (sm64[++sm64_cp] & 0xFF) << 8 - nb_rem_m);
                    nb_bits += 8;
                    ++k2;
                }
                sm8[nb_bits >>> 3] = (byte)((sm64[sm64_cp++] & 0xFF) >>> nb_rem_m);
                if ((nb_rem2 = (nb_rem2 + 7 & 7) + 1) > 8 - nb_rem_m) {
                    int n = nb_bits >>> 3;
                    sm8[n] = (byte)(sm8[n] ^ (byte)((sm64[sm64_cp++] & 0xFF) << 8 - nb_rem_m));
                }
                nb_bits += nb_rem2;
            } else {
                k2 = 0;
                while (k2 < nb_rem2 + 7 >>> 3) {
                    sm8[nb_bits >>> 3] = sm64[sm64_cp++];
                    nb_bits += 8;
                    ++k2;
                }
                nb_bits -= 8 - (nb_rem2 & 7) & 7;
            }
            sm64_cp += (8 - (this.NB_BYTES_GFqnv & 7) & 7) + (this.HFEmq8 & 7);
            ++k1;
        }
    }

    void convMQS_one_to_last_mr8_equations_gf2(byte[] pk_U, PointerUnion pk_cp) {
        int pk_U_cp = 0;
        pk_cp.moveNextBytes(this.HFEmq8);
        PointerUnion pk_cp2 = new PointerUnion(pk_cp);
        int HFENq8 = this.NB_MONOMIAL_PK >>> 3;
        int ir = 0;
        while (ir < this.HFEmr8) {
            int jr;
            pk_cp2.changeIndex(pk_cp);
            int jq = 0;
            while (jq < HFENq8) {
                int tmp = pk_cp2.getByte() >>> ir & 1;
                pk_cp2.moveNextBytes(this.NB_BYTES_GFqm);
                jr = 1;
                while (jr < 8) {
                    tmp ^= (pk_cp2.getByte() >>> ir & 1) << jr;
                    pk_cp2.moveNextBytes(this.NB_BYTES_GFqm);
                    ++jr;
                }
                pk_U[pk_U_cp++] = (byte)tmp;
                ++jq;
            }
            if (this.HFENr8 != 0) {
                long tmp1 = pk_cp2.getWithCheck() >>> ir & 1L;
                pk_cp2.moveNextBytes(this.NB_BYTES_GFqm);
                jr = 1;
                while (jr < this.HFENr8) {
                    tmp1 ^= (pk_cp2.getWithCheck() >>> ir & 1L) << jr;
                    pk_cp2.moveNextBytes(this.NB_BYTES_GFqm);
                    ++jr;
                }
                pk_U[pk_U_cp++] = (byte)tmp1;
            }
            ++ir;
        }
    }

    void convMQ_UL_gf2(byte[] pk, byte[] pk_U, int end) {
        int j = 0;
        while (j < end) {
            int pk_p = this.ACCESS_last_equations8 + j * this.NB_BYTES_EQUATION;
            int pk_U_cp = j * this.NB_BYTES_EQUATION;
            this.for_setPK(pk, pk_U, pk_p, pk_U_cp, this.HFEnv + 1);
            ++j;
        }
    }

    private int for_setPK(byte[] pk, byte[] pk_U, int pk_p, int pk_U_cp, int end) {
        pk[pk_p] = (byte)(pk_U[pk_U_cp] & 3);
        int k = 2;
        int i = 2;
        while (i < end) {
            k = this.setPK(pk, pk_U, i, pk_p, pk_U_cp, k, this.HFEnv - 1, this.HFEnv - i);
            ++i;
        }
        return k;
    }

    private int setPK(byte[] pk, byte[] pk_U, int nb_bits, int pk_p, int pk_U_cp, int k, int start, int end) {
        int j = start;
        while (j >= end) {
            int n = pk_p + (k >>> 3);
            pk[n] = (byte)(pk[n] ^ (pk_U[pk_U_cp + (nb_bits >>> 3)] >>> (nb_bits & 7) & 1) << (k & 7));
            nb_bits += j;
            --j;
            ++k;
        }
        this.buffer = nb_bits;
        return k;
    }

    void convMQS_one_eq_to_hybrid_rep8_comp_gf2(byte[] pk, PointerUnion pk_cp, byte[] pk_U) {
        int pk_p = 0;
        this.convMQ_UL_gf2(pk, pk_U, this.HFEmr8);
        int i = 0;
        while (i < this.NB_MONOMIAL_PK) {
            pk_p = pk_cp.toBytesMove(pk, pk_p, this.HFEmq8);
            if (this.HFEmr8 != 0) {
                pk_cp.moveNextByte();
            }
            ++i;
        }
    }

    void convMQS_one_eq_to_hybrid_rep8_uncomp_gf2(byte[] pk, PointerUnion pk_cp, byte[] pk_U) {
        int j = this.HFEmr8 - 1;
        long val = 0L;
        this.convMQ_UL_gf2(pk, pk_U, j);
        int pk2_cp = this.ACCESS_last_equations8 + j * this.NB_BYTES_EQUATION;
        int pk_U_cp = j * this.NB_BYTES_EQUATION;
        int k = this.for_setPK(pk, pk_U, pk2_cp, pk_U_cp, this.HFEnv);
        int nb_bits = this.HFEnv;
        k = this.setPK(pk, pk_U, nb_bits, pk2_cp, pk_U_cp, k, this.HFEnv - 1, this.LOST_BITS);
        j = this.LOST_BITS - 1;
        nb_bits = this.buffer;
        while (j >= 0) {
            val ^= (long)(pk_U[pk_U_cp + (nb_bits >>> 3)] >>> (nb_bits & 7) & 1) << this.LOST_BITS - 1 - j;
            nb_bits += j;
            --j;
            ++k;
        }
        pk2_cp = this.ACCESS_last_equations8 - 1;
        j = 0;
        while (j < this.HFEmr8 - 1) {
            int n = pk2_cp += this.NB_BYTES_EQUATION;
            pk[n] = (byte)(pk[n] ^ (byte)(val >>> j * this.HFENr8c) << this.HFENr8);
            ++j;
        }
        pk_cp.indexReset();
        int i = 0;
        pk2_cp = 0;
        while (i < this.NB_MONOMIAL_PK) {
            pk2_cp = pk_cp.toBytesMove(pk, pk2_cp, this.HFEmq8);
            pk_cp.moveNextByte();
            ++i;
        }
    }

    public int crypto_sign_open(byte[] PK2, byte[] message, byte[] signature) {
        int i;
        PointerUnion pk = new PointerUnion(PK2);
        long val = 0L;
        if (this.HFENr8 != 0 && this.HFEmr8 > 1) {
            PointerUnion pk_cp = new PointerUnion(pk);
            pk_cp.moveNextBytes(this.ACCESS_last_equations8 - 1);
            i = 0;
            while (i < this.HFEmr8 - 1) {
                pk_cp.moveNextBytes(this.NB_BYTES_EQUATION);
                val ^= ((long)pk_cp.getByte() & 0xFFL) >>> this.HFENr8 << i * this.HFENr8c;
                ++i;
            }
        }
        if (this.HFEmr8 != 0) {
            Pointer pk_tmp = new Pointer(1 + this.NB_WORD_UNCOMP_EQ * this.HFEmr8);
            long cst = 0L;
            PointerUnion pk64 = new PointerUnion(pk);
            i = 0;
            while (i < this.HFEmr8 - 1) {
                pk64.setByteIndex(this.ACCESS_last_equations8 + i * this.NB_BYTES_EQUATION);
                cst ^= this.convMQ_uncompressL_gf2(new Pointer(pk_tmp, 1 + i * this.NB_WORD_UNCOMP_EQ), pk64) << i;
                ++i;
            }
            pk64.setByteIndex(this.ACCESS_last_equations8 + i * this.NB_BYTES_EQUATION);
            cst ^= this.convMQ_last_uncompressL_gf2(new Pointer(pk_tmp, 1 + i * this.NB_WORD_UNCOMP_EQ), pk64) << i;
            if (this.HFENr8 != 0) {
                if (this.HFEnvr == 0) {
                    pk_tmp.setXor((i + 1) * this.NB_WORD_UNCOMP_EQ, val << 64 - this.LOST_BITS);
                } else if (this.HFEnvr > this.LOST_BITS) {
                    pk_tmp.setXor((i + 1) * this.NB_WORD_UNCOMP_EQ, val << this.HFEnvr - this.LOST_BITS);
                } else if (this.HFEnvr == this.LOST_BITS) {
                    pk_tmp.set((i + 1) * this.NB_WORD_UNCOMP_EQ, val);
                } else {
                    pk_tmp.setXor((i + 1) * this.NB_WORD_UNCOMP_EQ - 1, val << 64 - (this.LOST_BITS - this.HFEnvr));
                    pk_tmp.set((i + 1) * this.NB_WORD_UNCOMP_EQ, val >>> this.LOST_BITS - this.HFEnvr);
                }
            }
            pk_tmp.set(cst << this.HFEmr - this.HFEmr8);
            return this.sign_openHFE_huncomp_pk(message, message.length, signature, pk, new PointerUnion(pk_tmp));
        }
        Pointer sm = new Pointer(this.SIZE_SIGN_UNCOMPRESSED);
        Pointer Si_tab = new Pointer(this.NB_WORD_GF2nv);
        Pointer Si = new Pointer(Si_tab);
        Pointer D = new Pointer(this.SIZE_DIGEST_UINT);
        sm.fill(0, signature, 0, this.NB_BYTES_GFqnv);
        byte[] hashbuffer = new byte[64];
        this.getSHA3Hash(D, 0, 64, message, 0, message.length, hashbuffer);
        this.evalMQSnocst8_quo_gf2(Si, sm, pk);
        return Si.isEqual_nocst_gf2(D, this.NB_WORD_GF2m);
    }

    void changeVariablesMQS64_gf2(Pointer MQS, Pointer S) {
        int jr;
        int iq;
        Pointer MQS_cpj = new Pointer();
        Pointer MQS2 = new Pointer(this.HFEnv * this.HFEnv * this.NB_WORD_GFqn);
        Pointer MQS_cpi = new Pointer(MQS, this.NB_WORD_GFqn);
        Pointer MQS2_cp = new Pointer(MQS2);
        Pointer S_cpj = new Pointer(S);
        int j = 0;
        while (j < this.HFEnv) {
            int ir;
            MQS_cpj.changeIndex(MQS_cpi);
            iq = 0;
            while (iq < this.HFEnvq) {
                ir = 0;
                while (ir < 64) {
                    this.LOOPKR(MQS_cpj, MQS2_cp, S_cpj.get() >>> ir, ir, 64);
                    this.LOOPK_COMPLETE(MQS2_cp, S_cpj, MQS_cpj, 1, this.HFEnvq - iq);
                    ++ir;
                }
                S_cpj.moveIncremental();
                ++iq;
            }
            if (this.HFEnvr != 0) {
                ir = 0;
                while (ir < this.HFEnvr) {
                    this.LOOPKR(MQS_cpj, MQS2_cp, S_cpj.get() >>> ir, ir, this.HFEnvr);
                    MQS2_cp.move(this.NB_WORD_GFqn);
                    ++ir;
                }
                S_cpj.moveIncremental();
            }
            ++j;
        }
        MQS_cpi.changeIndex(MQS2);
        MQS2_cp.changeIndex(MQS, this.NB_WORD_GFqn);
        Pointer S_cpi = new Pointer(S);
        int jq = 0;
        while (jq < this.HFEnvq) {
            jr = 0;
            while (jr < 64) {
                S_cpj.changeIndex(S_cpi);
                this.LOOPIR_INIT(MQS2_cp, MQS_cpj, MQS_cpi, S_cpj, jr, 64);
                iq = jq + 1;
                while (iq < this.HFEnvq) {
                    this.LOOPIR_INIT(MQS2_cp, MQS_cpj, MQS_cpi, S_cpj, 0, 64);
                    ++iq;
                }
                if (this.HFEnvr != 0) {
                    this.LOOPIR_INIT(MQS2_cp, MQS_cpj, MQS_cpi, S_cpj, 0, this.HFEnvr);
                }
                MQS_cpi.changeIndex(MQS_cpj);
                S_cpi.move(this.NB_WORD_GF2nv);
                ++jr;
            }
            ++jq;
        }
        if (this.HFEnvr != 0) {
            jr = 0;
            while (jr < this.HFEnvr) {
                S_cpj.changeIndex(S_cpi);
                MQS_cpj.changeIndex(MQS_cpi);
                this.LOOPIR_INIT(MQS2_cp, MQS_cpj, MQS_cpi, S_cpj, jr, this.HFEnvr);
                MQS_cpi.changeIndex(MQS_cpj);
                S_cpi.move(this.NB_WORD_GF2nv);
                ++jr;
            }
        }
        MQS_cpi.changeIndex(MQS2);
        MQS2_cp.changeIndex(MQS, this.NB_WORD_GFqn);
        S_cpj.changeIndex(S);
        jq = 0;
        while (jq < this.HFEnvq) {
            jr = 0;
            while (jr < 64) {
                MQS2_cp.move(this.NB_WORD_GFqn);
                MQS_cpi.move(this.HFEnv * this.NB_WORD_GFqn);
                MQS_cpj.changeIndex(MQS_cpi);
                this.LOOPIR_LOOPK_COMPLETE(MQS2_cp, S_cpj, MQS_cpj, jr + 1, 64);
                iq = jq + 1;
                while (iq < this.HFEnvq) {
                    this.LOOPIR_LOOPK_COMPLETE(MQS2_cp, S_cpj, MQS_cpj, 0, 64);
                    ++iq;
                }
                if (this.HFEnvr != 0) {
                    this.LOOPIR_LOOPK_COMPLETE(MQS2_cp, S_cpj, MQS_cpj, 0, this.HFEnvr);
                }
                S_cpj.move(this.NB_WORD_GF2nv);
                ++jr;
            }
            ++jq;
        }
        if (this.HFEnvr != 0) {
            jr = 0;
            while (jr < this.HFEnvr - 1) {
                MQS2_cp.move(this.NB_WORD_GFqn);
                MQS_cpi.move(this.HFEnv * this.NB_WORD_GFqn);
                MQS_cpj.changeIndex(MQS_cpi);
                this.LOOPIR_LOOPK_COMPLETE(MQS2_cp, S_cpj, MQS_cpj, jr + 1, this.HFEnvr);
                S_cpj.move(this.NB_WORD_GF2nv);
                ++jr;
            }
        }
        MQS.indexReset();
        S.indexReset();
    }

    private void LOOPIR_INIT(Pointer MQS2_cp, Pointer MQS_cpj, Pointer MQS_cpi, Pointer S_cpj, int STARTIR, int NB_ITIR) {
        int ir = STARTIR;
        while (ir < NB_ITIR) {
            MQS2_cp.setRangeClear(0, this.NB_WORD_GFqn);
            MQS_cpj.changeIndex(MQS_cpi);
            this.LOOPK_COMPLETE(MQS2_cp, S_cpj, MQS_cpj, 0, this.HFEnvq);
            S_cpj.move(this.NB_WORD_GF2nv);
            ++ir;
        }
    }

    private void LOOPIR_LOOPK_COMPLETE(Pointer MQS2_cp, Pointer S_cpj, Pointer MQS_cpj, int STARTIR, int NB_ITIR) {
        int ir = STARTIR;
        while (ir < NB_ITIR) {
            this.LOOPK_COMPLETE(MQS2_cp, S_cpj, MQS_cpj, 0, this.HFEnvq);
            ++ir;
        }
    }

    private void LOOPK_COMPLETE(Pointer MQS2_cp, Pointer S_cpj, Pointer MQS_cpj, int start, int end) {
        int kq = start;
        while (kq < end) {
            this.LOOPKR(MQS_cpj, MQS2_cp, S_cpj.get(kq), 0, 64);
            ++kq;
        }
        if (this.HFEnvr != 0) {
            this.LOOPKR(MQS_cpj, MQS2_cp, S_cpj.get(end), 0, this.HFEnvr);
        }
        MQS2_cp.move(this.NB_WORD_GFqn);
    }

    private void LOOPKR(Pointer MQS_cpj, Pointer MQS2_cp, long bit_kr, int START, int NB_IT) {
        int kr = START;
        while (kr < NB_IT) {
            MQS2_cp.setXorRangeAndMaskMove(MQS_cpj, this.NB_WORD_GFqn, -(bit_kr & 1L));
            bit_kr >>>= 1;
            ++kr;
        }
    }

    int interpolateHFE_FS_ref(Pointer MQS, Pointer F2, Pointer S) {
        Pointer e_ijS = new Pointer(this.NB_WORD_GF2nv);
        Pointer tab_eval_i2 = new Pointer();
        Pointer e_i2S = new Pointer();
        Pointer tab_eval = new Pointer(this.HFEnv * this.NB_WORD_GFqn);
        MQS.copyFrom(F2, this.NB_WORD_GFqn);
        Pointer e_iS = new Pointer(S);
        Pointer tab_eval_i = new Pointer(tab_eval);
        int i = 0;
        while (i < this.HFEnv) {
            this.evalHFEv_gf2nx(tab_eval_i, F2, e_iS);
            tab_eval_i.move(this.NB_WORD_GFqn);
            e_iS.move(this.NB_WORD_GF2nv);
            ++i;
        }
        e_iS.changeIndex(S);
        tab_eval_i.changeIndex(tab_eval);
        i = 0;
        while (i < this.HFEnv) {
            MQS.move(this.NB_WORD_GFqn);
            tab_eval_i.setXorRange(F2, this.NB_WORD_GFqn);
            MQS.copyFrom(tab_eval_i, this.NB_WORD_GFqn);
            tab_eval_i2.changeIndex(tab_eval_i);
            e_i2S.changeIndex(e_iS);
            int i2 = i + 1;
            while (i2 < this.HFEnv) {
                MQS.move(this.NB_WORD_GFqn);
                tab_eval_i2.move(this.NB_WORD_GFqn);
                e_i2S.move(this.NB_WORD_GF2nv);
                e_ijS.setRangeFromXor(e_iS, e_i2S, this.NB_WORD_GF2nv);
                this.evalHFEv_gf2nx(MQS, F2, e_ijS);
                MQS.setXorRangeXor(0, tab_eval_i, 0, tab_eval_i2, 0, this.NB_WORD_GFqn);
                ++i2;
            }
            tab_eval_i.move(this.NB_WORD_GFqn);
            e_iS.move(this.NB_WORD_GF2nv);
            ++i;
        }
        MQS.indexReset();
        return 0;
    }

    void evalHFEv_gf2nx(Pointer Fxv, Pointer F2, Pointer xv) {
        Pointer cur_acc = new Pointer(this.NB_WORD_MUL);
        Pointer acc = new Pointer(this.NB_WORD_MUL);
        Pointer tab_Xqj = new Pointer((this.HFEDegI + 1) * this.NB_WORD_GFqn);
        Pointer tab_Xqj_cp2 = new Pointer();
        int F_orig = F2.getIndex();
        Pointer V = new Pointer(this.NB_WORD_GFqv);
        Pointer tab_Xqj_cp = new Pointer(tab_Xqj, this.NB_WORD_GFqn);
        tab_Xqj.copyFrom(xv, this.NB_WORD_GFqn);
        tab_Xqj.setAnd(this.NB_WORD_GFqn - 1, this.MASK_GF2n);
        int j = 1;
        while (j <= this.HFEDegI) {
            this.sqr_gf2n(tab_Xqj_cp, 0, tab_Xqj_cp, -this.NB_WORD_GFqn);
            tab_Xqj_cp.move(this.NB_WORD_GFqn);
            ++j;
        }
        int endloop = this.NB_WORD_GFqn + this.NB_WORD_GFqv == this.NB_WORD_GF2nv ? this.NB_WORD_GFqv : this.NB_WORD_GFqv - 1;
        V.setRangeRotate(0, xv, this.NB_WORD_GFqn - 1, endloop, 64 - this.HFEnr);
        if (this.NB_WORD_GFqn + this.NB_WORD_GFqv != this.NB_WORD_GF2nv) {
            V.set(endloop, xv.get(this.NB_WORD_GFqn - 1 + endloop) >>> this.HFEnr);
        }
        this.evalMQSv_unrolled_gf2(cur_acc, V, F2);
        F2.move(this.MQv_GFqn_SIZE);
        this.vmpv_xorrange_move(acc, V, F2);
        tab_Xqj_cp.changeIndex(tab_Xqj);
        this.mul_xorrange(cur_acc, tab_Xqj_cp, acc);
        j = 1;
        while (j < this.HFEDegI) {
            this.vmpv_xorrange_move(acc, V, F2);
            acc.setRangeClear(this.NB_WORD_GFqn, this.NB_WORD_MMUL - this.NB_WORD_GFqn);
            tab_Xqj_cp2.changeIndex(tab_Xqj_cp);
            this.for_mul_xorrange_move(acc, F2, tab_Xqj_cp2, j);
            this.rem_gf2n(acc, 0, acc);
            this.mul_xorrange(cur_acc, tab_Xqj_cp2, acc);
            ++j;
        }
        this.vmpv_xorrange_move(acc, V, F2);
        tab_Xqj_cp2.changeIndex(tab_Xqj_cp);
        if (this.HFEDegJ != 0) {
            acc.setRangeClear(this.NB_WORD_GFqn, this.NB_WORD_MMUL - this.NB_WORD_GFqn);
            this.for_mul_xorrange_move(acc, F2, tab_Xqj_cp2, this.HFEDegJ);
            acc.setXorRange(tab_Xqj_cp2, this.NB_WORD_GFqn);
            this.rem_gf2n(acc, 0, acc);
        } else {
            acc.setRangeFromXor(acc, tab_Xqj_cp2, this.NB_WORD_GFqn);
        }
        tab_Xqj_cp.move(this.HFEDegI * this.NB_WORD_GFqn);
        this.mul_xorrange(cur_acc, tab_Xqj_cp, acc);
        this.rem_gf2n(Fxv, 0, cur_acc);
        F2.changeIndex(F_orig);
    }

    private void vmpv_xorrange_move(Pointer acc, Pointer V, Pointer F2) {
        this.vecMatProduct(acc, V, new Pointer(F2, this.NB_WORD_GFqn), FunctionParams.V);
        acc.setXorRange(F2, this.NB_WORD_GFqn);
        F2.move(this.MLv_GFqn_SIZE);
    }

    private static long remainderUnsigned(long dividend, long divisor) {
        if (dividend > 0L && divisor > 0L) {
            return dividend % divisor;
        }
        return new BigInteger(1, Pack.longToBigEndian(dividend)).mod(new BigInteger(1, Pack.longToBigEndian(divisor))).longValue();
    }

    static enum FunctionParams {
        NV,
        V,
        N,
        M;

    }
}

