/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

class PolyVecK {
    Poly[] vec;
    private MLDSAEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumK;
    private int dilithiumL;

    public PolyVecK(MLDSAEngine engine) {
        this.engine = engine;
        this.mode = engine.getDilithiumMode();
        this.dilithiumK = engine.getDilithiumK();
        this.dilithiumL = engine.getDilithiumL();
        this.vec = new Poly[this.dilithiumK];
        int i = 0;
        while (i < this.dilithiumK) {
            this.vec[i] = new Poly(engine);
            ++i;
        }
    }

    public PolyVecK() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int i) {
        return this.vec[i];
    }

    public void setVectorIndex(int i, Poly p) {
        this.vec[i] = p;
    }

    public void uniformEta(byte[] seed, short nonce) {
        short n = nonce;
        int i = 0;
        while (i < this.dilithiumK) {
            short s = n;
            n = (short)(s + 1);
            this.getVectorIndex(i).uniformEta(seed, s);
            ++i;
        }
    }

    public void reduce() {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).reduce();
            ++i;
        }
    }

    public void invNttToMont() {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).invNttToMont();
            ++i;
        }
    }

    public void addPolyVecK(PolyVecK b) {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).addPoly(b.getVectorIndex(i));
            ++i;
        }
    }

    public void conditionalAddQ() {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).conditionalAddQ();
            ++i;
        }
    }

    public void power2Round(PolyVecK pvk) {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).power2Round(pvk.getVectorIndex(i));
            ++i;
        }
    }

    public void polyVecNtt() {
        int i = 0;
        while (i < this.dilithiumK) {
            this.vec[i].polyNtt();
            ++i;
        }
    }

    public void decompose(PolyVecK v) {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).decompose(v.getVectorIndex(i));
            ++i;
        }
    }

    public byte[] packW1() {
        byte[] out = new byte[this.dilithiumK * this.engine.getDilithiumPolyW1PackedBytes()];
        int i = 0;
        while (i < this.dilithiumK) {
            System.arraycopy(this.getVectorIndex(i).w1Pack(), 0, out, i * this.engine.getDilithiumPolyW1PackedBytes(), this.engine.getDilithiumPolyW1PackedBytes());
            ++i;
        }
        return out;
    }

    public void pointwisePolyMontgomery(Poly a, PolyVecK v) {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).pointwiseMontgomery(a, v.getVectorIndex(i));
            ++i;
        }
    }

    public void subtract(PolyVecK inpVec) {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).subtract(inpVec.getVectorIndex(i));
            ++i;
        }
    }

    public boolean checkNorm(int bound) {
        int i = 0;
        while (i < this.dilithiumK) {
            if (this.getVectorIndex(i).checkNorm(bound)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int makeHint(PolyVecK v0, PolyVecK v1) {
        int s = 0;
        int i = 0;
        while (i < this.dilithiumK) {
            s += this.getVectorIndex(i).polyMakeHint(v0.getVectorIndex(i), v1.getVectorIndex(i));
            ++i;
        }
        return s;
    }

    public void useHint(PolyVecK u, PolyVecK h) {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).polyUseHint(u.getVectorIndex(i), h.getVectorIndex(i));
            ++i;
        }
    }

    public void shiftLeft() {
        int i = 0;
        while (i < this.dilithiumK) {
            this.getVectorIndex(i).shiftLeft();
            ++i;
        }
    }

    public String toString() {
        String out = "[";
        int i = 0;
        while (i < this.dilithiumK) {
            out = String.valueOf(out) + i + " " + this.getVectorIndex(i).toString();
            if (i != this.dilithiumK - 1) {
                out = String.valueOf(out) + ",\n";
            }
            ++i;
        }
        out = String.valueOf(out) + "]";
        return out;
    }

    public String toString(String name) {
        return String.valueOf(name) + ": " + this.toString();
    }
}

