/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mlkem;

import org.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import org.bouncycastle.pqc.crypto.mlkem.Poly;
import org.bouncycastle.util.Arrays;

class PolyVec {
    Poly[] vec;
    private MLKEMEngine engine;
    private int kyberK;
    private int polyVecBytes;

    public PolyVec(MLKEMEngine engine) {
        this.engine = engine;
        this.kyberK = engine.getKyberK();
        this.polyVecBytes = engine.getKyberPolyVecBytes();
        this.vec = new Poly[this.kyberK];
        int i = 0;
        while (i < this.kyberK) {
            this.vec[i] = new Poly(engine);
            ++i;
        }
    }

    public PolyVec() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int i) {
        return this.vec[i];
    }

    public void polyVecNtt() {
        int i = 0;
        while (i < this.kyberK) {
            this.getVectorIndex(i).polyNtt();
            ++i;
        }
    }

    public void polyVecInverseNttToMont() {
        int i = 0;
        while (i < this.kyberK) {
            this.getVectorIndex(i).polyInverseNttToMont();
            ++i;
        }
    }

    public byte[] compressPolyVec() {
        this.conditionalSubQ();
        byte[] r = new byte[this.engine.getKyberPolyVecCompressedBytes()];
        int count = 0;
        if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 320) {
            short[] t = new short[4];
            int i = 0;
            while (i < this.kyberK) {
                int j = 0;
                while (j < 64) {
                    int k = 0;
                    while (k < 4) {
                        long t_k = this.getVectorIndex(i).getCoeffIndex(4 * j + k);
                        t_k <<= 10;
                        t_k += 1665L;
                        t_k *= 1290167L;
                        t_k >>= 32;
                        t[k] = (short)(t_k &= 0x3FFL);
                        ++k;
                    }
                    r[count + 0] = (byte)(t[0] >> 0);
                    r[count + 1] = (byte)(t[0] >> 8 | t[1] << 2);
                    r[count + 2] = (byte)(t[1] >> 6 | t[2] << 4);
                    r[count + 3] = (byte)(t[2] >> 4 | t[3] << 6);
                    r[count + 4] = (byte)(t[3] >> 2);
                    count += 5;
                    ++j;
                }
                ++i;
            }
        } else if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 352) {
            short[] t = new short[8];
            int i = 0;
            while (i < this.kyberK) {
                int j = 0;
                while (j < 32) {
                    int k = 0;
                    while (k < 8) {
                        long t_k = this.getVectorIndex(i).getCoeffIndex(8 * j + k);
                        t_k <<= 11;
                        t_k += 1664L;
                        t_k *= 645084L;
                        t_k >>= 31;
                        t[k] = (short)(t_k &= 0x7FFL);
                        ++k;
                    }
                    r[count + 0] = (byte)(t[0] >> 0);
                    r[count + 1] = (byte)(t[0] >> 8 | t[1] << 3);
                    r[count + 2] = (byte)(t[1] >> 5 | t[2] << 6);
                    r[count + 3] = (byte)(t[2] >> 2);
                    r[count + 4] = (byte)(t[2] >> 10 | t[3] << 1);
                    r[count + 5] = (byte)(t[3] >> 7 | t[4] << 4);
                    r[count + 6] = (byte)(t[4] >> 4 | t[5] << 7);
                    r[count + 7] = (byte)(t[5] >> 1);
                    r[count + 8] = (byte)(t[5] >> 9 | t[6] << 2);
                    r[count + 9] = (byte)(t[6] >> 6 | t[7] << 5);
                    r[count + 10] = (byte)(t[7] >> 3);
                    count += 11;
                    ++j;
                }
                ++i;
            }
        } else {
            throw new RuntimeException("Kyber PolyVecCompressedBytes neither 320 * KyberK or 352 * KyberK!");
        }
        return r;
    }

    public void decompressPolyVec(byte[] compressedPolyVecCipherText) {
        int count = 0;
        if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 320) {
            short[] t = new short[4];
            int i = 0;
            while (i < this.kyberK) {
                int j = 0;
                while (j < 64) {
                    t[0] = (short)((compressedPolyVecCipherText[count] & 0xFF) >> 0 | (short)((compressedPolyVecCipherText[count + 1] & 0xFF) << 8));
                    t[1] = (short)((compressedPolyVecCipherText[count + 1] & 0xFF) >> 2 | (short)((compressedPolyVecCipherText[count + 2] & 0xFF) << 6));
                    t[2] = (short)((compressedPolyVecCipherText[count + 2] & 0xFF) >> 4 | (short)((compressedPolyVecCipherText[count + 3] & 0xFF) << 4));
                    t[3] = (short)((compressedPolyVecCipherText[count + 3] & 0xFF) >> 6 | (short)((compressedPolyVecCipherText[count + 4] & 0xFF) << 2));
                    count += 5;
                    int k = 0;
                    while (k < 4) {
                        this.vec[i].setCoeffIndex(4 * j + k, (short)((t[k] & 0x3FF) * 3329 + 512 >> 10));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (this.engine.getKyberPolyVecCompressedBytes() == this.kyberK * 352) {
            short[] t = new short[8];
            int i = 0;
            while (i < this.kyberK) {
                int j = 0;
                while (j < 32) {
                    t[0] = (short)((compressedPolyVecCipherText[count] & 0xFF) >> 0 | (short)(compressedPolyVecCipherText[count + 1] & 0xFF) << 8);
                    t[1] = (short)((compressedPolyVecCipherText[count + 1] & 0xFF) >> 3 | (short)(compressedPolyVecCipherText[count + 2] & 0xFF) << 5);
                    t[2] = (short)((compressedPolyVecCipherText[count + 2] & 0xFF) >> 6 | (short)(compressedPolyVecCipherText[count + 3] & 0xFF) << 2 | (short)((compressedPolyVecCipherText[count + 4] & 0xFF) << 10));
                    t[3] = (short)((compressedPolyVecCipherText[count + 4] & 0xFF) >> 1 | (short)(compressedPolyVecCipherText[count + 5] & 0xFF) << 7);
                    t[4] = (short)((compressedPolyVecCipherText[count + 5] & 0xFF) >> 4 | (short)(compressedPolyVecCipherText[count + 6] & 0xFF) << 4);
                    t[5] = (short)((compressedPolyVecCipherText[count + 6] & 0xFF) >> 7 | (short)(compressedPolyVecCipherText[count + 7] & 0xFF) << 1 | (short)((compressedPolyVecCipherText[count + 8] & 0xFF) << 9));
                    t[6] = (short)((compressedPolyVecCipherText[count + 8] & 0xFF) >> 2 | (short)(compressedPolyVecCipherText[count + 9] & 0xFF) << 6);
                    t[7] = (short)((compressedPolyVecCipherText[count + 9] & 0xFF) >> 5 | (short)(compressedPolyVecCipherText[count + 10] & 0xFF) << 3);
                    count += 11;
                    int k = 0;
                    while (k < 8) {
                        this.vec[i].setCoeffIndex(8 * j + k, (short)((t[k] & 0x7FF) * 3329 + 1024 >> 11));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            throw new RuntimeException("Kyber PolyVecCompressedBytes neither 320 * KyberK or 352 * KyberK!");
        }
    }

    public static void pointwiseAccountMontgomery(Poly out, PolyVec inp1, PolyVec inp2, MLKEMEngine engine) {
        Poly t = new Poly(engine);
        Poly.baseMultMontgomery(out, inp1.getVectorIndex(0), inp2.getVectorIndex(0));
        int i = 1;
        while (i < engine.getKyberK()) {
            Poly.baseMultMontgomery(t, inp1.getVectorIndex(i), inp2.getVectorIndex(i));
            out.addCoeffs(t);
            ++i;
        }
        out.reduce();
    }

    public void reducePoly() {
        int i = 0;
        while (i < this.kyberK) {
            this.getVectorIndex(i).reduce();
            ++i;
        }
    }

    public void addPoly(PolyVec b) {
        int i = 0;
        while (i < this.kyberK) {
            this.getVectorIndex(i).addCoeffs(b.getVectorIndex(i));
            ++i;
        }
    }

    public byte[] toBytes() {
        byte[] r = new byte[this.polyVecBytes];
        int i = 0;
        while (i < this.kyberK) {
            System.arraycopy(this.vec[i].toBytes(), 0, r, i * 384, 384);
            ++i;
        }
        return r;
    }

    public void fromBytes(byte[] inputBytes) {
        int i = 0;
        while (i < this.kyberK) {
            this.getVectorIndex(i).fromBytes(Arrays.copyOfRange(inputBytes, i * 384, (i + 1) * 384));
            ++i;
        }
    }

    public void conditionalSubQ() {
        int i = 0;
        while (i < this.kyberK) {
            this.getVectorIndex(i).conditionalSubQ();
            ++i;
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("[");
        int i = 0;
        while (i < this.kyberK) {
            out.append(this.vec[i].toString());
            if (i != this.kyberK - 1) {
                out.append(", ");
            }
            ++i;
        }
        out.append("]");
        return out.toString();
    }
}

