/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import org.bouncycastle.util.Pack;

class GF2Field {
    static final byte[][] gfMulTable = new byte[256][256];
    static final byte[] gfInvTable = new byte[256];
    public static final int MASK = 255;

    static {
        long p = 0x101010101010101L;
        int i = 1;
        while (i <= 255) {
            long q = 506097522914230528L;
            int j = 0;
            while (j < 256) {
                long r = GF2Field.gf256Mul_64(p, q);
                Pack.longToLittleEndian(r, gfMulTable[i], j);
                q += 0x808080808080808L;
                j += 8;
            }
            p += 0x101010101010101L;
            ++i;
        }
        p = 506097522914230528L;
        i = 0;
        while (i < 256) {
            long r = GF2Field.gf256Inv_64(p);
            Pack.longToLittleEndian(r, gfInvTable, i);
            p += 0x808080808080808L;
            i += 8;
        }
    }

    GF2Field() {
    }

    private static short gf4Mul2(short a) {
        int r = a << 1;
        return (short)((r ^= (a >>> 1) * 7) & 0xFF);
    }

    private static short gf4Mul3(short a) {
        int msk = a - 2 >>> 1;
        int r = msk & a * 3 | ~msk & a - 1;
        return (short)(r & 0xFF);
    }

    private static short gf4Mul(short a, short b) {
        int r = a * (b & 1);
        return (short)((r ^= GF2Field.gf4Mul2(a) * (b >>> 1)) & 0xFF);
    }

    private static short gf4Squ(short a) {
        int r = a ^ a >>> 1;
        return (short)(r & 0xFF);
    }

    private static short gf16Mul(short a, short b) {
        short a0 = (short)(a & 3 & 0xFF);
        short a1 = (short)(a >>> 2 & 0xFF);
        short b0 = (short)(b & 3 & 0xFF);
        short b1 = (short)(b >>> 2 & 0xFF);
        short a0b0 = GF2Field.gf4Mul(a0, b0);
        short a1b1 = GF2Field.gf4Mul(a1, b1);
        short a0b1_a1b0 = (short)(GF2Field.gf4Mul((short)(a0 ^ a1), (short)(b0 ^ b1)) ^ a0b0);
        short a1b1_x2 = GF2Field.gf4Mul2(a1b1);
        return (short)((a0b1_a1b0 << 2 ^ a0b0 ^ a1b1_x2) & 0xFF);
    }

    private static short gf16Squ(short a) {
        short a0 = (short)(a & 3 & 0xFF);
        short a1 = (short)(a >>> 2 & 0xFF);
        a1 = GF2Field.gf4Squ(a1);
        short a1squ_x2 = GF2Field.gf4Mul2(a1);
        return (short)((a1 << 2 ^ a1squ_x2 ^ GF2Field.gf4Squ(a0)) & 0xFF);
    }

    private static short gf16Mul8(short a) {
        short a0 = (short)(a & 3 & 0xFF);
        short a1 = (short)(a >>> 2 & 0xFF);
        int r = GF2Field.gf4Mul2((short)(a0 ^ a1)) << 2;
        return (short)((r |= GF2Field.gf4Mul3(a1)) & 0xFF);
    }

    private static short gf256Mul(short a, short b) {
        short a0 = (short)(a & 0xF & 0xFF);
        short a1 = (short)(a >>> 4 & 0xFF);
        short b0 = (short)(b & 0xF & 0xFF);
        short b1 = (short)(b >>> 4 & 0xFF);
        short a0b0 = GF2Field.gf16Mul(a0, b0);
        short a1b1 = GF2Field.gf16Mul(a1, b1);
        short a0b1_a1b0 = (short)(GF2Field.gf16Mul((short)(a0 ^ a1), (short)(b0 ^ b1)) ^ a0b0);
        short a1b1_x2 = GF2Field.gf16Mul8(a1b1);
        return (short)((a0b1_a1b0 << 4 ^ a0b0 ^ a1b1_x2) & 0xFF);
    }

    private static short gf256Squ(short a) {
        short a0 = (short)(a & 0xF & 0xFF);
        short a1 = (short)(a >>> 4 & 0xFF);
        a1 = GF2Field.gf16Squ(a1);
        short a1squ_x8 = GF2Field.gf16Mul8(a1);
        return (short)((a1 << 4 ^ a1squ_x8 ^ GF2Field.gf16Squ(a0)) & 0xFF);
    }

    private static short gf256Inv(short a) {
        short a2 = GF2Field.gf256Squ(a);
        short a4 = GF2Field.gf256Squ(a2);
        short a8 = GF2Field.gf256Squ(a4);
        short a4_2 = GF2Field.gf256Mul(a4, a2);
        short a8_4_2 = GF2Field.gf256Mul(a4_2, a8);
        short a64_ = GF2Field.gf256Squ(a8_4_2);
        a64_ = GF2Field.gf256Squ(a64_);
        a64_ = GF2Field.gf256Squ(a64_);
        short a64_2 = GF2Field.gf256Mul(a64_, a8_4_2);
        short a128_ = GF2Field.gf256Squ(a64_2);
        return GF2Field.gf256Mul(a2, a128_);
    }

    public static short addElem(short a, short b) {
        return (short)(a ^ b);
    }

    public static long addElem_64(long a, long b) {
        return a ^ b;
    }

    public static short invElem(short a) {
        return (short)(gfInvTable[a] & 0xFF);
    }

    public static long invElem_64(long a) {
        return GF2Field.gf256Inv_64(a);
    }

    public static short multElem(short a, short b) {
        return (short)(gfMulTable[a][b] & 0xFF);
    }

    public static long multElem_64(long a, long b) {
        return GF2Field.gf256Mul_64(a, b);
    }

    private static long gf4Mul2_64(long p) {
        long p0 = p & 0x5555555555555555L;
        long p1 = p & 0xAAAAAAAAAAAAAAAAL;
        return p1 ^ p0 << 1 ^ p1 >>> 1;
    }

    private static long gf4Mul_64(long p, long q) {
        long r1 = (p << 1 & q ^ q << 1 & p) & 0xAAAAAAAAAAAAAAAAL;
        long r02 = p & q;
        return r02 ^ r1 ^ (r02 & 0xAAAAAAAAAAAAAAAAL) >>> 1;
    }

    private static long gf4Squ_64(long p) {
        long p1 = p & 0xAAAAAAAAAAAAAAAAL;
        return p ^ p1 >>> 1;
    }

    private static long gf16Mul_64(long p, long q) {
        long t = GF2Field.gf4Mul_64(p, q);
        long a0b0 = t & 0x3333333333333333L;
        long a1b1 = t & 0xCCCCCCCCCCCCCCCCL;
        long pk = (p << 2 ^ p) & 0xCCCCCCCCCCCCCCCCL ^ a1b1 >>> 2;
        long qk = (q << 2 ^ q) & 0xCCCCCCCCCCCCCCCCL ^ 0x2222222222222222L;
        long v = GF2Field.gf4Mul_64(pk, qk);
        return v ^ a0b0 << 2 ^ a0b0;
    }

    private static long gf16Squ_64(long p) {
        long t = GF2Field.gf4Squ_64(p);
        long u = GF2Field.gf4Mul2_64(t & 0xCCCCCCCCCCCCCCCCL);
        return t ^ u >>> 2;
    }

    private static long gf16Mul8_64(long p) {
        long p0 = p & 0x3333333333333333L;
        long p1 = p & 0xCCCCCCCCCCCCCCCCL;
        long pk = p0 << 2 ^ p1 ^ p1 >>> 2;
        long t = GF2Field.gf4Mul2_64(pk);
        return t ^ p1 >>> 2;
    }

    private static long gf256Mul_64(long p, long q) {
        long t = GF2Field.gf16Mul_64(p, q);
        long a0b0 = t & 0xF0F0F0F0F0F0F0FL;
        long a1b1 = t & 0xF0F0F0F0F0F0F0F0L;
        long pk = (p << 4 ^ p) & 0xF0F0F0F0F0F0F0F0L ^ a1b1 >>> 4;
        long qk = (q << 4 ^ q) & 0xF0F0F0F0F0F0F0F0L ^ 0x808080808080808L;
        long v = GF2Field.gf16Mul_64(pk, qk);
        return v ^ a0b0 << 4 ^ a0b0;
    }

    private static long gf256Squ_64(long p) {
        long t = GF2Field.gf16Squ_64(p);
        long a1Sq = t & 0xF0F0F0F0F0F0F0F0L;
        long a1squ_x8 = GF2Field.gf16Mul8_64(a1Sq);
        return t ^ a1squ_x8 >>> 4;
    }

    private static long gf256Inv_64(long p) {
        long p2 = GF2Field.gf256Squ_64(p);
        long p4 = GF2Field.gf256Squ_64(p2);
        long p8 = GF2Field.gf256Squ_64(p4);
        long p4_2 = GF2Field.gf256Mul_64(p4, p2);
        long p8_4_2 = GF2Field.gf256Mul_64(p4_2, p8);
        long p64_ = GF2Field.gf256Squ_64(p8_4_2);
        p64_ = GF2Field.gf256Squ_64(p64_);
        p64_ = GF2Field.gf256Squ_64(p64_);
        long p64_2 = GF2Field.gf256Mul_64(p64_, p8_4_2);
        long p128_ = GF2Field.gf256Squ_64(p64_2);
        return GF2Field.gf256Mul_64(p2, p128_);
    }
}

