/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import org.bouncycastle.pqc.legacy.math.linearalgebra.BigEndianConversions;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;

public final class IntUtils {
    private IntUtils() {
    }

    public static boolean equals(int[] left, int[] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        int i = left.length - 1;
        while (i >= 0) {
            result &= left[i] == right[i];
            --i;
        }
        return result;
    }

    public static int[] clone(int[] array) {
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static void fill(int[] array, int value) {
        int i = array.length - 1;
        while (i >= 0) {
            array[i] = value;
            --i;
        }
    }

    public static void quicksort(int[] source) {
        IntUtils.quicksort(source, 0, source.length - 1);
    }

    public static void quicksort(int[] source, int left, int right) {
        if (right > left) {
            int index = IntUtils.partition(source, left, right, right);
            IntUtils.quicksort(source, left, index - 1);
            IntUtils.quicksort(source, index + 1, right);
        }
    }

    private static int partition(int[] source, int left, int right, int pivotIndex) {
        int pivot = source[pivotIndex];
        source[pivotIndex] = source[right];
        source[right] = pivot;
        int index = left;
        int i = left;
        while (i < right) {
            if (source[i] <= pivot) {
                int tmp = source[index];
                source[index] = source[i];
                source[i] = tmp;
                ++index;
            }
            ++i;
        }
        int tmp = source[index];
        source[index] = source[right];
        source[right] = tmp;
        return index;
    }

    public static int[] subArray(int[] input, int start, int end) {
        int[] result = new int[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static String toString(int[] input) {
        String result = "";
        int i = 0;
        while (i < input.length) {
            result = String.valueOf(result) + input[i] + " ";
            ++i;
        }
        return result;
    }

    public static String toHexString(int[] input) {
        return ByteUtils.toHexString(BigEndianConversions.toByteArray(input));
    }
}

