/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

public abstract class Pack {
    public static short bigEndianToShort(byte[] bs, int off) {
        int n = (bs[off] & 0xFF) << 8;
        return (short)(n |= bs[++off] & 0xFF);
    }

    public static int bigEndianToInt(byte[] bs, int off) {
        int n = bs[off] << 24;
        n |= (bs[++off] & 0xFF) << 16;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= bs[++off] & 0xFF;
    }

    public static void bigEndianToInt(byte[] bs, int off, int[] ns) {
        int i = 0;
        while (i < ns.length) {
            ns[i] = Pack.bigEndianToInt(bs, off);
            off += 4;
            ++i;
        }
    }

    public static void bigEndianToInt(byte[] bs, int off, int[] ns, int nsOff, int nsLen) {
        int i = 0;
        while (i < nsLen) {
            ns[nsOff + i] = Pack.bigEndianToInt(bs, off);
            off += 4;
            ++i;
        }
    }

    public static byte[] intToBigEndian(int n) {
        byte[] bs = new byte[4];
        Pack.intToBigEndian(n, bs, 0);
        return bs;
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static byte[] intToBigEndian(int[] ns) {
        byte[] bs = new byte[4 * ns.length];
        Pack.intToBigEndian(ns, bs, 0);
        return bs;
    }

    public static void intToBigEndian(int[] ns, byte[] bs, int off) {
        int i = 0;
        while (i < ns.length) {
            Pack.intToBigEndian(ns[i], bs, off);
            off += 4;
            ++i;
        }
    }

    public static void intToBigEndian(int[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        int i = 0;
        while (i < nsLen) {
            Pack.intToBigEndian(ns[nsOff + i], bs, bsOff);
            bsOff += 4;
            ++i;
        }
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int hi = Pack.bigEndianToInt(bs, off);
        int lo = Pack.bigEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void bigEndianToLong(byte[] bs, int off, long[] ns) {
        int i = 0;
        while (i < ns.length) {
            ns[i] = Pack.bigEndianToLong(bs, off);
            off += 8;
            ++i;
        }
    }

    public static void bigEndianToLong(byte[] bs, int bsOff, long[] ns, int nsOff, int nsLen) {
        int i = 0;
        while (i < nsLen) {
            ns[nsOff + i] = Pack.bigEndianToLong(bs, bsOff);
            bsOff += 8;
            ++i;
        }
    }

    public static long bigEndianToLong(byte[] bs, int off, int len) {
        long x = 0L;
        int i = 0;
        while (i < len) {
            x |= ((long)bs[i + off] & 0xFFL) << (7 - i << 3);
            ++i;
        }
        return x;
    }

    public static byte[] longToBigEndian(long n) {
        byte[] bs = new byte[8];
        Pack.longToBigEndian(n, bs, 0);
        return bs;
    }

    public static void longToBigEndian(long n, byte[] bs, int off) {
        Pack.intToBigEndian((int)(n >>> 32), bs, off);
        Pack.intToBigEndian((int)(n & 0xFFFFFFFFL), bs, off + 4);
    }

    public static byte[] longToBigEndian(long[] ns) {
        byte[] bs = new byte[8 * ns.length];
        Pack.longToBigEndian(ns, bs, 0);
        return bs;
    }

    public static void longToBigEndian(long[] ns, byte[] bs, int off) {
        int i = 0;
        while (i < ns.length) {
            Pack.longToBigEndian(ns[i], bs, off);
            off += 8;
            ++i;
        }
    }

    public static void longToBigEndian(long[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        int i = 0;
        while (i < nsLen) {
            Pack.longToBigEndian(ns[nsOff + i], bs, bsOff);
            bsOff += 8;
            ++i;
        }
    }

    public static void longToBigEndian(long value, byte[] bs, int off, int bytes) {
        int i = bytes - 1;
        while (i >= 0) {
            bs[i + off] = (byte)(value & 0xFFL);
            value >>>= 8;
            --i;
        }
    }

    public static short littleEndianToShort(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        return (short)(n |= (bs[++off] & 0xFF) << 8);
    }

    public static int littleEndianToInt(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    public static int littleEndianToInt_High(byte[] bs, int off, int len) {
        return Pack.littleEndianToInt_Low(bs, off, len) << (4 - len << 3);
    }

    public static int littleEndianToInt_Low(byte[] bs, int off, int len) {
        int result = bs[off] & 0xFF;
        int pos = 0;
        int i = 1;
        while (i < len) {
            result |= (bs[off + i] & 0xFF) << (pos += 8);
            ++i;
        }
        return result;
    }

    public static void littleEndianToInt(byte[] bs, int off, int[] ns) {
        int i = 0;
        while (i < ns.length) {
            ns[i] = Pack.littleEndianToInt(bs, off);
            off += 4;
            ++i;
        }
    }

    public static void littleEndianToInt(byte[] bs, int bOff, int[] ns, int nOff, int count) {
        int i = 0;
        while (i < count) {
            ns[nOff + i] = Pack.littleEndianToInt(bs, bOff);
            bOff += 4;
            ++i;
        }
    }

    public static int[] littleEndianToInt(byte[] bs, int off, int count) {
        int[] ns = new int[count];
        int i = 0;
        while (i < ns.length) {
            ns[i] = Pack.littleEndianToInt(bs, off);
            off += 4;
            ++i;
        }
        return ns;
    }

    public static byte[] shortToLittleEndian(short n) {
        byte[] bs = new byte[2];
        Pack.shortToLittleEndian(n, bs, 0);
        return bs;
    }

    public static void shortToLittleEndian(short n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
    }

    public static byte[] shortToBigEndian(short n) {
        byte[] r = new byte[2];
        Pack.shortToBigEndian(n, r, 0);
        return r;
    }

    public static void shortToBigEndian(short n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static byte[] intToLittleEndian(int n) {
        byte[] bs = new byte[4];
        Pack.intToLittleEndian(n, bs, 0);
        return bs;
    }

    public static void intToLittleEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    public static byte[] intToLittleEndian(int[] ns) {
        byte[] bs = new byte[4 * ns.length];
        Pack.intToLittleEndian(ns, bs, 0);
        return bs;
    }

    public static void intToLittleEndian(int[] ns, byte[] bs, int off) {
        int i = 0;
        while (i < ns.length) {
            Pack.intToLittleEndian(ns[i], bs, off);
            off += 4;
            ++i;
        }
    }

    public static void intToLittleEndian(int[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        int i = 0;
        while (i < nsLen) {
            Pack.intToLittleEndian(ns[nsOff + i], bs, bsOff);
            bsOff += 4;
            ++i;
        }
    }

    public static long littleEndianToLong(byte[] bs, int off) {
        int lo = Pack.littleEndianToInt(bs, off);
        int hi = Pack.littleEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void littleEndianToLong(byte[] bs, int off, long[] ns) {
        int i = 0;
        while (i < ns.length) {
            ns[i] = Pack.littleEndianToLong(bs, off);
            off += 8;
            ++i;
        }
    }

    public static long littleEndianToLong(byte[] input, int off, int len) {
        long result = 0L;
        int i = 0;
        while (i < len) {
            result |= ((long)input[off + i] & 0xFFL) << (i << 3);
            ++i;
        }
        return result;
    }

    public static void littleEndianToLong(byte[] bs, int bsOff, long[] ns, int nsOff, int nsLen) {
        int i = 0;
        while (i < nsLen) {
            ns[nsOff + i] = Pack.littleEndianToLong(bs, bsOff);
            bsOff += 8;
            ++i;
        }
    }

    public static void longToLittleEndian_High(long n, byte[] bs, int off, int len) {
        int pos = 56;
        bs[off] = (byte)(n >>> pos);
        int i = 1;
        while (i < len) {
            bs[off + i] = (byte)(n >>> (pos -= 8));
            ++i;
        }
    }

    public static void longToLittleEndian(long n, byte[] bs, int off, int len) {
        int i = 0;
        while (i < len) {
            bs[off + i] = (byte)(n >>> (i << 3));
            ++i;
        }
    }

    public static long littleEndianToLong_High(byte[] bs, int off, int len) {
        return Pack.littleEndianToLong_Low(bs, off, len) << (8 - len << 3);
    }

    public static long littleEndianToLong_Low(byte[] bs, int off, int len) {
        long result = bs[off] & 0xFF;
        int i = 1;
        while (i < len) {
            result <<= 8;
            result |= (long)(bs[off + i] & 0xFF);
            ++i;
        }
        return result;
    }

    public static byte[] longToLittleEndian(long n) {
        byte[] bs = new byte[8];
        Pack.longToLittleEndian(n, bs, 0);
        return bs;
    }

    public static void longToLittleEndian(long n, byte[] bs, int off) {
        Pack.intToLittleEndian((int)(n & 0xFFFFFFFFL), bs, off);
        Pack.intToLittleEndian((int)(n >>> 32), bs, off + 4);
    }

    public static byte[] longToLittleEndian(long[] ns) {
        byte[] bs = new byte[8 * ns.length];
        Pack.longToLittleEndian(ns, bs, 0);
        return bs;
    }

    public static void longToLittleEndian(long[] ns, byte[] bs, int off) {
        int i = 0;
        while (i < ns.length) {
            Pack.longToLittleEndian(ns[i], bs, off);
            off += 8;
            ++i;
        }
    }

    public static void longToLittleEndian(long[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        int i = 0;
        while (i < nsLen) {
            Pack.longToLittleEndian(ns[nsOff + i], bs, bsOff);
            bsOff += 8;
            ++i;
        }
    }
}

