/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.VirtualizationSerializer;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog(JRAbstractLRUVirtualizer.class);
    protected final VirtualizationSerializer serializer = new VirtualizationSerializer();
    private final Cache pagedIn;
    private final ReferenceMap pagedOut;
    protected volatile WeakReference<JRVirtualizable> lastObjectRef;
    protected ReferenceMap lastObjectMap;
    protected ReferenceMap lastObjectSet;
    private boolean readOnly;

    protected JRAbstractLRUVirtualizer(int maxSize) {
        this.pagedIn = new Cache(maxSize);
        this.pagedOut = new ReferenceMap(0, 2);
        this.lastObjectRef = null;
        this.lastObjectMap = new ReferenceMap(2, 2);
        this.lastObjectSet = new ReferenceMap(2, 0);
    }

    protected final synchronized boolean isPagedOut(String id) {
        return this.pagedOut.containsKey(id);
    }

    protected synchronized boolean isPagedOutAndTouch(JRVirtualizable o2, String uid) {
        boolean virtualized = this.isPagedOut(uid);
        if (!virtualized) {
            this.touch(o2);
        }
        return virtualized;
    }

    protected JRVirtualizable lastObject() {
        WeakReference<JRVirtualizable> ref = this.lastObjectRef;
        JRVirtualizable object = ref == null ? null : (JRVirtualizable)ref.get();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLastObject(JRVirtualizable o2) {
        JRVirtualizable currentLast = this.lastObject();
        if (o2 != null && currentLast != o2) {
            this.lastObjectRef = new WeakReference<JRVirtualizable>(o2);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                JRVirtualizationContext context = o2.getContext();
                Object ownerLast = this.lastObjectMap.get(context);
                if (ownerLast != o2) {
                    if (ownerLast != null) {
                        this.lastObjectSet.remove(ownerLast);
                    }
                    this.lastObjectMap.put(context, o2);
                    this.lastObjectSet.put(o2, Boolean.TRUE);
                }
            }
        }
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected final boolean isReadOnly(JRVirtualizable o2) {
        return this.readOnly || o2.getContext().isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(JRVirtualizable o2) {
        if (log.isDebugEnabled()) {
            log.debug("registering " + o2.getUID());
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            this.setLastObject(o2);
            JRVirtualizable old = this.pagedIn.put(o2.getUID(), o2);
            if (old != null && old != o2) {
                this.pagedIn.put(o2.getUID(), old);
                throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("registered object " + o2 + " with id " + o2.getUID());
        }
        this.evict();
    }

    protected boolean isEvictable(JRVirtualizable value) {
        return value.getContext().isDisposed() || !this.lastObjectSet.containsKey(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        List<JRVirtualizable> candidates;
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            candidates = this.pagedIn.evictionCandidates();
        }
        for (JRVirtualizable o2 : candidates) {
            String uid = o2.getUID();
            if (o2.getContext().tryLock()) {
                try {
                    boolean evictable;
                    JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer2 = this;
                    synchronized (jRAbstractLRUVirtualizer2) {
                        boolean bl = evictable = this.pagedIn.contains(uid) && this.isEvictable(o2);
                        if (evictable) {
                            this.pagedIn.remove(uid);
                        }
                    }
                    if (evictable) {
                        if (log.isDebugEnabled()) {
                            log.debug("evicting " + uid);
                        }
                        if (o2.getContext().isDisposed()) continue;
                        this.virtualizeData(o2);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("no longer evictable: " + uid);
                    continue;
                }
                finally {
                    o2.getContext().unlock();
                    continue;
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("couldn't lock for eviction " + uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterObject(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (log.isDebugEnabled()) {
            log.debug("deregistering " + uid);
        }
        try {
            this.dispose(o2);
        }
        catch (Exception e2) {
            log.error("Error removing virtual data", e2);
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            JRVirtualizable oldIn = this.pagedIn.remove(uid);
            if (oldIn != null) {
                if (oldIn != o2) {
                    this.pagedIn.put(uid, oldIn);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
                }
                Object contextLast = this.lastObjectMap.get(o2.getContext());
                if (contextLast == o2) {
                    this.lastObjectMap.remove(o2.getContext());
                    this.lastObjectSet.remove(o2);
                }
            } else {
                Object oldOut = this.pagedOut.remove(uid);
                if (oldOut != null && oldOut != o2) {
                    this.pagedOut.put(uid, oldOut);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("deregistered object " + o2 + " with id " + o2.getUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch(JRVirtualizable o2) {
        if (this.lastObject() != o2) {
            JRVirtualizable internalObject;
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                internalObject = this.pagedIn.get(o2.getUID());
            }
            this.setLastObject(internalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestData(JRVirtualizable o2) {
        boolean evictRequired;
        block10: {
            String uid = o2.getUID();
            evictRequired = false;
            o2.getContext().lock();
            try {
                if (!this.isPagedOutAndTouch(o2, uid)) break block10;
                if (log.isDebugEnabled()) {
                    log.debug("internalizing " + uid);
                }
                try {
                    this.pageIn(o2);
                }
                catch (IOException e2) {
                    log.error("Error devirtualizing object", e2);
                    throw new JRRuntimeException(e2);
                }
                JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
                synchronized (jRAbstractLRUVirtualizer) {
                    this.setLastObject(o2);
                    this.pagedOut.remove(uid);
                    this.pagedIn.put(uid, o2);
                }
                o2.afterInternalization();
                evictRequired = true;
            }
            finally {
                o2.getContext().unlock();
            }
        }
        if (evictRequired) {
            this.evict();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (this.isPagedOutAndTouch(o2, uid)) {
            this.dispose(uid);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.remove(uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void virtualizeData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (!this.isPagedOut(uid)) {
            if (log.isDebugEnabled()) {
                log.debug("externalizing " + uid);
            }
            o2.beforeExternalization();
            try {
                this.pageOut(o2);
            }
            catch (IOException e2) {
                log.error("Error virtualizing object", e2);
                throw new JRRuntimeException(e2);
            }
            o2.afterExternalization();
            o2.removeVirtualData();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.put(uid, o2);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected final void writeData(JRVirtualizable o2, OutputStream out) throws JRRuntimeException {
        try {
            this.serializer.writeData(o2, out);
        }
        catch (IOException e2) {
            log.error("Error virtualizing object", e2);
            throw new JRRuntimeException(e2);
        }
    }

    protected final void readData(JRVirtualizable o2, InputStream in) throws JRRuntimeException {
        try {
            this.serializer.readData(o2, in);
        }
        catch (IOException e2) {
            log.error("Error devirtualizing object", e2);
            throw new JRRuntimeException(e2);
        }
    }

    protected synchronized void reset() {
        this.readOnly = false;
    }

    protected final void disposeAll() {
        String id;
        Iterator<Object> it = this.pagedOut.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e2) {
                log.error("Error cleaning up virtualizer.", e2);
            }
        }
        it = this.pagedIn.idIterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e3) {
                log.error("Error cleaning up virtualizer.", e3);
            }
        }
    }

    protected abstract void pageOut(JRVirtualizable var1) throws IOException;

    protected abstract void pageIn(JRVirtualizable var1) throws IOException;

    protected void dispose(JRVirtualizable o2) {
        this.dispose(o2.getUID());
    }

    protected abstract void dispose(String var1);

    protected class Cache {
        private final int maxSize;
        private final ReferenceQueue<JRVirtualizable> refQueue;
        private final LinkedHashMap<String, CacheReference> map;

        Cache(int maxSize) {
            this.maxSize = maxSize;
            this.map = new LinkedHashMap(16, 0.75f, true);
            this.refQueue = new ReferenceQueue();
        }

        protected JRVirtualizable getMapValue(CacheReference val) {
            JRVirtualizable o2 = val == null ? null : (val.isEnqueued() ? null : (JRVirtualizable)val.get());
            return o2;
        }

        protected CacheReference toMapValue(JRVirtualizable val) {
            return val == null ? null : new CacheReference(val, this.refQueue);
        }

        protected void purge() {
            CacheReference ref;
            while ((ref = (CacheReference)this.refQueue.poll()) != null) {
                this.map.remove(ref.getId());
            }
        }

        public boolean contains(String id) {
            this.purge();
            return this.map.containsKey(id);
        }

        public JRVirtualizable get(String id) {
            this.purge();
            return this.getMapValue(this.map.get(id));
        }

        public JRVirtualizable put(String id, JRVirtualizable o2) {
            this.purge();
            return this.getMapValue(this.map.put(id, this.toMapValue(o2)));
        }

        public List<JRVirtualizable> evictionCandidates() {
            if (this.map.size() <= this.maxSize) {
                return Collections.emptyList();
            }
            int candidateCount = this.map.size() - this.maxSize;
            ArrayList<JRVirtualizable> candidates = new ArrayList<JRVirtualizable>();
            Iterator<Map.Entry<String, CacheReference>> mapIterator = this.map.entrySet().iterator();
            while (candidates.size() < candidateCount && mapIterator.hasNext()) {
                Map.Entry<String, CacheReference> entry = mapIterator.next();
                JRVirtualizable value = this.getMapValue(entry.getValue());
                if (value == null) {
                    --candidateCount;
                    continue;
                }
                if (!JRAbstractLRUVirtualizer.this.isEvictable(value)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("LRU eviction candidate: " + entry.getKey());
                }
                candidates.add(value);
            }
            if (candidates.size() < candidateCount) {
                log.debug("The virtualizer is used by more contexts than its in-memory cache size " + this.maxSize);
            }
            return candidates;
        }

        public JRVirtualizable remove(String id) {
            this.purge();
            return this.getMapValue((CacheReference)this.map.remove(id));
        }

        public Iterator<String> idIterator() {
            this.purge();
            final Iterator<CacheReference> valsIt = this.map.values().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return valsIt.hasNext();
                }

                @Override
                public String next() {
                    CacheReference ref = (CacheReference)valsIt.next();
                    return ref.getId();
                }

                @Override
                public void remove() {
                    valsIt.remove();
                }
            };
        }
    }

    protected static class CacheReference
    extends WeakReference<JRVirtualizable> {
        private final String id;

        public CacheReference(JRVirtualizable o2, ReferenceQueue<JRVirtualizable> queue) {
            super(o2, queue);
            this.id = o2.getUID();
        }

        public String getId() {
            return this.id;
        }
    }
}

