/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import org.apache.commons.collections.ReferenceMap;

public final class JRIncrementerFactoryCache {
    private static Map<Class<?>, JRIncrementerFactory> factoriesMap = new ReferenceMap(2, 0);

    public static synchronized JRIncrementerFactory getInstance(Class<?> factoryClass) {
        JRIncrementerFactory incrementerFactory = factoriesMap.get(factoryClass);
        if (incrementerFactory == null) {
            try {
                incrementerFactory = (JRIncrementerFactory)factoryClass.newInstance();
            }
            catch (InstantiationException e2) {
                throw new JRRuntimeException(e2);
            }
            catch (IllegalAccessException e3) {
                throw new JRRuntimeException(e3);
            }
            factoriesMap.put(factoryClass, incrementerFactory);
        }
        return incrementerFactory;
    }

    private JRIncrementerFactoryCache() {
    }
}

