/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.prng.ThreadedSeedGenerator;
import org.bouncycastle.crypto.tls.ByteQueue;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateVerifyer;
import org.bouncycastle.crypto.tls.CombinedHash;
import org.bouncycastle.crypto.tls.RecordStream;
import org.bouncycastle.crypto.tls.TlsCipherSuite;
import org.bouncycastle.crypto.tls.TlsCipherSuiteManager;
import org.bouncycastle.crypto.tls.TlsInputStream;
import org.bouncycastle.crypto.tls.TlsOuputStream;
import org.bouncycastle.crypto.tls.TlsUtils;

public class TlsProtocolHandler {
    private static final short RL_CHANGE_CIPHER_SPEC = 20;
    private static final short RL_ALERT = 21;
    private static final short RL_HANDSHAKE = 22;
    private static final short RL_APPLICATION_DATA = 23;
    private static final short HP_HELLO_REQUEST = 0;
    private static final short HP_CLIENT_HELLO = 1;
    private static final short HP_SERVER_HELLO = 2;
    private static final short HP_CERTIFICATE = 11;
    private static final short HP_SERVER_KEY_EXCHANGE = 12;
    private static final short HP_CERTIFICATE_REQUEST = 13;
    private static final short HP_SERVER_HELLO_DONE = 14;
    private static final short HP_CERTIFICATE_VERIFY = 15;
    private static final short HP_CLIENT_KEY_EXCHANGE = 16;
    private static final short HP_FINISHED = 20;
    private static final short CS_CLIENT_HELLO_SEND = 1;
    private static final short CS_SERVER_HELLO_RECEIVED = 2;
    private static final short CS_SERVER_CERTIFICATE_RECEIVED = 3;
    private static final short CS_SERVER_KEY_EXCHANGE_RECEIVED = 4;
    private static final short CS_SERVER_HELLO_DONE_RECEIVED = 5;
    private static final short CS_CLIENT_KEY_EXCHANGE_SEND = 6;
    private static final short CS_CLIENT_CHANGE_CIPHER_SPEC_SEND = 7;
    private static final short CS_CLIENT_FINISHED_SEND = 8;
    private static final short CS_SERVER_CHANGE_CIPHER_SPEC_RECEIVED = 9;
    private static final short CS_DONE = 10;
    protected static final short AP_close_notify = 0;
    protected static final short AP_unexpected_message = 10;
    protected static final short AP_bad_record_mac = 20;
    protected static final short AP_decryption_failed = 21;
    protected static final short AP_record_overflow = 22;
    protected static final short AP_decompression_failure = 30;
    protected static final short AP_handshake_failure = 40;
    protected static final short AP_bad_certificate = 42;
    protected static final short AP_unsupported_certificate = 43;
    protected static final short AP_certificate_revoked = 44;
    protected static final short AP_certificate_expired = 45;
    protected static final short AP_certificate_unknown = 46;
    protected static final short AP_illegal_parameter = 47;
    protected static final short AP_unknown_ca = 48;
    protected static final short AP_access_denied = 49;
    protected static final short AP_decode_error = 50;
    protected static final short AP_decrypt_error = 51;
    protected static final short AP_export_restriction = 60;
    protected static final short AP_protocol_version = 70;
    protected static final short AP_insufficient_security = 71;
    protected static final short AP_internal_error = 80;
    protected static final short AP_user_canceled = 90;
    protected static final short AP_no_renegotiation = 100;
    protected static final short AL_warning = 1;
    protected static final short AL_fatal = 2;
    private static final byte[] emptybuf = new byte[0];
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    private RecordStream rs;
    private SecureRandom random;
    private RSAKeyParameters serverRsaKey = null;
    private TlsInputStream tlsInputStream = null;
    private TlsOuputStream tlsOutputStream = null;
    private boolean closed = false;
    private boolean failedWithError = false;
    private boolean appDataReady = false;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private byte[] ms;
    private TlsCipherSuite choosenCipherSuite = null;
    private BigInteger Yc;
    private byte[] pms;
    private CertificateVerifyer verifyer = null;
    private short connection_state;

    public TlsProtocolHandler(InputStream inputStream, OutputStream outputStream) {
        ThreadedSeedGenerator threadedSeedGenerator = new ThreadedSeedGenerator();
        this.random = new SecureRandom();
        this.random.setSeed(threadedSeedGenerator.generateSeed(20, true));
        this.rs = new RecordStream(this, inputStream, outputStream);
    }

    public TlsProtocolHandler(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.rs = new RecordStream(this, inputStream, outputStream);
    }

    protected void processData(short s2, byte[] byArray, int n2, int n3) throws IOException {
        switch (s2) {
            case 20: {
                this.changeCipherSpecQueue.addData(byArray, n2, n3);
                this.processChangeCipherSpec();
                break;
            }
            case 21: {
                this.alertQueue.addData(byArray, n2, n3);
                this.processAlert();
                break;
            }
            case 22: {
                this.handshakeQueue.addData(byArray, n2, n3);
                this.processHandshake();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(byArray, n2, n3);
                this.processApplicationData();
                break;
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean bl;
        do {
            bl = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] byArray = new byte[4];
            this.handshakeQueue.read(byArray, 0, 4, 0);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            short s2 = TlsUtils.readUint8(byteArrayInputStream);
            int n2 = TlsUtils.readUint24(byteArrayInputStream);
            if (this.handshakeQueue.size() < n2 + 4) continue;
            byte[] byArray2 = new byte[n2];
            this.handshakeQueue.read(byArray2, 0, n2, 4);
            this.handshakeQueue.removeData(n2 + 4);
            if (s2 != 20) {
                this.rs.hash1.update(byArray, 0, 4);
                this.rs.hash2.update(byArray, 0, 4);
                this.rs.hash1.update(byArray2, 0, n2);
                this.rs.hash2.update(byArray2, 0, n2);
            }
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
            block3 : switch (s2) {
                case 11: {
                    Object object4;
                    switch (this.connection_state) {
                        case 2: {
                            Certificate certificate = Certificate.parse(byteArrayInputStream2);
                            this.assertEmpty(byteArrayInputStream2);
                            if (!this.verifyer.isValid(certificate.getCerts())) {
                                this.failWithError((short)2, (short)90);
                            }
                            object4 = null;
                            try {
                                object4 = RSAPublicKeyStructure.getInstance(certificate.certs[0].getTBSCertificate().getSubjectPublicKeyInfo().getPublicKey());
                            }
                            catch (Exception exception) {
                                this.failWithError((short)2, (short)43);
                            }
                            this.serverRsaKey = new RSAKeyParameters(false, object4.getModulus(), object4.getPublicExponent());
                            this.connection_state = (short)3;
                            bl = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 20: {
                    Object object4;
                    switch (this.connection_state) {
                        case 9: {
                            byte[] byArray3 = new byte[12];
                            TlsUtils.readFully(byArray3, byteArrayInputStream2);
                            this.assertEmpty(byteArrayInputStream2);
                            object4 = new byte[12];
                            byte[] byArray4 = new byte[36];
                            this.rs.hash2.doFinal(byArray4, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("server finished"), byArray4, object4);
                            for (int i2 = 0; i2 < byArray3.length; ++i2) {
                                if (byArray3[i2] == object4[i2]) continue;
                                this.failWithError((short)2, (short)40);
                            }
                            this.connection_state = (short)10;
                            this.appDataReady = true;
                            bl = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 2: {
                    Object object4;
                    switch (this.connection_state) {
                        case 1: {
                            TlsUtils.checkVersion(byteArrayInputStream2, this);
                            this.serverRandom = new byte[32];
                            TlsUtils.readFully(this.serverRandom, byteArrayInputStream2);
                            short s3 = TlsUtils.readUint8(byteArrayInputStream2);
                            object4 = new byte[s3];
                            TlsUtils.readFully(object4, byteArrayInputStream2);
                            this.choosenCipherSuite = TlsCipherSuiteManager.getCipherSuite(TlsUtils.readUint16(byteArrayInputStream2), this);
                            short s4 = TlsUtils.readUint8(byteArrayInputStream2);
                            if (s4 != 0) {
                                this.failWithError((short)2, (short)47);
                            }
                            this.assertEmpty(byteArrayInputStream2);
                            this.connection_state = (short)2;
                            bl = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 14: {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    switch (this.connection_state) {
                        case 3: {
                            if (this.choosenCipherSuite.getKeyExchangeAlgorithm() != 1) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 4: {
                            byte[] byArray5;
                            Object object5;
                            this.assertEmpty(byteArrayInputStream2);
                            this.connection_state = (short)5;
                            short s5 = this.choosenCipherSuite.getKeyExchangeAlgorithm();
                            switch (s5) {
                                case 1: {
                                    this.pms = new byte[48];
                                    this.pms[0] = 3;
                                    this.pms[1] = 1;
                                    for (int i3 = 2; i3 < 48; ++i3) {
                                        this.pms[i3] = (byte)this.random.nextInt();
                                    }
                                    object4 = new RSABlindedEngine();
                                    PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)object4);
                                    pKCS1Encoding.init(true, new ParametersWithRandom(this.serverRsaKey, this.random));
                                    byte[] byArray6 = null;
                                    try {
                                        byArray6 = pKCS1Encoding.processBlock(this.pms, 0, this.pms.length);
                                    }
                                    catch (InvalidCipherTextException invalidCipherTextException) {
                                        this.failWithError((short)2, (short)80);
                                    }
                                    object5 = new ByteArrayOutputStream();
                                    TlsUtils.writeUint8((short)16, (OutputStream)object5);
                                    TlsUtils.writeUint24(byArray6.length + 2, (OutputStream)object5);
                                    TlsUtils.writeUint16(byArray6.length, (OutputStream)object5);
                                    ((OutputStream)object5).write(byArray6);
                                    object3 = ((ByteArrayOutputStream)object5).toByteArray();
                                    this.rs.writeMessage((short)22, (byte[])object3, 0, ((byte[])object3).length);
                                    break;
                                }
                                case 5: {
                                    byArray5 = this.Yc.toByteArray();
                                    object2 = new ByteArrayOutputStream();
                                    TlsUtils.writeUint8((short)16, (OutputStream)object2);
                                    TlsUtils.writeUint24(byArray5.length + 2, (OutputStream)object2);
                                    TlsUtils.writeUint16(byArray5.length, (OutputStream)object2);
                                    ((OutputStream)object2).write(byArray5);
                                    object = ((ByteArrayOutputStream)object2).toByteArray();
                                    this.rs.writeMessage((short)22, (byte[])object, 0, ((byte[])object).length);
                                    break;
                                }
                                default: {
                                    this.failWithError((short)2, (short)10);
                                }
                            }
                            this.connection_state = (short)6;
                            object4 = new byte[]{1};
                            this.rs.writeMessage((short)20, (byte[])object4, 0, ((Object)object4).length);
                            this.connection_state = (short)7;
                            this.ms = new byte[48];
                            byte[] byArray7 = new byte[this.clientRandom.length + this.serverRandom.length];
                            System.arraycopy(this.clientRandom, 0, byArray7, 0, this.clientRandom.length);
                            System.arraycopy(this.serverRandom, 0, byArray7, this.clientRandom.length, this.serverRandom.length);
                            TlsUtils.PRF(this.pms, TlsUtils.toByteArray("master secret"), byArray7, this.ms);
                            this.rs.writeSuite = this.choosenCipherSuite;
                            this.rs.writeSuite.init(this.ms, this.clientRandom, this.serverRandom);
                            byte[] byArray8 = new byte[12];
                            object5 = new byte[36];
                            this.rs.hash1.doFinal((byte[])object5, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("client finished"), (byte[])object5, byArray8);
                            object3 = new ByteArrayOutputStream();
                            TlsUtils.writeUint8((short)20, (OutputStream)object3);
                            TlsUtils.writeUint24(12, (OutputStream)object3);
                            ((OutputStream)object3).write(byArray8);
                            byArray5 = ((ByteArrayOutputStream)object3).toByteArray();
                            this.rs.writeMessage((short)22, byArray5, 0, byArray5.length);
                            this.connection_state = (short)8;
                            bl = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)40);
                    break;
                }
                case 12: {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    switch (this.connection_state) {
                        case 3: {
                            if (this.choosenCipherSuite.getKeyExchangeAlgorithm() != 5) {
                                this.failWithError((short)2, (short)10);
                            }
                            int n3 = TlsUtils.readUint16(byteArrayInputStream2);
                            object4 = new byte[n3];
                            TlsUtils.readFully(object4, byteArrayInputStream2);
                            int n4 = TlsUtils.readUint16(byteArrayInputStream2);
                            byte[] byArray9 = new byte[n4];
                            TlsUtils.readFully(byArray9, byteArrayInputStream2);
                            int n5 = TlsUtils.readUint16(byteArrayInputStream2);
                            object3 = new byte[n5];
                            TlsUtils.readFully((byte[])object3, byteArrayInputStream2);
                            int n6 = TlsUtils.readUint16(byteArrayInputStream2);
                            object2 = new byte[n6];
                            TlsUtils.readFully((byte[])object2, byteArrayInputStream2);
                            this.assertEmpty(byteArrayInputStream2);
                            object = new CombinedHash();
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            TlsUtils.writeUint16(n3, byteArrayOutputStream);
                            byteArrayOutputStream.write((byte[])object4);
                            TlsUtils.writeUint16(n4, byteArrayOutputStream);
                            byteArrayOutputStream.write(byArray9);
                            TlsUtils.writeUint16(n5, byteArrayOutputStream);
                            byteArrayOutputStream.write((byte[])object3);
                            byte[] byArray10 = byteArrayOutputStream.toByteArray();
                            ((CombinedHash)object).update(this.clientRandom, 0, this.clientRandom.length);
                            ((CombinedHash)object).update(this.serverRandom, 0, this.serverRandom.length);
                            ((CombinedHash)object).update(byArray10, 0, byArray10.length);
                            byte[] byArray11 = new byte[((CombinedHash)object).getDigestSize()];
                            ((CombinedHash)object).doFinal(byArray11, 0);
                            RSABlindedEngine rSABlindedEngine = new RSABlindedEngine();
                            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine);
                            pKCS1Encoding.init(false, this.serverRsaKey);
                            byte[] byArray12 = null;
                            try {
                                byArray12 = pKCS1Encoding.processBlock((byte[])object2, 0, ((Object)object2).length);
                            }
                            catch (InvalidCipherTextException invalidCipherTextException) {
                                this.failWithError((short)2, (short)42);
                            }
                            if (byArray12.length != byArray11.length) {
                                this.failWithError((short)2, (short)42);
                            }
                            for (int i4 = 0; i4 < byArray12.length; ++i4) {
                                if (byArray12[i4] == byArray11[i4]) continue;
                                this.failWithError((short)2, (short)42);
                            }
                            BigInteger bigInteger = new BigInteger(1, (byte[])object4);
                            BigInteger bigInteger2 = new BigInteger(1, byArray9);
                            BigInteger bigInteger3 = new BigInteger(1, (byte[])object3);
                            BigInteger bigInteger4 = new BigInteger(bigInteger.bitLength() - 1, this.random);
                            this.Yc = bigInteger2.modPow(bigInteger4, bigInteger);
                            this.pms = bigInteger3.modPow(bigInteger4, bigInteger).toByteArray();
                            if (this.pms[0] == 0) {
                                byte[] byArray13 = new byte[this.pms.length - 1];
                                System.arraycopy(this.pms, 1, byArray13, 0, byArray13.length);
                                this.pms = byArray13;
                            }
                            this.connection_state = (short)4;
                            bl = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                default: {
                    this.failWithError((short)2, (short)10);
                }
            }
        } while (bl);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] byArray = new byte[2];
            this.alertQueue.read(byArray, 0, 2, 0);
            this.alertQueue.removeData(2);
            short s2 = byArray[0];
            short s3 = byArray[1];
            if (s2 == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (s3 != 0) continue;
            this.failWithError((short)1, (short)0);
        }
    }

    private void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] byArray = new byte[1];
            this.changeCipherSpecQueue.read(byArray, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (byArray[0] != 1) {
                this.failWithError((short)2, (short)10);
                continue;
            }
            if (this.connection_state == 8) {
                this.rs.readSuite = this.rs.writeSuite;
                this.connection_state = (short)9;
                continue;
            }
            this.failWithError((short)2, (short)40);
        }
    }

    public void connect(CertificateVerifyer certificateVerifyer) throws IOException {
        this.verifyer = certificateVerifyer;
        this.clientRandom = new byte[32];
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        this.clientRandom[0] = (byte)(n2 >> 24);
        this.clientRandom[1] = (byte)(n2 >> 16);
        this.clientRandom[2] = (byte)(n2 >> 8);
        this.clientRandom[3] = (byte)n2;
        for (int i2 = 4; i2 < this.clientRandom.length; ++i2) {
            this.clientRandom[i2] = (byte)this.random.nextInt();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeVersion(byteArrayOutputStream);
        byteArrayOutputStream.write(this.clientRandom);
        TlsUtils.writeUint8((short)0, byteArrayOutputStream);
        TlsCipherSuiteManager.writeCipherSuites(byteArrayOutputStream);
        byte[] byArray = new byte[]{0};
        TlsUtils.writeUint8((short)byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, byteArrayOutputStream2);
        TlsUtils.writeUint24(byteArrayOutputStream.size(), byteArrayOutputStream2);
        byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        this.rs.writeMessage((short)22, byArray2, 0, byArray2.length);
        this.connection_state = 1;
        while (this.connection_state != 10) {
            this.rs.readData();
        }
        this.tlsInputStream = new TlsInputStream(this);
        this.tlsOutputStream = new TlsOuputStream(this);
    }

    protected int readApplicationData(byte[] byArray, int n2, int n3) throws IOException {
        while (this.applicationDataQueue.size() == 0) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (this.closed) {
                return -1;
            }
            try {
                this.rs.readData();
            }
            catch (IOException iOException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw runtimeException;
            }
        }
        n3 = Math.min(n3, this.applicationDataQueue.size());
        this.applicationDataQueue.read(byArray, n2, n3, 0);
        this.applicationDataQueue.removeData(n3);
        return n3;
    }

    protected void writeData(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.failedWithError) {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
        if (this.closed) {
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        this.rs.writeMessage((short)23, emptybuf, 0, 0);
        do {
            n4 = Math.min(n3, 16384);
            try {
                this.rs.writeMessage((short)23, byArray, n2, n4);
            }
            catch (IOException iOException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw runtimeException;
            }
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public TlsOuputStream getTlsOuputStream() {
        return this.tlsOutputStream;
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public TlsInputStream getTlsInputStream() {
        return this.tlsInputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short s2, short s3) throws IOException {
        if (!this.closed) {
            byte[] byArray = new byte[]{(byte)s2, (byte)s3};
            this.closed = true;
            if (s2 == 2) {
                this.failedWithError = true;
            }
            this.rs.writeMessage((short)21, byArray, 0, 2);
            this.rs.close();
            if (s2 == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.failWithError((short)1, (short)0);
        }
    }

    protected void assertEmpty(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (byteArrayInputStream.available() > 0) {
            this.failWithError((short)2, (short)50);
        }
    }

    protected void flush() throws IOException {
        this.rs.flush();
    }
}

