/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.CertPolicyId;

public class PolicyMappings
extends ASN1Object {
    ASN1Sequence seq = null;

    public static PolicyMappings getInstance(Object obj) {
        if (obj instanceof PolicyMappings) {
            return (PolicyMappings)obj;
        }
        if (obj != null) {
            return new PolicyMappings(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PolicyMappings(ASN1Sequence seq) {
        this.seq = seq;
    }

    public PolicyMappings(Hashtable mappings) {
        ASN1EncodableVector dev = new ASN1EncodableVector(mappings.size());
        Enumeration it = mappings.keys();
        while (it.hasMoreElements()) {
            String idp = (String)it.nextElement();
            String sdp = (String)mappings.get(idp);
            dev.add(new DERSequence(new ASN1ObjectIdentifier(idp), new ASN1ObjectIdentifier(sdp)));
        }
        this.seq = new DERSequence(dev);
    }

    public PolicyMappings(CertPolicyId issuerDomainPolicy, CertPolicyId subjectDomainPolicy) {
        this.seq = new DERSequence(new DERSequence(issuerDomainPolicy, subjectDomainPolicy));
    }

    public PolicyMappings(CertPolicyId[] issuerDomainPolicy, CertPolicyId[] subjectDomainPolicy) {
        ASN1EncodableVector dev = new ASN1EncodableVector(issuerDomainPolicy.length);
        int i = 0;
        while (i != issuerDomainPolicy.length) {
            dev.add(new DERSequence(issuerDomainPolicy[i], subjectDomainPolicy[i]));
            ++i;
        }
        this.seq = new DERSequence(dev);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

