/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.Validity;
import org.bouncycastle.util.Properties;

public class TBSCertificate
extends ASN1Object {
    ASN1Sequence seq;
    ASN1Integer version;
    ASN1Integer serialNumber;
    AlgorithmIdentifier signature;
    X500Name issuer;
    Validity validity;
    X500Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;
    ASN1BitString issuerUniqueId;
    ASN1BitString subjectUniqueId;
    Extensions extensions;

    public static TBSCertificate getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertificate.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertificate getInstance(Object obj) {
        if (obj instanceof TBSCertificate) {
            return (TBSCertificate)obj;
        }
        if (obj != null) {
            return new TBSCertificate(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private TBSCertificate(ASN1Sequence seq) {
        super();
        seqStart = 0;
        this.seq = seq;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.version = ASN1Integer.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
        } else {
            seqStart = -1;
            this.version = new ASN1Integer(0L);
        }
        isV1 = false;
        isV2 = false;
        if (this.version.hasValue(0)) {
            isV1 = true;
        } else if (this.version.hasValue(1)) {
            isV2 = true;
        } else if (!this.version.hasValue(2)) {
            throw new IllegalArgumentException("version number not recognised");
        }
        this.serialNumber = ASN1Integer.getInstance(seq.getObjectAt(seqStart + 1));
        this.signature = AlgorithmIdentifier.getInstance(seq.getObjectAt(seqStart + 2));
        this.issuer = X500Name.getInstance(seq.getObjectAt(seqStart + 3));
        this.validity = Validity.getInstance(seq.getObjectAt(seqStart + 4));
        this.subject = X500Name.getInstance(seq.getObjectAt(seqStart + 5));
        this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(seqStart + 6));
        extras = seq.size() - (seqStart + 6) - 1;
        if (extras == 0 || !isV1) ** GOTO lbl44
        throw new IllegalArgumentException("version 1 certificate contains extra data");
lbl-1000:
        // 1 sources

        {
            extra = (ASN1TaggedObject)seq.getObjectAt(seqStart + 6 + extras);
            switch (extra.getTagNo()) {
                case 1: {
                    this.issuerUniqueId = ASN1BitString.getInstance(extra, false);
                    break;
                }
                case 2: {
                    this.subjectUniqueId = ASN1BitString.getInstance(extra, false);
                    break;
                }
                case 3: {
                    if (isV2) {
                        throw new IllegalArgumentException("version 2 certificate cannot contain extensions");
                    }
                    this.extensions = Extensions.getInstance(ASN1Sequence.getInstance(extra, true));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag encountered in structure: " + extra.getTagNo());
                }
            }
            --extras;
lbl44:
            // 2 sources

            ** while (extras > 0)
        }
lbl45:
        // 1 sources

    }

    public TBSCertificate(ASN1Integer version, ASN1Integer serialNumber, AlgorithmIdentifier signature, X500Name issuer, Validity validity, X500Name subject, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1BitString issuerUniqueId, ASN1BitString subjectUniqueId, Extensions extensions) {
        if (serialNumber == null) {
            throw new NullPointerException("'serialNumber' cannot be null");
        }
        if (signature == null) {
            throw new NullPointerException("'signature' cannot be null");
        }
        if (issuer == null) {
            throw new NullPointerException("'issuer' cannot be null");
        }
        if (validity == null) {
            throw new NullPointerException("'validity' cannot be null");
        }
        if (subject == null) {
            throw new NullPointerException("'subject' cannot be null");
        }
        if (subjectPublicKeyInfo == null) {
            throw new NullPointerException("'subjectPublicKeyInfo' cannot be null");
        }
        this.version = version != null ? version : new ASN1Integer(0L);
        this.serialNumber = serialNumber;
        this.signature = signature;
        this.issuer = issuer;
        this.validity = validity;
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.issuerUniqueId = issuerUniqueId;
        this.subjectUniqueId = subjectUniqueId;
        this.extensions = extensions;
        this.seq = null;
    }

    public int getVersionNumber() {
        return this.version.intValueExact() + 1;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public Time getStartDate() {
        return this.validity.getNotBefore();
    }

    public Time getEndDate() {
        return this.validity.getNotAfter();
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public ASN1BitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public ASN1BitString getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.seq != null) {
            if (Properties.getPropertyValue("org.bouncycastle.x509.allow_non-der_tbscert") != null) {
                if (Properties.isOverrideSet("org.bouncycastle.x509.allow_non-der_tbscert")) {
                    return this.seq;
                }
            } else {
                return this.seq;
            }
        }
        ASN1EncodableVector v = new ASN1EncodableVector(10);
        if (!this.version.hasValue(0)) {
            v.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.version));
        }
        v.add(this.serialNumber);
        v.add(this.signature);
        v.add(this.issuer);
        v.add(this.validity);
        v.add(this.subject);
        v.add(this.subjectPublicKeyInfo);
        if (this.issuerUniqueId != null) {
            v.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.issuerUniqueId));
        }
        if (this.subjectUniqueId != null) {
            v.add(new DERTaggedObject(false, 2, (ASN1Encodable)this.subjectUniqueId));
        }
        if (this.extensions != null) {
            v.add(new DERTaggedObject(true, 3, (ASN1Encodable)this.extensions));
        }
        return new DERSequence(v);
    }
}

